/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.business.ecoplatform.ECNUpdateBomBusiness;
import kd.mmc.pdm.business.ecoplatform.EcoCopUtils;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.business.ecoplatform.GetEcoEffectOrderBusiness;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.opplugin.ecn.ECNBaseOpPlugin;
import kd.mmc.pdm.opplugin.ecn.ECNNewAuditValidator;
import kd.mmc.pdm.opplugin.ecn.ECNResetEcoBomEntryDatePlugin;

public class ECNNewAuditOp
extends ECNBaseOpPlugin {
    private static final Log logger = LogFactory.getLog(ECNNewAuditOp.class);
    private Map<String, String> errorMap = new HashMap<String, String>(16);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("pentry.pentrybom");
        e.getFieldKeys().add("pentry.pentryecn");
        e.getFieldKeys().add("pentry.bomtype");
        e.getFieldKeys().add("pentry.pentrynewversion");
        e.getFieldKeys().add("pentry.pentryoldversion");
        e.getFieldKeys().add("pentry.ecobomid");
        e.getFieldKeys().add("pentry.ecobomdata");
        e.getFieldKeys().add("pentry.ecotype.trandatetoday");
        e.getFieldKeys().add("changetype");
        e.getFieldKeys().add("pentry.bomtype.checkrepeat");
        e.getFieldKeys().add("pentry.bomtype.verifydimension");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ECNResetEcoBomEntryDatePlugin());
        e.addValidator((AbstractValidator)new ECNNewAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dyncol = e.getDataEntities();
        String opName = e.getOperationKey();
        if (!"audit".equals(opName)) {
            return;
        }
        ArrayList<DynamicObject> newObjList = new ArrayList<DynamicObject>(10);
        boolean isBom = Boolean.FALSE;
        this.errorMap = new HashMap<String, String>(16);
        for (int j = 0; j < dyncol.length; ++j) {
            DynamicObject dObject = dyncol[j];
            if (!this.isBomChange(dObject)) continue;
            isBom = Boolean.TRUE;
            newObjList.add(dObject);
            StringBuilder errors = new StringBuilder();
            try (TXHandle h = TX.requiresNew();){
                try {
                    Set<Long> ecoBomIdSet = this.getAllEcoObjIds(dObject);
                    if (!ecoBomIdSet.isEmpty()) {
                        EcoUtils.updateStatusAndActTime(ecoBomIdSet, (DynamicObject)dObject);
                        EcoCopUtils.updateStatusAndActTime(ecoBomIdSet, (DynamicObject)dObject);
                    }
                    this.auditInitVersionEcoObj(dObject);
                    String errorMMsg = ECNUpdateBomBusiness.getInstance().execUpdate(dObject);
                    this.updateEstimateStatus(dObject);
                    errors.append(errorMMsg);
                }
                catch (Exception e1) {
                    newObjList.remove(dObject);
                    logger.error((Throwable)e1);
                    String errorMsg = e1.getMessage();
                    if (errorMsg == null || "".equals(errorMsg)) {
                        errorMsg = PlatformUtils.getExceptionString((Exception)e1);
                    }
                    errors.append(errorMsg);
                    h.markRollback();
                }
                if (errors.length() <= 0) continue;
                this.errorMap.put(dObject.getString("billno"), errors.toString());
                continue;
            }
        }
        if (isBom) {
            e.setDataEntities(newObjList.toArray(new DynamicObject[0]));
        }
        this.errorMap.put("successful_count", newObjList.size() + "");
        this.errorMap.put("failed_count", dyncol.length - newObjList.size() + "");
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String opName = e.getOperationKey();
        if (!"audit".equals(opName)) {
            return;
        }
        DynamicObject[] dyncol = e.getDataEntities();
        ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>(16);
        for (int j = 0; j < dyncol.length; ++j) {
            DynamicObject dObject = dyncol[j];
            if (!this.isBomChange(dObject)) continue;
            DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
            HashSet<Long> updateOrderPentryIdSet = new HashSet<Long>(16);
            for (DynamicObject obj : pentrys) {
                DynamicObject ecoType = obj.getDynamicObject("ecotype");
                if (ecoType == null || !ecoType.getBoolean("autoupdateorder")) continue;
                updateOrderPentryIdSet.add(obj.getLong("id"));
            }
            if (updateOrderPentryIdSet.isEmpty()) continue;
            String errorMsg = "";
            try {
                Map returnMap = GetEcoEffectOrderBusiness.getInstance().createStockChangeByPentryId(updateOrderPentryIdSet);
                errorMsg = returnMap.get("errormsg") == null ? "" : returnMap.get("errormsg").toString();
            }
            catch (Exception e1) {
                logger.error((Throwable)e1);
                errorMsg = PlatformUtils.getSimpleExceptionString((Exception)e1);
            }
            if (errorMsg == null || "".equals(errorMsg)) continue;
            if (errorMsg.length() > 1900) {
                errorMsg = errorMsg.substring(0, 1900);
            }
            dObject.set("errormsg", (Object)errorMsg);
            updateDataList.add(dObject);
        }
        if (!updateDataList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateDataList.toArray(new DynamicObject[updateDataList.size()]), (OperateOption)OperateOption.create());
        }
        this.throwAduitErrorMsg(this.errorMap);
    }
}

