/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.mmc.pdm.common.util.ECNUtil;
import kd.mmc.pdm.opplugin.ecn.ECNBaseValidatorPlugin;

public class ECNNewSaveValidator
extends ECNBaseValidatorPlugin {
    public static final String SAVE = "save";
    public static final String SUBMIT = "submit";

    @Override
    public void validate() {
        String operate = this.getOperateKey();
        if (!SAVE.equals(operate) && !SUBMIT.equals(operate)) {
            return;
        }
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (null == objs || objs.length == 0) {
            return;
        }
        for (ExtendedDataEntity obj : objs) {
            DynamicObject dObject = obj.getDataEntity();
            if (!this.isBomChange(dObject)) continue;
            String billno = dObject.getString("billno");
            DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
            if (pentrys.isEmpty()) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u53f7%s\u7684\u4ea7\u54c1\u5206\u5f55\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"ECNNewSaveValidator_1", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), billno));
                continue;
            }
            String checkOrgMsg = this.checkOrgPermItem(dObject);
            if (!this.isNullString(checkOrgMsg)) {
                this.addErrorMessage(obj, checkOrgMsg);
                continue;
            }
            ArrayList<Integer> idxs = new ArrayList<Integer>(16);
            HashMap<String, Integer> check = new HashMap<String, Integer>(16);
            boolean flag = true;
            int pSize = pentrys.size();
            for (int i = 0; i < pSize; ++i) {
                DynamicObject entry = (DynamicObject)pentrys.get(i);
                DynamicObject bom = entry.getDynamicObject("pentrybom");
                String versionCtr = entry.getString("entryversioncontrol");
                DynamicObject mater = this.getMaterialMasterObj(entry);
                this.setDefaultEcoType(dObject, entry);
                if (mater == null) {
                    flag = false;
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ECNNewSaveValidator_3", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                DynamicObject bomType = entry.getDynamicObject("bomtype");
                if (bomType == null) {
                    flag = false;
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0cBOM\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"ECNNewSaveValidator_4", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                String pMaterPK = mater.getString("id");
                String materialNum = mater.getString("number");
                if ("D".equals(versionCtr)) continue;
                Long pbomPK = ECNUtil.getDynamicObjectId((DynamicObject)bom);
                if (pbomPK <= 0L) {
                    flag = false;
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0cBOM\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ECNNewSaveValidator_0", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                String chkExistsEcnMsg = this.checkExistsEcnBill(dObject, bom);
                if (!this.isNullString(chkExistsEcnMsg)) {
                    this.setAddBillNoForContent(false);
                    flag = false;
                    this.addErrorMessage(obj, chkExistsEcnMsg);
                    continue;
                }
                if (!"B".equals(versionCtr)) continue;
                String key = pMaterPK + "+" + materialNum;
                Object value = check.get(key);
                if (value != null) {
                    flag = false;
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\u3001\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\u201c%3$s\u201d\u4ea7\u54c1\u7f16\u7801\u76f8\u540c\uff0c\u4e0d\u80fd\u540c\u65f6\u8fdb\u884c\u987a\u5ef6\u7248\u672c\u53d8\u66f4\u3002", (String)"ECNNewSaveValidator_2", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), check.get(key), i + 1, materialNum));
                    continue;
                }
                check.put(key, i + 1);
                idxs.add(i);
            }
            String statusMsg = this.checkBomRtIsAuditStatus(dObject);
            if (statusMsg != null && !"".equals(statusMsg)) {
                this.addErrorMessage(obj, statusMsg);
                continue;
            }
            if (!idxs.isEmpty() && !flag) continue;
        }
    }
}

