/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mmc.fmm.common.enums.MaterialAttrEnum;
import kd.mmc.pdm.business.ecoplatform.EcoCopUtils;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.enums.ECOEntryModeEnum;
import kd.mmc.pdm.common.helper.BomMaterialAuxPropHelper;
import kd.mmc.pdm.common.util.BOMVersionUtil;
import kd.mmc.pdm.common.util.ECNNewUtil;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;
import kd.mmc.pdm.opplugin.ecn.ECNBaseValidatorPlugin;

public class ECNNewSubmitValidator
extends ECNBaseValidatorPlugin {
    @Override
    public void validate() {
        String operate = this.getOperateKey();
        if (!"submit".equals(operate)) {
            return;
        }
        ExtendedDataEntity[] objs = this.getDataEntities();
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashSet<String> refNoSet = new HashSet<String>(16);
        HashSet<String> refNoSetA = new HashSet<String>(16);
        HashSet<String> refNoSetB = new HashSet<String>(16);
        HashSet<String> refNoRepeatSet = new HashSet<String>(16);
        HashMap<String, ExtendedDataEntity> refNoRowMap = new HashMap<String, ExtendedDataEntity>(16);
        HashMap<String, Map<Long, Long>> refNoEcoTypeMap = new HashMap<String, Map<Long, Long>>(16);
        boolean isOpenCP = PdmParamSetHelper.getBooleanParamValue((String)"ECNOpeContinuesPoint");
        Set<Long> ecoBomIdSet = this.getEcoBomIdSet(objs);
        Map<Long, DynamicObject> ecoBomDataMap = this.getEcoBomDatas(ecoBomIdSet);
        for (ExtendedDataEntity obj : objs) {
            Long ecnId;
            Map otherEcnMap;
            String statusMsg;
            DynamicObject dObject = obj.getDataEntity();
            if (!this.isBomChange(dObject)) continue;
            DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
            String billNo = dObject.getString("billno");
            if (pentrys.isEmpty()) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u53f7%s\u7684\u4ea7\u54c1\u5206\u5f55\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"ECNNewSubmitValidator_21", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), billNo));
                continue;
            }
            String checkOrgMsg = this.checkOrgPermItem(dObject);
            if (!this.isNullString(checkOrgMsg)) {
                this.addErrorMessage(obj, checkOrgMsg);
                continue;
            }
            HashMap<String, Integer> check = new HashMap<String, Integer>(16);
            HashSet<String> judgeSame = new HashSet<String>(16);
            HashSet<String> chkHasKeyGroupNoAllSet = new HashSet<String>(16);
            HashSet<String> chkHasKeyGroupNoSet = new HashSet<String>(16);
            HashSet<Long> bomEntryIdSet = new HashSet<Long>(16);
            int pentySize = pentrys.size();
            DynamicObject org = dObject.getDynamicObject("org");
            for (int i = 0; i < pentySize; ++i) {
                String ecoTypeStatusType;
                String chkExistsEcnMsg;
                DynamicObject newtype;
                DynamicObject bomtype;
                String flag;
                DynamicObject entry = (DynamicObject)pentrys.get(i);
                DynamicObject bom = entry.getDynamicObject("pentrybom");
                DynamicObject bomType = entry.getDynamicObject("bomtype");
                String versionCtr = entry.getString("entryversioncontrol");
                if (!"D".equals(versionCtr) && bom == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0cBOM\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ECNNewSubmitValidator_22", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                DynamicObject product = entry.getDynamicObject("proentrymaterial");
                DynamicObject mater = entry.getDynamicObject("proentrymaterialid");
                if (product == null && mater == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\u672a\u5f55\u5165\u7269\u6599\u4fe1\u606f\u3002", (String)"ECNNewSubmitValidator_23", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), billNo, i + 1));
                    continue;
                }
                if (mater == null && product != null) {
                    mater = product.getDynamicObject("masterid");
                }
                if (bomType == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0cBOM\u7c7b\u578b\u5fc5\u5f55\u3002", (String)"ECNNewSubmitValidator_54", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (bom != null && !bomType.getPkValue().equals(bom.getDynamicObject("type").getPkValue())) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0cBOM\u7c7b\u578b\u4e0eBOM\u5bf9\u5e94\u7684\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"ECNNewSubmitValidator_75", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if ("D".equals(versionCtr) && !"A".equals(bomType.getString("purpose"))) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u521d\u59cb\u7248\u672c\u4e0bBOM\u7c7b\u578b\u7684\u7528\u9014\u4e0d\u4e3a\u3010\u5236\u9020\u3011\uff0c \u4e0d\u5141\u8bb8\u3002", (String)"ECNNewSubmitValidator_55", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (product == null && this.isNeedMaterialMft(bomType)) {
                    DynamicObject mft = MaterialMftQueryHelper.getDataCacheByMaterial((DynamicObject)mater, (DynamicObject)org);
                    if (mft == null || !mft.getBoolean("ismainproduct")) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"%1$s:\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\u7684\u4ea7\u54c1\u7f16\u7801\u6ca1\u6709\u5bf9\u5e94\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff0c\u6216\u8005\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u4e0d\u662f\u53ef\u4e3b\u4ea7\u54c1\u3002", (String)"ECNNewSubmitValidator_93", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), billNo, i + 1));
                        continue;
                    }
                    entry.set("proentrymaterial", (Object)mft);
                }
                if (mater == null) continue;
                String pMaterPK = mater.getString("id");
                String materialNum = mater.getString("number");
                Date pentryvaliddate = entry.getDate("pentryvaliddate");
                if (pentryvaliddate == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0c\u751f\u6548\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ECNNewSubmitValidator_3", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                String entryversioncontrol = entry.getString("entryversioncontrol");
                DynamicObject pentryoldversion = entry.getDynamicObject("pentryoldversion");
                DynamicObject pentrynewversion = entry.getDynamicObject("pentrynewversion");
                if (pentrynewversion == null && (entryversioncontrol.equals("C") || entryversioncontrol.equals("D")) && BOMVersionUtil.isNeedVersion((boolean)true, (DynamicObject)dObject, (DynamicObject)entry)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u65b0\u7248\u672c\u3002", (String)"ECNNewSubmitValidator_4", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (entryversioncontrol.equals("B")) {
                    String key = pMaterPK + "+" + materialNum;
                    Object value = check.get(key);
                    if (value != null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\u3001\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\u201c%3$s\u201d\u4ea7\u54c1\u7f16\u7801\u76f8\u540c\uff0c\u4e0d\u80fd\u540c\u65f6\u8fdb\u884c\u987a\u5ef6\u7248\u672c\u53d8\u66f4\u3002", (String)"ECNNewSubmitValidator_24", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), check.get(key), i + 1, materialNum));
                        continue;
                    }
                    check.put(key, i + 1);
                    if (pentrynewversion == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u8bf7\u586b\u5199\u65b0\u7248\u672c\u3002", (String)"ECNNewSubmitValidator_4", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                }
                if ("D".equals(versionCtr) || "B".equals(versionCtr)) {
                    DynamicObject bomauxproperty = entry.getDynamicObject("bomauxproperty");
                    boolean auxIsMustInput = BomMaterialAuxPropHelper.isMustInput((Long)mater.getLong("id"), (Long)org.getLong("id"));
                    if (auxIsMustInput && null == bomauxproperty) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u5b58\u5728,\u8bf7\u586b\u5199\u3002", (String)"ECNNewSubmitValidator_25", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                }
                if ("D".equals(versionCtr) && pentrynewversion != null && !judgeSame.add(flag = mater.getPkValue() + "_" + pentrynewversion.getPkValue())) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u5b58\u5728\u521d\u59cb\u7248\u672c\uff0c\u4ea7\u54c1\u7f16\u7801\uff0c\u65b0\u7248\u672c\u76f8\u540c\u7684\u5206\u5f55\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ECNNewSubmitValidator_26", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                DynamicObject bomTypeRule = BOMVersionUtil.getBomTypeDefVersionRule((DynamicObject)bomType);
                if (("B".equals(versionCtr) || "D".equals(versionCtr)) && pentrynewversion != null && bomType != null && !BOMVersionUtil.checkIsSameRule((DynamicObject)bomTypeRule, (DynamicObject)pentrynewversion)) {
                    DynamicObject versionRule = BOMVersionUtil.getVersionRule((DynamicObject)pentrynewversion);
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u65b0\u7248\u672c\u53f7\u5bf9\u5e94\u7684\u7248\u672c\u89c4\u5219\u201c%2$s\u201d\u4e0eBOM\u7c7b\u578b\u7684\u7248\u672c\u89c4\u5219\u201c%3$s\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ECNNewSubmitValidator_101", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, bomTypeRule.getString("number"), versionRule.getString("number")));
                    continue;
                }
                if (bom != null && !"D".equals(versionCtr) && (bomtype = bom.getDynamicObject("type")) != null && pentryoldversion != null && !(newtype = BusinessDataServiceHelper.loadSingleFromCache((Object)bomtype.getPkValue(), (String)"mpdm_bomtype", (String)"isversionvalid")).getBoolean("isversionvalid") && entryversioncontrol.equals("B")) {
                    Date oldvaliddate = pentryoldversion.getDate("effectdate");
                    if (sdf.format(pentryvaliddate).compareTo(sdf.format(oldvaliddate)) < 0) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0cBOM\u7c7b\u578b\u4e0d\u5141\u8bb8\u7248\u672c\u540c\u65f6\u6709\u6548\uff0c\u4e14\u751f\u6548\u65f6\u95f4\u5e94\u5927\u4e8e\u65e7\u7248\u672c\u7684\u751f\u6548\u65f6\u95f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ECNNewSubmitValidator_7", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                }
                if (!this.isNullString(chkExistsEcnMsg = this.checkExistsEcnBill(dObject, bom))) {
                    this.addErrorMessage(obj, chkExistsEcnMsg);
                    continue;
                }
                Long ecobomid = entry.getLong("ecobomid");
                if (PlatformUtils.isNullLong((Long)ecobomid)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4ea7\u54c1\u5206\u5f55\uff0c\u5de5\u7a0b\u53d8\u66f4BOM\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"ECNNewSubmitValidator_10", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    break;
                }
                DynamicObject pEntryBOMDO = ecoBomDataMap.get(ecobomid);
                DynamicObjectCollection entrys = pEntryBOMDO.getDynamicObjectCollection("entry");
                DynamicObjectCollection copentrys = pEntryBOMDO.getDynamicObjectCollection("copentry");
                if (PlatformUtils.isNullCollection((DynamicObjectCollection)entrys) && PlatformUtils.isNullCollection((DynamicObjectCollection)copentrys)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4ea7\u54c1\u5206\u5f55\uff0c\u7ec4\u4ef6\u5206\u5f55\u53ca\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u53d8\u66f4\u4fe1\u606f\u5747\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"ECNNewSubmitValidator_11", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    break;
                }
                DynamicObject bomMaterialMaster = pEntryBOMDO.getDynamicObject("materialid");
                DynamicObject ecoType = entry.getDynamicObject("ecotype");
                boolean isEditRefKeyType = EcoUtils.isEditMode((DynamicObject)ecoType, (String)"refkeytype");
                boolean isEditGroupKeyType = EcoUtils.isEditMode((DynamicObject)ecoType, (String)"groupkeytype");
                if (!PlatformUtils.isNullCollection((DynamicObjectCollection)copentrys) && !"A".equals(ecoTypeStatusType = ecoType.getString("statustype"))) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4ea7\u54c1\u5206\u5f55\uff0c\u5b58\u5728\u8054\u526f\u4ea7\u54c1\u53d8\u66f4\uff0c\u4f46\u53d8\u66f4\u7c7b\u578b\u7684\u8bc4\u4f30\u72b6\u6001\u7c7b\u578b\u4e0d\u662f\u3010\u5ba1\u6838\u81ea\u52a8\u8bc4\u4f30\u5b8c\u6210\u3011\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ECNNewSubmitValidator_12", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    break;
                }
                HashSet<Long> bomEntryMaterialIdSet = new HashSet<Long>(16);
                HashSet<Long> bomCopEntryMaterialIdSet = new HashSet<Long>(16);
                if (bom != null) {
                    this.queryMftBomCopEntryIdSet(bom.getLong("id"), bomCopEntryMaterialIdSet);
                    this.queryMftBomEntryIdSet(bom.getLong("id"), bomEntryMaterialIdSet);
                }
                HashMap<String, Date> replaceGroupMap = new HashMap<String, Date>(16);
                HashMap<String, String> replaceGroupRefNoMap = new HashMap<String, String>(16);
                int index = 0;
                int entrySize = entrys.size();
                for (int j = 0; j < entrySize; ++j) {
                    Long bomentryId;
                    boolean auxIsMustInput;
                    Long bomentryId2;
                    DynamicObject entryentity = (DynamicObject)entrys.get(j);
                    ++index;
                    String entrymode = entryentity.getString("entrymode");
                    if (StringUtils.isBlank((CharSequence)entrymode)) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u884c\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"ECNNewSubmitValidator_13", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    String entrytype = entryentity.getString("entrytype");
                    String entrymaterialattr = entryentity.getString("entrymaterialattr");
                    if ("A".equals(entrytype)) {
                        if ((StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) && entryentity.getDynamicObject("entrymaterial") == null && entryentity.getDynamicObject("entrymaterialid") == null) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u672a\u5f55\u5165\u7ec4\u4ef6\u7f16\u7801\u3002", (String)"ECNNewSubmitValidator_65", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                            continue;
                        }
                        if (!MaterialAttrEnum.PURCHASEDPART.getValue().equalsIgnoreCase(entrymaterialattr) && bomType.getBoolean("isversion") && (StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) && entryentity.getDynamicObject("entryversion") == null) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0cBOM\u7c7b\u578b\u5f00\u542f\u7248\u672c\u7ba1\u7406\uff0c\u7ec4\u4ef6\u7c7b\u578b\u4e3a\u5e93\u5b58\u65f6\u7248\u672c\u53f7\u5fc5\u5f55\u3002", (String)"ECNNewSubmitValidator_63", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                            continue;
                        }
                    } else if ("B".equals(entrytype) && (StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) && entryentity.getDynamicObject("featuretype") == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u672a\u5f55\u5165\u7279\u5f81\u7c7b\u3002", (String)"ECNNewSubmitValidator_72", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    if (entryentity.getDate("acttime") == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"ECNNewSubmitValidator_99", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    String entryRefNo = entryentity.getString("entryrefno");
                    String groupNo = entryentity.getString("entrygroupno");
                    String estimateStatus = entryentity.getString("estimatestatus");
                    if (entryentity.getBoolean("refkey") && PlatformUtils.isNullString((String)entryRefNo)) {
                        if (!isEditRefKeyType) {
                            entryentity.set("refkey", (Object)false);
                        } else {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u52fe\u9009\u4e86\u5173\u8054\u4e3b\u952e\uff0c\u4f46\u672a\u5f55\u5165\u5173\u8054\u5b9e\u65bd\u53f7\u3002", (String)"ECNNewSubmitValidator_48", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                            continue;
                        }
                    }
                    if (entryentity.getBoolean("groupkey") && PlatformUtils.isNullString((String)groupNo)) {
                        if (!isEditGroupKeyType) {
                            entryentity.set("groupkey", (Object)false);
                        } else {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u52fe\u9009\u4e86\u6210\u7ec4\u4e3b\u952e\uff0c\u4f46\u672a\u5f55\u5165\u6210\u7ec4\u53f7\u3002", (String)"ECNNewSubmitValidator_49", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                            continue;
                        }
                    }
                    if (!estimateStatus.equals("C") && !PlatformUtils.isNullString((String)entryRefNo)) {
                        refNoSet.add(entryRefNo);
                        if (estimateStatus.equals("B")) {
                            refNoSetB.add(entryRefNo);
                        } else {
                            refNoSetA.add(entryRefNo);
                        }
                        if (isEditRefKeyType && entryentity.getBoolean("refkey")) {
                            if (!refNoRepeatSet.add(entryRefNo)) {
                                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u5173\u8054\u5b9e\u65bd\u53f7%3$s\uff0c\u5b58\u5728\u591a\u4e2a\u52fe\u9009\u7684\u5173\u8054\u4e3b\u952e\u3002", (String)"ECNNewSubmitValidator_47", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, entryRefNo));
                                continue;
                            }
                            if (!"E".equals(entrymode)) {
                                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u5173\u8054\u4e3b\u952e\u53ea\u5141\u8bb8\u5b58\u5728\u4e8e\u5931\u6548\u884c\u4e0a\u3002", (String)"ECNNewSubmitValidator_73", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                                continue;
                            }
                        }
                        if (ecoType != null) {
                            Long oldEcotypeId;
                            HashMap<Long, Long> oldEcoBomMap = (HashMap<Long, Long>)refNoEcoTypeMap.get(entryRefNo);
                            if (oldEcoBomMap == null) {
                                oldEcoBomMap = new HashMap<Long, Long>(16);
                            }
                            if (!PlatformUtils.isNullLong((Long)(oldEcotypeId = PlatformUtils.getFirstLongValueFromMap((Map)oldEcoBomMap))) && !oldEcotypeId.equals(ecoType.getLong("id"))) {
                                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u5b9e\u65bd\u53f7\u201c%3$s\u201d\u5b58\u5728\u4e0d\u540c\u7684\u53d8\u66f4\u7c7b\u578b\u3002", (String)"ECNNewSubmitValidator_70", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, entryRefNo));
                                continue;
                            }
                            oldEcoBomMap.put(ecobomid, ecoType.getLong("id"));
                            refNoEcoTypeMap.put(entryRefNo, oldEcoBomMap);
                        }
                    }
                    if (isEditGroupKeyType && !estimateStatus.equals("C") && !PlatformUtils.isNullString((String)groupNo)) {
                        chkHasKeyGroupNoAllSet.add(PlatformUtils.getUnionString((Object)entry.getPkValue(), (Object)groupNo));
                        if (entryentity.getBoolean("groupkey")) {
                            chkHasKeyGroupNoSet.add(PlatformUtils.getUnionString((Object)entry.getPkValue(), (Object)groupNo));
                        }
                    }
                    if (!PlatformUtils.isNullString((String)entryRefNo)) {
                        refNoRowMap.put(entryRefNo, obj);
                    }
                    if (!StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) && !StringUtils.equals((CharSequence)"C", (CharSequence)entrymode) && !StringUtils.equals((CharSequence)"E", (CharSequence)entrymode)) continue;
                    DynamicObject entrymaterial = entryentity.getDynamicObject("entrymaterial");
                    DynamicObject entrymaterialid = entryentity.getDynamicObject("entrymaterialid");
                    Date acttime = entryentity.getDate("acttime");
                    if (entrymaterialid != null && ((Long)entrymaterialid.getPkValue()).equals((Long)bomMaterialMaster.getPkValue())) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u7ec4\u4ef6\u7f16\u7801\u4e0eBOM\u8868\u5934\u7684\u4ea7\u54c1\u7f16\u7801\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ECNNewSubmitValidator_92", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    if (entrymaterialid != null && StringUtils.equals((CharSequence)"A", (CharSequence)entrymode)) {
                        bomEntryMaterialIdSet.add(entrymaterialid.getLong("id"));
                        if (bomCopEntryMaterialIdSet.contains(entrymaterialid.getLong("id"))) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u7ec4\u4ef6\u7f16\u7801%3$s\u5728\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u4e2d\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ECNNewSubmitValidator_95", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, entrymaterialid.getString("number")));
                            continue;
                        }
                    }
                    DynamicObject entryversion = entryentity.getDynamicObject("entryversion");
                    boolean isversion = bomType.getBoolean("isversion");
                    DynamicObject material = entrymaterialid;
                    if (material != null) {
                        boolean second;
                        boolean materIsVersion = material.getBoolean("isenablematerialversion");
                        if (entrymaterial != null) {
                            boolean first;
                            String attr = entrymaterial.getString("materialattr");
                            boolean bl = first = isversion && entryversion == null && ("10050".equals(attr) || "10020".equals(attr) || "10030".equals(attr));
                            if (first) {
                                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u884c\u7ec4\u4ef6\u5206\u5f55\uff0c\u7ec4\u4ef6\u201c\u7269\u6599\u5c5e\u6027\u201d\u4e3a\u81ea\u5236|\u59d4\u5916|\u865a\u62df\uff0c\u8bf7\u586b\u5199\u201c\u7248\u672c\u53f7\u201d\u3002", (String)"ECNNewSubmitValidator_28", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                                continue;
                            }
                        }
                        boolean bl = second = materIsVersion && entryversion == null;
                        if (second) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u884c\u7ec4\u4ef6\u5206\u5f55\uff0c\u7ec4\u4ef6\u7269\u6599\u542f\u7528\u7248\u672c\u7ba1\u7406\uff0c\u8bf7\u586b\u5199\u201c\u7248\u672c\u53f7\u201d\u3002", (String)"ECNNewSubmitValidator_29", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                            continue;
                        }
                    } else if ("A".equals(entryentity.getString("entrytype"))) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u884c\u7ec4\u4ef6\u5206\u5f55\uff0c\u7ec4\u4ef6\u7c7b\u578b\u4e3a\u5e93\u5b58\uff0c\u4f46\u672a\u5f55\u5165\u7ec4\u4ef6\u7269\u6599\u4fe1\u606f\u3002", (String)"ECNNewSubmitValidator_52", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    if ((StringUtils.equals((CharSequence)"C", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"A", (CharSequence)entrymode)) && entryversion != null && !BOMVersionUtil.checkIsSameRule((DynamicObject)bomTypeRule, (DynamicObject)entryversion)) {
                        DynamicObject versionRule = BOMVersionUtil.getVersionRule((DynamicObject)entryversion);
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u884c\u7ec4\u4ef6\u5206\u5f55\uff0c\u7248\u672c\u53f7\u5bf9\u5e94\u7684\u7248\u672c\u89c4\u5219\u201c%3$s\u201d\u4e0eBOM\u7c7b\u578b\u7684\u7248\u672c\u89c4\u5219\u201c%4$s\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ECNNewSubmitValidator_102", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, bomTypeRule.getString("number"), versionRule.getString("number")));
                        continue;
                    }
                    if ("B".equals(entryentity.getString("entrytype")) && entryentity.get("featuretype") == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u884c\u7ec4\u4ef6\u5206\u5f55\uff0c\u7ec4\u4ef6\u7c7b\u578b\u4e3a\u9009\u9879\uff0c\u4f46\u672a\u5f55\u5165\u7279\u5f81\u7c7b\u3002", (String)"ECNNewSubmitValidator_53", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    Date entryvaliddate = entryentity.getDate("entryvaliddate");
                    if (entryvaliddate == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u751f\u6548\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ECNNewSubmitValidator_30", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    Date entryinvaliddate = entryentity.getDate("entryinvaliddate");
                    if (entryinvaliddate == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u5931\u6548\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ECNNewSubmitValidator_15", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    Date entryinvaliddatetrans = null;
                    Date entryvaliddatetrans = null;
                    try {
                        entryinvaliddatetrans = sd.parse(sd.format(entryinvaliddate));
                        entryvaliddatetrans = sd.parse(sd.format(entryvaliddate));
                    }
                    catch (ParseException e) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c%3$s", (String)"ECNNewSubmitValidator_31", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, e.getMessage()));
                        continue;
                    }
                    if (entryvaliddatetrans.compareTo(entryinvaliddatetrans) > 0) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u7ec4\u4ef6\u5206\u5f55\u7684\u5931\u6548\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"ECNNewSubmitValidator_16", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) {
                        DynamicObject dynamicObject;
                        Date entryvaliddateBefore;
                        Long entrybomentryid = entryentity.getLong("entrybomentryid");
                        Optional<DynamicObject> optional = entrys.stream().filter(f -> "B".equals(f.getString("entrymode")) && Objects.equals(entrybomentryid, f.getLong("entrybomentryid"))).findFirst();
                        if (optional.isPresent() && (entryvaliddateBefore = (dynamicObject = optional.get()).getDate("entryvaliddate")) != null && ECNNewUtil.setDateSubOne((Date)entryvaliddate).compareTo(entryvaliddateBefore) < 0) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u53d8\u66f4\u540e\u751f\u6548\u65f6\u95f4\u65e9\u4e8e\u53d8\u66f4\u524d\u7ec4\u4ef6\u751f\u6548\u65f6\u95f4\u3002", (String)"ECNNewSubmitValidator_34", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                            continue;
                        }
                    }
                    Long ecoBomEntryId = entryentity.getLong("id");
                    boolean isExistsECN = false;
                    if (isOpenCP) {
                        isExistsECN = this.chekIsExistsContinuesEcn(ecoBomEntryId);
                    }
                    if (StringUtils.equals((CharSequence)"E", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"B", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) {
                        if (!(!StringUtils.equals((CharSequence)"B", (CharSequence)entrymode) && !StringUtils.equals((CharSequence)"E", (CharSequence)entrymode) || acttime == null || sdf.format(acttime).compareTo(sdf.format(entryvaliddate)) > 0 || isOpenCP && isExistsECN)) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u7ec4\u4ef6\u751f\u6548\u65f6\u95f4\u3002", (String)"ECNNewSubmitValidator_35", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                            continue;
                        }
                        if (!(acttime == null || sdf.format(acttime).compareTo(sdf.format(entryinvaliddate)) <= 0 || isOpenCP && isExistsECN)) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ec4\u4ef6\u5931\u6548\u65f6\u95f4\u3002", (String)"ECNNewSubmitValidator_33", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                            continue;
                        }
                    }
                    if (StringUtils.equals((CharSequence)"E", (CharSequence)entrymode) && "A".equals(versionCtr) && !PlatformUtils.isNullLong((Long)(bomentryId2 = Long.valueOf(entryentity.getLong("entrybomentryid"))))) {
                        DynamicObject mftentry;
                        Map chkRefPointMaps;
                        HashSet<Long> mftBomEntryIdSet = new HashSet<Long>(16);
                        mftBomEntryIdSet.add(bomentryId2);
                        String otherEcnBillNo = EcoUtils.getAduitEcnBill(mftBomEntryIdSet, (Long)dObject.getLong("id"), (String)entrymode);
                        if (otherEcnBillNo != null && !"".equals(otherEcnBillNo)) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55,\u4e0d\u5141\u8bb8\u540c\u65f6\u5b58\u5728\u591a\u5f20\u5931\u6548\u7684\u5de5\u7a0b\u53d8\u66f4\u6570\u636e,\u5176\u4ed6\u5de5\u7a0b\u53d8\u66f4\u5355\u53f7\u4e3a\u201c%3$s\u201d\u3002", (String)"ECNNewSubmitValidator_68", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, otherEcnBillNo));
                            continue;
                        }
                        if (!PlatformUtils.isNullString((String)entryRefNo) && (chkRefPointMaps = EcoUtils.getRefNoContinuPointEcnData((String)entryRefNo, mftBomEntryIdSet, (Long)dObject.getLong("id"))) != null && chkRefPointMaps.get(bomentryId2) != null) {
                            String otherEcnNo = (String)chkRefPointMaps.get(bomentryId2);
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u5bf9\u5e94\u7684\u8fde\u7eed\u65ad\u70b9\u53d8\u66f4\u5355%3$s\u5b58\u5728\u76f8\u540c\u7684\u5173\u8054\u5b9e\u65bd\u53f7,\u4e0d\u5141\u8bb8\u3002", (String)"ECNNewSubmitValidator_69", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, otherEcnNo));
                            continue;
                        }
                        Map mftBomEntryDataMap = EcoUtils.getMftBomEntryData(mftBomEntryIdSet);
                        DynamicObject dynamicObject = mftentry = mftBomEntryDataMap == null ? null : (DynamicObject)mftBomEntryDataMap.get(bomentryId2);
                        if (mftentry != null) {
                            entryvaliddate = mftentry.getDate("entryvaliddate");
                            entryinvaliddate = mftentry.getDate("entryinvaliddate");
                            if (!(acttime == null || sdf.format(acttime).compareTo(sdf.format(entryvaliddate)) > 0 || isOpenCP && isExistsECN)) {
                                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8eBOM\u5206\u5f55\u6700\u65b0\u7ec4\u4ef6\u751f\u6548\u65f6\u95f4\u3002", (String)"ECNNewSubmitValidator_66", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                                continue;
                            }
                            if (!(acttime == null || sdf.format(acttime).compareTo(sdf.format(entryinvaliddate)) <= 0 || isOpenCP && isExistsECN)) {
                                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8eBOM\u5206\u5f55\u6700\u65b0\u7ec4\u4ef6\u5931\u6548\u65f6\u95f4\u3002", (String)"ECNNewSubmitValidator_67", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                                continue;
                            }
                        }
                    }
                    DynamicObjectCollection qtyentry = entryentity.getDynamicObjectCollection("qtyentry");
                    String entryqtytype = MMCUtils.getDynamicObjectStringData((DynamicObject)entryentity, (String)"entryqtytype");
                    if ("C".equalsIgnoreCase(entryqtytype) && (qtyentry == null || qtyentry.isEmpty())) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u884c\u7ec4\u4ef6\u5206\u5f55\uff0c\u201c\u7528\u91cf\u7c7b\u578b\u201d\u4e3a\u9636\u68af\u65f6\uff0c\u9636\u68af\u7528\u91cf\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ECNNewSubmitValidator_17", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    if (entrymaterialid != null && (ECOEntryModeEnum.NEW.getValue().equalsIgnoreCase(entrymode) || ECOEntryModeEnum.EDIT.getValue().equalsIgnoreCase(entrymode)) && (auxIsMustInput = BomMaterialAuxPropHelper.isMustInput((Long)entrymaterialid.getLong("id"), (Long)org.getLong("id"))) && MMCUtils.getDynamicObjectData((DynamicObject)entryentity, (String)"entryauxproperty") == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6,\u5df2\u542f\u7528\u8f85\u52a9\u5c5e\u6027,\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u3002", (String)"ECNNewSubmitValidator_32", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    String replaceGroupNo = entryentity.getString("entryreplacegroup");
                    if (replaceGroupNo != null && !"".equals(replaceGroupNo) && (StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"E", (CharSequence)entrymode))) {
                        Date groupActtime = (Date)replaceGroupMap.get(replaceGroupNo);
                        if (groupActtime == null) {
                            replaceGroupMap.put(replaceGroupNo, acttime);
                        } else if (sdf.format(groupActtime).compareTo(sdf.format(acttime)) != 0) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u7f16\u7801%3$s\uff0c\u76f8\u540c\u7684\u66ff\u4ee3\u7ec4\u53f7\u5bf9\u5e94\u7684\u5b9e\u65bd\u65f6\u95f4\u4e0d\u540c\u3002", (String)"ECNNewSubmitValidator_97", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, entrymaterialid.getString("number")));
                            continue;
                        }
                        String oldRefno = (String)replaceGroupRefNoMap.get(replaceGroupNo);
                        if (oldRefno == null) {
                            replaceGroupRefNoMap.put(replaceGroupNo, entryRefNo);
                        } else if (PlatformUtils.isDiffString((String)oldRefno, (String)entryRefNo)) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u7ec4\u4ef6\u7f16\u7801%3$s\uff0c\u76f8\u540c\u7684\u66ff\u4ee3\u7ec4\u53f7\u5bf9\u5e94\u7684\u5173\u8054\u5b9e\u65bd\u53f7\u4e0d\u540c\u3002", (String)"ECNNewSubmitValidator_98", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, entrymaterialid.getString("number")));
                            continue;
                        }
                    }
                    if (PlatformUtils.isNullLong((Long)(bomentryId = Long.valueOf(entryentity.getLong("entrybomentryid"))))) continue;
                    bomEntryIdSet.add(bomentryId);
                }
                if (!this.groupNoValidate(entry, entrys, obj)) continue;
                this.copEntryValidate(obj, copentrys, i, bomMaterialMaster, versionCtr, bomEntryMaterialIdSet, bomCopEntryMaterialIdSet, bomTypeRule);
            }
            if ((statusMsg = this.checkBomRtIsAuditStatus(dObject)) != null && !"".equals(statusMsg)) {
                this.addErrorMessage(obj, statusMsg);
                continue;
            }
            if (!chkHasKeyGroupNoAllSet.isEmpty()) {
                for (String groups : chkHasKeyGroupNoAllSet) {
                    if (chkHasKeyGroupNoSet.contains(groups)) continue;
                    String groupno = PlatformUtils.getGroupNo((String)groups);
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u6210\u7ec4\u53f7\u201c%1$s\u201d\u7f3a\u5c11\u4e3b\u952e\u3002", (String)"ECNNewSubmitValidator_51", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), groupno));
                }
            }
            if (isOpenCP || bomEntryIdSet.isEmpty() || (otherEcnMap = EcoUtils.getEcnBomEntryNoEnd(bomEntryIdSet, (Long)(ecnId = Long.valueOf(dObject.getLong("id"))))) == null || otherEcnMap.isEmpty()) continue;
            String otherEcnBillNo = (String)otherEcnMap.get("ecobillno");
            String entrydesc = (String)otherEcnMap.get("entrydesc");
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"BOM\u5206\u5f55\u201c%1$s\u201d\u5b58\u5728\u672a\u8bc4\u4f30\u5b8c\u6210\u7684\u5176\u5b83\u53d8\u66f4\u5355\u201c%2$s\u201d\uff0c\u8bf7\u5148\u5b8c\u6210\u8bc4\u4f30\u540e\u518d\u63d0\u4ea4\u3002", (String)"ECNNewSubmitValidator_64", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), entrydesc, otherEcnBillNo));
        }
        this.refNoValidate(refNoSet, refNoSetA, refNoSetB, refNoRowMap, refNoEcoTypeMap, ecoBomIdSet);
        Set<Long> errorRowIndexSet = this.getErrorRowIndexSet();
        DynamicObject submitObjTem = BusinessDataServiceHelper.newDynamicObject((String)"pdm_ecobom");
        for (ExtendedDataEntity obj : objs) {
            DynamicObject dObject = obj.getDataEntity();
            if (!this.isBomChange(dObject) || errorRowIndexSet.contains(dObject.getPkValue())) continue;
            DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
            this.pentrySubmit(pentrys, obj, submitObjTem);
        }
    }

    private void pentrySubmit(DynamicObjectCollection pentry, ExtendedDataEntity enobj, DynamicObject submitObjTem) {
        ArrayList<Long> list = new ArrayList<Long>(16);
        HashMap<Long, DynamicObject> versionMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject[] obj : pentry) {
            String controlVersion = obj.getString("entryversioncontrol");
            if (!"D".equals(controlVersion)) continue;
            Long ecobomid = obj.getLong("ecobomid");
            list.add(ecobomid);
            versionMap.put(ecobomid, obj.getDynamicObject("pentrynewversion"));
        }
        if (!list.isEmpty()) {
            DynamicObject[] col;
            for (DynamicObject dy : col = BusinessDataServiceHelper.load((Object[])list.toArray(new Object[list.size()]), (DynamicObjectType)submitObjTem.getDynamicObjectType())) {
                String number = dy.getString("number");
                if (number == null || "".equals(number)) {
                    dy.set("number", (Object)("temp_" + dy.getPkValue()));
                }
                dy.set("status", (Object)"A");
                dy.set("version", versionMap.get(dy.getPkValue()));
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"pdm_ecobom", (DynamicObject[])col, null);
            String submitErrorMsg = PlatformUtils.getErrorMsg((OperationResult)result);
            if (submitErrorMsg != null && !"".equals(submitErrorMsg)) {
                this.addErrorMessage(enobj, submitErrorMsg);
            }
        }
    }

    public void refNoValidate(Set<String> refNoSet, Set<String> refNoSetA, Set<String> refNoSetB, Map<String, ExtendedDataEntity> refNoRowMap, Map<String, Map<Long, Long>> refNoEcoTypeMap, Set<Long> ecoBomIdSet) {
        Map refNoEcoTypeMap2;
        ExtendedDataEntity obj;
        Set existEndSet;
        if (refNoSet.isEmpty()) {
            return;
        }
        if (!refNoSetA.isEmpty() && !(existEndSet = EcoUtils.checkRefnoIsEnd(refNoSetA, (boolean)false)).isEmpty()) {
            for (String string : existEndSet) {
                obj = refNoRowMap.get(string);
                if (obj == null) continue;
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u65bd\u53f7\u201c%1$s\u201d\u5df2\u5b58\u5728\u8bc4\u4f30\u5b8c\u6210\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u3002", (String)"ECNNewSubmitValidator_74", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), existEndSet.toString()));
            }
        }
        if (!refNoSetB.isEmpty() && !(existEndSet = EcoUtils.checkRefnoIsEnd(refNoSetB, (boolean)false)).isEmpty()) {
            for (String string : existEndSet) {
                obj = refNoRowMap.get(string);
                if (obj == null) continue;
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u65bd\u53f7\u201c%1$s\u201d\u5df2\u5b58\u5728\u8bc4\u4f30\u5b8c\u6210\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u3002", (String)"ECNNewSubmitValidator_74", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), existEndSet.toString()));
            }
        }
        if ((refNoEcoTypeMap2 = EcoUtils.getRefnoEcoTypeMap(refNoSet, ecoBomIdSet)) == null || refNoEcoTypeMap2.isEmpty()) {
            return;
        }
        block2: for (Map.Entry entry : refNoEcoTypeMap2.entrySet()) {
            String refNo = (String)entry.getKey();
            Map<Long, Long> ecoBomRefDataMap = refNoEcoTypeMap.get(refNo);
            if (ecoBomRefDataMap == null) continue;
            Long currentEcoTypeId = PlatformUtils.getFirstLongValueFromMap(ecoBomRefDataMap);
            Map ecoBomDataMap2 = (Map)entry.getValue();
            for (Map.Entry ecoBomDataMap2s : ecoBomDataMap2.entrySet()) {
                ExtendedDataEntity obj2;
                Long ecoBomId = (Long)ecoBomDataMap2s.getKey();
                Long ecoTypeId = (Long)ecoBomDataMap2s.getValue();
                if (ecoTypeId == null || ecoTypeId.equals(0L) || currentEcoTypeId.equals(ecoTypeId) || ecoBomRefDataMap.containsKey(ecoBomId) || (obj2 = refNoRowMap.get(refNo)) == null) continue;
                this.addErrorMessage(obj2, String.format(ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u65bd\u53f7\u201c%1$s\u201d\u5bf9\u5e94\u7684\u53d8\u66f4\u7c7b\u578b\u4e0d\u552f\u4e00\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ECNNewSubmitValidator_71", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), refNo));
                continue block2;
            }
        }
    }

    public boolean groupNoValidate(DynamicObject pentry, DynamicObjectCollection entrys, ExtendedDataEntity enobj) {
        String keyString;
        if (PlatformUtils.isDisableGroupNo()) {
            return true;
        }
        DynamicObject ecoType = pentry.getDynamicObject("ecotype");
        DynamicObject pmaterialid = pentry.getDynamicObject("proentrymaterialid");
        boolean isEditGroupKeyType = EcoUtils.isEditMode((DynamicObject)ecoType, (String)"groupkeytype");
        HashMap<String, Date> addMap = new HashMap<String, Date>(16);
        HashMap<String, Date> disableMap = new HashMap<String, Date>(16);
        boolean hasError = false;
        HashSet<String> existMulGroupKey = new HashSet<String>(16);
        HashMap<String, String> groupMap = new HashMap<String, String>(16);
        HashMap<String, Boolean> hasKeyMap = new HashMap<String, Boolean>(16);
        int size = entrys.size();
        for (int j = 0; j < size; ++j) {
            String oldEntryrefno;
            DynamicObject entryentity = (DynamicObject)entrys.get(j);
            String entrygroupno = entryentity.getString("entrygroupno");
            if (PlatformUtils.isNullString((String)entrygroupno)) continue;
            String entryrefno = entryentity.getString("entryrefno");
            String entryMode = entryentity.getString("entrymode");
            Date actTime = entryentity.getDate("acttime");
            String keyString2 = entrygroupno;
            if ("A".equals(entryMode)) {
                addMap.put(keyString2, actTime);
            } else if ("E".equals(entryMode)) {
                disableMap.put(keyString2, actTime);
            }
            boolean isGroupKey = entryentity.getBoolean("groupkey");
            if (!hasKeyMap.containsKey(keyString2)) {
                hasKeyMap.put(keyString2, false);
            }
            if (isGroupKey) {
                hasKeyMap.put(keyString2, true);
                if (!"E".equals(entryMode)) {
                    this.addErrorMessage(enobj, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7269\u6599\u201c%1$s\u201d\u4e0b\u7684\u6210\u7ec4\u53f7\u201c%2$s\u201d\u7684\u6210\u7ec4\u4e3b\u952e\u5fc5\u987b\u5728\u5931\u6548\u884c\u4e0a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ECNNewSubmitValidator_58", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pmaterialid.getString("number"), entrygroupno));
                    hasError = true;
                }
                if (!existMulGroupKey.add(keyString2)) {
                    this.addErrorMessage(enobj, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7269\u6599\u201c%1$s\u201d\u4e0b\u7684\u6210\u7ec4\u53f7\u201c%2$s\u201d\u5b58\u5728\u591a\u4e2a\u6210\u7ec4\u4e3b\u952e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ECNNewSubmitValidator_42", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pmaterialid.getString("number"), entrygroupno));
                    hasError = true;
                }
                if (actTime == null) {
                    this.addErrorMessage(enobj, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7269\u6599\u201c%1$s\u201d\u4e0b\u7684\u7b2c\u201c%2$s\u201d\u884c\u6570\u636e\u4e3a\u6210\u7ec4\u4e3b\u952e\uff0c\u4f46\u662f\u5b9e\u65bd\u65f6\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ECNNewSubmitValidator_45", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pmaterialid.getString("number"), j + 1));
                    hasError = true;
                }
            }
            if (PlatformUtils.isNullString((String)entryrefno)) continue;
            if (groupMap.containsKey(keyString2) && !(oldEntryrefno = (String)groupMap.get(keyString2)).equals(entryrefno)) {
                this.addErrorMessage(enobj, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7269\u6599\u201c%1$s\u201d\u4e0b\u7684\u7b2c\u201c%2$s\u201d\u884c\u6570\u636e\u7684\u6210\u7ec4\u53f7\u201c%3$s\u201d\u5b58\u5728\u591a\u4e2a\u5173\u8054\u5b9e\u65bd\u53f7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ECNNewSubmitValidator_57", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pmaterialid.getString("number"), j + 1, entrygroupno));
                hasError = true;
            }
            groupMap.put(keyString2, entryrefno);
        }
        if (hasError) {
            return false;
        }
        if (isEditGroupKeyType) {
            for (Map.Entry datas : hasKeyMap.entrySet()) {
                if (Boolean.TRUE.equals(datas.getValue())) continue;
                keyString = (String)datas.getKey();
                this.addErrorMessage(enobj, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7269\u6599\u201c%1$s\u201d\u4e0b\u7684\u6210\u7ec4\u53f7\u201c%2$s\u201d\u6ca1\u6709\u6210\u7ec4\u4e3b\u952e\u884c\u3002", (String)"ECNNewSubmitValidator_59", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pmaterialid.getString("number"), keyString));
                hasError = true;
            }
        }
        for (Map.Entry addEntrys : addMap.entrySet()) {
            keyString = (String)addEntrys.getKey();
            if (disableMap.containsKey(keyString)) continue;
            this.addErrorMessage(enobj, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7269\u6599\u201c%1$s\u201d\u4e0b\u7684\u6210\u7ec4\u53f7\u201c%2$s\u201d\u6ca1\u6709\u540c\u65f6\u5b58\u5728\u65b0\u589e\u4e0e\u5931\u6548\u7684\u7ec4\u4ef6\u6570\u636e\u3002", (String)"ECNNewSubmitValidator_38", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pmaterialid.getString("number"), keyString));
            hasError = true;
        }
        if (hasError) {
            return false;
        }
        for (Map.Entry disableEntrys : disableMap.entrySet()) {
            keyString = (String)disableEntrys.getKey();
            if (addMap.containsKey(keyString)) continue;
            this.addErrorMessage(enobj, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7269\u6599\u201c%1$s\u201d\u4e0b\u7684\u6210\u7ec4\u53f7\u201c%2$s\u201d\u6ca1\u6709\u540c\u65f6\u5b58\u5728\u65b0\u589e\u4e0e\u5931\u6548\u7684\u7ec4\u4ef6\u6570\u636e\u3002", (String)"ECNNewSubmitValidator_38", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pmaterialid.getString("number"), keyString));
            hasError = true;
        }
        return !hasError;
    }

    private Set<Long> getErrorRowIndexSet() {
        HashSet<Long> errorSet = new HashSet<Long>(16);
        ValidateResult res = this.getValidateResult();
        List lista = res.getAllErrorInfo();
        if (!lista.isEmpty()) {
            for (OperateErrorInfo op : lista) {
                errorSet.add((Long)op.getPkValue());
            }
        }
        return errorSet;
    }

    public boolean checkCopVersion(DynamicObject version, Long copMaterialMasterId) {
        if (version == null) {
            return true;
        }
        DynamicObject versionMaterial = version.getDynamicObject("material");
        return versionMaterial != null && copMaterialMasterId.equals(versionMaterial.getPkValue());
    }

    public void copEntryValidate(ExtendedDataEntity obj, DynamicObjectCollection copentrys, int pentryRowIndex, DynamicObject bomMaterialMaster, String versionCtr, Set<Long> bomEntryMaterialIdSet, Set<Long> bomCopEntryMaterialIdSet, DynamicObject bomTypeRule) {
        int entrySize = copentrys.size();
        int index = 0;
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DynamicObject dObject = obj.getDataEntity();
        for (int j = 0; j < entrySize; ++j) {
            boolean auxIsMustInput;
            Long bomCopEntryId;
            DynamicObject copEntry = (DynamicObject)copentrys.get(j);
            ++index;
            String entrymode = copEntry.getString("copentrymode");
            if (StringUtils.isBlank((CharSequence)entrymode)) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u884c\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"ECNNewSubmitValidator_76", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                continue;
            }
            String copentrytype = copEntry.getString("copentrytype");
            if (StringUtils.isBlank((CharSequence)copentrytype)) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u4ea7\u54c1\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"ECNNewSubmitValidator_79", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                continue;
            }
            DynamicObject copentrymaterial = copEntry.getDynamicObject("copentrymaterial");
            if ((StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) && copentrymaterial == null) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u672a\u5f55\u5165\u4ea7\u54c1\u7f16\u7801\u3002", (String)"ECNNewSubmitValidator_77", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                continue;
            }
            BigDecimal copQty = copEntry.getBigDecimal("copentryqty");
            if ((StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) && (copQty == null || copQty.compareTo(BigDecimal.ZERO) <= 0)) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u5b57\u6bb5[\u6570\u91cf]\u7684\u503c0.0000000000\u8d85\u51fa\u9650\u5b9a\u8303\u56f4(0,9999999999999]\u3002", (String)"ECNNewSubmitValidator_94", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                continue;
            }
            Long copMaterialMasterId = (Long)copentrymaterial.getDynamicObject("masterid").getPkValue();
            if (copMaterialMasterId.equals((Long)bomMaterialMaster.getPkValue())) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u8054\u526f\u4ea7\u54c1\u7f16\u7801\u4e0eBOM\u8868\u5934\u7684\u4ea7\u54c1\u7f16\u7801\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ECNNewSubmitValidator_80", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                continue;
            }
            DynamicObject entryversion = copEntry.getDynamicObject("copentryversion");
            if ((StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) && !this.checkCopVersion(entryversion, copMaterialMasterId)) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u7248\u672c\u53f7\u5bf9\u5e94\u7684\u7269\u6599\u4e0e\u8054\u526f\u4ea7\u54c1\u7269\u6599\u4e0d\u4e00\u81f4\u3002", (String)"ECNNewSubmitValidator_78", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                continue;
            }
            Date entryvaliddate = copEntry.getDate("copentryvaliddate");
            if (entryvaliddate == null) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u751f\u6548\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ECNNewSubmitValidator_81", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                continue;
            }
            Date entryinvaliddate = copEntry.getDate("copentryinvaliddate");
            if (entryinvaliddate == null) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u5931\u6548\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ECNNewSubmitValidator_82", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                continue;
            }
            if (copEntry.getDate("copacttime") == null) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"ECNNewSubmitValidator_100", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                continue;
            }
            Date entryinvaliddatetrans = null;
            Date entryvaliddatetrans = null;
            try {
                entryinvaliddatetrans = sd.parse(sd.format(entryinvaliddate));
                entryvaliddatetrans = sd.parse(sd.format(entryvaliddate));
            }
            catch (ParseException e) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c%3$s", (String)"ECNNewSubmitValidator_83", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index, e.getMessage()));
                continue;
            }
            if (entryvaliddatetrans.compareTo(entryinvaliddatetrans) > 0) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u5176\u201c\u5931\u6548\u65e5\u671f\u201d\uff1c\u201c\u751f\u6548\u65e5\u671f\u201d", (String)"ECNNewSubmitValidator_84", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                continue;
            }
            if (StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) {
                DynamicObject dynamicObject;
                Date entryvaliddateBefore;
                Long entrybomCopEntryid = copEntry.getLong("oldcopentryid");
                Optional<DynamicObject> optional = copentrys.stream().filter(f -> "B".equals(f.getString("copentrymode")) && Objects.equals(entrybomCopEntryid, f.getLong("oldcopentryid"))).findFirst();
                if (optional.isPresent() && (entryvaliddateBefore = (dynamicObject = optional.get()).getDate("copentryvaliddate")) != null && ECNNewUtil.setDateSubOne((Date)entryvaliddate).compareTo(entryvaliddateBefore) < 0) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u53d8\u66f4\u540e\u751f\u6548\u65f6\u95f4\u65e9\u4e8e\u53d8\u66f4\u524d\u8054\u526f\u4ea7\u54c1\u751f\u6548\u65f6\u95f4\u3002", (String)"ECNNewSubmitValidator_85", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                    continue;
                }
            }
            if (StringUtils.equals((CharSequence)"E", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"B", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) {
                Date acttime = copEntry.getDate("copacttime");
                if ((StringUtils.equals((CharSequence)"B", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"E", (CharSequence)entrymode)) && acttime != null && sdf.format(acttime).compareTo(sdf.format(entryvaliddate)) <= 0) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u8054\u526f\u4ea7\u54c1\u751f\u6548\u65f6\u95f4\u3002", (String)"ECNNewSubmitValidator_86", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                    continue;
                }
                if (acttime != null && sdf.format(acttime).compareTo(sdf.format(entryinvaliddate)) > 0) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u8054\u526f\u4ea7\u54c1\u5931\u6548\u65f6\u95f4\u3002", (String)"ECNNewSubmitValidator_87", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                    continue;
                }
            }
            if (StringUtils.equals((CharSequence)"E", (CharSequence)entrymode) && "A".equals(versionCtr) && !PlatformUtils.isNullLong((Long)(bomCopEntryId = Long.valueOf(copEntry.getLong("oldcopentryid"))))) {
                DynamicObject mftCopEntry;
                HashSet<Long> mftBomCopEntryIdSet = new HashSet<Long>(16);
                mftBomCopEntryIdSet.add(bomCopEntryId);
                String otherEcnBillNo = EcoCopUtils.getAduitEcnBill(mftBomCopEntryIdSet, (Long)dObject.getLong("id"), (String)entrymode);
                if (otherEcnBillNo != null && !"".equals(otherEcnBillNo)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55,\u4e0d\u5141\u8bb8\u540c\u65f6\u5b58\u5728\u591a\u5f20\u5931\u6548\u7684\u5de5\u7a0b\u53d8\u66f4\u6570\u636e,\u5176\u4ed6\u5de5\u7a0b\u53d8\u66f4\u5355\u53f7\u4e3a[%3$s]\u3002", (String)"ECNNewSubmitValidator_88", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index, otherEcnBillNo));
                    continue;
                }
                Map mftBomCopEntryDataMap = EcoCopUtils.getMftBomCopEntryData(mftBomCopEntryIdSet);
                DynamicObject dynamicObject = mftCopEntry = mftBomCopEntryDataMap == null ? null : (DynamicObject)mftBomCopEntryDataMap.get(bomCopEntryId);
                if (mftCopEntry != null) {
                    Date acttime = copEntry.getDate("copacttime");
                    entryvaliddate = mftCopEntry.getDate("copentryvaliddate");
                    entryinvaliddate = mftCopEntry.getDate("copentryinvaliddate");
                    if (acttime != null && sdf.format(acttime).compareTo(sdf.format(entryvaliddate)) <= 0) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8eBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u6700\u65b0\u751f\u6548\u65f6\u95f4\u3002", (String)"ECNNewSubmitValidator_89", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                        continue;
                    }
                    if (acttime != null && sdf.format(acttime).compareTo(sdf.format(entryinvaliddate)) > 0) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8eBOM\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u6700\u65b0\u5931\u6548\u65f6\u95f4\u3002", (String)"ECNNewSubmitValidator_90", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                        continue;
                    }
                }
            }
            if ((StringUtils.equals((CharSequence)"C", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"A", (CharSequence)entrymode)) && entryversion != null && !BOMVersionUtil.checkIsSameRule((DynamicObject)bomTypeRule, (DynamicObject)entryversion)) {
                DynamicObject versionRule = BOMVersionUtil.getVersionRule((DynamicObject)entryversion);
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u7248\u672c\u53f7\u5bf9\u5e94\u7684\u7248\u672c\u89c4\u5219\u201c%3$s\u201d\u4e0eBOM\u7c7b\u578b\u7684\u7248\u672c\u89c4\u5219\u201c%4$s\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ECNNewSubmitValidator_103", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index, bomTypeRule.getString("number"), versionRule.getString("number")));
                continue;
            }
            DynamicObject copentrymaterialId = copEntry.getDynamicObject("copentrymaterialid");
            if (copentrymaterialId != null && (ECOEntryModeEnum.NEW.getValue().equalsIgnoreCase(entrymode) || ECOEntryModeEnum.EDIT.getValue().equalsIgnoreCase(entrymode)) && (auxIsMustInput = BomMaterialAuxPropHelper.isMustInput((Long)copentrymaterialId.getLong("id"), (Long)dObject.getDynamicObject("org").getLong("id"))) && MMCUtils.getDynamicObjectData((DynamicObject)copEntry, (String)"copentryauxproperty") == null) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55,\u5df2\u542f\u7528\u8f85\u52a9\u5c5e\u6027,\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u3002", (String)"ECNNewSubmitValidator_91", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index));
                continue;
            }
            if (copentrymaterialId == null || !StringUtils.equals((CharSequence)"A", (CharSequence)entrymode)) continue;
            bomCopEntryMaterialIdSet.add(copentrymaterialId.getLong("id"));
            if (!bomEntryMaterialIdSet.contains(copentrymaterialId.getLong("id"))) continue;
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u8054\u526f\u4ea7\u54c1\u5206\u5f55\uff0c\u8054\u526f\u4ea7\u54c1\u7f16\u7801%3$s\u5728\u7ec4\u4ef6\u5206\u5f55\u4e2d\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ECNNewSubmitValidator_96", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), pentryRowIndex + 1, index, copentrymaterialId.getString("number")));
        }
    }
}

