/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn.route;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.pdm.business.ecoplatform.EcoRouteUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.opplugin.ecn.ECNBaseValidatorPlugin;

public class ECNRouteAuditValidatorPlugin
extends ECNBaseValidatorPlugin {
    private static final Log logger = LogFactory.getLog(ECNRouteAuditValidatorPlugin.class);

    @Override
    public void validate() {
        String operate = this.getOperateKey();
        if (!"audit".equals(operate)) {
            return;
        }
        ExtendedDataEntity[] objs = this.getDataEntities();
        HashSet<Long> allProcessEntryIdSet = new HashSet<Long>(16);
        HashMap<Long, String> routeEntryEcoBillMap = new HashMap<Long, String>(16);
        Date neweffectdate = new Date();
        HashSet<String> repeatKeyString = new HashSet<String>(16);
        HashSet<String> judgeSame = new HashSet<String>(16);
        HashSet<Object> orgIdSet = new HashSet<Object>(16);
        Set<Long> ecoRouteIdSet = this.getEcoRouteIdSet(objs);
        Map<Long, DynamicObject> ecoRouteDataMap = this.getEcoRouteDatas(ecoRouteIdSet);
        block0: for (ExtendedDataEntity obj : objs) {
            DynamicObject dObject = obj.getDataEntity();
            if (!this.isRouteChange(dObject)) continue;
            String ecoBillNo = dObject.getString("billno");
            DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
            DynamicObject ecnorg = dObject.getDynamicObject("org");
            block1: for (int k = 0; k < pentrys.size(); ++k) {
                boolean versionres;
                DynamicObject pentry = (DynamicObject)pentrys.get(k);
                String entryversioncontrol = pentry.getString("entryversioncontrol");
                if (StringUtils.equals((CharSequence)entryversioncontrol, (CharSequence)"D") && orgIdSet.add(ecnorg.getPkValue()) && !(versionres = this.checkAddAuth(ecnorg, "pdm_route"))) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u7ec7\u201c%s\u201d\u7684\u5de5\u827a\u8def\u7ebf\u65b0\u589e\u6743\u9650\u3002", (String)"ECNRouteAuditValidatorPlugin_01", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), ecnorg.getString("name")));
                    continue block0;
                }
                DynamicObject route = pentry.getDynamicObject("pentryroute");
                Long ecorouteid = pentry.getLong("ecorouteid");
                if (PlatformUtils.isNullLong((Long)ecorouteid)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4ea7\u54c1\u5206\u5f55\uff0c\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"ECNRouteAuditValidatorPlugin_02", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1));
                    continue block0;
                }
                DynamicObject pEntryRouteDO = ecoRouteDataMap.get(ecorouteid);
                DynamicObjectCollection entrys = pEntryRouteDO.getDynamicObjectCollection("processentry");
                if (PlatformUtils.isNullCollection((DynamicObjectCollection)entrys)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4ea7\u54c1\u5206\u5f55\uff0c\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"ECNRouteAuditValidatorPlugin_02", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1));
                    continue block0;
                }
                if (!"D".equals(entryversioncontrol)) {
                    if (!repeatKeyString.add(String.valueOf(route.getPkValue()))) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u4fee\u6539\u6216\u987a\u5ef6\u7248\u672c\u64cd\u4f5c\u65f6\uff0c\u540c\u4e00\u5de5\u827a\u8def\u7ebf\u7f16\u7801%2$s\u4e0d\u5141\u8bb8\u8fdb\u884c\u591a\u6b21\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"ECNRouteSubmitValidatorPlugin_27", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1, route.getString("number")));
                        continue;
                    }
                } else {
                    DynamicObject mater = this.getMaterialMasterObj(pentry);
                    DynamicObject pentrynewversion = pentry.getDynamicObject("pentrynewrtversion");
                    String flag = mater.getPkValue() + "_" + pentrynewversion.getPkValue();
                    if (!judgeSame.add(flag)) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u5b58\u5728\u521d\u59cb\u7248\u672c\uff0c\u4ea7\u54c1\u7f16\u7801\uff0c\u65b0\u7248\u672c\u76f8\u540c\u7684\u5206\u5f55\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ECNRouteSubmitValidatorPlugin_20", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1));
                        continue;
                    }
                }
                Map<Long, DynamicObject> routeEntryDataMap = this.getRouteEntryData(entrys);
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject routeEntry;
                    Date invaliddate;
                    String msg;
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    String entrymode = entry.getString("entrymode");
                    Long processEntryid = entry.getLong("oldprocessentryid");
                    if (!PlatformUtils.isNullLong((Long)processEntryid)) {
                        if (!allProcessEntryIdSet.add(processEntryid)) {
                            String otherEcoBillNo = (String)routeEntryEcoBillMap.get(processEntryid);
                            if (otherEcoBillNo != null && !ecoBillNo.equals(otherEcoBillNo)) {
                                msg = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355%1$s\u4e0e\u53d8\u66f4\u5355%2$s\u7684\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5de5\u5e8f\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u8fdb\u884c\u5ba1\u6838\u5904\u7406\u3002", (String)"ECNRouteAuditValidatorPlugin_04", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), ecoBillNo, otherEcoBillNo);
                                this.addErrorMessage(obj, msg);
                                continue block1;
                            }
                        } else {
                            routeEntryEcoBillMap.put(processEntryid, ecoBillNo);
                        }
                    }
                    if ((StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) && (invaliddate = entry.getDate("entryinvaliddate")) != null && invaliddate.compareTo(neweffectdate) < 0) {
                        msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u201c\u5931\u6548\u65e5\u671f\u201d\uff1c\u201c\u5f53\u524d\u65e5\u671f\u201d\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"ECNRouteAuditValidatorPlugin_05", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1, i + 1);
                        this.addErrorMessage(obj, msg);
                        continue block1;
                    }
                    if (!StringUtils.equals((CharSequence)"E", (CharSequence)entrymode) || PlatformUtils.isNullLong((Long)processEntryid)) continue;
                    DynamicObject dynamicObject = routeEntry = routeEntryDataMap == null ? null : routeEntryDataMap.get(processEntryid);
                    if (routeEntry == null) continue;
                    Date acttime = entry.getDate("acttime");
                    Date entryvaliddate = routeEntry.getDate("entryvaliddate");
                    Date entryinvaliddate = routeEntry.getDate("entryinvaliddate");
                    if (acttime != null && acttime.compareTo(entryvaliddate) <= 0) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5de5\u827a\u8def\u7ebf\u5de5\u5e8f\u5206\u5f55\u6700\u65b0\u751f\u6548\u65f6\u95f4\u3002", (String)"ECNRouteAuditValidatorPlugin_06", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1, i + 1));
                        continue block1;
                    }
                    if (acttime == null || acttime.compareTo(entryinvaliddate) <= 0) continue;
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5de5\u827a\u8def\u7ebf\u5de5\u5e8f\u5206\u5f55\u6700\u65b0\u5931\u6548\u65f6\u95f4\u3002", (String)"ECNRouteAuditValidatorPlugin_07", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), k + 1, i + 1));
                    continue block1;
                }
            }
        }
    }

    private Map<Long, DynamicObject> getRouteEntryData(DynamicObjectCollection entrys) {
        int entrySize = entrys.size();
        HashSet<Long> processEntryIdSet = new HashSet<Long>(16);
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            String entrymode = entry.getString("entrymode");
            if (!StringUtils.equals((CharSequence)"E", (CharSequence)entrymode)) continue;
            Long processEntryid = entry.getLong("oldprocessentryid");
            processEntryIdSet.add(processEntryid);
        }
        return EcoRouteUtils.getRouteEntryData(processEntryIdSet);
    }
}

