/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn.route;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.ECNUtil;
import kd.mmc.pdm.opplugin.ecn.ECNBaseValidatorPlugin;

public class ECNRouteSaveValidatorPlugin
extends ECNBaseValidatorPlugin {
    @Override
    public void validate() {
        super.validate();
        String operate = this.getOperateKey();
        if (!"save".equals(operate) && !"submit".equals(operate)) {
            return;
        }
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (null == objs || objs.length == 0) {
            return;
        }
        Map<Long, DynamicObject> ecoRouteMaps = this.getEcoRoutes(objs);
        for (ExtendedDataEntity obj : objs) {
            DynamicObject dObject = obj.getDataEntity();
            if (!this.isRouteChange(dObject)) continue;
            DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
            if (pentrys.isEmpty()) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u53f7%s\u7684\u4ea7\u54c1\u5206\u5f55\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"ECNRouteSaveValidatorPlugin_9", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), dObject.getString("billno")));
                continue;
            }
            String checkOrgMsg = this.checkOrgPermItem(dObject);
            if (!this.isNullString(checkOrgMsg)) {
                this.addErrorMessage(obj, checkOrgMsg);
                continue;
            }
            HashMap<String, Integer> check = new HashMap<String, Integer>(16);
            int pSize = pentrys.size();
            boolean isCreateVersion = false;
            for (int i = 0; i < pSize; ++i) {
                String checkInputRtNameMsg;
                DynamicObject entry = (DynamicObject)pentrys.get(i);
                DynamicObject route = entry.getDynamicObject("pentryroute");
                Long ecoRouteId = entry.getLong("ecorouteid");
                String versionCtr = entry.getString("entryversioncontrol");
                DynamicObject mater = this.getMaterialMasterObj(entry);
                this.setDefaultEcoType(dObject, entry);
                DynamicObject ecoRoute = ecoRouteMaps.get(ecoRouteId);
                String checkEcoRouteMsg = this.checkEcoRouteData(ecoRoute, entry);
                if (!this.isNullString(checkEcoRouteMsg)) {
                    this.addErrorMessage(obj, checkEcoRouteMsg);
                    continue;
                }
                if (mater == null) continue;
                String pMaterPK = mater.getString("id");
                String materialNum = mater.getString("number");
                if (!"D".equals(versionCtr)) {
                    Long pbomPK = ECNUtil.getDynamicObjectId((DynamicObject)route);
                    if (pbomPK <= 0L) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0c\u5de5\u827a\u8def\u7ebf\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ECNRouteSaveValidatorPlugin_0", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    String chkExistsEcnMsg = this.checkExistsEcnBill(dObject, route);
                    if (!this.isNullString(chkExistsEcnMsg)) {
                        this.setAddBillNoForContent(false);
                        this.addErrorMessage(obj, chkExistsEcnMsg);
                        continue;
                    }
                    if ("B".equals(versionCtr)) {
                        Object value = check.get(pMaterPK);
                        if (value != null) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\u3001\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\u201c%3$s\u201d\u4ea7\u54c1\u7f16\u7801\u76f8\u540c\uff0c\u4e0d\u80fd\u540c\u65f6\u8fdb\u884c\u987a\u5ef6\u7248\u672c\u53d8\u66f4\u3002", (String)"ECNRouteSaveValidatorPlugin_1", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), check.get(pMaterPK), i + 1, materialNum));
                            continue;
                        }
                        check.put(pMaterPK, i + 1);
                    }
                }
                if (this.isNullString(checkInputRtNameMsg = this.checkRouteNameIsNull(dObject, entry))) continue;
                this.addErrorMessage(obj, checkInputRtNameMsg);
            }
            String statusMsg = this.checkBomRtIsAuditStatus(dObject);
            if (statusMsg == null || "".equals(statusMsg)) continue;
            this.addErrorMessage(obj, statusMsg);
        }
    }

    public String checkEcoRouteData(DynamicObject ecoRoute, DynamicObject pentry) {
        String seq = pentry.getString("seq");
        if (ecoRoute == null) {
            return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u7684\u4e0d\u5b58\u5728\u5de5\u7a0b\u53d8\u66f4\u5de5\u827a\u8def\u7ebf\u5bf9\u8c61\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u5904\u7406\u3002", (String)"ECNRouteSaveValidatorPlugin_2", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), seq);
        }
        DynamicObjectCollection entryColl = ecoRoute.getDynamicObjectCollection("entryentity");
        if (PlatformUtils.isNullCollection((DynamicObjectCollection)entryColl)) {
            return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u7a0b\u53d8\u66f4\u5de5\u827a\u8def\u7ebf\u6570\u636e\u6ca1\u6709\u5f55\u5165\u5de5\u5e8f\u5e8f\u5217\u6570\u636e\u3002", (String)"ECNRouteSaveValidatorPlugin_3", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), seq);
        }
        DynamicObjectCollection processColl = ecoRoute.getDynamicObjectCollection("processentry");
        if (PlatformUtils.isNullCollection((DynamicObjectCollection)processColl)) {
            return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u7a0b\u53d8\u66f4\u5de5\u827a\u8def\u7ebf\u6570\u636e\u6ca1\u6709\u5f55\u5165\u5f85\u53d8\u66f4\u7684\u5de5\u5e8f\u4fe1\u606f\u6570\u636e\u3002", (String)"ECNRouteSaveValidatorPlugin_4", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), seq);
        }
        HashSet<String> processSeqSet = new HashSet<String>(16);
        for (int i = 0; i < entryColl.size(); ++i) {
            processSeqSet.add(((DynamicObject)entryColl.get(i)).getString("processseq"));
        }
        HashSet<String> repeatOpNoSet = new HashSet<String>(16);
        for (int i = 0; i < processColl.size(); ++i) {
            DynamicObject processEntry = (DynamicObject)processColl.get(i);
            String operationno = processEntry.getString("operationno");
            String parent = processEntry.getString("parent");
            String entryMode = processEntry.getString("entrymode");
            if (operationno == null || "".equals(operationno) || parent == null || "".equals(parent)) {
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u7a0b\u53d8\u66f4\u5de5\u827a\u8def\u7ebf\u6570\u636e\u4e2d\uff0c\u5de5\u5e8f\u4fe1\u606f\u6ca1\u6709\u5f55\u5165\u5de5\u5e8f\u53f7\u6216\u5de5\u5e8f\u5e8f\u5217\u3002", (String)"ECNRouteSaveValidatorPlugin_5", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), seq);
            }
            if (!processSeqSet.contains(parent)) {
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u7a0b\u53d8\u66f4\u5de5\u827a\u8def\u7ebf\u6570\u636e\u4e2d\uff0c\u5de5\u5e8f\u4fe1\u606f\u7684\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u4e0d\u5b58\u5728\u4e8e\u5e8f\u5217\u5206\u5f55\u4e2d\u3002", (String)"ECNRouteSaveValidatorPlugin_6", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), seq, parent);
            }
            if (("A".equals(entryMode) || "C".equals(entryMode) || "E".equals(entryMode)) && !repeatOpNoSet.add(parent + "_" + operationno)) {
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u7a0b\u53d8\u66f4\u5de5\u827a\u8def\u7ebf\u6570\u636e\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u91cd\u590d\u3002", (String)"ECNRouteSaveValidatorPlugin_7", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), seq, parent, operationno);
            }
            if (processEntry.getDate("acttime") != null) continue;
            return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ea7\u54c1\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u7a0b\u53d8\u66f4\u5de5\u827a\u8def\u7ebf\u6570\u636e\u4e2d\uff0c\u5de5\u5e8f\u4fe1\u606f\u7684\u5de5\u5e8f\u5e8f\u5217\u201c%2$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%3$s\u201d\u7684\u5b9e\u65bd\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"ECNRouteSaveValidatorPlugin_8", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), seq, parent, operationno);
        }
        return "";
    }
}

