/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn.route;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.opplugin.ecn.ECNBaseOpPlugin;
import kd.mmc.pdm.opplugin.ecn.ECNSetVersionValueValidator;
import kd.mmc.pdm.opplugin.ecn.route.ECNRouteSubmitValidatorPlugin;

public class ECNRouteSubmitOpPlugin
extends ECNBaseOpPlugin {
    private static final Log logger = LogFactory.getLog(ECNRouteSubmitOpPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("pentry.pentryroute");
        e.getFieldKeys().add("pentry.pentryroutename");
        e.getFieldKeys().add("pentry.pentryoldrtversion");
        e.getFieldKeys().add("pentry.pentrynewrtversion");
        e.getFieldKeys().add("pentry.ecorouteid");
        e.getFieldKeys().add("pentry.ecoroutedata");
        e.getFieldKeys().add("pentry.ecotype.trandatetoday");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ECNSetVersionValueValidator());
        e.addValidator((AbstractValidator)new ECNRouteSubmitValidatorPlugin());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        Set<Long> ecoRouteIds = this.getAllEcoObjIds(e.getDataEntities(), Boolean.TRUE);
        if (!ecoRouteIds.isEmpty()) {
            String errorMsg;
            Map<Long, DynamicObject> ecoRouteMap = this.getEcoRouteMap(ecoRouteIds);
            ArrayList<DynamicObject> updateEcoRouteList = new ArrayList<DynamicObject>(16);
            for (DynamicObject data : e.getDataEntities()) {
                if (!this.isRouteChange(data)) continue;
                DynamicObjectCollection pentrys = data.getDynamicObjectCollection("pentry");
                for (int k = 0; k < pentrys.size(); ++k) {
                    DynamicObject pentry = (DynamicObject)pentrys.get(k);
                    Long ecoRouteId = pentry.getLong("ecorouteid");
                    String versionCtr = pentry.getString("entryversioncontrol");
                    String routeName = pentry.getString("pentryroutename");
                    if (!"D".equals(versionCtr)) continue;
                    DynamicObject ecoRoute = ecoRouteMap.get(ecoRouteId);
                    ecoRoute.set("name", (Object)routeName);
                    ecoRoute.set("number", (Object)("temp_" + String.valueOf(ecoRouteId)));
                    ecoRoute.set("routeversion", pentry.get("pentrynewrtversion"));
                    updateEcoRouteList.add(ecoRoute);
                }
            }
            if (!updateEcoRouteList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updateEcoRouteList.toArray(new DynamicObject[updateEcoRouteList.size()]));
            }
            if (!StringUtils.isEmpty((CharSequence)(errorMsg = this.execOperate(ecoRouteIds, "pdm_ecoroute", e.getOperationKey())))) {
                e.setCancel(true);
                throw new KDBizException(new ErrorCode("submitEcoRoute", errorMsg), new Object[0]);
            }
        }
    }

    private Map<Long, DynamicObject> getEcoRouteMap(Set<Long> ecoRouteIdSet) {
        DynamicObject[] ecoRoutes;
        HashMap<Long, DynamicObject> maps = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dy : ecoRoutes = BusinessDataServiceHelper.load((String)"pdm_ecoroute", (String)"id,number,name,version,routeversion", (QFilter[])new QFilter[]{new QFilter("id", "in", ecoRouteIdSet)})) {
            maps.put(dy.getLong("id"), dy);
        }
        return maps;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject data : e.getDataEntities()) {
            if (!this.isRouteChange(data)) continue;
            DynamicObjectCollection pentrys = data.getDynamicObjectCollection("pentry");
            int psize = pentrys.size();
            for (int k = 0; k < psize; ++k) {
                DynamicObject pentry = (DynamicObject)pentrys.get(k);
                pentry.set("ecoroutedata", (Object)pentry.getLong("ecorouteid"));
            }
        }
    }
}

