/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecoplatform;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EcoPlanProgramOpVal
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(EcoPlanProgramOpVal.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String opKey = this.getOperateKey();
        if (!"audit".equals(opKey) && !"enable".equals(opKey)) {
            return;
        }
        HashSet<String> repeatSet = new HashSet<String>(16);
        int size = 0;
        for (ExtendedDataEntity data : dataEntities) {
            DynamicObject obj = data.getDataEntity();
            String number = obj.getString("number");
            ++size;
            DynamicObjectCollection coll = obj.getDynamicObjectCollection("orgentryentity");
            if (coll == null || coll.isEmpty() || (!"enable".equals(opKey) ? "audit".equals(opKey) && !"1".equals(obj.getString("enable")) : !"C".equals(obj.getString("status")))) continue;
            if (!"B".equals(obj.getString("estimatetype"))) continue;
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject entry = (DynamicObject)coll.get(i);
                DynamicObject org = entry.getDynamicObject("entrydemandorg");
                if (org == null) continue;
                String keyString = org.getPkValue() + "";
                if (!repeatSet.add(keyString)) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u7f16\u7801\u4e3a%2$s\u7684\u65b9\u6848\u5bf9\u5e94\u7684\u7ec4\u7ec7\u53c2\u6570\u4e2d\uff0c\u7ec4\u7ec7\u201c%3$s\u201d\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2a\u5ba1\u6838\u53ef\u7528\u7684\u914d\u7f6e\u3002", (String)"EcoPlanProgramOpVal_01", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), data.getRowIndex() + 1, number, org.getString("name")));
                }
                if (!this.isExists(org.getLong("id"), (Long)obj.getPkValue())) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u7f16\u7801\u4e3a%2$s\u7684\u65b9\u6848\u5bf9\u5e94\u7684\u7ec4\u7ec7\u53c2\u6570\u4e2d\uff0c\u7ec4\u7ec7\u201c%3$s\u201d\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2a\u5ba1\u6838\u53ef\u7528\u7684\u914d\u7f6e\u3002", (String)"EcoPlanProgramOpVal_01", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), data.getRowIndex() + 1, number, org.getString("name")));
            }
        }
    }

    private boolean isExists(Long orgId, Long id) {
        QFilter qfilter = new QFilter("orgentryentity.entrydemandorg", "=", (Object)orgId);
        qfilter.and(new QFilter("estimatetype", "=", (Object)"B"));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("id", "<>", (Object)id));
        return QueryServiceHelper.exists((String)"pdm_planprogram_eco", (QFilter[])new QFilter[]{qfilter});
    }
}

