/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.prdsel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.opplugin.prdsel.ProConfigSchemeSaveVal;

public class ProConfigSchemeSaveOp
extends AbstractOperationServicePlugIn {
    private static final String MPDM_FEATURE_TYPE = "mpdm_featuretype";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("bomopentype");
        e.getFieldKeys().add("configtype");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("masterid");
        e.getFieldKeys().add("configtype");
        e.getFieldKeys().add("featureinfo");
        e.getFieldKeys().add("featureinfo.featuretype");
        e.getFieldKeys().add("featureinfo.seq");
        e.getFieldKeys().add("subentryentity.id");
        e.getFieldKeys().add("subentryentity.featurenumberid");
        e.getFieldKeys().add("subentryentity.featureid");
        e.getFieldKeys().add("subentryentity.featurevalue");
        e.getFieldKeys().add("subentryentity.featurevaluename");
        e.getFieldKeys().add("subentryentity.featurevalueid");
        e.getFieldKeys().add("subentryentity.seq");
        e.getFieldKeys().add("number");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ProConfigSchemeSaveVal());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Map<Long, List<Long>> featureTypeDefsMap = this.getFeatureTypeDefInfos(dataEntities);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i];
            DynamicObjectCollection featureInfos = dataEntity.getDynamicObjectCollection("featureinfo");
            if (featureInfos == null || featureInfos.isEmpty()) continue;
            this.suppleFeatureDefInfo(featureInfos, featureTypeDefsMap);
        }
    }

    private void suppleFeatureDefInfo(DynamicObjectCollection featureInfos, Map<Long, List<Long>> featureTypeDefsMap) {
        for (int j = 0; j < featureInfos.size(); ++j) {
            int i;
            DynamicObject featureTypeRow = (DynamicObject)featureInfos.get(j);
            DynamicObject featureType = featureTypeRow.getDynamicObject("featuretype");
            if (featureType == null) continue;
            List<Long> featureDefPks = featureTypeDefsMap.get(featureType.getLong("id"));
            HashSet<Long> exsitFeatureDefs = new HashSet<Long>(8);
            DynamicObjectCollection featureVEntry = featureTypeRow.getDynamicObjectCollection("subentryentity");
            for (i = 0; i < featureVEntry.size(); ++i) {
                DynamicObject featureVRow = (DynamicObject)featureVEntry.get(i);
                DynamicObject featureDef = featureVRow.getDynamicObject("featureid");
                if (featureDef == null) continue;
                exsitFeatureDefs.add(featureDef.getLong("id"));
            }
            for (i = 0; i < featureDefPks.size(); ++i) {
                Long featureDefPk = featureDefPks.get(i);
                if (exsitFeatureDefs.contains(featureDefPk)) continue;
                DynamicObject featureVEntity = featureVEntry.addNew();
                int rowCount = featureVEntry.getRowCount();
                featureVEntity.set("featureid", (Object)featureDefPk);
                featureVEntity.set("seq", (Object)rowCount);
            }
        }
    }

    private Map<Long, List<Long>> getFeatureTypeDefInfos(DynamicObject[] dataEntities) {
        HashSet<Long> featureTypePks = new HashSet<Long>(8);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i];
            DynamicObjectCollection featureInfos = dataEntity.getDynamicObjectCollection("featureinfo");
            if (featureInfos == null || featureInfos.isEmpty()) continue;
            for (int j = 0; j < featureInfos.size(); ++j) {
                DynamicObject featureTypeRow = (DynamicObject)featureInfos.get(j);
                DynamicObject featureType = featureTypeRow.getDynamicObject("featuretype");
                if (featureType == null) continue;
                featureTypePks.add(featureType.getLong("id"));
            }
        }
        HashMap<Long, List<Long>> featureTypeDefMap = new HashMap<Long, List<Long>>(8);
        if (!featureTypePks.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", featureTypePks);
            DynamicObjectCollection featureTypeInfos = QueryServiceHelper.query((String)MPDM_FEATURE_TYPE, (String)this.getFeatureTypeField(), (QFilter[])new QFilter[]{qFilter});
            for (int i = 0; i < featureTypeInfos.size(); ++i) {
                DynamicObject featureTypeInfo = (DynamicObject)featureTypeInfos.get(i);
                long featureTypePk = featureTypeInfo.getLong("id");
                long featurePk = featureTypeInfo.getLong("entryentity.featurenum.id");
                List featureDefs = featureTypeDefMap.getOrDefault(featureTypePk, new ArrayList(8));
                featureDefs.add(featurePk);
                featureTypeDefMap.put(featureTypePk, featureDefs);
            }
        }
        return featureTypeDefMap;
    }

    public String getFeatureTypeField() {
        StringBuilder bomExpandField = new StringBuilder();
        bomExpandField.append("id,");
        bomExpandField.append("number,");
        bomExpandField.append("name,");
        bomExpandField.append("type,");
        bomExpandField.append("entryentity.id,");
        bomExpandField.append("entryentity.featurenum.id,");
        bomExpandField.append("entryentity.featurenum.number,");
        bomExpandField.append("entryentity.featurenum.name");
        return bomExpandField.toString();
    }
}

