/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.prdsel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMExpandConfigBusiness;
import kd.mmc.pdm.opplugin.prdsel.ProductConfigureSaveToBOMOrderOpVal;

public class ProductConfigureSaveToBOMOrderOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ProductConfigureSaveToBOMOrderOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("treeentryentity");
        e.getFieldKeys().add("bomid");
        e.getFieldKeys().add("bomentryid");
        e.getFieldKeys().add("prodorgid");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("masterconfigcode");
        e.getFieldKeys().add("materielno");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("productconfigplan");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("superbom");
        e.getFieldKeys().add("entryauxproperty");
        e.getFieldKeys().add("entryversion");
        e.getFieldKeys().add("entryqtytype");
        e.getFieldKeys().add("entryqty");
        e.getFieldKeys().add("treeentryentity.pid");
        e.getFieldKeys().add("treeentryentity.seq");
        e.getFieldKeys().add("treeentryentity.entryunit");
        e.getFieldKeys().add("treeentryentity.entryfixscrap");
        e.getFieldKeys().add("treeentryentity.entryscraprate");
        e.getFieldKeys().add("treeentryentity.entrymaterial");
        e.getFieldKeys().add("treeentryentity.entryseq");
        e.getFieldKeys().add("treeentryentity.configcode");
        e.getFieldKeys().add("treeentryentity.entryversion");
        e.getFieldKeys().add("treeentryentity.entryauxproperty");
        e.getFieldKeys().add("treeentryentity.entryqtynumerator");
        e.getFieldKeys().add("treeentryentity.entryqtydenominator");
        e.getFieldKeys().add("treeentryentity.entryvaliddate");
        e.getFieldKeys().add("treeentryentity.entryinvaliddate");
        e.getFieldKeys().add("treeentryentity.bomid");
        e.getFieldKeys().add("treeentryentity.bomentryid");
        e.getFieldKeys().add("treeentryentity.superbomentryid");
        e.getFieldKeys().add("treeentryentity.pmaterial");
        e.getFieldKeys().add("treeentryentity.entryqty");
        e.getFieldKeys().add("treeentryentity.pversion");
        e.getFieldKeys().add("treeentryentity.entryisjumplevel");
        e.getFieldKeys().add("treeentryentity.issolid");
        e.getFieldKeys().add("treeentryentity.workcenter");
        e.getFieldKeys().add("treeentryentity.workstation");
        e.getFieldKeys().add("treeentryentity.workentryqty");
        e.getFieldKeys().add("treeentryentity.workentryid");
        e.getFieldKeys().add("treeentryentity.superbomid");
        e.getFieldKeys().add("treeentryentity.maxqtyopt");
        e.getFieldKeys().add("treeentryentity.minqtyopt");
        e.getFieldKeys().add("saleorderentity");
        e.getFieldKeys().add("saleorderentryid");
        e.getFieldKeys().add("saleorderentryseq");
        e.getFieldKeys().add("saleorderno");
        e.getFieldKeys().add("configcode");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ProductConfigureSaveToBOMOrderOpVal());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        try (TXHandle tx = TX.requiresNew((String)"kd.mmc.pdm.opplugin.prdsel.ProductConfigureSaveToBOMOrderOp.saveBom");){
            boolean isFailed = this.saveBom(e);
            if (isFailed) {
                tx.setRollback(true);
            }
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("saveBom", ResManager.loadKDString((String)"\u751f\u6210\u8ba2\u5355\u5931\u8d25\u3002", (String)"ProductConfigureSaveToBOMOrderOp_0", (String)"mmc-pdm-opplugin", (Object[])new Object[0])), new Object[]{ex});
        }
    }

    public boolean saveBom(BeforeOperationArgs e) {
        boolean isFailed = false;
        for (DynamicObject dataEntity : e.getDataEntities()) {
            HashMap<String, DynamicObject> idWithDynamicObject = new HashMap<String, DynamicObject>();
            HashMap<String, String> pidWithId = new HashMap<String, String>();
            ArrayList<DynamicObject> seqColls = new ArrayList<DynamicObject>();
            DynamicObject planDO = this.getProConfigPlan(dataEntity);
            boolean isSuccess = this.classifyMap(dataEntity, idWithDynamicObject, pidWithId, seqColls, planDO);
            if (!isSuccess) continue;
            HashMap<String, String> errorMap = new HashMap<String, String>();
            DynamicObjectCollection newDynamicObject = new DynamicObjectCollection();
            if (!pidWithId.isEmpty()) {
                this.setBomOrders(idWithDynamicObject, pidWithId, errorMap, newDynamicObject, dataEntity);
            }
            if (!errorMap.isEmpty()) {
                this.setErrorInfo(errorMap, e);
                continue;
            }
            OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"pdm_mftbom", (DynamicObject[])((DynamicObject[])newDynamicObject.toArray((Object[])new DynamicObject[newDynamicObject.size()])), (OperateOption)this.operateOption);
            if (!executeOperate.isSuccess()) {
                OperationServiceHelper.executeOperate((String)"delete", (String)"pdm_mftbom", (DynamicObject[])((DynamicObject[])newDynamicObject.toArray((Object[])new DynamicObject[newDynamicObject.size()])), (OperateOption)this.operateOption);
                this.setErrorWhenOperationFailed(executeOperate, dataEntity);
                isFailed = true;
                this.getOperationResult().setSuccess(false);
                continue;
            }
            if (!executeOperate.isSuccess() || executeOperate.getSuccessPkIds().isEmpty()) continue;
            boolean isDealResult = planDO.getBoolean("isdealresult");
            String configType = planDO.getString("configtype");
            if ("2".equals(configType) && !isDealResult) {
                DynamicObjectCollection treeEntry = dataEntity.getDynamicObjectCollection("treeentryentity");
                treeEntry.clear();
            }
            this.setBOMEntryidWhenSucess(dataEntity, seqColls, newDynamicObject, executeOperate);
            if (isFailed) continue;
            this.getOperationResult().setSuccess(true);
        }
        return isFailed;
    }

    private DynamicObject getProConfigPlan(DynamicObject dataEntity) {
        DynamicObject proConfigPlanDO = dataEntity.getDynamicObject("productconfigplan");
        long planPkValue = proConfigPlanDO != null ? proConfigPlanDO.getLong("id") : 0L;
        return QueryServiceHelper.queryOne((String)"pdm_proconfigscheme", (String)"id,isdealresult,configtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)planPkValue)});
    }

    private void setBOMEntryidWhenSucess(DynamicObject dataEntity, List<DynamicObject> seqColls, DynamicObjectCollection newDynamicObject, OperationResult executeOperate) {
        List successPkIds = executeOperate.getSuccessPkIds();
        DynamicObject[] successObjs = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(new Object[successPkIds.size()]), (DynamicObjectType)newDynamicObject.getDynamicObjectType());
        Iterator<DynamicObject> iterator = seqColls.iterator();
        for (DynamicObject successObj : successObjs) {
            Long successPkValue = Long.parseLong(successObj.getPkValue().toString());
            iterator.next().set("bomid", (Object)successPkValue);
            DynamicObjectCollection entrys = successObj.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long entryPkValue = Long.parseLong(entry.getPkValue().toString());
                iterator.next().set("bomentryid", (Object)entryPkValue);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        StringBuilder builder = new StringBuilder();
        for (DynamicObject dynamicObject : successObjs) {
            builder.append(dynamicObject.getString("number")).append(',');
        }
        String substring = builder.toString().substring(0, builder.toString().length() - 1);
        List succssIds = this.getOperationResult().getSuccessPkIds();
        succssIds.add(substring);
        this.operateOption.setVariableValue("SuccssSize", String.valueOf(succssIds.size()));
        StringBuilder stringBuilder = new StringBuilder();
        for (Object succssId : succssIds) {
            stringBuilder.append(succssId).append(';');
        }
        this.operateOption.setVariableValue("SuccssIds", String.valueOf(stringBuilder.toString()));
    }

    private void setErrorWhenOperationFailed(OperationResult executeOperate, DynamicObject dataEntity) {
        ValidateResultCollection validateResults = executeOperate.getValidateResult();
        List executeValidateErrors = validateResults.getValidateErrors();
        Object number = dataEntity.get("number");
        List allErrorInfo = ((ValidateResult)executeValidateErrors.get(0)).getAllErrorInfo();
        for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
            String message = operateErrorInfo.getMessage();
            OperateErrorInfo newError = new OperateErrorInfo();
            newError.setEntityKey("pdm_productconfigure");
            newError.setMessage(number + ": " + message);
            newError.setTitle(ResManager.loadKDString((String)"\u751f\u6210\u8ba2\u5355BOM\u3002", (String)"ProductConfigureSaveToBOMOrderOp_1", (String)"mmc-pdm-opplugin", (Object[])new Object[0]));
            newError.setErrorLevel(ErrorLevel.Error.name());
            this.getOperationResult().getAllErrorInfo().add(newError);
        }
    }

    private void setBomOrders(Map<String, DynamicObject> idWithDynamicObject, Map<String, String> pidWithId, Map<String, String> errorMap, DynamicObjectCollection newDynamicObject, DynamicObject dataEntity) {
        DynamicObject orgfield = dataEntity.getDynamicObject("prodorgid");
        String firstRowId = pidWithId.get("0");
        Set<Map.Entry<String, String>> entrySet = pidWithId.entrySet();
        int size = entrySet.size();
        if (size == 1) {
            String number = dataEntity.getString("number");
            errorMap.put("Cancel", "mertiralSizeIsOne");
            errorMap.put("CancelMessage", String.format(ResManager.loadKDString((String)"%1$s: \u7ec4\u4ef6\u4fe1\u606f\u53ea\u6709\u4e3b\u7269\u6599\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u8ba2\u5355BOM\u3002", (String)"ProductConfigureSaveToBOMOrderOp_2", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), number));
            return;
        }
        for (Map.Entry<String, String> entry : entrySet) {
            String configproperties;
            DynamicObject matObj;
            String pid = entry.getKey();
            DynamicObject parentObject = idWithDynamicObject.get(pid);
            if (StringUtils.equals((CharSequence)"0", (CharSequence)pid) || (matObj = parentObject.getDynamicObject("entrymaterial")) != null && !"2".equals(configproperties = matObj.getString("configproperties"))) continue;
            DynamicObject bomOrder = BusinessDataServiceHelper.newDynamicObject((String)"pdm_mftbom");
            this.setConstance(bomOrder, orgfield, dataEntity, errorMap);
            if (!errorMap.isEmpty()) {
                return;
            }
            DynamicObject materielno = parentObject.getDynamicObject("entrymaterial");
            this.setMaterial(dataEntity, materielno, bomOrder, errorMap, orgfield, "material");
            if (!errorMap.isEmpty()) {
                return;
            }
            this.copyMainProperties(dataEntity, firstRowId, pid, bomOrder, materielno, errorMap, parentObject);
            if (!errorMap.isEmpty()) {
                return;
            }
            this.copyComponentProperties(dataEntity, idWithDynamicObject, errorMap, orgfield, bomOrder, entry);
            if (!errorMap.isEmpty()) {
                return;
            }
            newDynamicObject.add((Object)bomOrder);
        }
    }

    private void copyComponentProperties(DynamicObject dataEntity, Map<String, DynamicObject> idWithDynamicObject, Map<String, String> errorMap, DynamicObject orgfield, DynamicObject bomOrder, Map.Entry<String, String> entry) {
        String[] ids;
        DynamicObjectCollection nowColls = bomOrder.getDynamicObjectCollection("entry");
        for (String id : ids = entry.getValue().split(",")) {
            DynamicObject sonObject = idWithDynamicObject.get(id);
            DynamicObject newComponent = nowColls.addNew();
            this.copyComponentPropertie(dataEntity, sonObject, newComponent, errorMap, orgfield);
            newComponent.set("seq", (Object)nowColls.size());
            if (errorMap.isEmpty()) continue;
            return;
        }
    }

    private void copyMainProperties(DynamicObject dataEntity, String firstRowId, String pid, DynamicObject bomOrder, DynamicObject materielno, Map<String, String> errorMap, DynamicObject parentObject) {
        DynamicObject createorg = dataEntity.getDynamicObject("createorg");
        DynamicObject superBom = dataEntity.getDynamicObject("superbom");
        String number = dataEntity.getString("number");
        DynamicObject productConfigPlanDO = dataEntity.getDynamicObject("productconfigplan");
        bomOrder.set("configuredcode", (Object)parentObject.getDynamicObject("configcode"));
        if (StringUtils.equals((CharSequence)pid, (CharSequence)firstRowId)) {
            this.copyFirstRowBOMProperties(number, superBom, bomOrder, errorMap, parentObject);
        } else {
            this.copyOtherRowBOMProperties(productConfigPlanDO, number, bomOrder, createorg, materielno, errorMap, parentObject);
        }
    }

    private DynamicObject copyFirstRowBOMProperties(String number, DynamicObject superBom, DynamicObject bomOrder, Map<String, String> errorMap, DynamicObject parentObject) {
        DynamicObject version = superBom.getDynamicObject("version");
        DynamicObject auxproperty = superBom.getDynamicObject("auxproperty");
        DynamicObject entryauxproperty = parentObject.getDynamicObject("entryauxproperty");
        Object yieldrate = superBom.get("yieldrate");
        bomOrder.set("version", (Object)version);
        bomOrder.set("auxproperty", (Object)auxproperty);
        BigDecimal bigDecimal = new BigDecimal(yieldrate.toString());
        if (bigDecimal.compareTo(new BigDecimal("1")) > 0 || bigDecimal.compareTo(new BigDecimal("0")) <= 0) {
            Object superBomNumber = superBom.get("number");
            errorMap.put("Cancel", "yieldrate");
            errorMap.put("CancelMessage", String.format(ResManager.loadKDString((String)"%1$s: \u8d85\u7ea7BOM\u7f16\u7801\u201c%2$s\u201d\u5b57\u6bb5\u201d\u6210\u54c1\u7387\u201d\u7684\u503c0\u8d85\u51fa\u9650\u5b9a\u8303\u56f4(0,1]\u3002", (String)"ProductConfigureSaveToBOMOrderOp_7", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), number, superBomNumber));
            return superBom;
        }
        bomOrder.set("yieldrate", yieldrate);
        bomOrder.set("auxproperty", (Object)entryauxproperty);
        bomOrder.set("minqtyopt_optctl", (Object)BigDecimal.ONE);
        bomOrder.set("maxqtyopt_optctl", (Object)BigDecimal.ONE);
        return superBom;
    }

    private DynamicObject copyOtherRowBOMProperties(DynamicObject productConfigPlanDO, String number, DynamicObject bomOrder, DynamicObject createorg, DynamicObject materielno, Map<String, String> errorMap, DynamicObject parentObject) {
        DynamicObject bomExpandConfig;
        Set bomTypeSet = new HashSet(100);
        Map bomExpandMap = new HashMap(1);
        if (productConfigPlanDO != null && (bomExpandConfig = productConfigPlanDO.getDynamicObject("bomexpandconfig")) != null) {
            bomExpandMap = BOMExpandConfigBusiness.getBomExpandConfig((long)((bomExpandConfig = BusinessDataServiceHelper.loadSingle((Object)bomExpandConfig.getPkValue(), (String)"mpdm_bomexpandconfig")) == null ? -1L : bomExpandConfig.getLong("id")));
            bomTypeSet = BOMExpandConfigBusiness.getBomTypeOfPurpose(bomExpandMap, (String)"B");
        }
        DynamicObject verObj = parentObject.getDynamicObject("entryversion");
        QFilter materialId = new QFilter("materialid", "=", (Object)Long.parseLong(materielno.getPkValue().toString()));
        QFilter materialStatus = new QFilter("status", "=", (Object)"C");
        QFilter materialEnable = new QFilter("enable", "=", (Object)"1");
        QFilter versionFilter = new QFilter("version", "=", (Object)(verObj == null ? 0L : Long.parseLong(verObj.getPkValue().toString())));
        QFilter replaceNoFilter = new QFilter("replaceno", "=", (Object)0L);
        QFilter auxPropFilter = new QFilter("auxproperty", "=", (Object)0L);
        QFilter bomTypeFilter = new QFilter("type", "in", bomTypeSet);
        QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)Long.parseLong(createorg.getPkValue().toString()));
        QFilter[] allDataFilter = new QFilter[]{materialId, materialStatus, materialEnable, ids, bomTypeFilter, versionFilter, replaceNoFilter, auxPropFilter};
        DynamicObject[] superBomArray = BusinessDataServiceHelper.load((String)"pdm_mftbom", (String)"id,type,version, auxproperty, yieldrate", (QFilter[])allDataFilter);
        DynamicObject superBom = BOMExpandConfigBusiness.firstLevelPriorityFilter((DynamicObject[])superBomArray, bomExpandMap, (String)"B");
        if (superBom != null) {
            this.copyFirstRowBOMProperties(number, superBom, bomOrder, errorMap, parentObject);
        }
        return superBom;
    }

    private void setErrorInfo(Map<String, String> errorMap, BeforeOperationArgs e) {
        this.setErrorInfo(errorMap);
    }

    private void setErrorInfo(Map<String, String> errorMap) {
        String message = errorMap.get("CancelMessage");
        OperateErrorInfo newError = new OperateErrorInfo();
        newError.setEntityKey("pdm_productconfigure");
        newError.setMessage(message);
        newError.setTitle(ResManager.loadKDString((String)"\u751f\u6210\u8ba2\u5355BOM\u3002", (String)"ProductConfigureSaveToBOMOrderOp_1", (String)"mmc-pdm-opplugin", (Object[])new Object[0]));
        newError.setErrorLevel(ErrorLevel.Error.name());
        this.getOperationResult().getAllErrorInfo().add(newError);
    }

    private void copyComponentPropertie(DynamicObject dataEntity, DynamicObject sonObject, DynamicObject newComponent, Map<String, String> errorMap, DynamicObject orgfield) {
        newComponent.set("entrytype", (Object)"A");
        DynamicObject materielno = sonObject.getDynamicObject("entrymaterial");
        this.setMaterial(dataEntity, materielno, newComponent, errorMap, orgfield, "entrymaterial");
        if (!errorMap.isEmpty()) {
            return;
        }
        BigDecimal object = sonObject.getBigDecimal("entryfixscrap");
        newComponent.set("entrymaterialid", (Object)materielno);
        newComponent.set("entryunit", sonObject.get("entryunit"));
        newComponent.set("entryversion", sonObject.get("entryversion"));
        newComponent.set("entryauxproperty", sonObject.get("entryauxproperty"));
        newComponent.set("entryqtytype", sonObject.get("entryqtytype"));
        newComponent.set("entryqtynumerator", sonObject.get("entryqtynumerator"));
        newComponent.set("entryqtydenominator", sonObject.get("entryqtydenominator"));
        newComponent.set("entryfixscrap", (Object)object);
        newComponent.set("entryscraprate", sonObject.get("entryscraprate"));
        newComponent.set("entryvaliddate", (Object)TimeServiceHelper.now());
        newComponent.set("entryinvaliddate", (Object)new Date(129, 0, 1));
        newComponent.set("entryprocessseq", (Object)0);
        newComponent.set("entryoperationnumber", (Object)10);
        newComponent.set("entryownertype", (Object)"bos_org");
        newComponent.set("entryconfiguredcode", sonObject.get("configcode"));
        BigDecimal maxQty = sonObject.getBigDecimal("maxqtyopt").compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ONE : sonObject.getBigDecimal("maxqtyopt");
        BigDecimal minQty = sonObject.getBigDecimal("minqtyopt").compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ONE : sonObject.getBigDecimal("minqtyopt");
        newComponent.set("maxqtyopt", (Object)maxQty);
        newComponent.set("minqtyopt", (Object)minQty);
    }

    private void setConstance(DynamicObject bomOrder, DynamicObject orgfield, DynamicObject dataEntity, Map<String, String> errorMap) {
        RequestContext requestContext = RequestContext.get();
        long userId = Long.parseLong(requestContext.getUserId());
        bomOrder.set("createorg", (Object)orgfield);
        bomOrder.set("creator", (Object)userId);
        bomOrder.set("createtime", (Object)new Date());
        bomOrder.set("status", (Object)"A");
        bomOrder.set("enable", (Object)"1");
        DynamicObject productconfigplan = dataEntity.getDynamicObject("productconfigplan");
        DynamicObject orderBOMType = productconfigplan.getDynamicObject("orderbom");
        Map typeMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_bomtype", (String)"id,number,name,issalebom,isversionvalid,isecnupdate,isversion,purpose,configtype,checkrepeat,verifydimension", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(orderBOMType == null ? 0L : orderBOMType.getLong("id")))});
        DynamicObject bomGroup = productconfigplan.getDynamicObject("bomgroup");
        bomOrder.set("group", (Object)bomGroup);
        if (null == orderBOMType) {
            String number = dataEntity.getString("number");
            errorMap.put("Cancel", "orderBOMType");
            errorMap.put("CancelMessage", String.format(ResManager.loadKDString((String)"%1$s: \u751f\u6210\u8ba2\u5355BOM\u9700\u8981\u586b\u5199\u914d\u7f6e\u65b9\u6848\u4e2d\u7684\u8ba2\u5355\u7c7b\u578b\u3002", (String)"ProductConfigureSaveToBOMOrderOp_9", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), number));
            return;
        }
        orderBOMType = (DynamicObject)typeMap.get(orderBOMType.getPkValue());
        bomOrder.set("type", (Object)orderBOMType);
    }

    private void setMaterial(DynamicObject dataEntity, DynamicObject materielno, DynamicObject bomOrder, Map<String, String> errorMap, DynamicObject orgfield, String materielkey) {
        long org = orgfield.getLong("id");
        String orgNum = orgfield.getString("number");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)org);
        QFilter materielFilter = new QFilter("masterid", "=", materielno.getPkValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enbleFilter = new QFilter("enable", "=", (Object)"1");
        baseDataFilter.and(materielFilter).and(statusFilter).and(enbleFilter);
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((String)"bd_materialmftinfo", (String)this.getMaterialInfoField(), (QFilter[])new QFilter[]{baseDataFilter});
        if (null == loadSingle) {
            String materielNumber = materielno.getString("number");
            String number = dataEntity.getString("number");
            errorMap.put("Cancel", "materielNumber");
            errorMap.put("CancelMessage", String.format(ResManager.loadKDString((String)"%1$s: \u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u5728\u751f\u4ea7\u7ec4\u7ec7\u7f16\u7801\u201c%3$s\u201d\u4e0b\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"ProductConfigureSaveToBOMOrderOp_10", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), number, materielNumber, orgNum));
            return;
        }
        String materialattr = loadSingle.getString("materialattr");
        bomOrder.set(materielkey, (Object)loadSingle);
        if (StringUtils.equals((CharSequence)"material", (CharSequence)materielkey)) {
            bomOrder.set("materialid", loadSingle.get("masterid"));
        } else if ("entrymaterial".equals(materielkey)) {
            bomOrder.set("entrymaterialid", loadSingle.get("masterid"));
            bomOrder.set("entrymaterialattr", (Object)materialattr);
            if ("10020".equals(materialattr)) {
                bomOrder.set("entryisjumplevel", (Object)true);
            } else {
                bomOrder.set("entryisjumplevel", (Object)false);
            }
            DynamicObject supplyorg = (DynamicObject)loadSingle.get("supplyorgunitid");
            DynamicObject warehouse = (DynamicObject)loadSingle.get("warehouse");
            DynamicObject location = (DynamicObject)loadSingle.get("location");
            DynamicObject outstorageunit = (DynamicObject)loadSingle.get("outstorageunit");
            DynamicObject outwarehouse = (DynamicObject)loadSingle.get("outwarehouse");
            DynamicObject outwarelocation = (DynamicObject)loadSingle.get("outwarelocation");
            bomOrder.set("entryissuemode", (Object)loadSingle.getString("issuemode"));
            bomOrder.set("entrysupplyorg", (Object)(supplyorg == null ? 0L : Long.parseLong(supplyorg.getPkValue().toString())));
            bomOrder.set("entrywarehouse", (Object)(warehouse == null ? 0L : Long.parseLong(warehouse.getPkValue().toString())));
            bomOrder.set("entrylocation", (Object)(location == null ? 0L : Long.parseLong(location.getPkValue().toString())));
            bomOrder.set("entryiskey", (Object)loadSingle.getString("iskeypart"));
            bomOrder.set("entryisstockalloc", (Object)loadSingle.getString("isstockallot"));
            bomOrder.set("entryoutorg", (Object)(outstorageunit == null ? 0L : Long.parseLong(outstorageunit.getPkValue().toString())));
            if (outwarehouse == null) {
                bomOrder.set("entryoutwarehouse", (Object)0);
            } else {
                bomOrder.set("entryoutwarehouse", (Object)(outwarehouse == null ? 0L : Long.parseLong(outwarehouse.getPkValue().toString())));
            }
            bomOrder.set("entryoutlocation", (Object)(outwarelocation == null ? 0L : Long.parseLong(outwarelocation.getPkValue().toString())));
            bomOrder.set("entryisbulkmaterial", (Object)loadSingle.getString("isbulkmaterial"));
            bomOrder.set("entryisbackflush", (Object)loadSingle.getString("isbackflush"));
        }
    }

    public String getMaterialInfoField() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",masterid");
        sb.append(",masterid.isuseauxpty");
        sb.append(",masterid.configproperties");
        sb.append(",materialattr");
        sb.append(",issuemode");
        sb.append(",supplyorgunitid");
        sb.append(",warehouse");
        sb.append(",location");
        sb.append(",iskeypart");
        sb.append(",isstockallot");
        sb.append(",outstorageunit");
        sb.append(",outwarehouse");
        sb.append(",outwarelocation");
        sb.append(",isbulkmaterial");
        sb.append(",isbackflush");
        sb.append(",isbompauxattmust");
        return sb.toString();
    }

    private boolean classifyMap(DynamicObject dataEntity, Map<String, DynamicObject> idWithDynamicObject, Map<String, String> pidWithId, List<DynamicObject> seqColls, DynamicObject planDO) {
        boolean isClassfyMap = this.setConfigTreeEntryFromService(dataEntity, planDO);
        if (!isClassfyMap) {
            return false;
        }
        DynamicObjectCollection originalColls = dataEntity.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject dynamicObject : originalColls) {
            seqColls.add(dynamicObject);
            String pid = dynamicObject.get("pid").toString();
            Iterator id = dynamicObject.get("id").toString();
            DynamicObject dynamicObject2 = dynamicObject.getDynamicObject("entrymaterial");
            String configproperties = dynamicObject2.getString("configproperties");
            idWithDynamicObject.put((String)((Object)id), dynamicObject);
            if ("3".equals(configproperties)) continue;
            String idString = pidWithId.get(pid);
            if (idString != null) {
                pidWithId.put(pid, idString + "," + id);
                continue;
            }
            pidWithId.put(pid, dynamicObject.getPkValue().toString());
        }
        Map<String, String> newPidWithId = this.mapCopy(pidWithId);
        Set<Map.Entry<String, String>> entrySet = newPidWithId.entrySet();
        HashSet<Object> removeSet = new HashSet<Object>(100);
        for (Map.Entry entry : entrySet) {
            String pid = (String)entry.getKey();
            DynamicObject pObj = idWithDynamicObject.get(pid);
            if (pObj == null) continue;
            String ppid = pObj.get("pid").toString();
            String[] pidString = pidWithId.get(ppid);
            DynamicObject matObj = pObj.getDynamicObject("entrymaterial");
            String configproperties = matObj.getString("configproperties");
            if (!"3".equals(configproperties)) continue;
            String idString = pidWithId.get(pid);
            this.calcFeatureEntrySonQty(pObj, idWithDynamicObject, idString);
            if (pidString != null) {
                pidWithId.put(ppid, (String)pidString + "," + idString);
            } else {
                pidWithId.put(ppid, idString);
            }
            removeSet.add(pid);
        }
        for (String string : removeSet) {
            pidWithId.remove(string);
        }
        Collection<String> values = pidWithId.values();
        HashSet<String> hashSet = new HashSet<String>();
        for (String value : values) {
            String[] split;
            for (String string : split = value.split(",")) {
                hashSet.add(string);
            }
        }
        Set<String> keySet = pidWithId.keySet();
        for (String value : hashSet) {
            boolean contains = keySet.contains(value);
            if (!contains) continue;
            seqColls.add(idWithDynamicObject.get(value));
        }
        if (seqColls.size() > 0) {
            seqColls.remove(0);
        }
        return true;
    }

    private void calcFeatureEntrySonQty(DynamicObject pObj, Map<String, DynamicObject> idWithDynamicObject, String idString) {
        String[] split;
        if (pObj == null) {
            return;
        }
        BigDecimal pNumer = pObj.getBigDecimal("entryqtynumerator");
        BigDecimal pDenomin = pObj.getBigDecimal("entryqtydenominator");
        for (String id : split = idString.split(",")) {
            DynamicObject sonDO = idWithDynamicObject.get(id);
            BigDecimal sonNumer = sonDO.getBigDecimal("entryqtynumerator");
            BigDecimal sonDenomin = sonDO.getBigDecimal("entryqtydenominator");
            BigDecimal numerQty = pNumer.multiply(sonNumer).setScale(sonNumer.scale(), 4);
            BigDecimal denominQty = pDenomin.multiply(sonDenomin).setScale(sonDenomin.scale(), 4);
            sonDO.set("entryqtynumerator", (Object)numerQty);
            sonDO.set("entryqtydenominator", (Object)denominQty);
        }
    }

    private boolean setConfigTreeEntryFromService(DynamicObject dataEntity, DynamicObject planDO) {
        boolean isSuccess = true;
        boolean isDealResult = planDO.getBoolean("isdealresult");
        String configType = planDO.getString("configtype");
        if (!"2".equals(configType)) {
            return isSuccess;
        }
        DynamicObjectCollection originalColls = dataEntity.getDynamicObjectCollection("treeentryentity");
        if (originalColls != null && !originalColls.isEmpty()) {
            return isSuccess;
        }
        DynamicObject configCode = dataEntity.getDynamicObject("masterconfigcode");
        JSONObject params = this.getDispatchServiceParams(dataEntity);
        try {
            JSONObject entryJson = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"proConfigListQueryService", (String)"getProdConfigListByFeature", (Object[])new Object[]{params.toString()});
            if (entryJson == null) {
                return isSuccess;
            }
            String serviceStatus = entryJson.getString("status");
            if (!"success".equals(serviceStatus)) {
                String msg = entryJson.getString("msg");
                this.setServiceErrorInfo("serviceExeFail", msg);
                return false;
            }
            if (entryJson.get((Object)"data") == null) {
                return isSuccess;
            }
            JSONObject data = (JSONObject)entryJson.get((Object)"data");
            Object configCodeInfoObj = data.get((Object)(configCode == null ? 0L : configCode.getLong("id")));
            if (configCodeInfoObj != null) {
                String status;
                JSONObject configCodeEntry = (JSONObject)configCodeInfoObj;
                String string = status = configCodeEntry.get((Object)"status") == null ? "" : configCodeEntry.get((Object)"status").toString();
                if (!"success".equals(status)) {
                    String errorMsg = configCodeEntry.getString("errorMsg");
                    this.setServiceErrorInfo("configDetailFail", errorMsg);
                    logger.info(configCodeEntry.getString("StackTrace"));
                    return false;
                }
                this.writeProConfDetail(configCodeEntry, originalColls, configCode);
            }
            return isSuccess;
        }
        catch (Exception e) {
            logger.error(e.getCause());
            throw new KDBizException(new ErrorCode("get_entry_error", e.getMessage()), new Object[]{e});
        }
    }

    private void setServiceErrorInfo(String cancelField, String msg) {
        HashMap<String, String> errorMap = new HashMap<String, String>(2);
        errorMap.put("Cancel", cancelField);
        errorMap.put("CancelMessage", msg);
        this.setErrorInfo(errorMap);
    }

    private JSONObject getDispatchServiceParams(DynamicObject dataEntity) {
        ArrayList<Long> codeList = new ArrayList<Long>(10);
        DynamicObject configCode = dataEntity.getDynamicObject("masterconfigcode");
        DynamicObject materialNo = dataEntity.getDynamicObject("materielno");
        DynamicObject prodOrg = dataEntity.getDynamicObject("prodorgid");
        Long configCodePk = 0L;
        Long materialNoPk = 0L;
        Long prodOrgId = 0L;
        if (configCode != null) {
            configCodePk = configCode.getLong("id");
        }
        if (materialNo != null) {
            materialNoPk = materialNo.getLong("id");
        }
        if (prodOrg != null) {
            prodOrgId = prodOrg.getLong("id");
        }
        codeList.add(configCodePk);
        JSONObject params = new JSONObject();
        params.put("searchTime", (Object)new Date());
        params.put("isNeedProRoute", (Object)false);
        params.put("model", (Object)"model_pdm");
        params.put("configCodeList", codeList);
        params.put("matId", (Object)materialNoPk);
        params.put("bomVer", null);
        params.put("org", (Object)prodOrgId);
        params.put("num", (Object)BigDecimal.ONE);
        return params;
    }

    private void writeProConfDetail(JSONObject configCodeEntry, DynamicObjectCollection originalColls, DynamicObject configCode) {
        if (configCodeEntry == null || originalColls == null) {
            return;
        }
        Object treeentryentity = configCodeEntry.get((Object)"treeentryentity");
        DataEntityPropertyCollection properties = originalColls.getDynamicObjectType().getProperties();
        if (treeentryentity instanceof JSONArray) {
            ArrayList<Long> materialPkList = new ArrayList<Long>(8);
            ArrayList<Long> attrPkList = new ArrayList<Long>(8);
            ArrayList<Long> versionPkList = new ArrayList<Long>(8);
            for (int i = 0; i < ((JSONArray)treeentryentity).size(); ++i) {
                Object entryInfo = ((JSONArray)treeentryentity).get(i);
                if (entryInfo == null) continue;
                DynamicObject treeEntry = originalColls.addNew();
                for (int j = 0; j < properties.size(); ++j) {
                    IDataEntityProperty property = (IDataEntityProperty)properties.get(j);
                    if (!((JSONObject)entryInfo).containsKey((Object)property.getName())) continue;
                    Object value = ((JSONObject)entryInfo).get((Object)property.getName());
                    if ("entrymaterial".equals(property.getName())) {
                        value = ((JSONObject)entryInfo).get((Object)"entrymaterial_id");
                        if (value != null && Pattern.matches("^[0-9]*$", value.toString())) {
                            materialPkList.add(Long.parseLong(value.toString()));
                        }
                        treeEntry.set("entrymaterial", value);
                        continue;
                    }
                    if ("entrymaterialattr".equals(property.getName())) {
                        if (value != null && Pattern.matches("^[0-9]*$", value.toString())) {
                            attrPkList.add(Long.parseLong(value.toString()));
                        }
                    } else if ("entryversion".equals(property.getName())) {
                        if (value != null && Pattern.matches("^[0-9]*$", value.toString())) {
                            versionPkList.add(Long.parseLong(value.toString()));
                        }
                    } else if ("configcode".equals(property.getName())) {
                        long configCodePk = 0L;
                        if (value instanceof Long) {
                            configCodePk = (Long)value;
                        } else if (value != null && Pattern.matches("^[0-9]*$", value.toString())) {
                            configCodePk = Long.parseLong(value.toString());
                        }
                        if (configCodePk <= 0L) continue;
                        treeEntry.set(property, (Object)configCode);
                        continue;
                    }
                    treeEntry.set(property, value);
                }
            }
            this.replenishDynamicData(materialPkList, attrPkList, versionPkList, originalColls, configCode);
        }
    }

    private void replenishDynamicData(List<Long> materialPkList, List<Long> attrPkList, List<Long> versionPkList, DynamicObjectCollection originalColls, DynamicObject configCode) {
        if (originalColls == null) {
            return;
        }
        Map materialMap = BusinessDataServiceHelper.loadFromCache((Object[])materialPkList.toArray(new Long[materialPkList.size()]), (String)"bd_material");
        Map auxPropMap = BusinessDataServiceHelper.loadFromCache((Object[])attrPkList.toArray(new Long[attrPkList.size()]), (String)"bd_flexauxprop");
        Map versionMap = BusinessDataServiceHelper.loadFromCache((Object[])versionPkList.toArray(new Long[versionPkList.size()]), (String)"bd_bomversion");
        for (int i = 0; i < originalColls.size(); ++i) {
            DynamicObject original = (DynamicObject)originalColls.get(i);
            Object materialInfoPk = original.get("entrymaterial");
            Object auxPropPk = original.get("entryauxproperty");
            Object versionPk = original.get("entryversion");
            if (materialInfoPk instanceof Long && materialMap != null) {
                DynamicObject mftInfoDO = (DynamicObject)materialMap.get((Long)materialInfoPk);
                if (mftInfoDO != null) {
                    original.set("entrymaterial", (Object)mftInfoDO);
                }
            } else {
                original.set("entrymaterial", null);
            }
            if (auxPropPk instanceof Long && auxPropMap != null) {
                original.set("entryauxproperty", auxPropMap.get((Long)auxPropPk));
            } else {
                original.set("entryauxproperty", null);
            }
            if (versionPk instanceof Long && versionMap != null) {
                original.set("entryversion", versionMap.get((Long)versionPk));
                continue;
            }
            original.set("entryversion", null);
        }
    }

    public Map<String, String> mapCopy(Map<String, String> dataMap) {
        HashMap<String, String> retMap = new HashMap<String, String>(100);
        if (dataMap == null || dataMap.isEmpty()) {
            return retMap;
        }
        Set<Map.Entry<String, String>> set = dataMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            retMap.put(entry.getKey(), entry.getValue());
        }
        return retMap;
    }
}

