/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.processroute;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.common.util.VersionDataObj;
import kd.mmc.pdm.opplugin.prodatatpl.PDMBaseTplOp;

public class PDMProMaterDTBBaseOp
extends PDMBaseTplOp {
    @Override
    public String getEntityKeyImpl() {
        return "pdm_promaterdtb";
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bom.id");
        e.getFieldKeys().add("processroute.id");
        e.getFieldKeys().add("createorg.id");
        e.getFieldKeys().add("effectdate");
        e.getFieldKeys().add("invaliddate");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        List validExtDataEntities = e.getValidExtDataEntities();
        switch (operationKey) {
            case "submit": {
                this.checkDate(e, validExtDataEntities);
                break;
            }
        }
    }

    private void checkDate(BeforeOperationArgs e, List<ExtendedDataEntity> validExtDataEntities) {
        int size = validExtDataEntities.size();
        HashMap<DynamicObject, VersionDataObj> map = new HashMap<DynamicObject, VersionDataObj>(size);
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            Date effectDate = dynamicObject.getDate("effectdate");
            Date invalidDate = dynamicObject.getDate("invaliddate");
            map.put(dynamicObject, new VersionDataObj(null, effectDate, invalidDate));
        }
        HashMap errorMap = new HashMap(size);
        for (ExtendedDataEntity extendedDataEntity : validExtDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Date effectDate = dataEntity.getDate("effectdate");
            Date invalidDate = dataEntity.getDate("invaliddate");
            long bomId = dataEntity.getLong("bom.id");
            long processRouteId = dataEntity.getLong("processroute.id");
            long createOrgId = dataEntity.getLong("createorg.id");
            String dataKey = bomId + "_" + processRouteId + "_" + createOrgId;
            if (effectDate == null || invalidDate == null) continue;
            Date efDate = effectDate;
            Date inDate = invalidDate;
            ArrayList<DynamicObject> errorLs = new ArrayList<DynamicObject>(size);
            for (Map.Entry entry : map.entrySet()) {
                DynamicObject otherDataEntity = (DynamicObject)entry.getKey();
                if (otherDataEntity.equals(dataEntity)) continue;
                long bomId_ot = otherDataEntity.getLong("bom.id");
                long processRouteId_ot = otherDataEntity.getLong("processroute.id");
                long createOrgId_ot = otherDataEntity.getLong("createorg.id");
                String dataKey_ot = bomId_ot + "_" + processRouteId_ot + "_" + createOrgId_ot;
                if (!dataKey.equals(dataKey_ot)) continue;
                VersionDataObj value = (VersionDataObj)entry.getValue();
                Date effectDate_ot = value.getEffectDate();
                Date invalidDate_ot = value.getInvalidDate();
                if (!efDate.before(invalidDate_ot) || !inDate.after(effectDate_ot)) continue;
                errorLs.add(otherDataEntity);
            }
            if (errorLs.isEmpty()) continue;
            errorMap.put(extendedDataEntity, errorLs);
        }
        for (Map.Entry entry : errorMap.entrySet()) {
            ExtendedDataEntity key = (ExtendedDataEntity)entry.getKey();
            String tip = ResManager.loadKDString((String)"\u201cBOM\u7f16\u7801\u201d\u3001\u201c\u5de5\u827a\u8def\u7ebf\u201d\u3001\u201c\u751f\u6548\u533a\u95f4\u201d \u7684\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"PDMProMaterDTBBaseOp_0", (String)"mmc-pdm-opplugin", (Object[])new Object[0]);
            this.addErrMessage(key, tip);
        }
        Set set = errorMap.keySet();
        validExtDataEntities.removeAll(set);
        ArrayList<ExtendedDataEntity> arrayList = new ArrayList<ExtendedDataEntity>(size);
        for (ExtendedDataEntity validExtDataEntity : validExtDataEntities) {
            String tip = ResManager.loadKDString((String)" \u201cBOM\u7f16\u7801\u201d\u3001\u201c\u5de5\u827a\u8def\u7ebf\u201d\u3001\u201c\u751f\u6548\u533a\u95f4\u201d \u7684\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"PDMProMaterDTBBaseOp_1", (String)"mmc-pdm-opplugin", (Object[])new Object[0]);
            boolean isOk = this.checkDates(validExtDataEntity);
            if (isOk) {
                arrayList.add(validExtDataEntity);
                continue;
            }
            this.addErrMessage(validExtDataEntity, tip);
        }
        if (arrayList.isEmpty()) {
            e.setCancel(true);
        } else {
            e.getValidExtDataEntities().clear();
            e.getValidExtDataEntities().addAll(arrayList);
        }
    }

    private boolean checkDates(ExtendedDataEntity validExtDataEntity) {
        DynamicObject dataEntity = validExtDataEntity.getDataEntity();
        long bomId = dataEntity.getLong("bom.id");
        long processRouteId = dataEntity.getLong("processroute.id");
        long createOrgId = dataEntity.getLong("createorg.id");
        long id = dataEntity.getLong("id");
        Object effectDate = dataEntity.get("effectdate");
        Object invalidDate = dataEntity.get("invaliddate");
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(4);
        QFilter bomQf = new QFilter("bom.id", "=", (Object)bomId);
        QFilter prQf = new QFilter("processroute.id", "=", (Object)processRouteId);
        QFilter coQf = new QFilter("createorg.id", "=", (Object)createOrgId);
        QFilter status = new QFilter("status", "!=", (Object)"A");
        qfs.add(bomQf);
        qfs.add(prQf);
        qfs.add(coQf);
        qfs.add(status);
        if (id != 0L) {
            QFilter idQf = new QFilter("id", "!=", (Object)id);
            qfs.add(idQf);
        }
        QFilter[] qFilters = qfs.toArray(new QFilter[qfs.size()]);
        String algoKey = "QueryPDMPro";
        HashMap map = new HashMap(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pdm_promaterdtb", (String)"id,effectdate,invaliddate", (QFilter[])qFilters, null);){
            dataSet.forEach(row -> map.put(row.getLong("id"), new VersionDataObj(row.getLong("id"), row.getDate("effectdate"), row.getDate("invaliddate"))));
        }
        boolean isOk = true;
        if (effectDate instanceof Date && invalidDate instanceof Date) {
            Date efDate = (Date)effectDate;
            Date inDate = (Date)invalidDate;
            for (Map.Entry entry : map.entrySet()) {
                VersionDataObj value = (VersionDataObj)entry.getValue();
                Date effectDate_ot = value.getEffectDate();
                Date invalidDate_ot = value.getInvalidDate();
                if (!efDate.before(invalidDate_ot) || !inDate.after(effectDate_ot)) continue;
                isOk = false;
            }
        }
        return isOk;
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsg) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "PDMProMaterDatesCheckError", ResManager.loadKDString((String)"\u68c0\u67e5\u751f\u6548\u65e5\u671f\u548c\u5931\u6548\u65e5\u671f\u3002", (String)"PDMProMaterDTBBaseOp_2", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

