/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.superbom;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mmc.pdm.common.util.MMCUtils;

public class SuperBomSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (objs == null || objs.length <= 0) {
            return;
        }
        String errMessage = "";
        for (ExtendedDataEntity obj : objs) {
            DynamicObject bom = obj.getDataEntity();
            if (bom == null) continue;
            this.validBomEntry(obj, bom);
        }
    }

    private void validBomEntry(ExtendedDataEntity obj, DynamicObject bom) {
        DynamicObject mat = bom.getDynamicObject("material");
        if (mat == null) {
            return;
        }
        String configproperties = mat.getString("configproperties");
        String optioncontrol = bom.getString("optioncontrol");
        DynamicObjectCollection bomEntrys = bom.getDynamicObjectCollection("entry");
        if (bomEntrys == null) {
            return;
        }
        if ("B".equals(optioncontrol) && bomEntrys.size() < 2) {
            this.addErrorMessage(obj, ResManager.loadKDString((String)"\u7236\u9879\u7279\u5f81\u4ef6\u9009\u9879\u63a7\u5236\u4e3a\u591a\u9009\uff0c\u7ec4\u4ef6\u9879\u76ee\u6570\u91cf\u4e0d\u80fd\u5c11\u4e8e2\u9879\u3002", (String)"SuperBomSaveValidator_0", (String)"mmc-pdm-opplugin", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject bomEntry : bomEntrys) {
            DynamicObject entrymaterial = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bomEntry, (String)"entrymaterial");
            if (entrymaterial == null) continue;
            String seq = bomEntry.getString("seq");
            BigDecimal minqtyopt = bomEntry.getBigDecimal("minqtyopt");
            BigDecimal maxqtyopt = bomEntry.getBigDecimal("maxqtyopt");
            String errMessage = StringUtils.isBlank((Object)minqtyopt) ? String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d\u3001\u201c\u6700\u5c0f\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuperBomSaveValidator_7", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), seq, entrymaterial.getString("name")) : (StringUtils.isBlank((Object)maxqtyopt) ? String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d\u3001\u201c\u6700\u5c0f\u6570\u91cf\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuperBomSaveValidator_8", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), seq, entrymaterial.getString("name")) : (minqtyopt.compareTo(maxqtyopt) > 0 ? String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7ec4\u4ef6\u5206\u5f55\uff0c\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d\uff0c\u201c\u6700\u5c0f\u6570\u91cf\u201d\u5927\u4e8e\u201c\u6700\u5927\u6570\u91cf\u201d\u3002", (String)"SuperBomSaveValidator_9", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), seq, entrymaterial.getString("name")) : ""));
            if (errMessage.length() > 0) {
                this.addErrorMessage(obj, errMessage);
                return;
            }
            String entryconfigproperties = entrymaterial.getString("configproperties");
            if ("3".equals(configproperties) && "3".equals(entryconfigproperties)) {
                this.addErrorMessage(obj, ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u4ea7\u54c1\u4e3a\u7279\u5f81\u4ef6\u65f6,\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d\u4e0d\u5141\u8bb8\u4e3a\u7279\u5f81\u4ef6\u3002", (String)"SuperBomSaveValidator_5", (String)"mmc-pdm-opplugin", (Object[])new Object[]{seq, entrymaterial.getString("name")}));
            }
            String opt = bomEntry.getString("opt");
            if (!"A".equals(optioncontrol) || !"false".equals(opt)) continue;
            errMessage = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d,\u7236\u9879\u7279\u5f81\u4ef6\u9009\u9879\u63a7\u5236\u4e3a\u5355\u9009\uff0c\u5b50\u9879\u5fc5\u987b\u5168\u90e8\u53ef\u9009\u3002", (String)"SuperBomSaveValidator_10", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), seq, entrymaterial.getString("name"));
            this.addErrorMessage(obj, errMessage);
        }
    }
}

