/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.workcard.botp;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.pdm.common.workcard.ToolRequireCardUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ProjectScopeToToolRequireCard
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        long userId = RequestContext.get().getCurrUserId();
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        HashSet<Long> projectIds = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : entitys) {
            DynamicObject projectRange;
            DynamicObject object = dataEntity.getDataEntity();
            if (object.getDynamicObject("org") != null) {
                orgIds.add(object.getDynamicObject("org").getLong("id"));
            }
            if ((projectRange = object.getDynamicObject("projectrange")) == null || projectRange.getDynamicObject("project") == null) continue;
            projectIds.add(projectRange.getDynamicObject("project").getLong("id"));
        }
        Map projectCardMap = ToolRequireCardUtils.getProjectCardMap(projectIds, (String)"mpdm_cardtooldemand");
        for (ExtendedDataEntity dataEntity : entitys) {
            Set set;
            DynamicObject object = dataEntity.getDataEntity();
            DynamicObject projectRange = object.getDynamicObject("projectrange");
            if (projectRange == null || projectRange.getDynamicObject("project") == null || !CollectionUtils.isNotEmpty((Collection)(set = (Set)projectCardMap.get(projectRange.getDynamicObject("project").getLong("id"))))) continue;
            Set longs = ToolRequireCardUtils.getToolRequireCard(orgIds, (Set)set);
            Set longSet = ToolRequireCardUtils.getCardToolDemand(orgIds, (Set)set);
            List collect = set.stream().filter(x -> !longs.contains(x)).filter(x -> !longSet.contains(x)).collect(Collectors.toList());
            DynamicObjectCollection dynamicObjectCollection = object.getDynamicObjectCollection("entryentity");
            Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_mrocardroute", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
            for (Long id : collect) {
                DynamicObject object1 = dynamicObjectCollection.addNew();
                object1.set("cardnum", objectDynamicObjectMap.get(id));
                object1.set("requiretool", (Object)"A");
                object1.set("toolstatus", (Object)"A");
                object1.set("moduser", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id"));
            }
        }
    }
}

