/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.mservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.mmc.business.query.helper.MmcCommonHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMExpandConfigBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMReportFromProConfigBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BomBackwardSearchBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BomForwardSearchBusiness;
import kd.mmc.pdm.business.proconfig.proconfiglist.ProConfigSearchForWorkOrderBuniesss;
import kd.mmc.pdm.business.proconfig.proconfiglist.ProductConifgListBusiness;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.mservice.IBomSearchService;

public class BomSearchServiceImpl
implements IBomSearchService {
    private static final Log logger = LogFactory.getLog(BomSearchServiceImpl.class);

    public String firsrLevelForwardSearch() {
        return null;
    }

    public String allLevelForwardSearch(String filterStr) {
        JSONArray retData = new JSONArray(16);
        JSONArray filterArray = JSONArray.parseArray((String)filterStr);
        HashSet<Long> bomIdSet = new HashSet<Long>(filterArray.size());
        for (int i = 0; i < filterArray.size(); ++i) {
            JSONObject filterJson = (JSONObject)filterArray.get(i);
            bomIdSet.add(filterJson.getLong("id"));
        }
        Map bomMap = BusinessDataServiceHelper.loadFromCache((String)"pdm_mftbom", (String)"id,materialid,type,version,replaceno,createorg,wbs", (QFilter[])new QFilter[]{new QFilter("id", "in", bomIdSet)});
        for (int i = 0; i < filterArray.size(); ++i) {
            JSONObject filterJson = (JSONObject)filterArray.get(i);
            long id = filterJson.getLong("id");
            retData = this.doQuery(filterJson, (DynamicObject)bomMap.get(id), retData);
        }
        return retData.toString();
    }

    public Map<Object, DynamicObject> getBomMap(JSONArray filterArray) {
        if (filterArray.isEmpty()) {
            return new HashMap<Object, DynamicObject>(1);
        }
        HashSet<Long> bomIdSet = new HashSet<Long>(filterArray.size());
        for (int i = 0; i < filterArray.size(); ++i) {
            long bomId;
            JSONObject filterJson = filterArray.getJSONObject(i);
            long l = bomId = filterJson.get((Object)"bomId") == null ? 0L : Long.parseLong(filterJson.get((Object)"bomId").toString());
            if (bomId == 0L) continue;
            bomIdSet.add(bomId);
        }
        String field = "id,materialid,type,version,replaceno,createorg,wbs";
        return BusinessDataServiceHelper.loadFromCache((String)"pdm_mftbom", (String)field, (QFilter[])new QFilter[]{new QFilter("id", "in", bomIdSet)});
    }

    public String bomExpandForMulType(String filterStr) {
        JSONArray retData = new JSONArray(16);
        JSONArray filterArray = JSONArray.parseArray((String)filterStr);
        if (filterArray.isEmpty()) {
            return "";
        }
        Map defaultExpandConfigMap = null;
        Map<Object, DynamicObject> matMap = this.getFirstLevelMat(filterArray);
        Map<Object, DynamicObject> bomMap = this.getBomMap(filterArray);
        JSONArray retArray = new JSONArray(filterArray.size());
        for (int i = 0; i < filterArray.size(); ++i) {
            JSONObject retJson = new JSONObject();
            try {
                DataSet set;
                JSONObject filterJson = filterArray.getJSONObject(i);
                Object bomId = filterJson.get((Object)"bomId");
                Object matId = filterJson.get((Object)"materialid");
                Object expand = filterJson.get((Object)"expandConfig");
                Object verObj = filterJson.get((Object)"version");
                Object wbs = filterJson.get((Object)"wbs");
                Object auxpObj = filterJson.get((Object)"auxproperty");
                Object configcode = filterJson.get((Object)"configcode");
                Object replaceno = filterJson.get((Object)"replaceno");
                Date searchDate = filterJson.getDate("searchDate");
                Object org = filterJson.get((Object)"org");
                String showtype = filterJson.getString("showtype");
                BigDecimal num = filterJson.getBigDecimal("num");
                if (num == null || num.compareTo(BigDecimal.ZERO) == 0) {
                    num = BigDecimal.ONE;
                }
                String purExpandStr = filterJson.getString("purexpand");
                String model = filterJson.getString("model");
                Object routeId = filterJson.get((Object)"routeId");
                if (model == null || "".equals(model)) {
                    model = "model_pdm";
                }
                if (purExpandStr == null || "".equals(purExpandStr)) {
                    purExpandStr = "true";
                }
                boolean purExpand = Boolean.parseBoolean(purExpandStr);
                Map bomExpandMap = null;
                DynamicObject bomExpandObj = BusinessDataServiceHelper.newDynamicObject((String)"mpdm_bomexpandconfig");
                if (expand != null) {
                    Long expandId = BOMExpandConfigBusiness.getLongValue((Object)expand);
                    bomExpandMap = BOMExpandConfigBusiness.getBomExpandConfig((long)expandId);
                    bomExpandObj.set("id", (Object)expandId);
                } else {
                    TreeMap bomExpandIdMap;
                    if (defaultExpandConfigMap == null) {
                        defaultExpandConfigMap = BOMExpandConfigBusiness.getBomExpandConfigByNum((String)"PP01");
                    }
                    long bomExpand = (bomExpandIdMap = (TreeMap)(bomExpandMap = defaultExpandConfigMap).get("id")).get(1) == null ? 0L : Long.parseLong(bomExpandIdMap.get(1).toString());
                    bomExpandObj.set("id", (Object)bomExpand);
                }
                DynamicObject matObj = matMap.get(matId);
                if (bomExpandMap == null || matObj == null && bomId == null) {
                    retJson.put("dataKey", (Object)"");
                    retJson.put("count", (Object)0);
                    retJson.put("data", (Object)new JSONArray());
                    retJson.put("success", (Object)false);
                    retJson.put("msg", (Object)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u3001BOMID\u3001BOM\u5c55\u5f00\u8bbe\u7f6e\u3002", (String)"BomSearchServiceImpl_0", (String)"mmc-pdm-mservice", (Object[])new Object[0]), expand));
                    retData.add((Object)retJson);
                    continue;
                }
                String purpose = "A";
                if (matObj != null) {
                    String configproperties = matObj.getString("configproperties");
                    purpose = "2".equals(configproperties) || "3".equals(configproperties) ? (configcode != null && !"0".equals(configcode.toString()) ? "C" : "B") : "A";
                }
                String dataId = "model_pom".equals(model) ? CreateStockByBomUtils.getMulBomFilterStr((JSONObject)filterJson) : UUID.randomUUID().toString();
                String verConfig = BOMExpandConfigBusiness.getExpandVerConfig((Map)bomExpandMap);
                Set bomTypeSet = BOMExpandConfigBusiness.getBomTypeOfPurpose((Map)bomExpandMap, (String)purpose);
                if (bomTypeSet == null || bomTypeSet.isEmpty()) {
                    retJson.put("dataKey", (Object)dataId);
                    retJson.put("count", (Object)retArray.size());
                    retJson.put("data", (Object)filterJson.toString());
                    retJson.put("success", (Object)false);
                    retJson.put("msg", (Object)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u3001BOMID\u3001BOM\u5c55\u5f00\u8bbe\u7f6e\u3002", (String)"BomSearchServiceImpl_0", (String)"mmc-pdm-mservice", (Object[])new Object[0]), expand));
                    retData.add((Object)retJson);
                    continue;
                }
                long bomVerId = BOMExpandConfigBusiness.getLongValue((Object)verObj);
                long wbsId = BOMExpandConfigBusiness.getLongValue((Object)wbs);
                DynamicObject bomObj = bomMap.get(bomId);
                long repNo = BOMExpandConfigBusiness.getLongValue((Object)replaceno);
                DynamicObject replaceNoObj = null;
                if (repNo != 0L) {
                    replaceNoObj = BusinessDataServiceHelper.newDynamicObject((String)"mpdm_replaceno");
                    replaceNoObj.set("id", (Object)repNo);
                }
                if (bomObj != null) {
                    DynamicObject bomVerObj = bomObj.getDynamicObject("version");
                    bomVerId = bomVerObj == null ? 0L : bomVerObj.getLong("id");
                    replaceNoObj = bomObj.getDynamicObject("replaceno");
                    wbsId = bomObj.getDynamicObject("wbs") == null ? 0L : bomObj.getDynamicObject("wbs").getLong("id");
                }
                QFilter bom = new QFilter("id", "=", (Object)(bomId == null ? 0L : Long.parseLong(bomId.toString())));
                QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)(org == null ? -1L : Long.parseLong(org.toString())));
                QFilter material = new QFilter("materialid", "=", (Object)BOMExpandConfigBusiness.getLongValue((Object)matId));
                QFilter bomType = new QFilter("type", "in", (Object)bomTypeSet);
                QFilter version = new QFilter("version", "=", (Object)BOMExpandConfigBusiness.getLongValue((Object)verObj));
                QFilter auxproperty = new QFilter("auxproperty", "=", (Object)BOMExpandConfigBusiness.getLongValue((Object)auxpObj));
                QFilter wbsQ = new QFilter("wbs", "=", (Object)BOMExpandConfigBusiness.getLongValue((Object)wbs));
                QFilter replace = new QFilter("replaceno", "=", (Object)BOMExpandConfigBusiness.getLongValue((Object)replaceno));
                QFilter configCodeFilter = new QFilter("configuredcode", "=", (Object)BOMExpandConfigBusiness.getLongValue((Object)configcode));
                QFilter effect = new QFilter("entry.entryvaliddate", "<=", (Object)searchDate);
                QFilter invalid = new QFilter("entry.entryinvaliddate", ">=", (Object)searchDate);
                QFilter enable = new QFilter("enable", "=", (Object)"1");
                QFilter status = new QFilter("status", "=", (Object)"C");
                QFilter[] allDataFilter = new QFilter[]{status, enable, effect, invalid, ids};
                Object[] globalDataFilter = new QFilter[]{bomType, material, auxproperty, status, enable, effect, invalid, ids, configCodeFilter};
                if (bomVerId != 0L) {
                    globalDataFilter = (QFilter[])ArrayUtils.add((Object[])globalDataFilter, (Object)version);
                }
                if (bomId != null) {
                    globalDataFilter = new QFilter[]{bom, status, enable, effect, invalid, configCodeFilter};
                }
                boolean isConfigBom = false;
                BomForwardSearchBusiness forwardBusiness = new BomForwardSearchBusiness("false", num, false, bomExpandObj, purExpand, purpose);
                if (configcode != null && !"0".equals(configcode.toString())) {
                    if (QueryServiceHelper.exists((String)"pdm_mftbom", (QFilter[])globalDataFilter)) {
                        set = forwardBusiness.getDataSet(allDataFilter, (QFilter[])globalDataFilter, showtype, false, searchDate, replaceNoObj, null, verConfig, bomVerId, Long.valueOf(wbsId), true);
                        retArray = MMCUtils.parseToJSONArray((DataSet)set);
                        retArray = this.isJumpFilter(retArray, showtype);
                    } else {
                        ArrayList<Long> list = new ArrayList<Long>();
                        list.add(configcode == null ? -1L : Long.parseLong(configcode.toString()));
                        JSONObject configList = new JSONObject();
                        configList.put(configcode.toString(), (Object)BOMExpandConfigBusiness.getLongValue((Object)routeId));
                        JSONObject params = new JSONObject();
                        params.put("searchTime", (Object)searchDate);
                        params.put("isNeedProRoute", (Object)false);
                        params.put("model", (Object)model);
                        if ("model_pom".equals(model)) {
                            params.put("configCodeList", (Object)configList);
                        } else {
                            params.put("configCodeList", list);
                        }
                        params.put("bomId", bomId);
                        params.put("matId", (Object)(matId == null ? -1L : Long.parseLong(matId.toString())));
                        params.put("bomVer", (Object)(verObj == null ? 0L : Long.parseLong(verObj.toString())));
                        params.put("purchaseExpand", (Object)purExpand);
                        params.put("num", (Object)num);
                        params.put("wbs", (Object)wbsId);
                        params.put("org", (Object)(org == null ? -1L : Long.parseLong(org.toString())));
                        JSONObject retObj = null;
                        retObj = "model_pom".equals(model) ? ProConfigSearchForWorkOrderBuniesss.getInstance().getConfigBomForWorkOrder(params.toJSONString()) : ProductConifgListBusiness.getInstance().getProdConfigListByFeature(params.toJSONString());
                        RowMeta rowMeta = this.getRowMeta(forwardBusiness);
                        long configCodeId = configcode == null ? 0L : Long.parseLong(configcode.toString());
                        BOMReportFromProConfigBusiness business = new BOMReportFromProConfigBusiness("");
                        set = business.parseToDataSetFromJson(rowMeta, retObj, configCodeId);
                        if ("B".equals(showtype)) {
                            String showItems = forwardBusiness.getShowTogeterItems();
                            set = set.groupBy(showItems.split(",")).sum("commonused").finish().orderBy(new String[]{"entrymaterialId"});
                        }
                        isConfigBom = true;
                        retArray = MMCUtils.parseToJSONArray((DataSet)set);
                    }
                } else {
                    set = forwardBusiness.getDataSet(allDataFilter, (QFilter[])globalDataFilter, showtype, false, searchDate, replaceNoObj, null, verConfig, bomVerId, Long.valueOf(wbsId), true);
                    retArray = MMCUtils.parseToJSONArray((DataSet)set);
                    retArray = this.isJumpFilter(retArray, showtype);
                }
                if (!isConfigBom) {
                    this.initReturnDataForJson(retArray, num);
                }
                this.setDataToCatch(retArray, dataId);
                retJson.put("dataKey", (Object)dataId);
                retJson.put("count", (Object)retArray.size());
                retJson.put("data", (Object)filterJson.toString());
                retJson.put("success", (Object)true);
                retJson.put("msg", (Object)"");
                retData.add((Object)retJson);
                retArray.clear();
                continue;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                retJson.put("dataKey", (Object)"");
                retJson.put("count", (Object)0);
                retJson.put("data", (Object)new JSONArray());
                retJson.put("success", (Object)false);
                retJson.put("msg", (Object)ResManager.loadKDString((String)"BOM\u5c55\u5f00\u5f02\u5e38\u3002", (String)"BomSearchServiceImpl_1", (String)"mmc-pdm-mservice", (Object[])new Object[0]));
                retJson.put("detialmsg", (Object)e.getMessage());
                retData.add((Object)retJson);
            }
        }
        return retData.toString();
    }

    private JSONArray isJumpFilter(JSONArray dataArray, String showType) {
        if (!"D".equals(showType)) {
            return dataArray;
        }
        int isize = dataArray.size();
        JSONArray retArray = new JSONArray();
        for (int i = 0; i < isize; ++i) {
            JSONObject dataObj = (JSONObject)dataArray.get(i);
            if (((Boolean)dataObj.get((Object)"entryisjumplevel")).booleanValue()) continue;
            retArray.add((Object)dataObj);
        }
        return retArray;
    }

    private void setDataToCatch(JSONArray dataArray, String dataId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
        cache.put(dataId, (Object)dataArray.toString(), 600);
    }

    public RowMeta getRowMeta(BomForwardSearchBusiness forwardBusiness) {
        String formNum = "pdm_mftbom";
        UUID uuid = UUID.randomUUID();
        String randomId = uuid.toString().replace("-", "");
        String selectItems = forwardBusiness.getSelectItems("1");
        selectItems = selectItems + ",concat('" + randomId + "',version) randomId,version tmpver";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BOMForwardSearchReportPlugin", (String)formNum, (String)selectItems, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)-1L)}, null).orderBy(new String[]{"entrySeq"});
        return dataSet.getRowMeta();
    }

    private Map<Object, DynamicObject> getBomExpandConfig(JSONArray filterArray) {
        HashMap<Object, DynamicObject> retMap = new HashMap<Object, DynamicObject>(64);
        if (filterArray == null || filterArray.isEmpty()) {
            return retMap;
        }
        HashSet<Long> expandIdSet = new HashSet<Long>(100);
        for (int i = 0; i < filterArray.size(); ++i) {
            JSONObject filterJson = filterArray.getJSONObject(i);
            Object expand = filterJson.get((Object)"expandConfig");
            if (expand == null) continue;
            long expandId = Long.parseLong(expand.toString());
            expandIdSet.add(expandId);
        }
        QFilter filter = new QFilter("id", "in", expandIdSet);
        if (expandIdSet.isEmpty()) {
            return retMap;
        }
        String fields = "id,superbomtype,probomtype,orderbomtype";
        return BusinessDataServiceHelper.loadFromCache((String)"mpdm_bomexpandconfig", (String)fields, (QFilter[])new QFilter[]{filter});
    }

    private DynamicObject getDefBomExpandConifgByNum(String bomExpandNum) {
        if (bomExpandNum == null) {
            return null;
        }
        QFilter expandIdFilter = new QFilter("number", "=", (Object)bomExpandNum);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_bomexpandconfig", (QFilter[])new QFilter[]{expandIdFilter, status, enable});
    }

    private Map<Object, DynamicObject> getFirstLevelMat(JSONArray filterArray) {
        HashMap<Object, DynamicObject> retMap = new HashMap<Object, DynamicObject>(64);
        if (filterArray == null || filterArray.isEmpty()) {
            return retMap;
        }
        HashSet<Long> matIdSet = new HashSet<Long>(64);
        for (int i = 0; i < filterArray.size(); ++i) {
            JSONObject filterJson = filterArray.getJSONObject(i);
            Object materialid = filterJson.get((Object)"materialid");
            if (materialid == null) continue;
            long expandId = Long.parseLong(materialid.toString());
            matIdSet.add(expandId);
        }
        QFilter filter = new QFilter("id", "in", matIdSet);
        String fields = "id,number,configproperties";
        return BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)fields, (QFilter[])new QFilter[]{filter});
    }

    private Map<String, Object> getRouteWorkCenter(Set<Long> routeIds) {
        if (routeIds == null || routeIds.isEmpty()) {
            return new HashMap<String, Object>(10);
        }
        QFilter routeIdsFilter = new QFilter("id", "in", routeIds);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        Map routeMap = BusinessDataServiceHelper.loadFromCache((String)"pdm_route", (String)"id,workcenter,workstation", (QFilter[])new QFilter[]{routeIdsFilter, status, enable});
        return this.getWorkCenter(routeMap);
    }

    private Map<String, Object> getWorkCenter(Map<Object, DynamicObject> routeMap) {
        HashMap<String, Object> retMap = new HashMap<String, Object>(100);
        if (routeMap == null) {
            return retMap;
        }
        for (Map.Entry<Object, DynamicObject> routeId : routeMap.entrySet()) {
            DynamicObject routeObj = routeId.getValue();
            DynamicObjectCollection col = routeObj.getDynamicObjectCollection("processentry");
            HashSet<Long> workCenterSet = new HashSet<Long>(100);
            HashMap<Long, HashSet<Long>> stationMap = new HashMap<Long, HashSet<Long>>(100);
            for (int i = 0; i < col.size(); ++i) {
                DynamicObject entry = (DynamicObject)col.get(i);
                DynamicObject workcenter = entry.getDynamicObject("workcenter");
                if (workcenter == null) continue;
                long workCenterId = workcenter.getLong("id");
                workCenterSet.add(workCenterId);
                DynamicObject workstation = entry.getDynamicObject("workstation");
                if (workstation == null) continue;
                long workstationId = workstation.getLong("id");
                HashSet<Long> workStationSet = (HashSet<Long>)stationMap.get(workCenterId);
                if (workStationSet == null) {
                    workStationSet = new HashSet<Long>(100);
                }
                workStationSet.add(workstationId);
                stationMap.put(workCenterId, workStationSet);
            }
            if (workCenterSet.isEmpty()) continue;
            retMap.put("center" + routeId.toString(), workCenterSet);
            if (stationMap.isEmpty()) continue;
            retMap.put("station" + routeId.toString(), stationMap);
        }
        return retMap;
    }

    public String sumLevelForwardSearch() {
        return null;
    }

    public String firstLevelBackForwardSearch() {
        return null;
    }

    public String allLevelBackForwardSearch(String filterStr) {
        JSONArray retData = new JSONArray(10);
        JSONArray filterArray = JSONArray.parseArray((String)filterStr);
        for (int i = 0; i < filterArray.size(); ++i) {
            JSONObject retJson = new JSONObject();
            JSONObject filterJson = (JSONObject)filterArray.get(i);
            Date searchDate = filterJson.getDate("time");
            BigDecimal demandCount = filterJson.getBigDecimal("num");
            Object entryVersion = filterJson.get((Object)"version");
            Object replaceno = filterJson.get((Object)"replaceno");
            QFilter material = new QFilter("entry.entrymaterialid", "=", (Object)filterJson.getLong("material"));
            QFilter bomType = new QFilter("type", "=", (Object)filterJson.getLong("bomType"));
            QFilter effect = new QFilter("entry.entryvaliddate", "<=", (Object)searchDate);
            QFilter invalid = new QFilter("entry.entryinvaliddate", ">=", (Object)searchDate);
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            QFilter status = new QFilter("status", "=", (Object)"C");
            QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)filterJson.getLong("createOrg"));
            DynamicObject insteadObj = BusinessDataServiceHelper.newDynamicObject((String)"mpdm_replaceno");
            insteadObj.set("id", (Object)filterJson.getLong("replaceno"));
            BomBackwardSearchBusiness backwardSearch = new BomBackwardSearchBusiness("false", demandCount);
            QFilter[] allDataFilter = new QFilter[]{bomType, status, enable, effect, invalid, ids};
            Object[] globalDataFilter = new QFilter[]{material, bomType, status, enable, effect, invalid, ids};
            if (entryVersion != null) {
                QFilter version = new QFilter("entry.entryversion", "=", (Object)filterJson.getLong("version"));
                globalDataFilter = (QFilter[])ArrayUtils.add((Object[])globalDataFilter, (Object)version);
            }
            if (replaceno != null) {
                QFilter insteadNum = new QFilter("replaceno", "=", (Object)filterJson.getLong("replaceno"));
                globalDataFilter = (QFilter[])ArrayUtils.add((Object[])globalDataFilter, (Object)insteadNum);
            }
            String string = UUID.randomUUID().toString();
        }
        return retData.toString();
    }

    private void setDataToCatch(List<Map<String, Object>> dataList, String dataId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
        cache.put(dataId, (Object)JSONObject.toJSONString(dataList), 600);
    }

    public String sumLevelBackForwardSearch() {
        return null;
    }

    private JSONArray doQuery(JSONObject filterJson, DynamicObject bomObj, JSONArray retData) {
        long wbsid;
        String expandType;
        long id = filterJson.getLong("id");
        Date searchDate = filterJson.getDate("time");
        BigDecimal demandCount = filterJson.getBigDecimal("num");
        Object expand = filterJson.get((Object)"expandConfig");
        String string = expandType = filterJson.containsKey((Object)"type") ? filterJson.getString("type") : "D";
        if (StringUtils.isEmpty((String)expandType)) {
            expandType = "D";
        }
        long time = searchDate.getTime();
        long bomId = bomObj.getLong("id");
        DynamicObject verObj = bomObj.getDynamicObject("version");
        DynamicObject insteadObj = bomObj.getDynamicObject("replaceno");
        DynamicObject createorgObj = bomObj.getDynamicObject("createorg");
        DynamicObject wbsObj = bomObj.getDynamicObject("wbs");
        long bomVerId = verObj == null ? 0L : verObj.getLong("id");
        long l = wbsid = wbsObj == null ? 0L : wbsObj.getLong("id");
        if (id == bomId) {
            Map defaultExpandConfigMap = BOMExpandConfigBusiness.getBomExpandConfigByNum((String)"PP01");
            Map bomExpandMap = null;
            DynamicObject bomExpandObj = BusinessDataServiceHelper.newDynamicObject((String)"mpdm_bomexpandconfig");
            if (expand != null) {
                Long expandId = BOMExpandConfigBusiness.getLongValue((Object)expand);
                bomExpandMap = BOMExpandConfigBusiness.getBomExpandConfig((long)expandId);
                bomExpandObj.set("id", (Object)expandId);
            } else {
                TreeMap bomExpandIdMap;
                if (defaultExpandConfigMap == null) {
                    defaultExpandConfigMap = BOMExpandConfigBusiness.getBomExpandConfigByNum((String)"PP01");
                }
                long bomExpand = (bomExpandIdMap = (TreeMap)(bomExpandMap = defaultExpandConfigMap).get("id")).get(1) == null ? 0L : Long.parseLong(bomExpandIdMap.get(1).toString());
                bomExpandObj.set("id", (Object)bomExpand);
            }
            String purpose = "A";
            Set bomTypeSet = BOMExpandConfigBusiness.getBomTypeOfPurpose((Map)bomExpandMap, (String)purpose);
            QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)createorgObj.getLong("id"));
            QFilter bomType = new QFilter("type", "in", (Object)bomTypeSet);
            QFilter effect = new QFilter("entry.entryvaliddate", "<=", (Object)searchDate);
            QFilter invalid = new QFilter("entry.entryinvaliddate", ">=", (Object)searchDate);
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            QFilter status = new QFilter("status", "=", (Object)"C");
            QFilter bom = new QFilter("id", "=", (Object)bomId);
            QFilter[] allDataFilter = new QFilter[]{bomType, status, enable, effect, invalid, ids};
            QFilter[] globalDataFilter = new QFilter[]{bom, status, enable, effect, invalid};
            JSONObject retJson = new JSONObject();
            try {
                BomForwardSearchBusiness forwardSearch = new BomForwardSearchBusiness("false", demandCount, false, bomExpandObj, false, purpose);
                List dataList = forwardSearch.getBomLevelSearch(allDataFilter, globalDataFilter, expandType, false, searchDate, insteadObj, "", "A", bomVerId, wbsid);
                String dataKey = bomId + "-" + demandCount;
                boolean isBomExpandTime = MmcCommonHelper.IsBomExpandTime();
                if (isBomExpandTime) {
                    dataKey = dataKey + "-" + time;
                } else {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    dataKey = dataKey + "-" + sdf.format(searchDate);
                }
                dataKey = dataKey + "-" + expandType;
                String routeId = filterJson.getString("routeId");
                dataKey = dataKey + "-" + routeId;
                this.initReturnData(dataList, demandCount);
                this.setDataToCatch(dataList, dataKey);
                retJson.put("dataKey", (Object)dataKey);
                retJson.put("count", (Object)dataList.size());
                retJson.put("data", (Object)filterJson.toString());
                retJson.put("success", (Object)true);
                retJson.put("msg", (Object)"");
                retData.add((Object)retJson);
            }
            catch (Exception e) {
                logger.info(e.toString());
                throw new KDBizException((Throwable)e, new ErrorCode("bomSearchException", ResManager.loadKDString((String)"BOM\u5c55\u5f00\u5f02\u5e38\u3002", (String)"BomSearchServiceImpl_2", (String)"mmc-pdm-mservice", (Object[])new Object[0])), new Object[0]);
            }
        }
        return retData;
    }

    private void initReturnData(List<Map<String, Object>> dataList, BigDecimal demandCount) {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> maps = dataList.get(i);
            String level = (String)maps.get("level");
            String parentfxd = (String)maps.get("parentfxd");
            BigDecimal entryqtynumerator = (BigDecimal)maps.get("entryqtynumerator");
            BigDecimal entryqtydenominator = (BigDecimal)maps.get("entryqtydenominator");
            String entryqtytype = (String)maps.get("entryqtytype");
            BigDecimal commonused = (BigDecimal)maps.get("commonused");
            BigDecimal oneNumberator = null;
            if (StringUtils.isEmpty((String)level) || "1".equals(level)) {
                maps.put("entryunitqty", entryqtynumerator);
                continue;
            }
            if ("1".equals(parentfxd) || "B".equals(entryqtytype)) {
                oneNumberator = MMCUtils.multiply((BigDecimal)commonused, (BigDecimal)entryqtydenominator);
                maps.put("entryqtytype", "B");
            } else {
                oneNumberator = MMCUtils.multiplyAndDivide((BigDecimal)commonused, (BigDecimal)entryqtydenominator, (BigDecimal)demandCount);
            }
            if ("B".equals(entryqtytype)) {
                BigDecimal convertrate = (BigDecimal)maps.get("convertrate");
                oneNumberator = MMCUtils.multiply((BigDecimal)oneNumberator, (BigDecimal)convertrate);
            }
            maps.put("entryunitqty", oneNumberator);
        }
    }

    private void initReturnDataForJson(JSONArray dataArray, BigDecimal demandCount) {
        if (dataArray == null || dataArray.isEmpty()) {
            return;
        }
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject obj = (JSONObject)dataArray.get(i);
            BigDecimal oneNumberator = null;
            String level = obj.getString("level");
            if (StringUtils.isEmpty((String)level) || "1".equals(level)) {
                BigDecimal entryqtynumerator = obj.getBigDecimal("entryqtynumerator");
                obj.put("entryunitqty", (Object)entryqtynumerator);
                continue;
            }
            String parentfxd = obj.getString("parentfxd");
            BigDecimal entryqtydenominator = obj.getBigDecimal("entryqtydenominator");
            String entryqtytype = obj.getString("entryqtytype");
            BigDecimal commonused = obj.getBigDecimal("commonused");
            if ("1".equals(parentfxd) || "B".equals(entryqtytype)) {
                oneNumberator = MMCUtils.multiply((BigDecimal)commonused, (BigDecimal)entryqtydenominator);
                obj.put("entryqtytype", (Object)"B");
            } else {
                oneNumberator = MMCUtils.multiplyAndDivide((BigDecimal)commonused, (BigDecimal)entryqtydenominator, (BigDecimal)demandCount);
            }
            if ("B".equals(entryqtytype)) {
                BigDecimal convertrate = obj.getBigDecimal("convertrate");
                oneNumberator = MMCUtils.multiply((BigDecimal)oneNumberator, (BigDecimal)convertrate);
            }
            obj.put("entryunitqty", (Object)oneNumberator);
        }
    }
}

