/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SyncBatchBOMLogDataService {
    private static final Log logger = LogFactory.getLog(SyncBatchBOMLogDataService.class);

    public static UpgradeResult handleHistoryLog() {
        DynamicObject[] bomInfoDOC;
        logger.info("\u5f00\u59cb\u5904\u7406BOM\u6279\u91cf\u4fee\u6539\u5386\u53f2\u65e5\u5fd7...");
        long startTime = System.currentTimeMillis();
        UpgradeResult result = new UpgradeResult();
        ArrayList<QFilter> filtersList = new ArrayList<QFilter>(1);
        filtersList.add(new QFilter("logdetailentry.bomnum", "=", (Object)" ").or(new QFilter("logdetailentry.bommaterialnumber", "=", (Object)" ")));
        DynamicObject[] batchmftbomlogDOC = BusinessDataServiceHelper.load((String)"pdm_batchmftbomlog", (String)"id,logdetailentry.id,logdetailentry.bomid,logdetailentry.bomnum,logdetailentry.bommaterialnumber,logdetailentry.bommatername", (QFilter[])filtersList.toArray(new QFilter[filtersList.size()]));
        HashSet<Long> bomIdSets = new HashSet<Long>(128);
        if (batchmftbomlogDOC == null || batchmftbomlogDOC.length == 0) {
            result.setLog(ResManager.loadKDString((String)"\u672a\u627e\u5230\u9700\u8981\u5904\u7406\u7684\u5386\u53f2\u6570\u636e\u3002", (String)"SyncBatchBOMLogDataService_0", (String)"mmc-pdm-mservice", (Object[])new Object[0]));
            logger.info("\u672a\u67e5\u8be2\u5230\u65e5\u5fd7\uff1b");
            result.setSuccess(true);
            return result;
        }
        logger.info("\u67e5\u8be2\u5230\u65e5\u5fd7\u6761\u6570\uff1a" + batchmftbomlogDOC.length);
        for (int i = 0; i < batchmftbomlogDOC.length; ++i) {
            DynamicObject batchMBomLogDO = batchmftbomlogDOC[i];
            DynamicObject[] logDEntryDOC = batchMBomLogDO.getDynamicObjectCollection("logdetailentry");
            for (DynamicObject logDEntryDO : logDEntryDOC) {
                Long bomId = logDEntryDO.getLong("bomid");
                if (bomId <= 0L) continue;
                bomIdSets.add(bomId);
            }
        }
        if (bomIdSets.isEmpty()) {
            result.setLog(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173BOM\u3002", (String)"SyncBatchBOMLogDataService_1", (String)"mmc-pdm-mservice", (Object[])new Object[0]));
            logger.info("\u672a\u67e5\u8be2\u5230\u76f8\u5173BOM\u3002");
            result.setSuccess(true);
            return result;
        }
        result.setLog(String.format(ResManager.loadKDString((String)"\u5171\u67e5\u8be2\u5230%1$s\u6761BOM\u3002", (String)"SyncBatchBOMLogDataService_2", (String)"mmc-pdm-mservice", (Object[])new Object[0]), bomIdSets.size()));
        logger.info("\u5171\u67e5\u8be2\u5230" + bomIdSets.size() + "\u6761BOM\u3002");
        HashMap<Long, BOMAndMaterialEntity> bomInfoMap = new HashMap<Long, BOMAndMaterialEntity>(16);
        for (DynamicObject bomInfoDO : bomInfoDOC = BusinessDataServiceHelper.load((String)"pdm_mftbom", (String)"id,number,material", (QFilter[])new QFilter[]{new QFilter("id", "in", bomIdSets)})) {
            Object pkValueObj;
            String bomNumber = bomInfoDO.getString("number");
            DynamicObject material = bomInfoDO.getDynamicObject("material");
            if (material == null) continue;
            DynamicObject materialid = material.getDynamicObject("masterid");
            BOMAndMaterialEntity bomAndMaterialEntity = new BOMAndMaterialEntity();
            bomAndMaterialEntity.setBomNumber(bomNumber);
            if (materialid != null) {
                bomAndMaterialEntity.setBomMaterialNumber(materialid.getString("number"));
                Object name = materialid.get("name");
                if (name instanceof OrmLocaleValue) {
                    bomAndMaterialEntity.setBomMaterialName((OrmLocaleValue)name);
                }
            }
            if (!((pkValueObj = bomInfoDO.getPkValue()) instanceof Long)) continue;
            Long pkVlaue = Long.valueOf(pkValueObj.toString());
            bomInfoMap.put(pkVlaue, bomAndMaterialEntity);
        }
        logger.info("\u5f00\u59cb\u6267\u884c\u8d4b\u503c\u64cd\u4f5c\uff0c\u4e3a\u5386\u53f2\u65e5\u5fd7\u5199\u5165BOM\u7f16\u7801\u3001\u4ea7\u54c1\u7f16\u7801\u548c\u4ea7\u54c1\u540d\u79f0\uff1b");
        StringBuilder msg = new StringBuilder();
        msg.append(ResManager.loadKDString((String)"\u8d4b\u503c\u4fe1\u606f\uff1a", (String)"SyncBatchBOMLogDataService_4", (String)"mmc-pdm-mservice", (Object[])new Object[0]));
        for (int i = 0; i < batchmftbomlogDOC.length; ++i) {
            DynamicObject bomLogDO = batchmftbomlogDOC[i];
            DynamicObjectCollection logDEntryDOC = bomLogDO.getDynamicObjectCollection("logdetailentry");
            for (DynamicObject logDEntryDO : logDEntryDOC) {
                long bomid = logDEntryDO.getLong("bomid");
                BOMAndMaterialEntity bomAndMaterialEntity = (BOMAndMaterialEntity)bomInfoMap.get(bomid);
                msg.append(i).append("\u3001");
                if (bomAndMaterialEntity != null) {
                    logDEntryDO.set("bomnum", (Object)bomAndMaterialEntity.getBomNumber());
                    logDEntryDO.set("bommaterialnumber", (Object)bomAndMaterialEntity.getBomMaterialNumber());
                    logDEntryDO.set("bommatername", (Object)bomAndMaterialEntity.getBomMaterialName());
                    msg.append(bomAndMaterialEntity.getBomNumber()).append("-").append(bomAndMaterialEntity.getBomMaterialNumber()).append("-").append(bomAndMaterialEntity.getBomMaterialName());
                }
                msg.append(",");
            }
        }
        msg.append("\uff1b");
        logger.info(msg.toString());
        logger.info("\u5f00\u59cb\u8d4b\u503c\u64cd\u4f5c\u6267\u884c\u6210\u529f\uff1b");
        try {
            logger.info("\u5f00\u59cb\u6267\u884c\u4fdd\u5b58\u64cd\u4f5cs\uff1b");
            Object[] save = SaveServiceHelper.save((DynamicObject[])batchmftbomlogDOC);
            logger.info("save\u6761\u6570:\u3010" + (save != null ? save.length : 0) + "\u3011\uff1b");
        }
        catch (KDBizException e) {
            logger.info("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            throw new KDBizException((Throwable)e, new ErrorCode("LogHandleException", ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u5904\u7406\u5931\u8d25\u3002", (String)"SyncBatchBOMLogDataService_5", (String)"mmc-pdm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        long endTime = System.currentTimeMillis();
        logger.info("\u603b\u8017\u65f6\uff1a" + (endTime - startTime) + "\u6beb\u79d2\uff1b");
        result.setLog(String.format(ResManager.loadKDString((String)"\u603b\u8017\u65f6\uff1a%1$s\u6beb\u79d2\u3002", (String)"SyncBatchBOMLogDataService_6", (String)"mmc-pdm-mservice", (Object[])new Object[0]), endTime - startTime));
        result.setSuccess(true);
        return result;
    }

    private static class BOMAndMaterialEntity {
        private String bomNumber;
        private String bomMaterialNumber;
        private OrmLocaleValue bomMaterialName;

        private BOMAndMaterialEntity() {
        }

        public String getBomNumber() {
            return this.bomNumber;
        }

        public void setBomNumber(String bomNumber) {
            this.bomNumber = bomNumber;
        }

        public String getBomMaterialNumber() {
            return this.bomMaterialNumber;
        }

        public void setBomMaterialNumber(String bomMaterialNumber) {
            this.bomMaterialNumber = bomMaterialNumber;
        }

        public OrmLocaleValue getBomMaterialName() {
            return this.bomMaterialName;
        }

        public void setBomMaterialName(OrmLocaleValue bomMaterialName) {
            this.bomMaterialName = bomMaterialName;
        }
    }
}

