/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.service;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.common.workcard.ToolRequireCardUtils;
import kd.mmc.pdm.mservice.ToolRequireCardUpdateService;

public class ToolRequireCardUpdateServiceImpl
implements ToolRequireCardUpdateService {
    public void updateToolRequireCardStatus(String op, Map<Long, DynamicObject> tcd) {
        ToolRequireCardUtils.updateToolRequireCardStatus((String)op, tcd);
    }

    public Boolean createToolRequireCard(Long projectId, Set<Long> cardIds, Long orgId) {
        if (cardIds == null) {
            return false;
        }
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"pmpd_project");
        if (null == project) {
            return false;
        }
        Set removeCardIds = ToolRequireCardUtils.getCardIds(cardIds, (long)orgId);
        if (removeCardIds.size() > 0) {
            cardIds.removeAll(removeCardIds);
        }
        if (cardIds.size() > 0) {
            ORM orm = ORM.create();
            DynamicObject toolRequireCard = orm.newDynamicObject("pdm_toolrequirecard");
            String number = CodeRuleServiceHelper.getNumber((String)"pdm_toolrequirecard", (DynamicObject)toolRequireCard, (String)String.valueOf(orgId));
            if (StringUtils.isEmpty((CharSequence)number)) {
                number = "TRD-" + String.valueOf(System.currentTimeMillis());
            }
            toolRequireCard.set("billno", (Object)number);
            toolRequireCard.set("projectnum", (Object)project);
            toolRequireCard.set("billstatus", (Object)"C");
            toolRequireCard.set("source", (Object)"A");
            toolRequireCard.set("toolcreatestatus", (Object)"A");
            DynamicObject fixdevicetype = project.getDynamicObject("fixdevicetype");
            if (null != fixdevicetype) {
                toolRequireCard.set("mratype", (Object)fixdevicetype);
            }
            toolRequireCard.set("org", (Object)orgId);
            DynamicObject devices = project.getDynamicObject("devices");
            if (null != devices) {
                toolRequireCard.set("checkregno", (Object)devices);
                DynamicObject materialmtcinfo = BusinessDataServiceHelper.loadSingle((Object)devices.getPkValue(), (String)"mpdm_materialmtcinfo");
                DynamicObject enginetype = materialmtcinfo.getDynamicObject("enginetype");
                if (null != enginetype) {
                    toolRequireCard.set("enginetype", (Object)enginetype);
                }
            }
            DynamicObjectCollection entryentity = toolRequireCard.getDynamicObjectCollection("entryentity");
            this.addNewEntry(cardIds, entryentity);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{toolRequireCard});
            return true;
        }
        return false;
    }

    public Boolean updateToolRequireCard(Long projectId, Set<Long> cardIds, Long orgId) {
        if (cardIds == null) {
            return false;
        }
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"pmpd_project");
        if (null == project) {
            return false;
        }
        QFilter toolCardQfilter = new QFilter("projectnum", "=", (Object)projectId);
        toolCardQfilter.and(new QFilter("org", "=", (Object)orgId));
        toolCardQfilter.and(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObject toolrequirecard = QueryServiceHelper.queryOne((String)"pdm_toolrequirecard", (String)"id", (QFilter[])toolCardQfilter.toArray());
        HashSet<Long> trdCardIds = new HashSet<Long>(16);
        Set existCTDCardIds = ToolRequireCardUtils.getExistCTDCardIds(cardIds, (long)orgId);
        Set existWorkTypeCtrl = ToolRequireCardUtils.getExistWorkTypeCtrl(cardIds);
        if (null != toolrequirecard) {
            long trdID = toolrequirecard.getLong("id");
            Set existCRDCardIds = ToolRequireCardUtils.getExistCRDCardIds(cardIds, (long)orgId, (long)trdID);
            DynamicObject trdDO = BusinessDataServiceHelper.loadSingle((Object)trdID, (String)"pdm_toolrequirecard");
            DynamicObjectCollection trdDOEntryEntity = trdDO.getDynamicObjectCollection("entryentity");
            if (null != trdDOEntryEntity && trdDOEntryEntity.size() > 0) {
                for (DynamicObject trdDOEntry : trdDOEntryEntity) {
                    DynamicObject cardnum = trdDOEntry.getDynamicObject("cardnum");
                    if (null == cardnum) continue;
                    long cardNumId = (Long)cardnum.getPkValue();
                    String toolstatus = trdDOEntry.getString("toolstatus");
                    if (cardIds.contains(cardNumId)) {
                        if (StringUtils.equals((CharSequence)"D", (CharSequence)toolstatus)) {
                            trdDOEntry.set("toolstatus", (Object)"A");
                        }
                        if (null != existCTDCardIds && existCTDCardIds.contains(cardNumId)) {
                            trdDOEntry.set("toolstatus", (Object)"C");
                        }
                        trdCardIds.add(cardNumId);
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)"C", (CharSequence)toolstatus)) continue;
                    trdDOEntry.set("toolstatus", (Object)"D");
                }
            }
            if (null != trdCardIds && trdCardIds.size() > 0) {
                cardIds.removeAll(trdCardIds);
            }
            ToolRequireCardUtils.removeSetCollect(cardIds, (Set)existCTDCardIds);
            ToolRequireCardUtils.removeSetCollect(cardIds, (Set)existCRDCardIds);
            ToolRequireCardUtils.removeSetCollect(cardIds, (Set)existWorkTypeCtrl);
            if (cardIds.size() > 0) {
                this.addNewEntry(cardIds, trdDOEntryEntity);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trdDO});
            return true;
        }
        this.createToolRequireCard(projectId, cardIds, orgId);
        return true;
    }

    public void addNewEntry(Set<Long> cardIds, DynamicObjectCollection entryentity) {
        Map wordCards = BusinessDataServiceHelper.loadFromCache((Object[])cardIds.toArray(), (String)"mpdm_mrocardroute");
        Collection values = wordCards.values();
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        if (null != values) {
            for (DynamicObject wordCard : values) {
                DynamicObject toolRequireCardEntry = entryentity.addNew();
                if (null != userObj) {
                    toolRequireCardEntry.set("moduser", (Object)userObj);
                }
                toolRequireCardEntry.set("cardnum", (Object)wordCard);
                toolRequireCardEntry.set("moddate", (Object)new Date());
                toolRequireCardEntry.set("toolstatus", (Object)"A");
            }
        }
    }
}

