/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.alloc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class AllocPlanCloseValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<ExtendedDataEntity> remains = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        ArrayList<Long> remainIds = new ArrayList<Long>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String status = dynamicObject.getString("status");
            if (!"A".equals(status)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6b63\u5e38\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u624b\u5de5\u5173\u95ed\u3002", (String)"AllocPlanCloseValidator_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
                continue;
            }
            remains.add(dataEntity);
            remainIds.add(dynamicObject.getLong("id"));
        }
        HashMap<Long, Long> destToSrc = new HashMap<Long, Long>();
        ConvertDataService reader = new ConvertDataService();
        Map dirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)"pom_allocationplan", (Long[])remainIds.toArray(new Long[0]));
        for (Map.Entry entry : dirtTargetBills.entrySet()) {
            Long srcId = (Long)entry.getKey();
            for (BFRow bfRow : (List)entry.getValue()) {
                String entityNumber;
                Long mainTableId = bfRow.getId().getMainTableId();
                TableDefine tableDefine = reader.loadTableDefine(mainTableId);
                if (tableDefine == null || !"im_transdirbill".equals(entityNumber = tableDefine.getEntityNumber())) continue;
                destToSrc.put(bfRow.getId().getBillId(), srcId);
            }
        }
        Set destIds = destToSrc.keySet();
        HashSet<Long> hashSet = new HashSet<Long>();
        QFilter filter = new QFilter("billstatus", "!=", (Object)"C");
        QFilter idFilter = new QFilter("id", "in", destIds);
        DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_transdirbill", (String)"id", (QFilter[])new QFilter[]{filter, idFilter}, null);
        Object object = null;
        try {
            for (Row d : ds) {
                hashSet.add(d.getLong("id"));
            }
        }
        catch (Throwable tableDefine) {
            object = tableDefine;
            throw tableDefine;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable tableDefine) {
                        ((Throwable)object).addSuppressed(tableDefine);
                    }
                } else {
                    ds.close();
                }
            }
        }
        Set unCloseSrcId = destToSrc.entrySet().stream().filter(x -> unAuditDestIds.contains(x.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
        for (ExtendedDataEntity remain : remains) {
            long id = remain.getDataEntity().getLong("id");
            if (!unCloseSrcId.contains(id)) continue;
            this.addErrorMessage(remain, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u624b\u5de5\u5173\u95ed\u3002", (String)"AllocPlanCloseValidator_1", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        }
    }
}

