/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.mmc.pom.business.coderule.mro.MROOrderCodeRuleHelper;

public class MroOrderBotpConvertCodeRuleOp
extends AbstractConvertPlugIn {
    private static final String STR_PROJECT = "project";
    private static final String STR_SOURCEBILLNUMBER = "sourceBillNumber";
    private static final String STR_CODERULE = "codeRule";

    public void afterConvert(AfterConvertEventArgs e) {
        DynamicObject codeRule;
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        HashMap<String, ArrayList<ExtendedDataEntity>> codeMap = new HashMap<String, ArrayList<ExtendedDataEntity>>(16);
        HashMap codeObjectMap = new HashMap(16);
        for (ExtendedDataEntity extendedDataEntity : billDataEntitys) {
            String sourceBillNumber;
            DynamicObject mroOrder = extendedDataEntity.getDataEntity();
            DynamicObject transtype = this.getTransactionType(mroOrder);
            if (transtype == null || (codeRule = MROOrderCodeRuleHelper.getTransactionTypeCodeMode((Long)transtype.getLong("id"))) == null) continue;
            DynamicObject project = this.getProject(mroOrder);
            String keyString = this.getKeyString(project, sourceBillNumber = this.getSourceBillNumber(mroOrder), codeRule);
            ArrayList<ExtendedDataEntity> rowIndexList = (ArrayList<ExtendedDataEntity>)codeMap.get(keyString);
            if (rowIndexList == null) {
                rowIndexList = new ArrayList<ExtendedDataEntity>(16);
            }
            rowIndexList.add(extendedDataEntity);
            codeMap.put(keyString, rowIndexList);
            HashMap<String, Object> codeObject = (HashMap<String, Object>)codeObjectMap.get(keyString);
            if (codeObject != null) continue;
            codeObject = new HashMap<String, Object>(16);
            codeObject.put(STR_PROJECT, project);
            codeObject.put(STR_SOURCEBILLNUMBER, sourceBillNumber);
            codeObject.put(STR_CODERULE, codeRule);
            codeObjectMap.put(keyString, codeObject);
        }
        for (Map.Entry entry : codeMap.entrySet()) {
            String sourceBillNumber;
            String keyString = (String)entry.getKey();
            List rowIndexList = (List)entry.getValue();
            if (rowIndexList.isEmpty()) continue;
            Map codeObject = (Map)codeObjectMap.get(keyString);
            DynamicObject project = codeObject.get(STR_PROJECT) == null ? null : (DynamicObject)codeObject.get(STR_PROJECT);
            codeRule = codeObject.get(STR_CODERULE) == null ? null : (DynamicObject)codeObject.get(STR_CODERULE);
            List codeList = MROOrderCodeRuleHelper.genCodeRuleNumbers((DynamicObject)codeRule, (DynamicObject)project, (String)(sourceBillNumber = codeObject.get(STR_SOURCEBILLNUMBER) == null ? null : (String)codeObject.get(STR_SOURCEBILLNUMBER)), (int)rowIndexList.size());
            int codeSize = codeList.size();
            if (codeSize <= 0) continue;
            for (int i = 0; i < rowIndexList.size(); ++i) {
                ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)rowIndexList.get(i);
                DynamicObject mroOrder = extendedDataEntity.getDataEntity();
                if (codeSize < i + 1) continue;
                mroOrder.set("billno", codeList.get(i));
                mroOrder.set("numberautogen", (Object)Boolean.TRUE);
            }
        }
    }

    private String getKeyString(DynamicObject project, String sourceBillNumber, DynamicObject codeRule) {
        return (project == null ? "" : project.getPkValue()) + "_" + (sourceBillNumber == null ? "" : sourceBillNumber) + "_" + (codeRule == null ? "" : codeRule.getPkValue());
    }

    private DynamicObject getTransactionType(DynamicObject mroorder) {
        return mroorder.getDynamicObject("transactiontype");
    }

    private DynamicObject getProject(DynamicObject order) {
        DynamicObjectCollection orderEntryEntitys = order.getDynamicObjectCollection("treeentryentity");
        if (orderEntryEntitys != null && !orderEntryEntitys.isEmpty()) {
            return ((DynamicObject)orderEntryEntitys.get(0)).getDynamicObject(STR_PROJECT);
        }
        return null;
    }

    private String getSourceBillNumber(DynamicObject order) {
        DynamicObjectCollection orderEntryEntitys = order.getDynamicObjectCollection("treeentryentity");
        if (orderEntryEntitys != null && !orderEntryEntitys.isEmpty()) {
            return ((DynamicObject)orderEntryEntitys.get(0)).getString("sourcebillnumber");
        }
        return null;
    }
}

