/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.botp;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.utils.UnitPrecisionUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrderToReworkConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(OrderToReworkConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("pid");
        e.addSrcField("treeentryentity.id");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey("treeentryentity");
        Map fldProperties = e.getFldProperties();
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            String pid;
            Object pidValue;
            DynamicObject targetOrderEntry = billDataEntity.getDataEntity();
            Object targetSrcEntryid = targetOrderEntry.getPkValue();
            if (targetSrcEntryid == null || StringUtils.equals((CharSequence)"0", (CharSequence)targetSrcEntryid.toString())) {
                Long newId = this.getLongId(targetOrderEntry);
                targetOrderEntry.set("id", (Object)newId);
            }
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject srcEntry = (DynamicObject)srcRows.get(0);
            DynamicProperty pidProperty = (DynamicProperty)fldProperties.get("pid");
            if (pidProperty == null || (pidValue = pidProperty.getValue((Object)srcEntry)) == null || StringUtils.equals((CharSequence)"0", (CharSequence)(pid = pidValue.toString()))) continue;
            this.loopChild(billDataEntitys, targetOrderEntry, pidProperty, pid);
        }
    }

    private Long getLongId(DynamicObject targetOrderEntry) {
        if (targetOrderEntry == null) {
            return 0L;
        }
        Long newId = ORM.create().genLongId(targetOrderEntry.getDataEntityType());
        return newId;
    }

    private void loopChild(ExtendedDataEntity[] billDataEntitys, DynamicObject targetOrderEntry, DynamicProperty pidProperty, String pid) {
        for (ExtendedDataEntity billDataEntityLoop : billDataEntitys) {
            String pidloop;
            List srcRowsChild = (List)billDataEntityLoop.getValue("ConvertSource");
            DynamicObject srcEntry = (DynamicObject)srcRowsChild.get(0);
            DynamicObject targetOrderEntryLoop = billDataEntityLoop.getDataEntity();
            Object entryidObj = targetOrderEntryLoop.get("srcorderentryid");
            String srcEntryid = "0";
            if (entryidObj == null) continue;
            srcEntryid = entryidObj.toString();
            Object pidValueLoop = pidProperty.getValue((Object)srcEntry);
            if (pidValueLoop == null || StringUtils.equals((CharSequence)pid, (CharSequence)(pidloop = pidValueLoop.toString())) || !StringUtils.equals((CharSequence)srcEntryid, (CharSequence)pid)) continue;
            targetOrderEntry.set("pid", targetOrderEntryLoop.getPkValue());
            break;
        }
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        boolean isPass = true;
        List selectedRows = e.getSelectedRows();
        Set primaryKeys = selectedRows.stream().map(k -> k.getPrimaryKeyValue()).collect(Collectors.toSet());
        Set entryPrimaryKeys = selectedRows.stream().map(k -> k.getEntryPrimaryKeyValue()).collect(Collectors.toSet());
        HashSet<Object> mainTypeEntryid = new HashSet<Object>(entryPrimaryKeys.size());
        HashSet<Object> otherTypeEntryid = new HashSet<Object>(entryPrimaryKeys.size());
        QFilter filter = new QFilter("id", "in", primaryKeys);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pom_mftorder", (String)"id,billno,treeentryentity.id,treeentryentity.producttype,treeentryentity.pid", (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                String producttype;
                Object entryid = row.get("treeentryentity.id");
                Object pid = row.get("treeentryentity.pid");
                if (!entryPrimaryKeys.contains(entryid)) continue;
                String string = producttype = row.get("treeentryentity.producttype") == null ? "" : row.getString("treeentryentity.producttype");
                if (StringUtils.equals((CharSequence)"C", (CharSequence)producttype)) {
                    mainTypeEntryid.add(entryid);
                    continue;
                }
                otherTypeEntryid.add(pid);
            }
            for (Object e2 : otherTypeEntryid) {
                if (mainTypeEntryid.contains(e2)) continue;
                isPass = false;
            }
        }
        if (!isPass) {
            logger.info("OrderToReworkConvertPlugin.beforeBuildRowCondition:\u4e0b\u63a8\u8fd4\u5de5\u5fc5\u9009\u4e3b\u4ea7\u54c1");
            e.setCustFilterDesc(ResManager.loadKDString((String)" \u4e0b\u63a8\u8fd4\u5de5\u5fc5\u9009\u4e3b\u4ea7\u54c1 ", (String)"OrderToReworkConvertPlugin_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            e.setCustFilterExpression(" treeentryentity.producttype = 'C' ");
            QFilter qFilter = new QFilter(" treeentryentity.producttype", "=", (Object)"C");
            e.getCustQFilters().add(qFilter);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactproduct", (Long)OrgUnitServiceHelper.getRootOrgId());
        QFilter filter = new QFilter("number", "=", (Object)"MTR-0002");
        DynamicObject defaltTrans = TransactionTypeQueryHelper.getSingleDataCacheByQFilter((QFilter[])new QFilter[]{filter, baseDataFilter});
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(tgtMainType);
        HashMap<Long, Set<Long>> materialOrgMap = new HashMap<Long, Set<Long>>(billDataEntitys.length);
        for (ExtendedDataEntity extendedDataEntity : billDataEntitys) {
            DynamicObject reworkOrderBill = extendedDataEntity.getDataEntity();
            reworkOrderBill.set("transactiontype", (Object)defaltTrans);
            DynamicObject org = reworkOrderBill.getDynamicObject("org");
            long orgid = org.getLong("id");
            DynamicObjectCollection entrys = reworkOrderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entrys) {
                DynamicObject mftmaterial = entry.getDynamicObject("material");
                if (mftmaterial == null) continue;
                materialOrgMap.computeIfAbsent(orgid, k -> new HashSet(16)).add(mftmaterial.getLong("id"));
            }
        }
        Map<Long, Map<Object, DynamicObject>> orgMaterialPlanMap = this.getMaterialPlanMap(materialOrgMap);
        this.setEntryValues(billDataEntitys, orgMaterialPlanMap);
    }

    private void setEntryValues(ExtendedDataEntity[] billDataEntitys, Map<Long, Map<Object, DynamicObject>> orgMaterialPlanMap) {
        Calendar calendar = Calendar.getInstance();
        for (ExtendedDataEntity extendedDataEntity : billDataEntitys) {
            DynamicObject reworkOrderBill = extendedDataEntity.getDataEntity();
            DynamicObject org = reworkOrderBill.getDynamicObject("org");
            long orgid = org.getLong("id");
            Map<Object, DynamicObject> materialPlanSet = orgMaterialPlanMap.get(orgid);
            DynamicObjectCollection entrys = reworkOrderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entrys) {
                DynamicObject mftmaterial = entry.getDynamicObject("material");
                if (mftmaterial == null) continue;
                DynamicObject materialPlan = materialPlanSet.get(mftmaterial.getPkValue());
                BigDecimal qty = entry.getBigDecimal("qty") == null ? BigDecimal.ZERO : entry.getBigDecimal("qty");
                DynamicObject material = mftmaterial.getDynamicObject("masterid");
                DynamicObject unit = entry.getDynamicObject("unit");
                DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                DynamicObject auxptyunit = entry.getDynamicObject("auxptyunit");
                BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                BigDecimal highlimit = entry.getBigDecimal("rcvinhighlimit");
                BigDecimal inwarmax = baseQty.multiply(BigDecimal.ONE.add(highlimit.divide(BigDecimal.valueOf(100L), baseUnit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)baseUnit.getString("precisionaccount")))));
                BigDecimal rcvinlowlimit = entry.getBigDecimal("rcvinlowlimit");
                BigDecimal inwarmin = baseQty.multiply(BigDecimal.ONE.subtract(rcvinlowlimit.divide(BigDecimal.valueOf(100L), baseUnit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)baseUnit.getString("precisionaccount")))));
                BigDecimal repmaxrate = entry.getBigDecimal("repmaxrate");
                BigDecimal repmaxqty = qty.multiply(BigDecimal.ONE.add(repmaxrate.divide(BigDecimal.valueOf(100L), unit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)unit.getString("precisionaccount")))));
                BigDecimal repminrate = entry.getBigDecimal("repminrate");
                BigDecimal repminqty = qty.multiply(BigDecimal.ONE.subtract(repminrate.divide(BigDecimal.valueOf(100L), unit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)unit.getString("precisionaccount")))));
                BigDecimal estscrapqty = OrderToReworkConvertPlugin.calEstscrapqty(entry, materialPlan);
                entry.set("baseqty", (Object)baseQty);
                entry.set("estscrapqty", (Object)estscrapqty);
                entry.set("inwarmax", (Object)inwarmax);
                entry.set("inwarmin", (Object)inwarmin);
                entry.set("repmaxqty", (Object)repmaxqty);
                entry.set("repminqty", (Object)repminqty);
                entry.set("planqty", (Object)qty);
                entry.set("planbaseqty", (Object)baseQty);
                BigDecimal auxptyqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)auxptyunit);
                entry.set("auxptyqty", (Object)auxptyqty);
                Date enddate = this.getPlanEndDate(calendar, materialPlan, entry);
                entry.set("planendtime", (Object)enddate);
            }
        }
    }

    public static BigDecimal calEstscrapqty(DynamicObject mftOrderEntry, DynamicObject planinfo) {
        BigDecimal estscrapqty = BigDecimal.ZERO;
        if (null != mftOrderEntry) {
            BigDecimal yield = mftOrderEntry.getBigDecimal("yieldrate");
            BigDecimal qty = mftOrderEntry.getBigDecimal("qty");
            DynamicObject bom = mftOrderEntry.getDynamicObject("bomid");
            if (BigDecimal.ZERO.compareTo(yield) < 0) {
                estscrapqty = qty.multiply(BigDecimal.valueOf(1L).subtract(yield));
            } else if (null == bom) {
                if (planinfo != null) {
                    BigDecimal yieldrate = planinfo.getBigDecimal("yield");
                    estscrapqty = qty.multiply(BigDecimal.valueOf(1L).subtract(new BigDecimal(yieldrate.toString())));
                }
            } else {
                BigDecimal yieldrate = bom.getBigDecimal("yieldrate");
                estscrapqty = qty.multiply(BigDecimal.valueOf(1L).subtract(yieldrate));
            }
        }
        return estscrapqty;
    }

    private Date getPlanEndDate(Calendar calendar, DynamicObject materialPlan, DynamicObject entry) {
        if (entry == null) {
            return calendar.getTime();
        }
        Date planBeginTime = entry.get("planbegintime") == null ? new Date() : entry.getDate("planbegintime");
        Date enddate = null;
        calendar.setTime(planBeginTime);
        if (materialPlan != null) {
            String leadtimetype = materialPlan.getString("leadtimetype");
            int fixedleadtime = materialPlan.getInt("fixedleadtime");
            int changeleadtime = materialPlan.getInt("changeleadtime");
            int preprocessingtime = materialPlan.getInt("preprocessingtime");
            int postprocessingtime = materialPlan.getInt("postprocessingtime");
            int changebatch = materialPlan.getInt("changebatch");
            if ("A".equals(leadtimetype)) {
                calendar.add(5, fixedleadtime);
            } else if ("B".equals(leadtimetype)) {
                BigDecimal qty = entry.getBigDecimal("baseqty") == null ? BigDecimal.ZERO : entry.getBigDecimal("baseqty");
                BigDecimal decChangebatch = new BigDecimal(changebatch);
                BigDecimal decChangeleadtime = new BigDecimal(changeleadtime);
                if (changebatch != 0) {
                    BigDecimal result = qty.multiply(decChangeleadtime).divide(decChangebatch, 0, 0);
                    calendar.add(5, result.intValue());
                }
            }
            calendar.add(5, preprocessingtime);
            calendar.add(5, postprocessingtime);
            enddate = calendar.getTime();
        } else {
            enddate = calendar.getTime();
        }
        return enddate;
    }

    private Map<Long, Map<Object, DynamicObject>> getMaterialPlanMap(Map<Long, Set<Long>> materialOrgMap) {
        if (materialOrgMap == null || materialOrgMap.isEmpty()) {
            return new HashMap<Long, Map<Object, DynamicObject>>(16);
        }
        HashMap<Long, Map<Object, DynamicObject>> orgMaterialPlanMap = new HashMap<Long, Map<Object, DynamicObject>>(materialOrgMap.size());
        for (Map.Entry<Long, Set<Long>> materialOrgMapEntry : materialOrgMap.entrySet()) {
            Set<Long> materialIds = materialOrgMapEntry.getValue();
            Long orgId = materialOrgMapEntry.getKey();
            Map materialPlanSet = MaterialPlanQueryHelper.getDataCacheByMaterialSet(materialIds, (Long)orgId);
            orgMaterialPlanMap.put(orgId, materialPlanSet);
        }
        return orgMaterialPlanMap;
    }
}

