/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.manufacturemodel;

import java.util.HashSet;
import kd.bd.mpdm.common.mftorder.enums.ManuBillProductTypeEnum;
import kd.bd.mpdm.common.mftorder.utils.JsonUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class MftOrderGenChildOrder
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(MftOrderGenChildOrder.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("treeentryentity");
        e.getFieldKeys().add("bizstatus");
        e.getFieldKeys().add("transactiontype");
        e.getFieldKeys().add("treeentryentity.seq");
        e.getFieldKeys().add("producttype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MftOrderGenChildOrderValidator());
    }

    private static class MftOrderGenChildOrderValidator
    extends AbstractValidator {
        private MftOrderGenChildOrderValidator() {
        }

        public void validate() {
            String billSelectRowList = this.getOption().getVariableValue("billSelectRowList");
            HashSet entryIds = new HashSet(JsonUtils.jsonToList((String)billSelectRowList));
            HashSet<Long> passIds = new HashSet<Long>(16);
            HashSet<Long> otherIds = new HashSet<Long>(16);
            for (ExtendedDataEntity extend : this.dataEntities) {
                DynamicObject order = extend.getDataEntity();
                DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject orderEntry : orderEntrys) {
                    String producttype = orderEntry.getString("producttype");
                    long orderEntryid = orderEntry.getLong("id");
                    if (!entryIds.contains(orderEntryid)) continue;
                    if (StringUtils.equals((CharSequence)ManuBillProductTypeEnum.MAIN.getValue(), (CharSequence)producttype)) {
                        passIds.add(orderEntryid);
                        Object seq = orderEntry.get("seq");
                        String bizstatus = orderEntry.getString("bizstatus");
                        if (StringUtils.equals((CharSequence)"B", (CharSequence)bizstatus)) {
                            this.addErrorMessage(extend, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u5df2\u6302\u8d77\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4e0b\u7ea7\u5de5\u5355\u3002", (String)"MftOrderGenChildOrder_2", (String)"mmc-pom-opplugin", (Object[])new Object[0]), seq));
                            continue;
                        }
                        if (!StringUtils.equals((CharSequence)"C", (CharSequence)bizstatus)) continue;
                        this.addErrorMessage(extend, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4e0b\u7ea7\u5de5\u5355\u3002", (String)"MftOrderGenChildOrder_3", (String)"mmc-pom-opplugin", (Object[])new Object[0]), seq));
                        continue;
                    }
                    otherIds.add(orderEntryid);
                }
            }
            if (passIds.size() > 1) {
                for (ExtendedDataEntity extend : this.dataEntities) {
                    this.addErrorMessage(extend, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u751f\u6210\u4e0b\u7ea7\u5de5\u5355\u3002", (String)"MftOrderGenChildOrder_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
                }
                passIds.clear();
            }
            if (passIds.isEmpty() && !otherIds.isEmpty()) {
                for (ExtendedDataEntity extend : this.dataEntities) {
                    this.addErrorMessage(extend, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u751f\u4ea7\u5de5\u5355\u8054\u526f\u4ea7\u54c1\u751f\u6210\u4e0b\u7ea7\u5de5\u5355\u3002", (String)"MftOrderGenChildOrder_1", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
                }
            }
            String jsonString = SerializationUtils.toJsonString(passIds);
            this.getOption().setVariableValue("passId", jsonString);
        }
    }
}

