/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.manufacturemodel.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class StockUnAuditOnAddVal
extends AbstractValidator {
    public void validate() {
        String mftorder = this.getOption().getVariableValue("manuorder", "");
        if ("".equals(mftorder)) {
            mftorder = EntityNameUtils.getEntityName((int)1, (int)0, (String)this.getEntityKey());
        }
        HashSet<Object> orderEntryPks = new HashSet<Object>(16);
        HashMap<Object, ExtendedDataEntity> orderEntryStockMap = new HashMap<Object, ExtendedDataEntity>(this.getDataEntities().length);
        HashSet<Object> purOrderEntryPks = new HashSet<Object>(16);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject manufactureStock = rowDataEntity.getDataEntity();
            DynamicObject transactiontype = manufactureStock.getDynamicObject("transactiontypeid");
            if (transactiontype == null) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7684\u5de5\u5355\u3002", (String)"StockUnAuditOnAddVal_14", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject orderEntry = (DynamicObject)manufactureStock.get("orderentryid");
            if (!"pm_om_purorderbill".equals(mftorder)) {
                if (orderEntry == null) continue;
                orderEntryPks.add(orderEntry.getPkValue());
                orderEntryStockMap.put(orderEntry.getPkValue(), rowDataEntity);
                continue;
            }
            if (orderEntry == null) continue;
            purOrderEntryPks.add(orderEntry.getPkValue());
            orderEntryStockMap.put(orderEntry.getPkValue(), rowDataEntity);
        }
        if (!orderEntryPks.isEmpty()) {
            String selectFields = "billno,treeentryentity.id entryID,treeentryentity.bizstatus bizstatus ,treeentryentity.planstatus planstatus";
            QFilter closestatus = new QFilter("treeentryentity.id", "in", orderEntryPks);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-pom-StockUnAuditOnAddVal", (String)mftorder, (String)selectFields, (QFilter[])new QFilter[]{closestatus}, (String)"");){
                while (ds.hasNext()) {
                    Row arow = ds.next();
                    String bizstatus = arow.get("bizstatus") == null ? "" : arow.getString("bizstatus");
                    ExtendedDataEntity rowDataEntity = (ExtendedDataEntity)orderEntryStockMap.get(arow.get("entryID"));
                    if (rowDataEntity == null) continue;
                    DynamicObject manufactureStock = rowDataEntity.getDataEntity();
                    DynamicObject orderEntry = (DynamicObject)manufactureStock.get("orderentryid");
                    String indexseq = "1";
                    if (orderEntry != null && orderEntry.containsProperty("entryseq")) {
                        String string = indexseq = orderEntry.get("entryseq") == null ? "1" : String.valueOf(orderEntry.get("entryseq"));
                    }
                    if (StringUtils.equals((CharSequence)"A", (CharSequence)bizstatus)) continue;
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff1b\u884c\u53f7\uff1a%2$s\uff09\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u201c\u6b63\u5e38\u201d\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"StockUnAuditOnAddVal_15", (String)"mmc-pom-opplugin", (Object[])new Object[0]), arow.getString("billno"), indexseq));
                }
            }
        }
        this.validPurOrderBillStatus(mftorder, purOrderEntryPks, orderEntryStockMap);
    }

    private void validPurOrderBillStatus(String mftorder, Set<Object> orderEntryPks, Map<Object, ExtendedDataEntity> orderEntryStockMap) {
        if (orderEntryPks.isEmpty()) {
            return;
        }
        String selectFields = "billno,billentry.id entryID,billentry.rowclosestatus rowclosestatus ,billentry.rowterminatestatus rowterminatestatus";
        QFilter qf = new QFilter("billentry.id", "in", orderEntryPks);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)mftorder, (String)selectFields, (QFilter[])qf.toArray(), (String)"");){
            while (ds.hasNext()) {
                String rowterminatestatus;
                Row arow = ds.next();
                String rowclosestatus = arow.get("rowclosestatus") == null ? "" : arow.getString("rowclosestatus");
                String string = rowterminatestatus = arow.get("rowterminatestatus") == null ? "" : arow.getString("rowterminatestatus");
                ExtendedDataEntity rowDataEntity = orderEntryStockMap.get(arow.get("entryID"));
                if (rowDataEntity == null || StringUtils.equals((CharSequence)"A", (CharSequence)rowclosestatus) && StringUtils.equals((CharSequence)"A", (CharSequence)rowterminatestatus)) continue;
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u59d4\u5916\u8ba2\u5355\u884c\u5173\u95ed\u6216\u884c\u7ec8\u6b62\u72b6\u6001\u4e0d\u7b49\u4e8e\u6b63\u5e38\u3002", (String)"StockUnAuditOnAddVal_11", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

