/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mftreport.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pom.common.manufacture.utils.MftOrderReportUtils;

public class POMMftorderReptBillValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> mftentryIdSet = new HashSet<Long>(16);
        String operate = this.getOperateKey();
        ArrayList<DynamicObject> mftEntryObjList = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObjectCollection sumentryColls;
            DynamicObject dynObj = this.dataEntities[i].getDataEntity();
            if (!StringUtils.isBlank((CharSequence)dynObj.getString("srctype")) || (sumentryColls = dynObj.getDynamicObjectCollection("sumentry")) == null || sumentryColls.isEmpty()) continue;
            for (DynamicObject sumentryDyObj : sumentryColls) {
                DynamicObject mftEntryObj = null;
                if (sumentryDyObj.containsProperty("manufactureentryid")) {
                    mftEntryObj = sumentryDyObj.getDynamicObject("manufactureentryid");
                }
                if (null == mftEntryObj) {
                    Long mftentryId = sumentryDyObj.getLong("mftentryid");
                    mftentryIdSet.add(mftentryId);
                    continue;
                }
                mftEntryObjList.add(mftEntryObj);
            }
        }
        Map<Long, List<Map<String, Object>>> xmftordersMap = this.getXMftorderMap(mftentryIdSet, mftEntryObjList);
        HashMap<Long, Map<String, Object>> mftordersMap = new HashMap(16);
        if ("save".equals(operate)) {
            mftordersMap = this.getMftorderMap(mftentryIdSet, mftEntryObjList);
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObjectCollection sumentryColls;
            String operateName = ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"POMMftorderReptBillValidator_7", (String)"mmc-pom-opplugin", (Object[])new Object[0]);
            DynamicObject dynObj = this.dataEntities[i].getDataEntity();
            if (!StringUtils.isBlank((CharSequence)dynObj.getString("srctype")) || (sumentryColls = dynObj.getDynamicObjectCollection("sumentry")) == null || sumentryColls.isEmpty()) continue;
            if ("save".equals(operate)) {
                this.checkMftOrderEntry(i, sumentryColls, mftordersMap);
            }
            block17: for (int j = 0; j < sumentryColls.getRowCount(); ++j) {
                DynamicObject sumentry = (DynamicObject)sumentryColls.get(j);
                DynamicObjectCollection subentrys = null;
                int row = sumentry.getInt("seq");
                switch (operate) {
                    case "save": {
                        this.checkQualityorgFilled(i, row, sumentry);
                        this.validateReportQty(i, row, sumentry);
                        operateName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"POMMftorderReptBillValidator_8", (String)"mmc-pom-opplugin", (Object[])new Object[0]);
                        this.checkAllXMftOrderAudited(i, row, sumentry, operateName, xmftordersMap);
                        subentrys = sumentry.getDynamicObjectCollection("subentryentity");
                        this.checkSubEntry(i, row, subentrys);
                        continue block17;
                    }
                    case "delete": {
                        operateName = ResManager.loadKDString((String)"\u5220\u9664", (String)"POMMftorderReptBillValidator_9", (String)"mmc-pom-opplugin", (Object[])new Object[0]);
                        this.checkAllXMftOrderAudited(i, row, sumentry, operateName, xmftordersMap);
                        continue block17;
                    }
                    case "submit": {
                        this.checkQualityorgFilled(i, row, sumentry);
                        this.validateReportQty(i, row, sumentry);
                        operateName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"POMMftorderReptBillValidator_10", (String)"mmc-pom-opplugin", (Object[])new Object[0]);
                        this.checkAllXMftOrderAudited(i, row, sumentry, operateName, xmftordersMap);
                        subentrys = sumentry.getDynamicObjectCollection("subentryentity");
                        this.checkSubEntry(i, row, subentrys);
                        continue block17;
                    }
                    case "audit": {
                        this.checkQualityorgFilled(i, row, sumentry);
                        this.validateReportQty(i, row, sumentry);
                        operateName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"POMMftorderReptBillValidator_11", (String)"mmc-pom-opplugin", (Object[])new Object[0]);
                        this.checkAllXMftOrderAudited(i, row, sumentry, operateName, xmftordersMap);
                        continue block17;
                    }
                    case "unaudit": {
                        operateName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"POMMftorderReptBillValidator_12", (String)"mmc-pom-opplugin", (Object[])new Object[0]);
                        this.checkAllXMftOrderAudited(i, row, sumentry, operateName, xmftordersMap);
                        continue block17;
                    }
                }
            }
        }
    }

    private void checkSubEntry(int i, int row, DynamicObjectCollection subentrys) {
        if (null != subentrys && !subentrys.isEmpty()) {
            for (int k = 0; k < subentrys.getRowCount(); ++k) {
                DynamicObject subentry = (DynamicObject)subentrys.get(k);
                int subRow = subentry.getInt("seq");
                this.checkRepactualTime(i, row, subRow, subentry);
            }
        }
    }

    private void checkRepactualTime(int i, int row, int subRow, DynamicObject subentryentity) {
        Date repactualbegintime = subentryentity.getDate("repactualbegintime");
        Date repactualfinishtime = subentryentity.getDate("repactualfinishtime");
        if (null != repactualbegintime && null != repactualfinishtime && repactualbegintime.after(repactualfinishtime)) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u6c47\u603b\u5206\u5f55\u7b2c%1$s\u884c\u7684\u6d3b\u52a8\u5217\u8868\u7b2c%2$s\u884c\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4\u5c0f\u4e8e\u7b49\u4e8e\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4\u3002", (String)"POMMftorderReptBillValidator_16", (String)"mmc-pom-opplugin", (Object[])new Object[0]), row, subRow));
        }
    }

    private void checkQualityorgFilled(int i, int row, DynamicObject sumentryDyObj) {
        boolean ischeckmaterial = sumentryDyObj.getBoolean("ischeckmaterial");
        DynamicObject qualityorg = sumentryDyObj.getDynamicObject("qualityorg");
        if (ischeckmaterial && null == qualityorg) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u660e\u7ec6\u5206\u5f55\u7684\u201c\u8d28\u68c0\u7ec4\u7ec7\u201d\u3002", (String)"POMMftorderReptBillValidator_13", (String)"mmc-pom-opplugin", (Object[])new Object[0]), row));
        }
    }

    private void checkAllXMftOrderAudited(int i, int row, DynamicObject sumentryDyObj, String key, Map<Long, List<Map<String, Object>>> xmftordersMap) {
        String mftentryid = sumentryDyObj.getString("mftentryid");
        if (mftentryid == null || "".equals(mftentryid)) {
            return;
        }
        List<Map<String, Object>> xmftOrderList = xmftordersMap.get(Long.parseLong(mftentryid));
        if (xmftOrderList == null || xmftOrderList.isEmpty()) {
            return;
        }
        for (int k = 0; k < xmftOrderList.size(); ++k) {
            Map<String, Object> xmap = xmftOrderList.get(k);
            String xmftBillStatus = (String)xmap.get("billstatus");
            Long orgId = (Long)xmap.get("org");
            Map pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap((Long)orgId, (String)"pom_mftorderreport");
            Boolean isMftOrderCtrlBusExe = (Boolean)pmAppParameterMap.get("ismftorderctrlbusexe");
            if (!isMftOrderCtrlBusExe.booleanValue() || StringUtils.equals((CharSequence)"C", (CharSequence)xmftBillStatus)) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5355\u6c47\u62a5\u5355\u7b2c%1$s\u5206\u5f55\u5bf9\u5e94\u7684\u751f\u4ea7\u5de5\u5355\u5206\u5f55\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5de5\u5355\u53d8\u66f4\u5355\uff0c%2$s\u5931\u8d25\u3002", (String)"POMMftorderReptBillValidator_17", (String)"mmc-pom-opplugin", (Object[])new Object[0]), row, key));
        }
    }

    private void validateReportQty(int i, int j, DynamicObject sumentryDyObj) {
        boolean ischeckmaterial = sumentryDyObj.getBoolean("ischeckmaterial");
        if (ischeckmaterial) {
            return;
        }
        BigDecimal completqty = sumentryDyObj.getBigDecimal("completqty");
        BigDecimal qualifyqty = sumentryDyObj.getBigDecimal("qualifyqty");
        BigDecimal concesionqty = sumentryDyObj.getBigDecimal("concesionqty");
        BigDecimal scrappedqty = sumentryDyObj.getBigDecimal("scrappedqty");
        BigDecimal repairqty = sumentryDyObj.getBigDecimal("repairqty");
        BigDecimal reworkqty = sumentryDyObj.getBigDecimal("reworkqty");
        if (completqty.compareTo(qualifyqty.add(concesionqty).add(scrappedqty).add(repairqty).add(reworkqty)) != 0) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u4e3a\u975e\u4ea7\u54c1\u68c0\u9a8c\u7684\u7269\u6599\uff0c\u201c\u6c47\u62a5\u6570\u91cf\u201d\u987b\u6ee1\u8db3\u6761\u4ef6\uff1a\u6c47\u62a5\u6570\u91cf=\u5408\u683c\u6570\u91cf+\u8ba9\u6b65\u63a5\u6536\u6570\u91cf+\u62a5\u5e9f\u6570\u91cf+\u8fd4\u4fee\u6570\u91cf+\u8fd4\u5de5\u6570\u91cf\u3002", (String)"POMMftorderReptBillValidator_6", (String)"mmc-pom-opplugin", (Object[])new Object[0]), j));
        }
    }

    private void checkMftOrderEntry(int i, DynamicObjectCollection sumentryColls, Map<Long, Map<String, Object>> mftordersMap) {
        for (DynamicObject sumentryDyObj : sumentryColls) {
            Long mftentryId;
            Map<String, Object> orderMap;
            DynamicObject mftEntryObj = sumentryDyObj.getDynamicObject("manufactureentryid");
            if (null != mftEntryObj || null != (orderMap = mftordersMap.get(mftentryId = Long.valueOf(sumentryDyObj.getLong("mftentryid")))) && !orderMap.isEmpty()) continue;
            String info = String.format(ResManager.loadKDString((String)"\u5de5\u5355\u6c47\u62a5\u5355\u5bf9\u5e94\u7684\u751f\u4ea7\u5de5\u5355\u7b2c%s\u884c\u4e0d\u5b58\u5728\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"POMMftorderReptBillValidator_18", (String)"mmc-pom-opplugin", (Object[])new Object[0]), sumentryDyObj.getInt("manufacturerow")) + "\n";
            this.addErrorMessage(this.dataEntities[i], info);
            return;
        }
    }

    private Map<Long, Map<String, Object>> getMftorderMap(Set<Long> mftentryIDSet, List<DynamicObject> mftEntryObjList) {
        if (mftentryIDSet.isEmpty() && mftEntryObjList.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<String, Object>> orderMap = new HashMap<Long, Map<String, Object>>(16);
        if (!mftEntryObjList.isEmpty()) {
            for (int i = 0; i < mftEntryObjList.size(); ++i) {
                DynamicObject dy = mftEntryObjList.get(i);
                HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
                dataMap.put("taskstatus", dy.getString("taskstatus"));
                dataMap.put("bizstatus", dy.getString("bizstatus"));
                dataMap.put("entryid", dy.getLong("id"));
                orderMap.put(dy.getLong("id"), dataMap);
            }
        }
        if (!mftentryIDSet.isEmpty()) {
            QFilter qfilter = new QFilter("treeentryentity.id", "in", mftentryIDSet);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-POMMftorderReptBillValidator-getMftorderMap", (String)"pom_mftorder", (String)"treeentryentity.taskstatus taskstatus ,treeentryentity.bizstatus bizstatus,treeentryentity.id mftEntryID", (QFilter[])new QFilter[]{qfilter}, (String)"");){
                while (ds.hasNext()) {
                    Row dsRow = ds.next();
                    HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
                    dataMap.put("taskstatus", dsRow.getString("taskstatus"));
                    dataMap.put("bizstatus", dsRow.getString("bizstatus"));
                    dataMap.put("entryid", dsRow.getLong("mftEntryID"));
                    orderMap.put(dsRow.getLong("mftEntryID"), dataMap);
                }
            }
        }
        return orderMap;
    }

    private Map<Long, List<Map<String, Object>>> getXMftorderMap(Set<Long> mftentryIDSet, List<DynamicObject> mftEntryObjList) {
        if (mftentryIDSet.isEmpty() && mftEntryObjList.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<Map<String, Object>>> xorderMap = new HashMap<Long, List<Map<String, Object>>>(16);
        if (!mftEntryObjList.isEmpty()) {
            for (int i = 0; i < mftEntryObjList.size(); ++i) {
                DynamicObject dy = mftEntryObjList.get(i);
                mftentryIDSet.add(dy.getLong("id"));
            }
        }
        QFilter qfilter = new QFilter("treeentryentity.srcbillentryid", "in", (Object)MftOrderReportUtils.convertLongToStringSet(mftentryIDSet));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-POMMftorderReptBillValidator-getXMftorderMap", (String)"pom_xmftorder", (String)"org,billstatus,id,treeentryentity.srcbillentryid mftEntryID ", (QFilter[])new QFilter[]{qfilter}, (String)"");){
            while (ds.hasNext()) {
                Row dsRow = ds.next();
                Long mftEntryID = dsRow.getLong("mftEntryID");
                ArrayList xorderList = (ArrayList)xorderMap.get(mftEntryID);
                if (xorderList == null) {
                    xorderList = new ArrayList(16);
                }
                HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
                dataMap.put("billstatus", dsRow.getString("billstatus"));
                dataMap.put("id", dsRow.getLong("id"));
                dataMap.put("mftEntryID", mftEntryID);
                dataMap.put("org", dsRow.get("org"));
                xorderList.add(dataMap);
                xorderMap.put(mftEntryID, xorderList);
            }
        }
        return xorderMap;
    }
}

