/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MROOrderAuditOp
extends AbstractOperationServicePlugIn {
    private static final String KEY_ENTITY_DAILYLOG = "sfc_dailyplanlog";
    private static final String KEY_ENTITY_MROORDER = "pom_mroorder";
    private static final String KEY_MROORDERID = "mroorderid";
    private static final String KEY_BILLNO = "billno";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add(KEY_BILLNO);
        e.getFieldKeys().add("org");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if (this.billEntityType == null || !StringUtils.equals((CharSequence)this.billEntityType.getName(), (CharSequence)KEY_ENTITY_MROORDER)) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)"audit", (CharSequence)operationKey)) {
            ArrayList<DynamicObject> dailyplanlogs = new ArrayList<DynamicObject>(dataEntities.length);
            HashSet<Object> orderids = new HashSet<Object>(dataEntities.length);
            for (DynamicObject dynamicObject : dataEntities) {
                orderids.add(dynamicObject.getPkValue());
            }
            DeleteServiceHelper.delete((String)KEY_ENTITY_DAILYLOG, (QFilter[])new QFilter[]{new QFilter(KEY_MROORDERID, "in", orderids)});
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)KEY_ENTITY_DAILYLOG);
            HashMap<String, Integer> orgMap = new HashMap<String, Integer>(16);
            HashSet<String> orgIDSet = new HashSet<String>(16);
            for (DynamicObject dataEntity : dataEntities) {
                String orgId = dataEntity.getDynamicObject("org").getPkValue().toString();
                int count = 0;
                if (orgIDSet.contains(orgId)) {
                    count = (Integer)orgMap.get(orgId);
                }
                orgIDSet.add(orgId);
                orgMap.put(orgId, ++count);
            }
            HashMap hashMap = new HashMap(orgMap.size());
            DynamicObject dailyplanlog = new DynamicObject((DynamicObjectType)dataEntityType);
            for (Map.Entry orgEntry : orgMap.entrySet()) {
                String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)KEY_ENTITY_DAILYLOG, (DynamicObject)dailyplanlog, (String)((String)orgEntry.getKey()), (int)((Integer)orgEntry.getValue()));
                hashMap.put(orgEntry.getKey(), new ArrayList<String>(Arrays.asList(numbers)));
            }
            for (DynamicObject dataEntity : dataEntities) {
                String orgID = dataEntity.getDynamicObject("org").getPkValue().toString();
                List numbers = (List)hashMap.get(orgID);
                String number = null;
                if (numbers != null && numbers.size() > 0) {
                    number = (String)numbers.get(0);
                    numbers.remove(number);
                }
                dailyplanlog = new DynamicObject((DynamicObjectType)dataEntityType);
                if (StringUtils.isEmpty(number)) {
                    dailyplanlog.set(KEY_BILLNO, (Object)("DPL-" + System.currentTimeMillis()));
                } else {
                    dailyplanlog.set(KEY_BILLNO, (Object)number);
                }
                dailyplanlog.set("org", dataEntity.get("org"));
                dailyplanlog.set("mroorderno", dataEntity.get(KEY_BILLNO));
                dailyplanlog.set(KEY_MROORDERID, dataEntity.getPkValue());
                dailyplanlog.set("billstatus", (Object)"A");
                dailyplanlogs.add(dailyplanlog);
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)KEY_ENTITY_DAILYLOG);
            SaveServiceHelper.save((IDataEntityType)mainType, (Object[])dailyplanlogs.toArray());
        }
    }
}

