/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.utils.CalendarUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class MROToolSubmitOnAddVal
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject tool = rowDataEntity.getDataEntity();
            DynamicObject org = tool.getDynamicObject("org");
            DynamicObjectCollection stockEntrys = tool.getDynamicObjectCollection("stockentry");
            if (stockEntrys.isEmpty()) continue;
            this.valLevel(stockEntrys, rowDataEntity);
            this.valSupply(stockEntrys, rowDataEntity);
            this.valQty(stockEntrys, rowDataEntity);
            this.valUseTime(stockEntrys, rowDataEntity, org);
            this.valRepGroup(stockEntrys, rowDataEntity);
        }
    }

    private void valRepGroup(DynamicObjectCollection stockEntrys, ExtendedDataEntity rowDataEntity) {
        HashMap<String, Integer> groupLevelMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < stockEntrys.size(); ++i) {
            DynamicObject stockEntry = (DynamicObject)stockEntrys.get(i);
            DynamicObject master = stockEntry.getDynamicObject("materielmasterid");
            String replaceGroup = stockEntry.getString("entryreplacegroup");
            if ("".equals(replaceGroup) || master == null) continue;
            Integer seq = (Integer)groupLevelMap.get(replaceGroup + master.getPkValue());
            if (seq == null) {
                groupLevelMap.put(replaceGroup + master.getPkValue(), i);
                continue;
            }
            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u201c\u5de5\u5177\u4ef6\u53f7\u201d\u548c\u201c\u66ff\u4ee3\u7ec4\u201d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MROToolSubmitOnAddVal_5", (String)"mmc-pom-opplugin", (Object[])new Object[0]), seq + 1, i + 1));
        }
    }

    private void valUseTime(DynamicObjectCollection stockEntrys, ExtendedDataEntity rowDataEntity, DynamicObject org) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList<Integer> workList = new ArrayList<Integer>();
        ArrayList<Integer> workDateNullList = new ArrayList<Integer>();
        HashMap calendarInfoMap = new HashMap(16);
        for (int i = 0; i < stockEntrys.size(); ++i) {
            DynamicObject stockdym = (DynamicObject)stockEntrys.get(i);
            Date begintime = stockdym.getDate("begintime");
            Date workDate = CalendarUtils.getRecentleWorkDateNew((DynamicObject)org, (Date)begintime, calendarInfoMap);
            if (null == workDate) {
                workDateNullList.add(i + 1);
            } else if (!CalendarUtils.compateDateAccurateDay((Date)begintime, (Date)workDate)) {
                workList.add(i + 1);
            }
            Date endtime = stockdym.getDate("endtime");
            if (endtime.compareTo(begintime) >= 0) continue;
            list.add(i + 1);
        }
        if (!list.isEmpty()) {
            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7ed3\u675f\u4f7f\u7528\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u4f7f\u7528\u65f6\u95f4\u3002", (String)"MROToolSubmitOnAddVal_3", (String)"mmc-pom-opplugin", (Object[])new Object[0]), list.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!workList.isEmpty()) {
            this.addWarningMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5f00\u59cb\u4f7f\u7528\u65f6\u95f4\u4e0d\u5728\u5de5\u4f5c\u65e5\u5185\u3002", (String)"MROToolSubmitOnAddVal_7", (String)"mmc-pom-opplugin", (Object[])new Object[0]), workList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!workDateNullList.isEmpty()) {
            this.addWarningMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u672a\u627e\u5230\u751f\u4ea7\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u751f\u4ea7\u65e5\u5386\u6216\u5f00\u59cb\u4f7f\u7528\u65f6\u95f4\u4e0d\u5728\u65e5\u5386\u8bbe\u7f6e\u4e2d\u65e5\u5386\u7684\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"MROToolSubmitOnAddVal_8", (String)"mmc-pom-opplugin", (Object[])new Object[0]), workDateNullList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
    }

    private void valQty(DynamicObjectCollection stockEntrys, ExtendedDataEntity rowDataEntity) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < stockEntrys.size(); ++i) {
            BigDecimal outqty;
            DynamicObject stockdym = (DynamicObject)stockEntrys.get(i);
            BigDecimal demandqty = stockdym.getBigDecimal("demandqty");
            if (demandqty.compareTo(outqty = stockdym.getBigDecimal("outqty")) >= 0) continue;
            list.add(i + 1);
        }
        if (!list.isEmpty()) {
            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u9700\u6c42\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u4e0b\u63a8\u5de5\u5177\u7533\u8bf7\u57fa\u672c\u6570\u91cf\u3002", (String)"MROToolSubmitOnAddVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]), list.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
    }

    private void valSupply(DynamicObjectCollection stockEntrys, ExtendedDataEntity rowDataEntity) {
        ArrayList<Integer> supplierList = new ArrayList<Integer>();
        for (int i = 0; i < stockEntrys.size(); ++i) {
            DynamicObject stockdym = (DynamicObject)stockEntrys.get(i);
            String supplyfield = (String)stockdym.get("supplymode");
            DynamicObject supply = (DynamicObject)stockdym.get("supplierid");
            if (supply != null || !"bos_org".equals(supplyfield)) continue;
            supplierList.add(i + 1);
        }
        if (!supplierList.isEmpty()) {
            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u8d27\u4e3b\u7c7b\u578b\u4e3a\u4e1a\u52a1\u5355\u5143\uff0c\u8d27\u4e3b\u5fc5\u586b\u3002", (String)"MROToolSubmitOnAddVal_1", (String)"mmc-pom-opplugin", (Object[])new Object[0]), supplierList.stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
    }

    private void valLevel(DynamicObjectCollection stockEntrys, ExtendedDataEntity rowDataEntity) {
        HashMap<String, Integer> groupLevelMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < stockEntrys.size(); ++i) {
            DynamicObject stockEntry = (DynamicObject)stockEntrys.get(i);
            Integer level = stockEntry.getInt("entrylevel");
            String replaceGroup = stockEntry.getString("entryreplacegroup");
            if ("".equals(replaceGroup)) continue;
            Integer seq = (Integer)groupLevelMap.get(replaceGroup + level);
            if (seq == null) {
                groupLevelMap.put(replaceGroup + level, i);
                continue;
            }
            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u201c\u4f18\u5148\u7ea7\u201d\u548c\u201c\u66ff\u4ee3\u7ec4\u201d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MROToolSubmitOnAddVal_2", (String)"mmc-pom-opplugin", (Object[])new Object[0]), seq + 1, i + 1));
        }
    }
}

