/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPlanStatusEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.business.coderule.mro.MROOrderCodeRuleHelper;
import kd.mmc.pom.common.mro.utils.MRONRCUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

public class OrderAuditAfterExeOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OrderAuditAfterExeOp.class);
    private static final String STR_PROJECT = "project";
    private static final String STR_SOURCEBILLNUMBER = "sourceBillNumber";
    private static final String STR_CODERULE = "codeRule";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("orderbillno");
        e.getFieldKeys().add("isshowlist");
        e.getFieldKeys().add("numberautogen");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("transactiontype");
        e.getFieldKeys().add("planstatus");
        e.getFieldKeys().add("plansuretime");
        e.getFieldKeys().add("treeentryentity.baseqty");
        e.getFieldKeys().add("treeentryentity.qty");
        e.getFieldKeys().add("treeentryentity.producedept");
        e.getFieldKeys().add("treeentryentity.sourcebillnumber");
        e.getFieldKeys().add("treeentryentity.plandeptcontrolno");
        e.getFieldKeys().add("treeentryentity.headbillno");
        e.getFieldKeys().add("treeentryentity.project");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.dataEntities = e.getDataEntities();
        this.generateNumber(this.dataEntities);
        SaveServiceHelper.save((DynamicObject[])this.dataEntities);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.dataEntities = e.getDataEntities();
        Date now = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        for (DynamicObject nrMroOrderBill : this.dataEntities) {
            nrMroOrderBill.set("isshowlist", (Object)"1");
            if (null != nrMroOrderBill && StringUtils.isNotBlank((CharSequence)nrMroOrderBill.getString("orderbillno")) || null == nrMroOrderBill || null == nrMroOrderBill.getDynamicObjectCollection("treeentryentity")) continue;
            DynamicObjectCollection cols = nrMroOrderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : cols) {
                entry.set("plandeptcontrolno", (Object)(sf.format(now) + "-" + nrMroOrderBill.get("orderbillno")));
            }
        }
        SaveServiceHelper.save((DynamicObject[])this.dataEntities);
    }

    public void generateNumber(DynamicObject[] dynamicObjects) {
        HashMap<String, ArrayList<DynamicObject>> codeMap = new HashMap<String, ArrayList<DynamicObject>>(16);
        HashMap codeObjectMap = new HashMap(16);
        for (DynamicObject data : dynamicObjects) {
            DynamicObject transactiontype = (DynamicObject)data.get("transactiontype");
            DynamicObject codeRule = this.getCodeRule(transactiontype);
            if (codeRule == null) continue;
            DynamicObject project = MRONRCUtils.getProject((DynamicObject)data);
            String keyString = MRONRCUtils.getKeyString((DynamicObject)project, (DynamicObject)codeRule);
            ArrayList<DynamicObject> rowIndexList = (ArrayList<DynamicObject>)codeMap.get(keyString);
            if (rowIndexList == null) {
                rowIndexList = new ArrayList<DynamicObject>(16);
            }
            rowIndexList.add(data);
            codeMap.put(keyString, rowIndexList);
            HashMap<String, Object> codeObject = (HashMap<String, Object>)codeObjectMap.get(keyString);
            if (codeObject != null) continue;
            codeObject = new HashMap<String, Object>(16);
            codeObject.put(STR_PROJECT, project);
            codeObject.put(STR_SOURCEBILLNUMBER, "");
            codeObject.put(STR_CODERULE, codeRule);
            codeObjectMap.put(keyString, codeObject);
        }
        for (Map.Entry entry : codeMap.entrySet()) {
            String sourceBillNumber;
            String keyString = (String)entry.getKey();
            List rowIndexList = (List)entry.getValue();
            if (rowIndexList.isEmpty()) continue;
            Map codeObject = (Map)codeObjectMap.get(keyString);
            DynamicObject project = codeObject.get(STR_PROJECT) == null ? null : (DynamicObject)codeObject.get(STR_PROJECT);
            DynamicObject codeRule = codeObject.get(STR_CODERULE) == null ? null : (DynamicObject)codeObject.get(STR_CODERULE);
            List codeList = MROOrderCodeRuleHelper.genCodeRuleNumbersByImmediately((DynamicObject)codeRule, (DynamicObject)project, (String)(sourceBillNumber = codeObject.get(STR_SOURCEBILLNUMBER) == null ? null : (String)codeObject.get(STR_SOURCEBILLNUMBER)), (int)rowIndexList.size());
            int codeSize = codeList.size();
            if (codeSize <= 0) continue;
            for (int i = 0; i < rowIndexList.size(); ++i) {
                DynamicObject mroOrder = (DynamicObject)rowIndexList.get(i);
                if (codeSize < i + 1) {
                    logger.info("error:codeSize = " + codeSize + ",rowIndexList = " + rowIndexList.size());
                    continue;
                }
                String orderbillno = (String)codeList.get(i);
                mroOrder.set("orderbillno", (Object)orderbillno);
                mroOrder.set("numberautogen", (Object)true);
                DynamicObjectCollection entrys = mroOrder.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject entry2 : entrys) {
                    entry2.set("headbillno", (Object)orderbillno);
                }
            }
        }
    }

    private DynamicObject getCodeRule(DynamicObject transactionType) {
        if (transactionType == null) {
            return null;
        }
        return MROOrderCodeRuleHelper.getTransactionTypeCodeMode((Long)transactionType.getLong("id"));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Map<Object, DynamicObject> orders = this.loadMtfOrders(e.getDataEntities());
        HashSet<Object> transactionTypeIds = new HashSet<Object>(16);
        Date date = new Date();
        for (DynamicObject order : orders.values()) {
            if (order.getDynamicObject("transactiontype") != null) {
                transactionTypeIds.add(order.getDynamicObject("transactiontype").getPkValue());
            }
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entry = (DynamicObject)entryCol.get(j);
                entry.set("planstatus", (Object)ManuBillPlanStatusEnum.PLANSURE.getValue());
                entry.set("plansuretime", (Object)date);
            }
        }
    }

    private Map<Object, DynamicObject> loadMtfOrders(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return new HashedMap(0);
        }
        HashedMap orders = new HashedMap(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            orders.put(dataEntity.getPkValue(), dataEntity);
        }
        return orders;
    }
}

