/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPlanStatusEnum;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.map.HashedMap;

public class OrderAuditStockAndTechExeOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OrderAuditStockAndTechExeOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("orderbillno");
        e.getFieldKeys().add("isshowlist");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("transactiontype");
        e.getFieldKeys().add("planstatus");
        e.getFieldKeys().add("plansuretime");
        e.getFieldKeys().add("treeentryentity.baseqty");
        e.getFieldKeys().add("treeentryentity.qty");
        e.getFieldKeys().add("treeentryentity.producedept");
        e.getFieldKeys().add("treeentryentity.sourcebillnumber");
        e.getFieldKeys().add("treeentryentity.plandeptcontrolno");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        Map<Object, DynamicObject> orders = this.loadMtfOrders(e.getDataEntities());
        HashSet<Object> transactionTypeIds = new HashSet<Object>(16);
        Date date = new Date();
        for (DynamicObject order : orders.values()) {
            if (order.getDynamicObject("transactiontype") != null) {
                transactionTypeIds.add(order.getDynamicObject("transactiontype").getPkValue());
            }
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entry = (DynamicObject)entryCol.get(j);
                entry.set("planstatus", (Object)ManuBillPlanStatusEnum.PLANSURE.getValue());
                entry.set("plansuretime", (Object)date);
            }
        }
        Map transactionTypeMap = TransactionTypeQueryHelper.getDataCacheBySet(transactionTypeIds);
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        long auditStockBegin = System.currentTimeMillis();
        this.auditStock(orders, successObjs, transactionTypeMap);
        long auditStockEnd = System.currentTimeMillis();
        logger.info("auditStock cost time:" + (auditStockEnd - auditStockBegin));
        if (successObjs.size() > 0) {
            ArrayList<DynamicObject> success;
            Map<Object, DynamicObject> order = this.loadMtfOrders(successObjs.toArray(new DynamicObject[0]));
            Map<Object, String> audittechnis = this.audittechnis(order, success = new ArrayList<DynamicObject>(), transactionTypeMap);
            if (MapUtils.isNotEmpty(audittechnis)) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ishasright", "true");
                operateOption.setVariableValue("ignorewarn", "true");
                operateOption.setVariableValue("ignoreinteraction", "true");
                operateOption.setVariableValue("orderBillType", "pom_mftorder");
                operateOption.setVariableValue("stockBillType", "pom_mrostock");
                Map<Object, Object> objectObjectMap = this.buildUnauditData(order, transactionTypeMap);
                String stockname = "pom_mrostock";
                OperationServiceHelper.executeOperate((String)"unaudit", (String)stockname, (Object[])objectObjectMap.keySet().toArray(), (OperateOption)operateOption);
            }
            e.setDataEntities(success.toArray(new DynamicObject[success.size()]));
        } else {
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
        }
    }

    private Map<Object, DynamicObject> loadMtfOrders(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return new HashedMap(0);
        }
        HashedMap orders = new HashedMap(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            orders.put(dataEntity.getPkValue(), dataEntity);
        }
        return orders;
    }

    private void auditStock(Map<Object, DynamicObject> orders, List<DynamicObject> successObjs, Map<Object, DynamicObject> transactionTypeMap) {
        Object orderEntryId;
        Object stockId;
        Object orderEntryId2;
        HashedMap orderEntryIdtoBillIds = new HashedMap(orders.size());
        for (DynamicObject order : orders.values()) {
            boolean isAuditStock;
            DynamicObject transactiontype = order.getDynamicObject("transactiontype");
            if (!transactiontype.getDataEntityType().getProperties().containsKey((Object)"isauditstock")) {
                transactiontype = transactionTypeMap.get(transactiontype.getPkValue());
            }
            if (!(isAuditStock = transactiontype.getBoolean("isauditstock"))) continue;
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject col : entryCol) {
                orderEntryId2 = col.getPkValue();
                orderEntryIdtoBillIds.put(orderEntryId2, order.getPkValue());
            }
        }
        if (orderEntryIdtoBillIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return;
        }
        HashedMap submitStockIdtoOrderEntryIds = new HashedMap(orders.size());
        HashedMap auditStockIdtoOrderEntryIds = new HashedMap(orders.size());
        HashedMap failOrderEntryIds = new HashedMap(orders.size());
        HashSet<Object> auditStockId = new HashSet<Object>(orders.size());
        String stockname = "pom_mrostock";
        QFilter stockqfilter = new QFilter("orderentryid", "in", (Object)orderEntryIdtoBillIds.keySet().toArray());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"OrdereAuditAfterExeOp.auditStock", (String)stockname, (String)"id,billstatus,orderentryid", (QFilter[])new QFilter[]{stockqfilter}, (String)"");
        orderEntryId2 = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                Object stockId2 = row.get("id");
                Object orderEntryId3 = row.get("orderentryid");
                if ("A".equals(row.get("billstatus"))) {
                    submitStockIdtoOrderEntryIds.put(stockId2, orderEntryId3);
                    continue;
                }
                if (!"B".equals(row.get("billstatus"))) continue;
                auditStockIdtoOrderEntryIds.put(stockId2, orderEntryId3);
                auditStockId.add(stockId2);
            }
        }
        catch (Throwable row) {
            orderEntryId2 = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (orderEntryId2 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)orderEntryId2).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (submitStockIdtoOrderEntryIds.isEmpty() && auditStockIdtoOrderEntryIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("orderBillType", "pom_mftorder");
        option.setVariableValue("stockBillType", "pom_mrostock");
        if (!submitStockIdtoOrderEntryIds.isEmpty()) {
            long stockSubmitStart = System.currentTimeMillis();
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)stockname, (Object[])submitStockIdtoOrderEntryIds.keySet().toArray(), (OperateOption)option);
            long stockSubmitEnd = System.currentTimeMillis();
            logger.info("stock Submit cost time:" + (stockSubmitEnd - stockSubmitStart) + ";IdsSize:" + submitStockIdtoOrderEntryIds.size());
            HashSet submitSuccessIds = new HashSet(submitResult.getSuccessPkIds());
            if (submitSuccessIds.isEmpty()) {
                this.setFailMes(submitResult, (Map<Object, Object>)submitStockIdtoOrderEntryIds, (Map<Object, String>)failOrderEntryIds);
            } else {
                auditStockId.addAll(submitSuccessIds);
                for (Map.Entry stockIdtoOrderEntryId : submitStockIdtoOrderEntryIds.entrySet()) {
                    stockId = stockIdtoOrderEntryId.getKey();
                    orderEntryId = stockIdtoOrderEntryId.getValue();
                    if (!submitSuccessIds.contains(stockId)) {
                        failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(stockId, submitResult));
                        continue;
                    }
                    auditStockIdtoOrderEntryIds.put(stockId, orderEntryId);
                }
            }
        }
        if (!auditStockId.isEmpty()) {
            option.setVariableValue("autoaudit", "1");
            long stockAuditStart = System.currentTimeMillis();
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)stockname, (Object[])auditStockId.toArray(), (OperateOption)option);
            long stockAuditEnd = System.currentTimeMillis();
            logger.info("stock audit cost time:" + (stockAuditEnd - stockAuditStart) + ";IdsSize:" + auditStockId.size());
            HashSet auditSuccessIds = new HashSet(auditResult.getSuccessPkIds());
            for (Map.Entry stockIdtoOrderEntryId : auditStockIdtoOrderEntryIds.entrySet()) {
                stockId = stockIdtoOrderEntryId.getKey();
                orderEntryId = stockIdtoOrderEntryId.getValue();
                if (auditSuccessIds.contains(stockId)) continue;
                failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(stockId, auditResult));
            }
        }
        if (!failOrderEntryIds.isEmpty()) {
            for (DynamicObject order : orders.values()) {
                boolean errBoolean = false;
                DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
                for (int i = 1; i <= entryCol.size(); ++i) {
                    Object orderEntryId4 = ((DynamicObject)entryCol.get(i - 1)).getPkValue();
                    String ids = (String)failOrderEntryIds.get(orderEntryId4);
                    if (ids == null) continue;
                    errBoolean = true;
                    this.operationResult.addErrorInfo(this.buildErrMessage(order, ids, i));
                }
                if (errBoolean) continue;
                successObjs.add(order);
            }
        } else {
            successObjs.addAll(orders.values());
        }
    }

    private OperateErrorInfo buildErrMessage(DynamicObject order, String err, int i) {
        Object pkId = order.getPkValue();
        int dataIndex = 0;
        int rowIndex = i - 1;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = String.format(ResManager.loadKDString((String)"\u5de5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u7684\u7b2c%2$s\u884c\u5206\u5f55\uff0c\u7ec4\u4ef6\u6e05\u5355\u81ea\u52a8\u5ba1\u6838\u5931\u8d25\uff1a%3$s\u3002", (String)"OrderAuditStockAndTechExeOp_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]), order.getString("billno"), i, err);
        return new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "OrderAuditAfterExeOp_auditStock_Fail", "order", msg, errorLevel);
    }

    private void setFailMes(OperationResult submitResult, Map<Object, Object> submitStockIdtoOrderEntryIds, Map<Object, String> failOrderEntryIds) {
        HashSet submitSuccessIds = new HashSet(submitResult.getSuccessPkIds());
        for (Map.Entry<Object, Object> stockIdtoOrderEntryId : submitStockIdtoOrderEntryIds.entrySet()) {
            Object stockId = stockIdtoOrderEntryId.getKey();
            Object orderEntryId = stockIdtoOrderEntryId.getValue();
            if (submitSuccessIds.contains(stockId)) continue;
            failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(stockId, submitResult));
        }
    }

    private String getErrorBystockId(Object stockId, OperationResult submitResult) {
        for (IOperateInfo errInfo : submitResult.getAllErrorOrValidateInfo()) {
            if (!errInfo.getPkValue().toString().equals(stockId.toString())) continue;
            return errInfo.getMessage();
        }
        return "";
    }

    private Map<Object, String> audittechnis(Map<Object, DynamicObject> orders, List<DynamicObject> successObjs, Map<Object, DynamicObject> transactionTypeMap) {
        Object orderEntryId;
        Object id;
        Object col2;
        HashSet<Object> orderEntryIds = new HashSet<Object>(orders.size());
        HashedMap failOrderEntryIds = new HashedMap(orders.size());
        for (DynamicObject order : orders.values()) {
            boolean isaudittechnis;
            DynamicObject transactiontype = order.getDynamicObject("transactiontype");
            if (!transactiontype.getDataEntityType().getProperties().containsKey((Object)"isaudittechnis")) {
                transactiontype = transactionTypeMap.get(transactiontype.getPkValue());
            }
            if (!(isaudittechnis = transactiontype.getBoolean("isaudittechnis"))) continue;
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
            for (Object col2 : entryCol) {
                Object orderEntryId2 = col2.getPkValue();
                orderEntryIds.add(orderEntryId2);
            }
        }
        if (orderEntryIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return failOrderEntryIds;
        }
        QFilter technisqfilter = new QFilter("mftentryseq", "in", orderEntryIds);
        HashSet submitIds = new HashSet();
        HashSet auditIds = new HashSet();
        String manuftechKey = "sfc_mromanuftech";
        HashedMap billIdsToOrderEntryId = new HashedMap(orders.size());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"MftOrderTechnicsCreateBillUtil.audittechnis", (String)manuftechKey, (String)"id,billstatus,mftentryseq.id", (QFilter[])new QFilter[]{technisqfilter}, (String)"");
        col2 = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                Iterator id2 = row.get("id");
                if ("A".equals(row.get("billstatus"))) {
                    submitIds.add(id2);
                } else if ("B".equals(row.get("billstatus"))) {
                    auditIds.add(id2);
                }
                billIdsToOrderEntryId.put(id2, row.getLong("mftentryseq.id"));
            }
        }
        catch (Throwable row) {
            col2 = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (col2 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)col2).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (CollectionUtils.isEmpty(submitIds) && CollectionUtils.isEmpty(auditIds)) {
            successObjs.addAll(orders.values());
            return failOrderEntryIds;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("ignorewarn", "true");
        operateOption.setVariableValue("ignoreinteraction", "true");
        operateOption.setVariableValue("ignoreValidation", "true");
        operateOption.setVariableValue("orderBillType", this.billEntityType.getName());
        operateOption.setVariableValue("stockBillType", "pom_mrostock");
        operateOption.setVariableValue("autoAudit", "true");
        if (CollectionUtils.isNotEmpty(submitIds)) {
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)manuftechKey, (Object[])submitIds.toArray(), (OperateOption)operateOption);
            HashSet submitSuccessIds = new HashSet(submitResult.getSuccessPkIds());
            auditIds.addAll(submitSuccessIds);
            for (Map.Entry entry : billIdsToOrderEntryId.entrySet()) {
                id = entry.getKey();
                orderEntryId = entry.getValue();
                if (submitSuccessIds.contains(id)) continue;
                failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(id, submitResult));
            }
        }
        if (CollectionUtils.isNotEmpty(auditIds)) {
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)manuftechKey, (Object[])auditIds.toArray(), (OperateOption)operateOption);
            HashSet auditSuccessIds = new HashSet(auditResult.getSuccessPkIds());
            for (Map.Entry entry : billIdsToOrderEntryId.entrySet()) {
                id = entry.getKey();
                orderEntryId = entry.getValue();
                if (auditSuccessIds.contains(id)) continue;
                failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(id, auditResult));
            }
        }
        if (MapUtils.isNotEmpty((Map)failOrderEntryIds)) {
            for (DynamicObject order : orders.values()) {
                boolean errBoolean = false;
                DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
                for (int i = 0; i < entryCol.size(); ++i) {
                    orderEntryId = ((DynamicObject)entryCol.get(i)).getPkValue();
                    String ids = (String)failOrderEntryIds.get(orderEntryId);
                    if (ids == null) continue;
                    errBoolean = true;
                    String msg = String.format(ResManager.loadKDString((String)"\u5de5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u7684\u7b2c%2$s\u884c\u5206\u5f55\uff0c\u5de5\u5e8f\u8ba1\u5212\u81ea\u52a8\u5ba1\u6838\u5931\u8d25\uff1a%3$s\u3002", (String)"OrderAuditStockAndTechExeOp_1", (String)"mmc-pom-opplugin", (Object[])new Object[0]), order.getString("billno"), i + 1, ids);
                    this.operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", order.getPkValue(), 0, i, "OrderAuditAfterExeOp_audittechnis_Fail", "order", msg, ErrorLevel.Error));
                }
                if (errBoolean) continue;
                successObjs.add(order);
            }
        } else {
            successObjs.addAll(orders.values());
        }
        return failOrderEntryIds;
    }

    private DynamicObject loadTransactionType(Object transactionTypeId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)transactionTypeId, (String)"mpdm_transactproduct", (String)"isauditstock,isaudittechnis");
    }

    private Map<Object, Object> buildUnauditData(Map<Object, DynamicObject> orders, Map<Object, DynamicObject> transactionTypeMap) {
        HashedMap orderEntryIdtoBillIds = new HashedMap();
        HashedMap auditStockIdtoOrderEntryIds = new HashedMap();
        for (DynamicObject order : orders.values()) {
            boolean isAuditStock;
            DynamicObject transactiontype = order.getDynamicObject("transactiontype");
            if (!transactiontype.getDataEntityType().getProperties().containsKey((Object)"isauditstock")) {
                transactiontype = transactionTypeMap.get(transactiontype.getPkValue());
            }
            if (!(isAuditStock = transactiontype.getBoolean("isauditstock"))) continue;
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject col : entryCol) {
                Object orderEntryId = col.getPkValue();
                orderEntryIdtoBillIds.put(orderEntryId, order.getPkValue());
            }
        }
        String stockname = "pom_mrostock";
        QFilter stockqfilter = new QFilter("orderentryid", "in", (Object)orderEntryIdtoBillIds.keySet().toArray());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrdereAuditAfterExeOp.auditStock", (String)stockname, (String)"id,billstatus,orderentryid.id", (QFilter[])new QFilter[]{stockqfilter}, (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                Object stockId = row.get("id");
                Long orderEntryId = row.getLong("orderentryid.id");
                if (!"C".equals(row.get("billstatus"))) continue;
                auditStockIdtoOrderEntryIds.put(stockId, orderEntryId);
            }
        }
        return auditStockIdtoOrderEntryIds;
    }
}

