/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro;

import java.util.HashSet;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPlanStatusEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import org.apache.commons.collections4.map.HashedMap;

public class OrderUnAuditBeginOptOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("transactiontype");
        e.getFieldKeys().add("planstatus");
        e.getFieldKeys().add("plansuretime");
        e.getFieldKeys().add("treeentryentity.plandeptcontrolno");
        e.getFieldKeys().add("treeentryentity.qty");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Map<Object, DynamicObject> orders = this.loadMtfOrders(e.getDataEntities());
        HashSet<Object> transactionTypeIds = new HashSet<Object>(16);
        for (DynamicObject order : orders.values()) {
            if (order.getDynamicObject("transactiontype") != null) {
                transactionTypeIds.add(order.getDynamicObject("transactiontype").getPkValue());
            }
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("treeentryentity");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject entry = (DynamicObject)entryCol.get(j);
                entry.set("planstatus", (Object)ManuBillPlanStatusEnum.PLAN.getValue());
                entry.set("plansuretime", null);
            }
        }
    }

    private Map<Object, DynamicObject> loadMtfOrders(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return new HashedMap(0);
        }
        HashedMap orders = new HashedMap(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            orders.put(dataEntity.getPkValue(), dataEntity);
        }
        return orders;
    }
}

