/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro.validator;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MROOrderUnAuditCBValidator
extends AbstractValidator {
    public void validate() {
        this.validateCBToolStatus();
    }

    private void validateCBToolStatus() {
        HashSet<Object> ids = new HashSet<Object>(8);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String entitytype = dataEntity.getString("entitytype");
            if (!"pom_mroorder".equals(entitytype)) continue;
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("treeentryentity");
            for (Object row : dynamicObjectCollection) {
                ids.add(row.getPkValue());
            }
        }
        if (!ids.isEmpty()) {
            QFilter filter = new QFilter("entryentity.cbtoolstatus", "=", (Object)"ON");
            filter.and(new QFilter("entryentity.mulorderno.fbasedataid", "in", ids));
            DynamicObject[] pom_mroeleccontrols = BusinessDataServiceHelper.load((String)"pom_mroeleccontrol", (String)"id,billno,entryentity.mulorderno", (QFilter[])filter.toArray());
            HashSet<String> cbOrderNo = new HashSet<String>(8);
            for (DynamicObject dynamicObject : pom_mroeleccontrols) {
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    DynamicObjectCollection mulorderno = entry.getDynamicObjectCollection("mulorderno");
                    for (DynamicObject mulord : mulorderno) {
                        DynamicObject fbasedataid = mulord.getDynamicObject("fbasedataid");
                        long pkValue = (Long)fbasedataid.getPkValue();
                        if (!ids.contains(pkValue)) continue;
                        cbOrderNo.add(fbasedataid.getString("headbillno"));
                    }
                }
            }
            if (cbOrderNo.isEmpty()) {
                return;
            }
            for (DynamicObject dynamicObject : this.dataEntities) {
                String billNo = dynamicObject.getBillNo();
                if (!cbOrderNo.contains(billNo)) continue;
                String errormsg = ResManager.loadKDString((String)"\u4e0b\u6e38\u65ad\u8def\u5668\u5206\u5f55\u5b58\u5728\u6253\u5f00\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838", (String)"MROOrderUnAuditCBValidator_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]);
                this.addErrorMessage((ExtendedDataEntity)dynamicObject, errormsg);
            }
        }
    }
}

