/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mrocard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.business.coderule.mro.MROOrderCodeRuleHelper;
import kd.mmc.pom.common.mro.utils.MRONRCUtils;

public class MRONRCUnauditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("orderbillno");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("isshowlist");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.recycleCodeRuleNumbers(dataEntities);
        for (DynamicObject order : dataEntities) {
            order.set("isshowlist", (Object)false);
            order.set("orderbillno", null);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void recycleCodeRuleNumbers(DynamicObject[] datas) {
        HashSet<String> codeSet;
        HashMap delCodeMap = new HashMap(datas.length);
        for (DynamicObject data : datas) {
            DynamicObject transactiontype = data.getDynamicObject("transactiontype");
            DynamicObject project = MRONRCUtils.getProject((DynamicObject)data);
            DynamicObject codeRule = this.getCodeRule(transactiontype);
            String projectKeys = MROOrderCodeRuleHelper.genProjectKeys((DynamicObject)transactiontype, (DynamicObject)project, (String)"");
            HashMap<String, Object> delmap = (HashMap<String, Object>)delCodeMap.get(projectKeys);
            if (delmap == null) {
                delmap = new HashMap<String, Object>(datas.length);
            }
            codeSet = delmap.get("codeSet") == null ? new HashSet<String>(datas.length) : (HashSet)delmap.get("codeSet");
            String orderbillno = data.getString("orderbillno");
            codeSet.add(orderbillno);
            delmap.put("coderule", codeRule);
            delmap.put("codeSet", codeSet);
            delCodeMap.put(projectKeys, delmap);
        }
        if (!delCodeMap.isEmpty()) {
            for (Map.Entry entry : delCodeMap.entrySet()) {
                Map saveMap = (Map)entry.getValue();
                DynamicObject codeRule = (DynamicObject)saveMap.get("coderule");
                codeSet = (HashSet<String>)saveMap.get("codeSet");
                MROOrderCodeRuleHelper.recycleCodeRuleNumbers((DynamicObject)codeRule, (String)((String)entry.getKey()), (Set)codeSet);
            }
        }
    }

    private DynamicObject getCodeRule(DynamicObject transactionType) {
        if (transactionType == null) {
            return null;
        }
        return MROOrderCodeRuleHelper.getTransactionTypeCodeMode((Long)transactionType.getLong("id"));
    }
}

