/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mrocard;

import java.util.ArrayList;
import java.util.List;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.common.mro.utils.MROToolUtils;

public class MROSWSBatchOp
extends AbstractOperationServicePlugIn {
    private List<DynamicObject> savedataEntities = new ArrayList<DynamicObject>();
    private static final Log logger = LogFactory.getLog(MROSWSBatchOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isexistorder");
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("progroup");
        e.getFieldKeys().add("professiona");
        e.getFieldKeys().add("workhours");
        e.getFieldKeys().add("enworkhourunit");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs;
        super.beforeExecuteOperationTransaction(e);
        List billIdList = new ArrayList(16);
        for (DynamicObject obj : objs = e.getDataEntities()) {
            String orderids = obj.getString("orderids");
            billIdList = MROToolUtils.getBillnoList((String)orderids);
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setTargetEntityNumber("pom_mrosws");
        pushArgs.setHasRight(true);
        pushArgs.setRuleId("1442611280966856704");
        pushArgs.setBuildConvReport(true);
        pushArgs.setSourceEntityNumber("pom_mroorder");
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        for (String billId : billIdList) {
            ListSelectedRow srcBill = new ListSelectedRow((Object)Long.parseLong(billId));
            needPushRows.add(srcBill);
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"pom_mrosws");
        if (!pushResult.isSuccess()) {
            logger.info(MPDMMftGenStocksUtils.getErrByRes((ConvertOperationResult)pushResult));
            throw new KDBizException(new ErrorCode("MROSWSBatchOp", String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355\u4e0b\u63a8\u5931\u8d25\uff1a\u8865\u5145\u5de5\u4f5c\u5355%s", (String)"MROSWSBatchOp_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]), MPDMMftGenStocksUtils.getErrByRes((ConvertOperationResult)pushResult))), new Object[0]);
        }
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        for (DynamicObject targetBillObj : targetBillObjs) {
            this.savedataEntities.add(targetBillObj);
        }
        if (!this.savedataEntities.isEmpty()) {
            OperateOption create = OperateOption.create();
            create.setVariableValue("ishasright", "true");
            create.setVariableValue("ignorewarn", "true");
            create.setVariableValue("ignoreinteraction", "true");
            this.setSWSValue(e.getDataEntities(), this.savedataEntities);
            OperationResult saveOperate = SaveServiceHelper.saveOperate((String)"pom_mrosws", (DynamicObject[])this.savedataEntities.toArray(new DynamicObject[this.savedataEntities.size()]), (OperateOption)create);
            if (!saveOperate.isSuccess()) {
                logger.info("\u8865\u5145\u5de5\u4f5c\u5355\u4fdd\u5b58\u5931\u8d25\uff1a" + OrderOpUtils.getErrDetail((OperationResult)saveOperate));
                throw new KDBizException(new ErrorCode("AutoGenerateStock3", String.format(ResManager.loadKDString((String)"\u8865\u5145\u5de5\u4f5c\u5355\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"MROSWSBatchOp_1", (String)"mmc-pom-opplugin", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveOperate))), new Object[0]);
            }
        }
    }

    private void setSWSValue(DynamicObject[] dataEntities, List<DynamicObject> savedataEntities2) {
        DynamicObject obj = dataEntities[0];
        for (DynamicObject savedata : savedataEntities2) {
            DynamicObjectCollection billentry = savedata.getDynamicObjectCollection("billentry");
            billentry.clear();
            for (DynamicObject entry : obj.getDynamicObjectCollection("billentry")) {
                DynamicObject addNew = billentry.addNew();
                DataEntityPropertyCollection properties = addNew.getDataEntityType().getProperties();
                for (IDataEntityProperty propertie : properties) {
                    if ("attachment".equals(propertie.getName())) {
                        DynamicObjectCollection attachments = entry.getDynamicObjectCollection("attachment");
                        DynamicObjectCollection addNewAtt = addNew.getDynamicObjectCollection("attachment");
                        for (DynamicObject attach : attachments) {
                            addNewAtt.addNew().set("fbasedataid", attach.get("fbasedataid"));
                        }
                        continue;
                    }
                    addNew.set(propertie.getName(), entry.get(propertie.getName()));
                }
            }
        }
    }
}

