/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mrocard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pom.common.entity.SendMsgObject;
import kd.mmc.pom.common.service.SendMsgUtils;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class MROSWSEndWorkSendMsgOp
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        List selectedRows = e.getSelectedRows();
        Map<Object, DynamicObject> billMap = this.getMROManuMap(selectedRows);
        HashSet<String> orderBillNos = new HashSet<String>(16);
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity objEntity : selectedRows) {
            DynamicObject bill = billMap.get(objEntity.getBillPkId());
            orderBillNos.add(bill.getString("billno"));
            for (DynamicObject dyn : bill.getDynamicObjectCollection("treeentryentity")) {
                String taskStatus = dyn.getString("taskstatus");
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)taskStatus) && !StringUtils.equals((CharSequence)"D", (CharSequence)taskStatus)) continue;
                orderEntryIds.add(dyn.getLong("id"));
            }
        }
        Set<Long> receivers = this.getRecevierUsers(orderEntryIds);
        if (CollectionUtils.isEmpty(receivers)) {
            return;
        }
        ArrayList<SendMsgObject> sendMsgList = new ArrayList<SendMsgObject>(10);
        this.packageSengMsgInfo(receivers, sendMsgList, orderBillNos);
        SendMsgUtils.sendMsg(sendMsgList);
    }

    private void packageSengMsgInfo(Set<Long> receivers, List<SendMsgObject> sendMsgList, Set<String> orderBillNos) {
        SendMsgObject sendMsgObject = new SendMsgObject();
        sendMsgObject.setReceivers(receivers);
        String content = String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ed9\u60a8\u7684\u68c0\u4fee\u5de5\u5355\u7f16\u7801%1$s\u5df2\u7ecf\u5b8c\u5de5\u3002", (String)"MROSWSEndWorkSendMsgOp_5", (String)"mmc-pom-opplugin", (Object[])new Object[0]), orderBillNos);
        sendMsgObject.setContentZhCN(content);
        String contentTw = String.format(ResManager.loadKDString((String)"\u5206\u914d\u7d66\u60a8\u7684\u6aa2\u4fee\u5de5\u55ae\u7de8\u78bc%1$s\u5df2\u7d93\u5b8c\u5de5\u3002", (String)"MROSWSEndWorkSendMsgOp_1", (String)"mmc-pom-opplugin", (Object[])new Object[0]), orderBillNos);
        sendMsgObject.setContentZhTW(contentTw);
        String contentEn = String.format("The repair code %1$s assigned to you has been completed.", orderBillNos);
        sendMsgObject.setContentEn(contentEn);
        sendMsgObject.setTag(ResManager.loadKDString((String)"\u7d27\u6025", (String)"MROSWSEndWorkSendMsgOp_2", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        sendMsgObject.setEntityNumber("pom_mroorder");
        sendMsgObject.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
        sendMsgObject.setType("message");
        sendMsgObject.setTitleValueEn("Repair list completion reminder");
        sendMsgObject.setTitleValueZhCN(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355\u5b8c\u5de5\u63d0\u9192", (String)"MROSWSEndWorkSendMsgOp_3", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        sendMsgObject.setTitleValueZhTW(ResManager.loadKDString((String)"\u6aa2\u4fee\u5de5\u55ae\u5b8c\u5de5\u63d0\u9192", (String)"MROSWSEndWorkSendMsgOp_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        sendMsgList.add(sendMsgObject);
    }

    private Set<Long> getRecevierUsers(Set<Long> orderEntryIds) {
        HashSet<Long> receivers = new HashSet<Long>(16);
        QFilter qf = new QFilter("oprentryentity.mroorderentryid", "in", orderEntryIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryRecevUser", (String)"sfc_dailyplan", (String)"planentryentity.allocsubentryentity.id,planentryentity.allocsubentryentity.userincharge.user", (QFilter[])new QFilter[]{qf}, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            receivers.add(row.getLong("planentryentity.allocsubentryentity.userincharge.user"));
        }
        return receivers;
    }

    private Map<Object, DynamicObject> getMROManuMap(List<ExtendedDataEntity> selectedRows) {
        String entityName = "pom_mroorder";
        ArrayList<Object> idList = new ArrayList<Object>(selectedRows.size());
        for (ExtendedDataEntity objEntity : selectedRows) {
            idList.add(objEntity.getBillPkId());
            entityName = objEntity.getDataEntity().getDataEntityType().getName();
        }
        String selects = "id,billno,treeentryentity,treeentryentity.id,treeentryentity.taskstatus";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", idList)};
        DynamicObject[] load = BusinessDataServiceHelper.load((String)entityName, (String)selects, (QFilter[])qFilters);
        HashMap<Object, DynamicObject> billMap = new HashMap<Object, DynamicObject>(load.length);
        for (DynamicObject dym : load) {
            billMap.put(dym.getPkValue(), dym);
        }
        return billMap;
    }
}

