/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.orderrestructure.val;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class OrderRestructureCheckNotRestructedBillVal
extends AbstractValidator {
    public void validate() {
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject restructBill = extendedDataEntity.getDataEntity();
            DynamicObject orderEntryF7 = restructBill.getDynamicObject("pborderentryid");
            if (null == orderEntryF7) continue;
            orderEntryIds.add(orderEntryF7.getLong("id"));
        }
        HashMap<Long, List<Map<String, Object>>> notRestructedOrderEntryIds = new HashMap<Long, List<Map<String, Object>>>(16);
        if (CollectionUtils.isNotEmpty(orderEntryIds)) {
            QFilter qf = new QFilter("pborderentryid", "in", orderEntryIds);
            qf.and("isrestructured", "!=", (Object)true);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CheckNotRestructedBill", (String)this.entityKey, (String)"id,billno,pborderentryid", (QFilter[])qf.toArray(), (String)"");){
                for (Row row : dataSet) {
                    Long pborderentryid = row.getLong("pborderentryid");
                    ArrayList pborderentryids = (ArrayList)notRestructedOrderEntryIds.get(pborderentryid);
                    if (null == pborderentryids) {
                        pborderentryids = new ArrayList(10);
                    }
                    String billNo = row.getString("billno");
                    Long restructBillId = row.getLong("id");
                    HashMap<String, Object> temp = new HashMap<String, Object>(16);
                    temp.put("billNo", billNo);
                    temp.put("restructBillId", restructBillId);
                    pborderentryids.add(temp);
                    notRestructedOrderEntryIds.put(pborderentryid, pborderentryids);
                }
            }
        }
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            this.checkNotRestructedBill(extendedDataEntity, notRestructedOrderEntryIds);
        }
    }

    private void checkNotRestructedBill(ExtendedDataEntity dataEntity, Map<Long, List<Map<String, Object>>> notRestructedOrderEntryIds) {
        Long orderEntryId;
        List<Map<String, Object>> billNoInfos;
        DynamicObject restructureBill = dataEntity.getDataEntity();
        DynamicObject orderEntryF7 = restructureBill.getDynamicObject("pborderentryid");
        if (null != orderEntryF7 && null != notRestructedOrderEntryIds && CollectionUtils.isNotEmpty(billNoInfos = notRestructedOrderEntryIds.get(orderEntryId = Long.valueOf(orderEntryF7.getLong("id"))))) {
            boolean exist = false;
            Long restructBillId = restructureBill.getLong("id");
            HashSet<String> billNos = new HashSet<String>(16);
            for (Map<String, Object> billNoInfo : billNoInfos) {
                if (null == billNoInfo.get("restructBillId") || restructBillId.equals(Long.parseLong(billNoInfo.get("restructBillId").toString()))) continue;
                exist = true;
                billNos.add(null == billNoInfo.get("billNo") ? "" : billNoInfo.get("billNo").toString());
            }
            if (exist) {
                String errorInfo = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%1$s\uff09\u5b58\u5728\u672a\u6539\u5236\u5b8c\u6210\u7684\u6539\u5236\u7533\u8bf7\u5355\uff08%2$s\uff09\u3002", (String)"OrderRestructureCheckNotRestructedBillVal_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]), restructureBill.getString("pbordernumber"), StringUtils.join(billNos, (String)","));
                this.addErrorMessage(dataEntity, errorInfo);
            }
        }
    }
}

