/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.orderrestructure.val;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class OrderRestructurePlanAndReceivedQtyVal
extends AbstractValidator {
    public void validate() {
        HashSet<Long> orderEntryIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject orderRestructureBill = extendedDataEntity.getDataEntity();
            DynamicObject pborderentryid = orderRestructureBill.getDynamicObject("pborderentryid");
            if (null == pborderentryid) continue;
            orderEntryIdSet.add(pborderentryid.getLong("id"));
        }
        HashSet<String> stockCombineSet = new HashSet<String>(16);
        if (CollectionUtils.isNotEmpty(orderEntryIdSet)) {
            QFilter qf = new QFilter("orderentryid", "in", orderEntryIdSet);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"dealReturnBills", (String)"pom_mftstock", (String)"id,stockentry.id,stockentry.wipqty,stockentry.oprno,stockentry.processseq,stockentry.materialid,stockentry.entryconfiguredcode", (QFilter[])qf.toArray(), (String)"");){
                for (Row row : dataSet) {
                    Long stockEntryMaterialId = row.getLong("stockentry.materialid");
                    String stockEntryOprNo = row.getString("stockentry.oprno");
                    String stockEntryProcessSeq = row.getString("stockentry.processseq");
                    String entryconfiguredcode = row.getString("stockentry.entryconfiguredcode");
                    StringBuilder sb = new StringBuilder();
                    sb.append("mftMaterial");
                    sb.append(stockEntryMaterialId);
                    sb.append("oprparent");
                    sb.append(stockEntryProcessSeq);
                    sb.append("oprno");
                    sb.append(stockEntryOprNo);
                    sb.append("configuredCode");
                    sb.append(entryconfiguredcode);
                    stockCombineSet.add(sb.toString());
                }
            }
        }
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            this.checkPlanAndReceivedQty(extendedDataEntity, stockCombineSet);
        }
    }

    private void checkPlanAndReceivedQty(ExtendedDataEntity dataEntity, Set<String> stockCombineSet) {
        String restructurtype;
        DynamicObject restructureBill = dataEntity.getDataEntity();
        if (CollectionUtils.isNotEmpty(stockCombineSet) && StringUtils.equals((CharSequence)"B", (CharSequence)(restructurtype = restructureBill.getString("restructurtype")))) {
            HashSet<String> repeatSet = new HashSet<String>(16);
            this.checkSameMftMaterial(restructureBill, "retstockentry", "retmftmaterial", "retoprparent", "retoprno", "retconfiguredcode", "retreceivedbaseqty", "retplanreturnbaseqty", stockCombineSet, ResManager.loadKDString((String)"\u7ec4\u4ef6\u9000\u6599\u660e\u7ec6", (String)"OrderRestructurePlanAndReceivedQtyVal_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]), dataEntity, ResManager.loadKDString((String)"\u8ba1\u5212\u9000\u6599\u57fa\u672c\u6570\u91cf", (String)"OrderRestructurePlanAndReceivedQtyVal_1", (String)"mmc-pom-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u9886\u57fa\u672c\u6570\u91cf", (String)"OrderRestructurePlanAndReceivedQtyVal_2", (String)"mmc-pom-opplugin", (Object[])new Object[0]), repeatSet);
            this.checkSameMftMaterial(restructureBill, "scrapstockentry", "scrapmftmaterial", "scrapoprparent", "scrapoprno", "scrapconfiguredcode", "scrapreceivedbaseqty", "scrapplanreturnbaseqty", stockCombineSet, ResManager.loadKDString((String)"\u7ec4\u4ef6\u62a5\u5e9f\u660e\u7ec6", (String)"OrderRestructurePlanAndReceivedQtyVal_3", (String)"mmc-pom-opplugin", (Object[])new Object[0]), dataEntity, ResManager.loadKDString((String)"\u8ba1\u5212\u62a5\u5e9f\u57fa\u672c\u6570\u91cf", (String)"OrderRestructurePlanAndReceivedQtyVal_4", (String)"mmc-pom-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u9886\u57fa\u672c\u6570\u91cf", (String)"OrderRestructurePlanAndReceivedQtyVal_2", (String)"mmc-pom-opplugin", (Object[])new Object[0]), repeatSet);
            this.checkSameMftMaterialForAll(restructureBill, stockCombineSet, dataEntity, repeatSet);
        }
    }

    private void checkSameMftMaterial(DynamicObject restructureBill, String entryEntity, String mftMaterialEntity, String oprParentEntity, String oprNoEntity, String configuredCodeEntity, String receivedbaseqtyEntity, String planbaseqtyEntity, Set<String> stockCombineSet, String entryName, ExtendedDataEntity dataEntity, String receivedbaseqtyName, String planbaseqtyName, Set<String> repeatSet) {
        if (null != restructureBill) {
            DynamicObjectCollection retEntrys = restructureBill.getDynamicObjectCollection(entryEntity);
            for (DynamicObject retEntry : retEntrys) {
                if (null == retEntry) continue;
                StringBuilder sb = new StringBuilder();
                DynamicObject mftMaterial = retEntry.getDynamicObject(mftMaterialEntity);
                if (null != mftMaterial) {
                    sb.append("mftMaterial");
                    sb.append(mftMaterial.getLong("id"));
                }
                String oprparent = retEntry.getString(oprParentEntity);
                sb.append("oprparent");
                sb.append(oprparent);
                String oprno = retEntry.getString(oprNoEntity);
                sb.append("oprno");
                sb.append(oprno);
                DynamicObject configuredCode = retEntry.getDynamicObject(configuredCodeEntity);
                Long configuredCodeId = 0L;
                if (null != configuredCode) {
                    configuredCodeId = configuredCode.getLong("id");
                }
                sb.append("configuredCode");
                sb.append(configuredCodeId);
                BigDecimal receivedbaseqty = retEntry.getBigDecimal(receivedbaseqtyEntity);
                BigDecimal planbaseqty = retEntry.getBigDecimal(planbaseqtyEntity);
                if (null == stockCombineSet || null == planbaseqty || planbaseqty.compareTo(receivedbaseqty) <= 0 || !stockCombineSet.contains(sb.toString())) continue;
                String errorInfo = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c%3$s\u4e0d\u5141\u8bb8\u5927\u4e8e%4$s\u3002", (String)"OrderRestructurePlanAndReceivedQtyVal_5", (String)"mmc-pom-opplugin", (Object[])new Object[0]), entryName, retEntry.getString("seq"), null == configuredCode ? "" : configuredCode.getString("number"), planbaseqtyName, receivedbaseqtyName);
                repeatSet.add(sb.toString());
                this.addErrorMessage(dataEntity, errorInfo);
            }
        }
    }

    private void checkSameMftMaterialForAll(DynamicObject restructureBill, Set<String> stockCombineSet, ExtendedDataEntity dataEntity, Set<String> repeatSet) {
        HashMap totalInfo = new HashMap(16);
        if (null != restructureBill) {
            String info;
            BigDecimal planbaseqty;
            BigDecimal receivedbaseqty;
            Map bigDecimalMap;
            String comBine;
            Long configuredCodeId;
            String configuredCodeNumber;
            DynamicObject configuredCode;
            String oprno;
            String oprparent;
            String retmaterialname;
            DynamicObject retmaterial;
            DynamicObject mftMaterial;
            StringBuilder sb;
            DynamicObjectCollection retEntrys = restructureBill.getDynamicObjectCollection("retstockentry");
            for (DynamicObject retEntry : retEntrys) {
                if (null == retEntry) continue;
                StringBuilder sb2 = new StringBuilder();
                DynamicObject mftMaterial2 = retEntry.getDynamicObject("retmftmaterial");
                if (null != mftMaterial2) {
                    sb2.append("mftMaterial");
                    sb2.append(mftMaterial2.getLong("id"));
                }
                String oprparent2 = retEntry.getString("retoprparent");
                sb2.append("oprparent");
                sb2.append(oprparent2);
                String oprno2 = retEntry.getString("retoprno");
                sb2.append("oprno");
                sb2.append(oprno2);
                DynamicObject configuredCode2 = retEntry.getDynamicObject("retconfiguredcode");
                Long configuredCodeId2 = 0L;
                if (null != configuredCode2) {
                    configuredCodeId2 = configuredCode2.getLong("id");
                }
                sb2.append("configuredCode");
                sb2.append(configuredCodeId2);
                BigDecimal receivedbaseqty2 = retEntry.getBigDecimal("retreceivedbaseqty");
                BigDecimal planbaseqty2 = retEntry.getBigDecimal("retplanreturnbaseqty");
                String combine = sb2.toString();
                if (!stockCombineSet.contains(sb2.toString())) continue;
                HashMap<String, BigDecimal> bigDecimalMap2 = (HashMap<String, BigDecimal>)totalInfo.get(combine);
                if (null == bigDecimalMap2) {
                    bigDecimalMap2 = new HashMap<String, BigDecimal>(16);
                }
                BigDecimal planbaseqtyTemp = null == bigDecimalMap2.get("planbaseqty") ? BigDecimal.ZERO : (BigDecimal)bigDecimalMap2.get("planbaseqty");
                bigDecimalMap2.put("receivedbaseqty", receivedbaseqty2);
                bigDecimalMap2.put("planbaseqty", planbaseqtyTemp.add(planbaseqty2));
                totalInfo.put(combine, bigDecimalMap2);
            }
            DynamicObjectCollection scrapEntrys = restructureBill.getDynamicObjectCollection("scrapstockentry");
            for (DynamicObject scrapEntry : scrapEntrys) {
                if (null == scrapEntry) continue;
                sb = new StringBuilder();
                mftMaterial = scrapEntry.getDynamicObject("scrapmftmaterial");
                if (null != mftMaterial) {
                    sb.append("mftMaterial");
                    sb.append(mftMaterial.getLong("id"));
                }
                String oprparent3 = scrapEntry.getString("scrapoprparent");
                sb.append("oprparent");
                sb.append(oprparent3);
                String oprno3 = scrapEntry.getString("scrapoprno");
                sb.append("oprno");
                sb.append(oprno3);
                DynamicObject configuredCode3 = scrapEntry.getDynamicObject("scrapconfiguredcode");
                Long configuredCodeId3 = 0L;
                if (null != configuredCode3) {
                    configuredCodeId3 = configuredCode3.getLong("id");
                }
                sb.append("configuredCode");
                sb.append(configuredCodeId3);
                BigDecimal receivedbaseqty3 = scrapEntry.getBigDecimal("scrapreceivedbaseqty");
                BigDecimal planbaseqty3 = scrapEntry.getBigDecimal("scrapplanreturnbaseqty");
                String combine = sb.toString();
                if (!stockCombineSet.contains(sb.toString())) continue;
                HashMap<String, BigDecimal> bigDecimalMap3 = (HashMap<String, BigDecimal>)totalInfo.get(combine);
                if (null == bigDecimalMap3) {
                    bigDecimalMap3 = new HashMap<String, BigDecimal>(16);
                }
                BigDecimal planbaseqtyTemp = null == bigDecimalMap3.get("planbaseqty") ? BigDecimal.ZERO : (BigDecimal)bigDecimalMap3.get("planbaseqty");
                bigDecimalMap3.put("receivedbaseqty", receivedbaseqty3);
                bigDecimalMap3.put("planbaseqty", planbaseqtyTemp.add(planbaseqty3));
                totalInfo.put(combine, bigDecimalMap3);
            }
            for (DynamicObject retEntry : retEntrys) {
                if (null == retEntry) continue;
                sb = new StringBuilder();
                mftMaterial = retEntry.getDynamicObject("retmftmaterial");
                if (null != mftMaterial) {
                    sb.append("mftMaterial");
                    sb.append(mftMaterial.getLong("id"));
                }
                retmaterial = retEntry.getDynamicObject("retmaterial");
                retmaterialname = "unknown";
                if (null != retmaterial) {
                    retmaterialname = retmaterial.getString("name");
                }
                oprparent = retEntry.getString("retoprparent");
                sb.append("oprparent");
                sb.append(oprparent);
                oprno = retEntry.getString("retoprno");
                sb.append("oprno");
                sb.append(oprno);
                configuredCode = retEntry.getDynamicObject("retconfiguredcode");
                configuredCodeNumber = "";
                configuredCodeId = 0L;
                if (null != configuredCode) {
                    configuredCodeId = configuredCode.getLong("id");
                    configuredCodeNumber = configuredCode.getString("number");
                    if (StringUtils.isNotEmpty((CharSequence)configuredCodeNumber)) {
                        configuredCodeNumber = String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u53f7\u201c%1$s\u201d", (String)"OrderRestructurePlanAndReceivedQtyVal_8", (String)"mmc-pom-opplugin", (Object[])new Object[0]), configuredCodeNumber);
                    }
                }
                sb.append("configuredCode");
                sb.append(configuredCodeId);
                comBine = sb.toString();
                bigDecimalMap = (Map)totalInfo.get(comBine);
                if (null == bigDecimalMap) continue;
                receivedbaseqty = (BigDecimal)bigDecimalMap.get("receivedbaseqty");
                planbaseqty = (BigDecimal)bigDecimalMap.get("planbaseqty");
                if (repeatSet.contains(comBine) || null == planbaseqty || planbaseqty.compareTo(receivedbaseqty) <= 0) continue;
                info = String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\uff08%1$s\uff09\u3001\u5e8f\u5217\u53f7\uff08%2$s\uff09\u3001\u5de5\u5e8f\u53f7\uff08%3$s\uff09%4$s\u5408\u8ba1\u8ba1\u5212\u9000\u6599/\u62a5\u5e9f\u6570\u91cf\uff08%5$s\uff09\u5927\u4e8e\u5df2\u9886\u6570\u91cf\uff08%6$s\uff09", (String)"OrderRestructurePlanAndReceivedQtyVal_7", (String)"mmc-pom-opplugin", (Object[])new Object[0]), retmaterialname, oprparent, oprno, configuredCodeNumber, planbaseqty.compareTo(BigDecimal.ZERO) == 0 ? "0" : planbaseqty, receivedbaseqty.compareTo(BigDecimal.ZERO) == 0 ? "0" : receivedbaseqty);
                repeatSet.add(comBine);
                this.addErrorMessage(dataEntity, info);
            }
            for (DynamicObject scrapEntry : scrapEntrys) {
                if (null == scrapEntry) continue;
                sb = new StringBuilder();
                mftMaterial = scrapEntry.getDynamicObject("scrapmftmaterial");
                if (null != mftMaterial) {
                    sb.append("mftMaterial");
                    sb.append(mftMaterial.getLong("id"));
                }
                retmaterial = scrapEntry.getDynamicObject("scrapmaterial");
                retmaterialname = "unknown";
                if (null != retmaterial) {
                    retmaterialname = retmaterial.getString("name");
                }
                oprparent = scrapEntry.getString("scrapoprparent");
                sb.append("oprparent");
                sb.append(oprparent);
                oprno = scrapEntry.getString("scrapoprno");
                sb.append("oprno");
                sb.append(oprno);
                configuredCode = scrapEntry.getDynamicObject("scrapconfiguredcode");
                configuredCodeNumber = "";
                configuredCodeId = 0L;
                if (null != configuredCode) {
                    configuredCodeId = configuredCode.getLong("id");
                    configuredCodeNumber = configuredCode.getString("number");
                    if (StringUtils.isNotEmpty((CharSequence)configuredCodeNumber)) {
                        configuredCodeNumber = String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u53f7\u201c%1$s\u201d", (String)"OrderRestructurePlanAndReceivedQtyVal_8", (String)"mmc-pom-opplugin", (Object[])new Object[0]), configuredCodeNumber);
                    }
                }
                sb.append("configuredCode");
                sb.append(configuredCodeId);
                comBine = sb.toString();
                bigDecimalMap = (Map)totalInfo.get(comBine);
                if (null == bigDecimalMap) continue;
                receivedbaseqty = (BigDecimal)bigDecimalMap.get("receivedbaseqty");
                planbaseqty = (BigDecimal)bigDecimalMap.get("planbaseqty");
                if (repeatSet.contains(comBine) || null == planbaseqty || planbaseqty.compareTo(receivedbaseqty) <= 0) continue;
                info = String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\uff08%1$s\uff09\u3001\u5e8f\u5217\u53f7\uff08%2$s\uff09\u3001\u5de5\u5e8f\u53f7\uff08%3$s\uff09%4$s\u5408\u8ba1\u8ba1\u5212\u9000\u6599/\u62a5\u5e9f\u6570\u91cf\uff08%5$s\uff09\u5927\u4e8e\u5df2\u9886\u6570\u91cf\uff08%6$s\uff09", (String)"OrderRestructurePlanAndReceivedQtyVal_7", (String)"mmc-pom-opplugin", (Object[])new Object[0]), retmaterialname, oprparent, oprno, configuredCodeNumber, planbaseqty.compareTo(BigDecimal.ZERO) == 0 ? "0" : planbaseqty, receivedbaseqty.compareTo(BigDecimal.ZERO) == 0 ? "0" : receivedbaseqty);
                repeatSet.add(comBine);
                this.addErrorMessage(dataEntity, info);
            }
        }
    }
}

