/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.report.outproduce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class OutProductMaterialRptQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam queryParam, Object obj) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        DataSet result = this.getReturnData(filterInfo);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet getReturnData(FilterInfo filterInfo) {
        DataSet purChaseData = null;
        DataSet purApplyData = null;
        DataSet mftOrderData = null;
        DataSet mftStockData = null;
        DataSet joinResult = null;
        try {
            DataSet result;
            purChaseData = this.getPurChaseDataSet(filterInfo);
            purApplyData = this.getPurApplyDataSet(purChaseData);
            mftOrderData = this.getMftOrderDataSet(filterInfo, purApplyData);
            mftStockData = this.getMftStockDataSet(filterInfo, mftOrderData);
            joinResult = this.getDataSetByJoin(purChaseData, purApplyData, mftOrderData, mftStockData);
            DataSet dataSet = result = joinResult.copy();
            return dataSet;
        }
        finally {
            if (purChaseData != null) {
                purChaseData.close();
            }
            if (purApplyData != null) {
                purApplyData.close();
            }
            if (mftOrderData != null) {
                mftOrderData.close();
            }
            if (mftStockData != null) {
                mftStockData.close();
            }
            if (joinResult != null) {
                joinResult.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet getDataSetByJoin(DataSet purChaseData, DataSet purApplyData, DataSet mftOrderData, DataSet mftStockData) {
        DataSet purChaseJoinData = null;
        DataSet mftOrderJoinData = null;
        try {
            DataSet mftStockJoinData;
            JoinDataSet purChaseJoin = purChaseData.join(purApplyData);
            purChaseJoinData = purChaseJoin.on("srcbillentryid", "entryid").select(new String[]{"billno", "unit", "poqtynum", "recivqty", "invqty", "rejectqty", "supplercode", "createtime", "audittime", "purchaseuser", "deliqty"}, new String[]{"srcbillentryid"}).finish();
            JoinDataSet mftOrderJoin = purChaseJoinData.join(mftOrderData);
            mftOrderJoinData = mftOrderJoin.on("srcbillentryid", "entryid").select(new String[]{"billno", "unit", "poqtynum", "recivqty", "invqty", "rejectqty", "supplercode", "createtime", "audittime", "purchaseuser", "deliqty"}, new String[]{"mftbillno", "planstatus", "mftmaterial", "startqty", "cmplqty", "transmittime", "planbegintime", "entryid", "finishqty"}).finish();
            JoinDataSet mftStockJoin = mftOrderJoinData.join(mftStockData);
            DataSet dataSet = mftStockJoinData = mftStockJoin.on("entryid", "orderentryid").select(new String[]{"billno", "unit unitfield", "poqtynum", "recivqty", "invqty", "rejectqty", "supplercode suppliercode", "createtime", "audittime", "purchaseuser", "deliqty", "mftbillno", "planstatus", "mftmaterial", "startqty", "cmplqty", "transmittime", "planbegintime", "finishqty"}, new String[]{"mftstockmaterial", "demandqty", "wipqty", "sendqty", "bomqty"}).finish();
            return dataSet;
        }
        finally {
            if (purChaseJoinData != null) {
                purChaseJoinData.close();
            }
            if (mftOrderJoinData != null) {
                mftOrderJoinData.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet getMftStockDataSet(FilterInfo filterInfo, DataSet mftOrderData) {
        DynamicObject material;
        DataSet set = mftOrderData.copy();
        ArrayList<Object> idList = new ArrayList<Object>(10);
        ArrayList<QFilter> mftStockFilterList = new ArrayList<QFilter>();
        while (set.hasNext()) {
            Row row = set.next();
            idList.add(row.get("entryid"));
        }
        if (!idList.isEmpty()) {
            mftStockFilterList.add(new QFilter("orderentryid", "in", idList));
        }
        if (null != (material = filterInfo.getDynamicObject("material"))) {
            mftStockFilterList.add(new QFilter("stockentry.materialid.masterid", "=", material.getPkValue()));
        }
        mftStockFilterList.add(new QFilter("stockentry.issuemode", "!=", (Object)"C"));
        StringBuilder selectStr = new StringBuilder();
        selectStr.append("stockentry.qtynumerator qtynumerator,");
        selectStr.append("stockentry.qtydenominator qtydenominator,");
        selectStr.append("stockentry.materialid.masterid mftstockmaterial,");
        selectStr.append("stockentry.demandqty demandqty,");
        selectStr.append("stockentry.actissueqty actissueqty,");
        selectStr.append("stockentry.rejectedqty rejectedqty,");
        selectStr.append("stockentry.feedingqty feedingqty,");
        selectStr.append("stockentry.wipqty wipqty,");
        selectStr.append("orderentryid");
        try (DataSet mftStockData = null;){
            DataSet result;
            mftStockData = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "pom_mftstock"), (String)"pom_mftstock", (String)selectStr.toString(), (QFilter[])mftStockFilterList.toArray(new QFilter[0]), null);
            DataSet dataSet = result = mftStockData.select(new String[]{"orderentryid", "mftstockmaterial", "demandqty", "wipqty", "actissueqty-rejectedqty+feedingqty sendqty", "qtynumerator/qtydenominator bomqty"});
            return dataSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet getMftOrderDataSet(FilterInfo filterInfo, DataSet purApplyData) {
        DynamicObject prodMaterial;
        String orderBillNo;
        Date startEndTime;
        Date startBeginTime;
        Date releaseEnd;
        Date releaseBegine;
        DataSet set = purApplyData.copy();
        ArrayList<Object> idList = new ArrayList<Object>(10);
        ArrayList<QFilter> mftOrderFilterList = new ArrayList<QFilter>();
        while (set.hasNext()) {
            Row row = set.next();
            idList.add(row.get("srcbillentryid"));
        }
        if (!idList.isEmpty()) {
            mftOrderFilterList.add(new QFilter("treeentryentity.id", "in", idList));
        }
        if (null != (releaseBegine = filterInfo.getDate("releasebegine"))) {
            mftOrderFilterList.add(new QFilter("treeentryentity.transmittime", ">=", (Object)releaseBegine));
        }
        if (null != (releaseEnd = filterInfo.getDate("releaseend"))) {
            mftOrderFilterList.add(new QFilter("treeentryentity.transmittime", "<=", (Object)releaseEnd));
        }
        if (null != (startBeginTime = filterInfo.getDate("startbegintime"))) {
            mftOrderFilterList.add(new QFilter("treeentryentity.planbegintime", ">=", (Object)startBeginTime));
        }
        if (null != (startEndTime = filterInfo.getDate("startendtime"))) {
            mftOrderFilterList.add(new QFilter("treeentryentity.planbegintime", "<=", (Object)startEndTime));
        }
        if (StringUtils.isNotEmpty((CharSequence)(orderBillNo = filterInfo.getString("orderbillno")))) {
            String[] billNos = orderBillNo.split(";");
            mftOrderFilterList.add(new QFilter("billno", "in", (Object)billNos));
        }
        if (null != (prodMaterial = filterInfo.getDynamicObject("prodmaterial"))) {
            mftOrderFilterList.add(new QFilter("treeentryentity.material.masterid", "=", prodMaterial.getPkValue()));
        }
        mftOrderFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        StringBuilder mftOrderStr = new StringBuilder();
        mftOrderStr.append("billno mftbillno,");
        mftOrderStr.append("treeentryentity.planstatus planstatus,");
        mftOrderStr.append("treeentryentity.material.masterid mftmaterial,");
        mftOrderStr.append("treeentryentity.qty startqty,");
        mftOrderStr.append("treeentryentity.quainwaqty quainwaqty,");
        mftOrderStr.append("treeentryentity.unquainwaqty unquainwaqty,");
        mftOrderStr.append("treeentryentity.scrinwaqty scrinwaqty,");
        mftOrderStr.append("treeentryentity.pickingpairs cmplqty,");
        mftOrderStr.append("treeentryentity.transmittime transmittime,");
        mftOrderStr.append("treeentryentity.planbegintime planbegintime,");
        mftOrderStr.append("treeentryentity.id entryid");
        try (DataSet mftOrderData = null;){
            DataSet result;
            mftOrderData = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "pom_mftorder"), (String)"pom_mftorder", (String)mftOrderStr.toString(), (QFilter[])mftOrderFilterList.toArray(new QFilter[0]), null);
            DataSet dataSet = result = mftOrderData.select(new String[]{"mftbillno", "planstatus", "mftmaterial", "startqty", "cmplqty", "transmittime", "planbegintime", "entryid", "quainwaqty+unquainwaqty+scrinwaqty finishqty"});
            return dataSet;
        }
    }

    private DataSet getPurApplyDataSet(DataSet purChaseData) {
        DataSet set = purChaseData.copy();
        ArrayList<Object> idList = new ArrayList<Object>(10);
        while (set.hasNext()) {
            Row row = set.next();
            idList.add(row.get("srcbillentryid"));
        }
        ArrayList<QFilter> purApplyFilterList = new ArrayList<QFilter>();
        purApplyFilterList.add(new QFilter("billentry.id", "in", idList));
        StringBuilder purApplyStr = new StringBuilder();
        purApplyStr.append("billentry.id entryid,");
        purApplyStr.append("billentry.srcbillentryid srcbillentryid");
        DataSet purApplyData = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "pm_purapplybill"), (String)"pm_purapplybill", (String)purApplyStr.toString(), (QFilter[])purApplyFilterList.toArray(new QFilter[0]), null);
        return purApplyData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet getPurChaseDataSet(FilterInfo filterInfo) {
        DynamicObject userField;
        DynamicObject supplier;
        DynamicObjectCollection purchaseBillColls;
        Date auditEnd;
        ArrayList<QFilter> purOrderFilterList = new ArrayList<QFilter>();
        Object orgId = filterInfo.getDynamicObject("orgfield").getPkValue();
        purOrderFilterList.add(new QFilter("org", "=", orgId));
        Date createBegin = (Date)filterInfo.getValue("createbegin");
        purOrderFilterList.add(new QFilter("createtime", ">=", (Object)createBegin));
        Date createEnd = (Date)filterInfo.getValue("createend");
        purOrderFilterList.add(new QFilter("createtime", "<=", (Object)createEnd));
        purOrderFilterList.add(new QFilter("billtype", "=", (Object)Long.valueOf("1005695800258488320")));
        Date auditBegine = filterInfo.getDate("auditbegine");
        if (null != auditBegine) {
            purOrderFilterList.add(new QFilter("auditdate", ">=", (Object)auditBegine));
        }
        if (null != (auditEnd = filterInfo.getDate("auditend"))) {
            purOrderFilterList.add(new QFilter("auditdate", "<=", (Object)auditEnd));
        }
        if (!CollectionUtils.isEmpty((Collection)(purchaseBillColls = filterInfo.getDynamicObjectCollection("purchasebillno")))) {
            ArrayList<String> billNoList = new ArrayList<String>();
            for (DynamicObject billDyn : purchaseBillColls) {
                billNoList.add(billDyn.getString("billno"));
            }
            purOrderFilterList.add(new QFilter("billno", "in", billNoList));
        }
        if (null != (supplier = filterInfo.getDynamicObject("supplier"))) {
            purOrderFilterList.add(new QFilter("supplier", "=", supplier.getPkValue()));
        }
        if (null != (userField = filterInfo.getDynamicObject("userfield"))) {
            purOrderFilterList.add(new QFilter("operator", "=", userField.getPkValue()));
        }
        StringBuilder purorderStr = new StringBuilder();
        purorderStr.append("billno,");
        purorderStr.append("billentry.unit unit,");
        purorderStr.append("billentry.qty poqtynum,");
        purorderStr.append("billentry.receiveqty recivqty,");
        purorderStr.append("billentry.invqty invqty,");
        purorderStr.append("billentry.returnqty rejectqty,");
        purorderStr.append("supplier supplercode,");
        purorderStr.append("createtime,");
        purorderStr.append("auditdate audittime,");
        purorderStr.append("billentry.srcbillentryid srcbillentryid,");
        purorderStr.append("operator purchaseuser");
        try (DataSet purDataSet = null;){
            DataSet result;
            purDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "pm_purorderbill"), (String)"pm_purorderbill", (String)purorderStr.toString(), (QFilter[])purOrderFilterList.toArray(new QFilter[0]), null);
            DataSet dataSet = result = purDataSet.select(new String[]{"billno", "unit", "poqtynum", "recivqty", "invqty", "rejectqty", "supplercode", "createtime", "audittime", "purchaseuser", "poqtynum-invqty deliqty", "srcbillentryid"});
            return dataSet;
        }
    }
}

