/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.common.mro.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MRONRCUtils {
    private MRONRCUtils() {
    }

    public static DynamicObject getDefaultTrans(Long orgId, Long bizId) {
        QFilter qFilter = new QFilter("isfault", "=", (Object)"1");
        QFilter planFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactproduct", (Long)orgId);
        qFilter.and(planFilter);
        qFilter.and(new QFilter("transactiontype", "=", (Object)bizId));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"mpdm_transactproduct", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
        DynamicObject tran = null;
        if (load != null && load.length == 1) {
            tran = load[0];
        }
        return tran;
    }

    public static Object getDefaultTransId(Long orgId, Long bizId) {
        DynamicObject tran = MRONRCUtils.getDefaultTrans(orgId, bizId);
        Long tranid = 0L;
        if (tran != null) {
            tranid = (Long)tran.getPkValue();
        }
        return tranid;
    }

    public static DynamicObject getNewData(DynamicObject[] load) {
        int num = load.length - 1;
        DynamicObject order = load[num];
        for (int i = 0; i < num; ++i) {
            Date date2;
            Date date = order.getDate("createtime");
            if (!date.before(date2 = load[i].getDate("createtime"))) continue;
            order = load[i];
        }
        return order;
    }

    public static void updateOrderMroManuftech(List<DynamicObject> savedataEntities, DynamicObject[] objs) {
        if (!savedataEntities.isEmpty()) {
            HashSet<String> swsEntryIdSet = new HashSet<String>(16);
            for (DynamicObject order : savedataEntities) {
                DynamicObjectCollection entrys = order.getDynamicObjectCollection("treeentryentity");
                if (entrys.isEmpty()) continue;
                swsEntryIdSet.add(((DynamicObject)entrys.get(0)).getString("sourceentryseq"));
            }
            Map<String, DynamicObject> swsEntryMap = MRONRCUtils.getSwsEntryMap(swsEntryIdSet, objs);
            HashMap<String, String> swsEntryOrderMap = new HashMap<String, String>(16);
            QFilter q = new QFilter("treeentryentity.sourceentryseq", "in", swsEntryIdSet);
            DynamicObjectCollection querys = QueryServiceHelper.query((String)"pom_mroorder", (String)"id,treeentryentity.sourceentryseq", (QFilter[])new QFilter[]{q});
            HashSet<String> orderIdSet = new HashSet<String>(16);
            for (DynamicObject query : querys) {
                orderIdSet.add(query.get("id").toString());
                swsEntryOrderMap.put(query.get("id").toString(), query.get("treeentryentity.sourceentryseq").toString());
            }
            QFilter qFtech = new QFilter("manufactureorderid", "in", orderIdSet);
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)"sfc_mromanuftech", (String)"baseunit,baseqty,manufactureorderid,org,billno,billtype,mftentryseq,processroute,oprentryentity,oprno,oprparent,machiningtype,oprprocessgroup,oprprofessiona,oprorg,oprplanbegintime,oprplanfinishtime,oprctrlstrategy,oprstandardqty,oprqty,oprunit,overlapunit,headqty,headunit,operationqty,oprdescription,oprworkhours,oprworkhourunit,oprstatus,oprsourcetype", (QFilter[])new QFilter[]{qFtech});
            MRONRCUtils.updateMroManuftech(loads, swsEntryMap, swsEntryOrderMap);
            SaveServiceHelper.save((DynamicObject[])loads);
        }
    }

    private static void updateMroManuftech(DynamicObject[] loads, Map<String, DynamicObject> swsEntryMap, Map<String, String> swsEntryOrderMap) {
        for (DynamicObject load : loads) {
            DynamicObjectCollection oprentryentitys = load.getDynamicObjectCollection("oprentryentity");
            DynamicObject addNew = oprentryentitys.addNew();
            String orderid = load.getString("manufactureorderid");
            DynamicObject orderEntryF7 = load.getDynamicObject("mftentryseq");
            Object qty = orderEntryF7.get("qty");
            Object unit = orderEntryF7.get("unit");
            DynamicObject swsEntry = swsEntryMap.get(swsEntryOrderMap.get(orderid));
            addNew.set("oprparent", (Object)"1");
            addNew.set("oprno", (Object)"10");
            addNew.set("machiningtype", (Object)"1001");
            addNew.set("oprprocessgroup", swsEntry.get("progroup"));
            addNew.set("oprprofessiona", swsEntry.get("professiona"));
            addNew.set("oprworkhours", swsEntry.get("workhours"));
            addNew.set("oprworkhourunit", swsEntry.get("enworkhourunit"));
            addNew.set("oprorg", load.get("org"));
            addNew.set("oprctrlstrategy", (Object)1426881277977454592L);
            addNew.set("oprstandardqty", qty);
            addNew.set("oprqty", qty);
            addNew.set("oprunit", unit);
            addNew.set("overlapunit", unit);
            addNew.set("headqty", qty);
            addNew.set("headunit", unit);
            addNew.set("operationqty", qty);
            addNew.set("oprdescription", (Object)ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5e8f", (String)"MRONRCUtils_0", (String)"mmc-pom-common", (Object[])new Object[0]));
            addNew.set("oprstatus", (Object)"A");
            addNew.set("oprsourcetype", (Object)"B");
            addNew.set("oprplanbegintime", orderEntryF7.get("planbegintime"));
            addNew.set("oprplanfinishtime", orderEntryF7.get("planendtime"));
        }
    }

    private static Map<String, DynamicObject> getSwsEntryMap(Set<String> swsEntryIdSet, DynamicObject[] dataEntities) {
        HashMap<String, DynamicObject> swsEntryMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject obj : dataEntities) {
            String name = obj.getDynamicObjectType().getName();
            if ("pom_mroswsback".equals(name)) {
                swsEntryMap.put(obj.getPkValue().toString(), obj);
                continue;
            }
            DynamicObjectCollection billentrys = obj.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentrys) {
                if (!swsEntryIdSet.contains(billentry.getPkValue().toString())) continue;
                swsEntryMap.put(billentry.getPkValue().toString(), billentry);
            }
        }
        return swsEntryMap;
    }

    public static Set<Long> getSealTypeNumberSet() {
        HashSet<Long> sealTypeNumberSet = new HashSet<Long>(16);
        sealTypeNumberSet.add(1550017019573760000L);
        sealTypeNumberSet.add(1550017988474761216L);
        sealTypeNumberSet.add(1550017743124754432L);
        sealTypeNumberSet.add(1550017893616381952L);
        sealTypeNumberSet.add(1550018231241076736L);
        return sealTypeNumberSet;
    }

    public static List<Long> getSwsAndNrcSealUserIds() {
        QFilter carduserQfilter = new QFilter("status", "=", (Object)"C");
        carduserQfilter.and(new QFilter("enable", "=", (Object)"1"));
        carduserQfilter.and(new QFilter("seal.sealtype", "in", MRONRCUtils.getSealTypeNumberSet()));
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"AuthorizeUserInformService", (String)"getUserId", (Object[])new Object[]{carduserQfilter});
        List<Long> entrycarduseridList = new ArrayList<Long>(16);
        if (null != result) {
            entrycarduseridList = (List)result.get((Object)"data");
        }
        return entrycarduseridList;
    }

    public static Map<Long, Boolean> getUserIsSwsAndNrcSeal(List<Long> userIdList) {
        Object data;
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"SealInformService", (String)"getSealInformation", (Object[])new Object[]{userIdList});
        HashMap<Long, Boolean> isUserSealMap = new HashMap<Long, Boolean>(16);
        if (null != result && null != (data = result.get((Object)"data"))) {
            Map userSealInfoMap = (Map)data;
            userSealInfoMap.forEach((k, v) -> {
                if (v != null) {
                    for (JSONObject jsonObject : v) {
                        Long sealTypeId = (Long)jsonObject.get((Object)"sealTypeId");
                        if (!MRONRCUtils.getSealTypeNumberSet().contains(sealTypeId)) continue;
                        isUserSealMap.put((Long)k, true);
                        break;
                    }
                }
            });
        }
        return isUserSealMap;
    }

    public static Map<Long, DynamicObject> getManuPersonByUserId(List<Long> userIdList) {
        DynamicObject[] manupeople;
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(16);
        QFilter manuPersonQfilter = new QFilter("user", "in", userIdList);
        for (DynamicObject manuPerson : manupeople = BusinessDataServiceHelper.load((String)"mpdm_manuperson", (String)"id,user", (QFilter[])manuPersonQfilter.toArray())) {
            DynamicObject user = manuPerson.getDynamicObject("user");
            if (null == user) continue;
            Long userId = (Long)user.getPkValue();
            resultMap.put(userId, manuPerson);
        }
        return resultMap;
    }

    public static DynamicObject getSysProgroup(DynamicObject manftech) {
        Object nrcdefaultgroup;
        DynamicObject org = manftech.getDynamicObject("org");
        if (org == null) {
            return null;
        }
        Long orgId = org.getLong("id");
        Map pomSystemParam = MPDMMftGenStocksUtils.getPmAppParameterMap((Long)orgId, (String)"pom_mftstock");
        DynamicObject progroup = null;
        if (pomSystemParam != null && (nrcdefaultgroup = pomSystemParam.get("nrcdefaultgroup")) instanceof Map) {
            Map resReadyPlanMap = (Map)nrcdefaultgroup;
            Long groupPK = Long.parseLong(String.valueOf(resReadyPlanMap.get("id")));
            progroup = BusinessDataServiceHelper.loadSingle((Object)groupPK, (String)"mpdm_progroup");
        }
        return progroup;
    }

    public static Boolean getSysIsAuth(DynamicObject org) {
        Object isauth;
        if (null == org) {
            return false;
        }
        Long orgId = (Long)org.getPkValue();
        Map pomSystemParam = MPDMMftGenStocksUtils.getPmAppParameterMap((Long)orgId, (String)"pom_mftstock");
        Boolean result = false;
        if (pomSystemParam != null && (isauth = pomSystemParam.get("swsisauth")) instanceof Boolean) {
            result = (Boolean)isauth;
        }
        return result;
    }

    public static Boolean readNRCIsModifySrcOrderParam() {
        DynamicObject billParameter = ParameterReader.getBillParameter((String)"pom_mronrc");
        Boolean isModify = billParameter.getBoolean("ismodsrcorder");
        return isModify;
    }

    public static String getKeyString(DynamicObject project, DynamicObject codeRule) {
        return (project == null ? "" : project.getPkValue()) + "_" + (codeRule == null ? "" : codeRule.getPkValue());
    }

    public static DynamicObject getProject(DynamicObject order) {
        DynamicObjectCollection orderEntryEntitys = order.getDynamicObjectCollection("treeentryentity");
        if (orderEntryEntitys != null && !orderEntryEntitys.isEmpty()) {
            return ((DynamicObject)orderEntryEntitys.get(0)).getDynamicObject("project");
        }
        return null;
    }
}

