/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.common.resready;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mmc.pom.common.resready.RecOrgStrategy;
import kd.mmc.pom.common.resready.ReqOrgStategy;

public class GetRelationOrgMapFunction
extends MapFunction {
    private RowMeta rowMeta;
    private int targetFieldIndex;
    private String owner;
    private String recorg;
    private String reqorg;

    public GetRelationOrgMapFunction(RowMeta rowMeta, String targetField, String owner, String recorg, String reqorg) {
        this.rowMeta = rowMeta;
        this.targetFieldIndex = rowMeta.getFieldIndex(targetField);
        this.owner = owner;
        this.recorg = recorg;
        this.reqorg = reqorg;
    }

    public Object[] map(Row row) {
        int count = 0;
        if (this.rowMeta != null) {
            count = this.rowMeta.getFieldCount();
        }
        Object[] newRow = new Object[count];
        if (row == null || this.rowMeta == null) {
            return new Object[0];
        }
        for (int i = 0; i < this.rowMeta.getFieldCount(); ++i) {
            newRow[i] = this.targetFieldIndex == i ? this.getValue(row, this.owner, this.recorg, this.reqorg) : row.get(i);
        }
        return newRow;
    }

    private Long getValue(Row data, String owner, String recorg, String reqorg) {
        long realOwner = 0L;
        long realRecorgId = 0L;
        long realReqorgId = 0L;
        realOwner = GetRelationOrgMapFunction.getRealId(owner, data);
        if (realOwner != 0L) {
            return realOwner;
        }
        realRecorgId = GetRelationOrgMapFunction.getRealId(recorg, data);
        realReqorgId = GetRelationOrgMapFunction.getRealId(reqorg, data);
        if (realRecorgId != 0L) {
            Map<String, Object> relationMap = GetRelationOrgMapFunction.getDelegationOrgList(realRecorgId);
            if (relationMap == null || relationMap.isEmpty() || relationMap.get("data") == null) {
                RecOrgStrategy recOrgStrategy = new RecOrgStrategy();
                return recOrgStrategy.calStrategyOrgId(realRecorgId);
            }
            if (relationMap.get("data") != null) {
                ArrayList orgList = (ArrayList)relationMap.get("data");
                if (orgList.isEmpty()) {
                    RecOrgStrategy recOrgStrategy = new RecOrgStrategy();
                    return recOrgStrategy.calStrategyOrgId(realRecorgId);
                }
                ReqOrgStategy reqOrgStategy = new ReqOrgStategy(orgList);
                return reqOrgStategy.calStrategyOrgId(realReqorgId);
            }
        }
        return 0L;
    }

    private static Map<String, Object> getDelegationOrgList(Long orgId) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType("05");
        param.setToViewType("10");
        param.setDirectViewType("toorg");
        return OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
    }

    private static Long getRealId(String field, Row data) {
        long realId = 0L;
        if ((field = field.trim()) != null && (field.matches("[1-9]+[0-9]*") || "0".equals(field))) {
            return Long.parseLong(field);
        }
        if (field != null && data != null && data.get(field) != null && (realId = data.getLong(field).longValue()) != 0L) {
            return realId;
        }
        return 0L;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

