/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.common.resready.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class ResReadyBussinessUtil {
    private static final String PARTTERN = "^[0-9][0-9]*$";
    private static final String RESREADYPLAN = "resreadyplan";
    private static final String FMM_READYPLAN = "fmm_readyplan";

    public static List<Map<String, Object>> excludeNullCheckBill(List<Map<String, Object>> resModelData, String excludeResTpye) {
        if (resModelData == null) {
            return null;
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(resModelData.size());
        for (Map<String, Object> dataMap : resModelData) {
            Object restype;
            if (dataMap == null || (restype = dataMap.get("restype")) == null) continue;
            String restypeStr = restype.toString();
            if (StringUtils.equals((CharSequence)restypeStr, (CharSequence)excludeResTpye)) {
                resultList.add(dataMap);
                continue;
            }
            Object checkBill = dataMap.get("checkebill");
            if (checkBill == null || !StringUtils.isNotEmpty((CharSequence)checkBill.toString())) continue;
            resultList.add(dataMap);
        }
        return resultList;
    }

    public static Map<String, Object> setCheckBillInfoMap(DynamicObject value) {
        HashMap<String, Object> taskMap = new HashMap<String, Object>(4);
        if (value == null) {
            return taskMap;
        }
        Long projectTaskID = value.getLong("treeentryentity.multprojecttask.fbasedataid_id");
        String taskNumber = value.getString("treeentryentity.multprojecttask.fbasedataid.number");
        String taskName = value.getString("treeentryentity.multprojecttask.fbasedataid.name");
        String workCardID = value.getString("treeentryentity.workcard.id");
        String workCardName = value.getString("treeentryentity.workcard.name");
        String area = value.getString("treeentryentity.area");
        String ataid = value.getString("treeentryentity.ataid");
        String zone = value.getString("treeentryentity.zone");
        String execondition = value.getString("treeentryentity.execondition");
        String majorflag = value.getString("treeentryentity.workcard.majorflag");
        String remark = value.getString("remark");
        taskMap.put("id", projectTaskID);
        taskMap.put("tasknumber", taskNumber);
        taskMap.put("taskname", taskName);
        taskMap.put("workcardid", workCardID);
        taskMap.put("workcardname", workCardName);
        taskMap.put("area", area);
        taskMap.put("functionlocation", zone);
        taskMap.put("atachapterno", ataid);
        taskMap.put("remark", remark);
        taskMap.put("execondition", execondition);
        if (StringUtils.equals((CharSequence)majorflag, (CharSequence)"false")) {
            taskMap.put("majorflag", "0");
        } else {
            taskMap.put("majorflag", "1");
        }
        return taskMap;
    }

    public static long getLongToMapValue(Map<String, Object> chickBillInfoMap, String filedName) {
        Object filedValue;
        long value = 0L;
        if (chickBillInfoMap != null && ((filedValue = chickBillInfoMap.get(filedName)) instanceof Long || filedValue != null && Pattern.matches(PARTTERN, String.valueOf(filedValue)))) {
            value = Long.parseLong(filedValue.toString());
        }
        return value;
    }

    public static String getStringToMapValue(Map<String, Object> chickBillInfoMap, String filedName) {
        Object filedValue;
        String value = "";
        if (chickBillInfoMap != null && (filedValue = chickBillInfoMap.get(filedName)) instanceof String) {
            value = filedValue.toString();
        }
        return value;
    }

    public static DynamicObject getResReadyPlan(Long orgId) {
        Map<String, Object> pomSystemParam = ResReadyBussinessUtil.getPomSystemParam(orgId);
        DynamicObject resReadyPlanDO = ResReadyBussinessUtil.getSysParamResReadyPlan(pomSystemParam);
        return resReadyPlanDO;
    }

    public static Map<String, Object> getPomSystemParam(long orgId) {
        DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (String)"id,orgfunc", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"pom")});
        Map<String, Object> syPparams = ResReadyBussinessUtil.getAppParam(bizApp.getString("id"), bizApp.getString("orgfunc"), orgId, 0L);
        return syPparams;
    }

    public static Map<String, Object> getAppParam(String appId, String viewType, long orgId, long bookId) {
        AppParam appParam = new AppParam();
        appParam.setAppId(appId);
        appParam.setViewType(viewType);
        appParam.setOrgId(Long.valueOf(orgId));
        appParam.setActBookId(Long.valueOf(bookId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }

    public static DynamicObject getSysParamResReadyPlan(Map<String, Object> pomSystemParam) {
        DynamicObject resReadyPlanDO = null;
        if (pomSystemParam != null) {
            Object resReadyPlanObj = pomSystemParam.get(RESREADYPLAN);
            Long resReadyPlanPK = 0L;
            if (resReadyPlanObj instanceof Map) {
                Map resReadyPlanMap = (Map)resReadyPlanObj;
                resReadyPlanPK = Long.parseLong(String.valueOf(resReadyPlanMap.get("id")));
                resReadyPlanDO = BusinessDataServiceHelper.loadSingle((Object)resReadyPlanPK, (String)FMM_READYPLAN);
            } else if (resReadyPlanObj instanceof DynamicObject) {
                Object pkValue = ((DynamicObject)resReadyPlanObj).getPkValue();
                resReadyPlanDO = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)FMM_READYPLAN);
            }
        }
        return resReadyPlanDO;
    }

    public static Map<String, Integer> getLeveLRelationMap(DynamicObject readylevelDO) {
        HashMap<String, Integer> levelMap = new HashMap<String, Integer>(4);
        DynamicObjectCollection entryentity = null;
        if (readylevelDO != null) {
            entryentity = readylevelDO.getDynamicObjectCollection("entryentity");
        }
        if (entryentity != null) {
            for (DynamicObject entityDO : entryentity) {
                String readystatus = entityDO.getString("entryreadystatus");
                int level = entityDO.getInt("entrylevel");
                levelMap.put(readystatus, level);
            }
        }
        return levelMap;
    }

    public static String getLevelToStatus(String finalStatus, String processStatus, Map<String, Integer> levelMap) {
        Integer preLevel;
        if (levelMap == null) {
            return processStatus;
        }
        if (StringUtils.equals((CharSequence)"D", (CharSequence)finalStatus)) {
            preLevel = 0;
        } else {
            Integer n = preLevel = levelMap.get(finalStatus) == null ? Integer.valueOf(-1) : levelMap.get(finalStatus);
        }
        Integer curLevel = StringUtils.equals((CharSequence)"D", (CharSequence)processStatus) ? Integer.valueOf(0) : (levelMap.get(processStatus) == null ? Integer.valueOf(-1) : levelMap.get(processStatus));
        String status = "";
        status = curLevel >= preLevel ? processStatus : finalStatus;
        switch (status) {
            case "A": 
            case "B": 
            case "C": 
            case "D": {
                return status;
            }
        }
        return "A";
    }

    public static Map<String, Integer> getLeveMap(Long orgId) {
        Map<String, Integer> levelMap = new HashMap<String, Integer>(4);
        DynamicObject resReadyPlan = ResReadyBussinessUtil.getResReadyPlan(orgId);
        if (resReadyPlan == null) {
            return levelMap;
        }
        DynamicObject levelDO = resReadyPlan.getDynamicObject("readylevel");
        levelMap = ResReadyBussinessUtil.getLeveLRelationMap(levelDO);
        return levelMap;
    }

    public static String getMetaFlagFromEntityType(MainEntityType srcType, String formulaStr) {
        if (srcType == null || StringUtils.isEmpty((CharSequence)formulaStr)) {
            return "";
        }
        formulaStr = formulaStr.trim();
        DataEntityPropertyCollection properties = srcType.getProperties();
        if (properties.containsKey((Object)formulaStr)) {
            String headField = "";
            if (properties.get((Object)formulaStr) instanceof BasedataProp) {
                BasedataProp baseDataProp = (BasedataProp)properties.get((Object)formulaStr);
                IDataEntityProperty dispProp = baseDataProp.getDispProp();
                if (dispProp == null) {
                    return headField;
                }
                IDataEntityType parent = dispProp.getParent();
                if (parent == null) {
                    return headField;
                }
                headField = parent.getName();
            }
            return headField;
        }
        DataEntityPropertyCollection mateProps = properties;
        String entryField = "";
        String[] formulaStrs = formulaStr.split("\\.");
        for (int i = 0; i < formulaStrs.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)formulaStrs[i]) || !mateProps.containsKey((Object)formulaStrs[i])) continue;
            if (mateProps.get((Object)formulaStrs[i]) instanceof EntryProp) {
                EntryProp propertyType = (EntryProp)mateProps.get((Object)formulaStrs[i]);
                if (propertyType != null) {
                    mateProps = propertyType.getDynamicCollectionItemPropertyType().getProperties();
                    continue;
                }
                return entryField;
            }
            if (!(mateProps.get((Object)formulaStrs[i]) instanceof BasedataProp)) continue;
            BasedataProp baseDataProp = (BasedataProp)mateProps.get((Object)formulaStrs[i]);
            IDataEntityProperty dispProp = baseDataProp.getDispProp();
            if (dispProp == null) {
                return entryField;
            }
            IDataEntityType parent = dispProp.getParent();
            if (parent == null) {
                return entryField;
            }
            entryField = parent.getName();
            break;
        }
        return entryField;
    }

    public static void writeResourceInfo(String mateFlag, String field, List<Map<String, Object>> dataList) {
        DynamicObjectCollection mateDataDOC;
        if (StringUtils.isEmpty((CharSequence)mateFlag) || dataList == null || dataList.isEmpty()) {
            return;
        }
        ArrayList<Long> pkList = new ArrayList<Long>(64);
        ArrayList<String> numberList = new ArrayList<String>(64);
        HashMap<Long, List> pkRelationMap = new HashMap<Long, List>(dataList.size());
        HashMap<String, List> numberRelationMap = new HashMap<String, List>(dataList.size());
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            Object resource = dataMap.get(field);
            if (resource instanceof Long) {
                long pkID = Long.parseLong(resource.toString());
                pkList.add(pkID);
                List defaultList = pkRelationMap.getOrDefault(pkID, new ArrayList());
                defaultList.add(dataMap);
                pkRelationMap.put(pkID, defaultList);
            }
            if (!(resource instanceof String)) continue;
            numberList.add(resource.toString());
            List defaultList = numberRelationMap.getOrDefault(resource.toString(), new ArrayList());
            defaultList.add(dataMap);
            numberRelationMap.put(resource.toString(), defaultList);
        }
        QFilter filter = null;
        if (pkList != null) {
            filter = new QFilter("id", "in", pkList);
        }
        if (numberList != null) {
            if (filter == null) {
                filter = new QFilter("number", "in", numberList);
            } else {
                filter.or(new QFilter("number", "in", numberList));
            }
        }
        if ((mateDataDOC = QueryServiceHelper.query((String)mateFlag, (String)"id,number,name", (QFilter[])new QFilter[]{filter})) == null || mateDataDOC.isEmpty()) {
            return;
        }
        for (DynamicObject mateDataDO : mateDataDOC) {
            int i;
            Long pkid = mateDataDO.getLong("id");
            String number = mateDataDO.getString("number");
            String name = mateDataDO.getString("name");
            if (pkRelationMap != null && pkRelationMap.containsKey(pkid)) {
                List pkDataMapList = pkRelationMap.getOrDefault(pkid, new ArrayList());
                for (i = 0; i < pkDataMapList.size(); ++i) {
                    Map pkDataMap = (Map)pkDataMapList.get(i);
                    if (pkDataMap == null) continue;
                    pkDataMap.put("resourcenumber", number);
                    pkDataMap.put("resourcename", name);
                }
                continue;
            }
            List numberDataMapList = numberRelationMap.getOrDefault(number, new ArrayList());
            for (i = 0; i < numberDataMapList.size(); ++i) {
                Map numberDataMap = (Map)numberDataMapList.get(i);
                if (numberDataMap == null) continue;
                numberDataMap.put("resourcenumber", number);
                numberDataMap.put("resourcename", name);
            }
        }
    }
}

