/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.webapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;

@ApiController(desc="\u751f\u4ea7\u5de5\u5355\u4e1a\u52a1\u64cd\u4f5c\u6267\u884c\u63a5\u53e3", value="mmc")
public class MftOrderWebApiService
implements Serializable {
    private static final int maxCount = 10;

    public Set<String> getOperationType() {
        HashSet<String> operationTypeSet = new HashSet<String>(16);
        operationTypeSet.add("invalid");
        operationTypeSet.add("planconfirm");
        operationTypeSet.add("transmit");
        operationTypeSet.add("untransmit");
        operationTypeSet.add("beginwork");
        operationTypeSet.add("unbeginwork");
        operationTypeSet.add("endwork");
        operationTypeSet.add("unendwork");
        operationTypeSet.add("hangup");
        operationTypeSet.add("unhangup");
        operationTypeSet.add("shut");
        operationTypeSet.add("unshut");
        operationTypeSet.add("submit");
        operationTypeSet.add("unsubmit");
        operationTypeSet.add("delete");
        operationTypeSet.add("audit");
        operationTypeSet.add("unaudit");
        return operationTypeSet;
    }

    public List<Long> getIdList(String orderids) {
        String[] idStr = orderids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>(idStr.length);
        for (String ids : idStr) {
            idList.add(Long.valueOf(ids));
        }
        return idList;
    }

    @ApiPostMapping(value="mftOrderBizOperation")
    public CustomApiResult<String> execMftOrderBizOperation(@NotBlank @ApiParam(value="\u751f\u4ea7\u5de5\u5355\u7684\u8868\u5934\u7684ID\u96c6\u5408,\u591a\u4e2a\u7528\u9017\u53f7\u5206\u9694\uff0c\u5982:123,456", required=true) @NotBlank @ApiParam(value="\u751f\u4ea7\u5de5\u5355\u7684\u8868\u5934\u7684ID\u96c6\u5408,\u591a\u4e2a\u7528\u9017\u53f7\u5206\u9694\uff0c\u5982:123,456", required=true) String orderids, @NotBlank @ApiParam(value="\u64cd\u4f5c\u7c7b\u578b,\u5982\uff1asubmit,unsubmit,delete,audit,unaudit,invalid...\u7b49\u7b49", required=true) @NotBlank @ApiParam(value="\u64cd\u4f5c\u7c7b\u578b,\u5982\uff1asubmit,unsubmit,delete,audit,unaudit,invalid...\u7b49\u7b49", required=true) String operationtype) {
        CustomApiResult result = null;
        Set<String> operationTypeSet = this.getOperationType();
        if (!operationTypeSet.contains(operationtype)) {
            String errorString = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u64cd\u4f5c\u7c7b\u578b\uff08%1$s\uff09\u7cfb\u7edf\u4e0d\u652f\u6301\uff0c\u7cfb\u7edf\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b\u4e3a\uff08%2$s\uff09\u3002", (String)"ErrorCodeEnum_1", (String)"mmc-pom-webapi", (Object[])new Object[0]), operationtype, operationTypeSet.toString());
            return CustomApiResult.fail((String)"mmc.100001", (String)errorString);
        }
        List<Long> idList = this.getIdList(orderids);
        if (idList.size() > 10) {
            String errorString = String.format(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u5141\u8bb8\u5904\u7406\u4e0d\u8d85\u8fc7\uff08%1$s\uff09\u6761\u7684\u751f\u4ea7\u5de5\u5355\u6570\u91cf\u3002", (String)"ErrorCodeEnum_2", (String)"mmc-pom-webapi", (Object[])new Object[0]), 10);
            return CustomApiResult.fail((String)"mmc.100002", (String)errorString);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationtype, (String)"pom_mftorder", (Object[])idList.toArray(), (OperateOption)option);
        HashMap<Object, String> operationMap = new HashMap<Object, String>(1);
        HashSet operationSuccessIds = new HashSet(operationResult.getSuccessPkIds());
        int successfulCount = 0;
        int errorCount = 0;
        for (Long orderID : idList) {
            if (!operationSuccessIds.contains(orderID)) {
                operationMap.put(orderID, this.getErrorByOrderId(orderID, operationResult));
                ++errorCount;
                continue;
            }
            operationMap.put(orderID, "successful");
            ++successfulCount;
        }
        operationMap.put("successfulCount", String.valueOf(successfulCount));
        operationMap.put("errorCount", String.valueOf(errorCount));
        String returnString = SerializationUtils.toJsonString(operationMap);
        if (errorCount > 0) {
            String errorString = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u53d1\u751f\u9519\u8bef\uff1a%1$s", (String)"ErrorCodeEnum_3", (String)"mmc-pom-webapi", (Object[])new Object[0]), returnString);
            return CustomApiResult.fail((String)"mmc.100009", (String)errorString);
        }
        result = CustomApiResult.success((Object)returnString);
        result.setData((Object)returnString);
        return result;
    }

    private String getErrorByOrderId(Object orderID, OperationResult operationResult) {
        StringBuilder sf = new StringBuilder();
        sf.append("error:");
        for (IOperateInfo errInfo : operationResult.getAllErrorOrValidateInfo()) {
            if (!errInfo.getPkValue().toString().equals(orderID.toString())) continue;
            sf.append(errInfo.getMessage()).append("\r\n");
        }
        return sf.toString();
    }
}

