/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.mro.mservice;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pom.mro.mservice.AbstractOrderDeleteValidator;

public class MroOrderDeleteValidService
extends AbstractOrderDeleteValidator {
    @Override
    public Map<Long, String> deleteValidate(Set<Long> ids) {
        Map<Long, String> validMroOrder = this.validMroOrder(ids);
        Map<Long, String> validMroTechnis = this.validMroTechnis(ids);
        validMroOrder = this.mergeMap(validMroOrder, validMroTechnis);
        return validMroOrder;
    }

    private Map<Long, String> mergeMap(Map<Long, String> sourceMap, Map<Long, String> targetMap) {
        for (Map.Entry<Long, String> target : targetMap.entrySet()) {
            Long id = target.getKey();
            String targetValue = target.getValue();
            String sourceValue = sourceMap.get(id);
            if (sourceValue == null) {
                sourceMap.put(id, targetValue);
                continue;
            }
            sourceMap.put(id, sourceValue + targetValue);
        }
        return sourceMap;
    }

    private Map<Long, String> validMroOrder(Set<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        HashMap<Long, String> result = new HashMap<Long, String>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)MroOrderDeleteValidService.class.getName(), (String)"pom_mroorder", (String)"id,billno,billstatus", (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                Long pk = row.getLong("id");
                String billstatus = row.getString("billstatus");
                String billno = row.getString("billno");
                if (billstatus == null || "A".equals(billstatus)) continue;
                result.put(pk, String.format(ResManager.loadKDString((String)"%1$s \u53ea\u80fd\u5220\u9664\u6682\u5b58\u7684\u5355\u636e\u3002", (String)"MroOrderDeleteValidService_0", (String)"mmc-pom-mservice", (Object[])new Object[0]), billno));
            }
        }
        return result;
    }

    private Map<Long, String> validMroTechnis(Set<Long> ids) {
        HashSet<String> orderid = new HashSet<String>(8);
        for (Long pk : ids) {
            orderid.add(pk.toString());
        }
        QFilter filter = new QFilter("manufactureorderid", "in", (Object)orderid.toArray());
        HashSet strs = Sets.newHashSet((Object[])new String[]{"A", "B", "C"});
        HashMap<Long, String> result = new HashMap<Long, String>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)MroOrderDeleteValidService.class.getName(), (String)"sfc_mromanuftech", (String)"manufactureorderid,billno,oprentryentity.oprno,oprentryentity.oprstatus", (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                Long pk = Long.valueOf(row.getString("manufactureorderid"));
                String billno = row.getString("billno");
                String oprstatus = row.getString("oprentryentity.oprstatus");
                String oprno = row.getString("oprentryentity.oprno");
                if (oprstatus == null || strs.contains(oprstatus)) continue;
                result.put(pk, String.format(ResManager.loadKDString((String)"%1$s\u5de5\u5e8f[%2$s]\u5b58\u5728\u4e0b\u8fbe\u6216\u540e\u7eed\u64cd\u4f5c,\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MroOrderDeleteValidService_1", (String)"mmc-pom-mservice", (Object[])new Object[0]), billno, oprno));
            }
        }
        return result;
    }
}

