/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mmc.pom.mservice.api.IMroNrcDeleteService;

public class MroNrcDeleteServiceImpl
implements IMroNrcDeleteService {
    private static String POM_MRONRC = "pom_mronrc";
    private static Map<String, String> opKeyMap = new HashMap<String, String>(8);

    public Map<String, Object> deleteNrc(Set<Object> ids) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        QFilter idsFilter = new QFilter("treeentryentity.project", "in", ids);
        HashSet<String> billStatus = new HashSet<String>(2);
        billStatus.add("A");
        billStatus.add("B");
        QFilter billStatusFilter = new QFilter("billstatus", "in", billStatus);
        HashSet<String> approvalStatus = new HashSet<String>(2);
        approvalStatus.add("A");
        approvalStatus.add("E");
        QFilter approvalStatusFilter = new QFilter("approvalstatus", "in", approvalStatus);
        idsFilter.and(billStatusFilter);
        idsFilter.and(approvalStatusFilter);
        String selectProperties = "id,billno,billstatus,treeentryentity.project";
        DynamicObject[] loadNrcIds = BusinessDataServiceHelper.load((String)"pom_mronrc", (String)selectProperties, (QFilter[])new QFilter[]{idsFilter});
        HashSet<Long> unsubmitNrc = new HashSet<Long>(loadNrcIds.length);
        HashSet<Long> deleteNrc = new HashSet<Long>(loadNrcIds.length);
        HashMap<Long, String> nrcNameMap = new HashMap<Long, String>(loadNrcIds.length);
        for (DynamicObject nrcTmpId : loadNrcIds) {
            String billstatus = nrcTmpId.getString("billstatus");
            if ("A".equals(billstatus)) {
                deleteNrc.add(nrcTmpId.getLong("id"));
            } else if ("B".equals(billstatus)) {
                unsubmitNrc.add(nrcTmpId.getLong("id"));
            }
            nrcNameMap.put(nrcTmpId.getLong("id"), nrcTmpId.getString("billno"));
        }
        StringBuilder error = new StringBuilder();
        if (unsubmitNrc != null && !unsubmitNrc.isEmpty()) {
            List<Object> unsubmitSuccess = this.opNrcOrder(unsubmitNrc, nrcNameMap, error, "unsubmit");
            for (Object nrc : unsubmitSuccess) {
                deleteNrc.add((Long)nrc);
            }
        }
        if (deleteNrc != null && !deleteNrc.isEmpty()) {
            this.opNrcOrder(deleteNrc, nrcNameMap, error, "delete");
        }
        if (error.toString().length() > 255) {
            result.put("success", "true");
            result.put("msg", error.toString().substring(0, 255));
        } else {
            result.put("success", "true");
            result.put("msg", error.toString());
        }
        return result;
    }

    private List<Object> opNrcOrder(Set<Long> opNrc, Map<Long, String> nrcNameMap, StringBuilder error, String opKey) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)opKey, (String)POM_MRONRC, (Object[])opNrc.toArray(), (OperateOption)OperateOption.create());
        List operationSuccessPkIds = operationResult.getSuccessPkIds();
        if (operationSuccessPkIds.size() < opNrc.size()) {
            opNrc.removeAll(operationSuccessPkIds);
            if (!opNrc.isEmpty()) {
                ArrayList<String> errorName = new ArrayList<String>(opNrc.size());
                for (Long pid : opNrc) {
                    if (!nrcNameMap.containsKey(pid)) continue;
                    errorName.add(nrcNameMap.get(pid));
                }
                error.append(String.format(ResManager.loadKDString((String)"%1$s\u5de5\u5355%2$s\u5931\u8d25\uff1a%3$s", (String)"MroNrcDeleteServiceImpl_6", (String)"mmc-pom-mservice", (Object[])new Object[0]), opKeyMap.get(opKey), String.join((CharSequence)"\u3001", errorName), this.getErrDetail(operationResult)));
            }
        }
        return operationSuccessPkIds;
    }

    private String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        if (optResult.getMessage() != null) {
            errDetail.append(optResult.getMessage().replaceAll("\\(\\)", "").replaceAll("</br>", ""));
        }
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage().replaceAll("\\(\\)", "").replaceAll("</br>", ""));
        }
        return errDetail.toString();
    }

    static {
        opKeyMap.put("unsubmit", ResManager.loadKDString((String)"\u64a4\u9500", (String)"MroNrcDeleteServiceImpl_4", (String)"mmc-pom-mservice", (Object[])new Object[0]));
        opKeyMap.put("delete", ResManager.loadKDString((String)"\u5220\u9664", (String)"MroNrcDeleteServiceImpl_5", (String)"mmc-pom-mservice", (Object[])new Object[0]));
    }
}

