/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.mservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pom.mservice.api.IProjectReleasableService;

public class ProjectReleasableServiceImpl
implements IProjectReleasableService {
    private static final String BILL_STANDARD = "D";
    private static final String TASK_STANDARD = "CEFJ";

    public Map<Long, Boolean> queryAllOrderOfProjectState(List<Long> projectIds) {
        QFilter qFilter = new QFilter("treeentryentity.project.id", "in", projectIds);
        DataSet mroOrders = QueryServiceHelper.queryDataSet((String)"pom.mroorder", (String)"pom_mroorder", (String)"billstatus, treeentryentity.project.id, treeentryentity.taskstatus, mroordertypeid.number", (QFilter[])qFilter.toArray(), null);
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(16);
        for (Long projectId : projectIds) {
            result.put(projectId, Boolean.TRUE);
        }
        for (Row mroOrder : mroOrders) {
            String orderType = mroOrder.getString("mroordertypeid.number");
            if (orderType.equals("OVERHEADJOB_S")) continue;
            Long orderId = mroOrder.getLong("treeentryentity.project.id");
            String billStatus = mroOrder.getString("billstatus");
            String taskStatus = mroOrder.getString("treeentryentity.taskstatus");
            Boolean releasable = BILL_STANDARD.equals(billStatus) || TASK_STANDARD.contains(taskStatus);
            result.merge(orderId, releasable, (oldValue, newValue) -> {
                if (oldValue.booleanValue() && !newValue.booleanValue()) {
                    return false;
                }
                return oldValue;
            });
        }
        return result;
    }
}

