/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.mservice.upgrade;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.mmc.pom.mservice.upgrade.entity.SubinStorageEntity;
import org.apache.commons.collections4.CollectionUtils;

public class PlanBaseQty4PomXUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(PlanBaseQty4PomXUpgradeServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        DataSet srcEntryId = null;
        try {
            srcEntryId = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)"select fentryid, funit, fbaseunit, fmaterielmasterid ,fplanqty from t_pom_xmftorderentry t where t.fplanbaseqty is null or t.fplanbaseqty = 0");
            ArrayList<SubinStorageEntity> detailIds = new ArrayList<SubinStorageEntity>(10);
            while (srcEntryId.hasNext()) {
                Row row = srcEntryId.next();
                SubinStorageEntity subinStorageEntity = new SubinStorageEntity();
                subinStorageEntity.setManufactureEntryId(row.getLong("fentryid"));
                subinStorageEntity.setUnit(row.getLong("funit"));
                subinStorageEntity.setBaseunit(row.getLong("fbaseunit"));
                subinStorageEntity.setMaterielmasterid(row.getLong("fmaterielmasterid"));
                subinStorageEntity.setPlanqty(row.getBigDecimal("fplanqty"));
                detailIds.add(subinStorageEntity);
            }
            result.setLog(String.format(ResManager.loadKDString((String)"\u9700\u8981update\u6570\u636e\u7684size %1$s", (String)"PlanBaseQty4PomXUpgradeServiceImpl_3", (String)"mmc-pom-mservice", (Object[])new Object[0]), detailIds.size()));
            String updateInvTypeSql = "update t_pom_xmftorderentry set fplanbaseqty = ? where fentryid = ?";
            ArrayList paramsList = new ArrayList(10);
            detailIds.forEach(var -> {
                BigDecimal decimal = var.getPlanqty();
                decimal = this.getQty((SubinStorageEntity)var, decimal);
                paramsList.add(new Object[]{decimal, var.getManufactureEntryId()});
            });
            result.setLog(String.format(ResManager.loadKDString((String)"\u7ec4\u88c5SQL\u53c2\u6570\u7684size %1$s", (String)"PlanBaseQty4PomXUpgradeServiceImpl_4", (String)"mmc-pom-mservice", (Object[])new Object[0]), paramsList.size()));
            if (CollectionUtils.isNotEmpty(paramsList)) {
                List partition = Lists.partition(paramsList, (int)1000);
                result.setLog(String.format(ResManager.loadKDString((String)"\u7ec4\u88c5SQL\u53c2\u6570\u5207\u5272\u540e\u7684size %1$s", (String)"PlanBaseQty4PomXUpgradeServiceImpl_5", (String)"mmc-pom-mservice", (Object[])new Object[0]), partition.size()));
                for (List objects : partition) {
                    this.batchUpdate(scmRoute, objects, updateInvTypeSql);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            result.setLog(e.toString());
            result.setSuccess(false);
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
        finally {
            if (null != srcEntryId) {
                srcEntryId.close();
            }
        }
        result.setSuccess(true);
        return result;
    }

    private BigDecimal getQty(SubinStorageEntity subinStorageEntity, BigDecimal qty) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = UnitConvertHelper.calculateNewQty((BigDecimal)qty, (Long)subinStorageEntity.getBaseunit(), (Long)subinStorageEntity.getUnit(), (Long)subinStorageEntity.getMaterielmasterid(), (StringBuilder)new StringBuilder());
        }
        catch (Throwable throwable) {
            return BigDecimal.ZERO;
        }
        return bigDecimal;
    }

    private void batchUpdate(DBRoute scmRoute, List<Object[]> objects, String updateInvTypeSql) {
        ThreadPools.executeOnceIncludeRequestContext((String)"QtyUpgradeServiceImpl", (Runnable)ThreadLifeCycleManager.wrapRunnable(() -> DB.executeBatch((DBRoute)scmRoute, (String)updateInvTypeSql, (List)objects)));
    }
}

