/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.mservice.upgrade.xstock;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

public class SplitSQLHelper {
    public static Map<Integer, Object[]> getExecSqlParams(String algoKey, DBRoute route, String splitTablename, String idcol, int BATCH_EXEC_NUMS) {
        String countSql = "select count(1) as count,min(" + idcol + ") as minid,max(" + idcol + ") as maxid from " + splitTablename;
        long count = 0L;
        long minid = 0L;
        long maxid = 0L;
        try (DataSet countSet = DB.queryDataSet((String)algoKey, (DBRoute)route, (String)countSql);){
            for (Row row : countSet) {
                count = row.getLong("count");
                if (count <= 0L) continue;
                minid = row.getLong("minid");
                maxid = row.getLong("maxid");
                break;
            }
        }
        if (count <= 0L) {
            return Collections.emptyMap();
        }
        if (count <= (long)BATCH_EXEC_NUMS) {
            return Collections.singletonMap(1, new Object[]{minid, maxid + 1L});
        }
        int batchs = 0;
        if (BATCH_EXEC_NUMS != 0) {
            batchs = new BigDecimal(count).divide(new BigDecimal(BATCH_EXEC_NUMS), 10, RoundingMode.CEILING).intValue();
        }
        HashMap<Integer, Object[]> params = new HashMap<Integer, Object[]>(batchs);
        HashMap<Integer, Object[]> paramsReorder = new HashMap<Integer, Object[]>(batchs);
        long idFrom = minid;
        long idTo = 0L;
        String nextIdSql = "select top 1," + BATCH_EXEC_NUMS + " " + idcol + " as id from " + splitTablename + " where " + idcol + " >= ?" + " order by " + idcol;
        for (int i = 1; i <= batchs; ++i) {
            Object[] param = new Object[2];
            if (i == batchs) {
                idTo = maxid + 1L;
            } else {
                try (DataSet nextIdtoSet = SplitSQLHelper.getNextIdtoSet(algoKey, route, idFrom, nextIdSql);){
                    if (nextIdtoSet.hasNext()) {
                        Row row = nextIdtoSet.next();
                        idTo = row.getLong("id");
                    }
                }
            }
            param[0] = idFrom;
            param[1] = idTo;
            params.put(i, param);
            idFrom = idTo;
        }
        int index = 1;
        for (int i = 1; i <= 3; ++i) {
            for (int j = i; j <= batchs; j += 3) {
                Object[] param = (Object[])params.get(j);
                paramsReorder.put(index, param);
                ++index;
            }
        }
        return paramsReorder;
    }

    private static DataSet getNextIdtoSet(String algoKey, DBRoute route, long idFrom, String nextIdSql) {
        return DB.queryDataSet((String)algoKey, (DBRoute)route, (String)nextIdSql, (Object[])new Object[]{idFrom});
    }
}

