/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.distr;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.business.distr.helper.DistrUtil;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.step.ICalcStep;

public class CreateDistribPlan
implements ICalcStep {
    protected static final Log log = LogFactory.getLog(CreateDistribPlan.class);
    String entrydetailmsg = "";
    String entrydetailmsg_tag = "";
    private long logid = 0L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doWork(ExecutionEnv env, int stepIdx) {
        try (AlgoContext algoContext = Algo.newContext();){
            String string = this.doExecute(env, stepIdx);
            return string;
        }
    }

    private String doExecute(ExecutionEnv env, int stepIdx) {
        String logEntityNumber = env.getLogEntityNumber();
        this.logid = env.getCtxId();
        DynamicObjectCollection ordersColl = QueryServiceHelper.query((String)"pom_distplansuggest", (String)"billno,id,gourpid,supplybillid", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)this.logid)});
        if (ordersColl == null || ordersColl.isEmpty()) {
            return "";
        }
        Object[] ids = ordersColl.stream().map(o -> o.getLong("id")).toArray();
        String msg = ResManager.loadKDString((String)"\u5171%1$d\u6761\uff0c\u4e0b\u63a8%2$d\u6761\u3002", (String)"CreateDistribPlan_02", (String)"mmc-pom-business", (Object[])new Object[0]);
        this.entrydetailmsg = String.format(msg, ordersColl.size(), ids.length);
        if (ids.length > 0) {
            this.doPush(ids);
        }
        this.logCount(stepIdx, logEntityNumber, env);
        return "";
    }

    private void logCount(int stepIdx, String logEntityNumber, ExecutionEnv env) {
        DynamicObject runlog = BusinessDataServiceHelper.loadSingle((Object)this.logid, (String)logEntityNumber);
        DynamicObjectCollection entryentity = runlog.getDynamicObjectCollection("entryentity");
        List list = entryentity.stream().filter(o -> String.valueOf(stepIdx).equals(o.getString("entrystepseq"))).collect(Collectors.toList());
        if (!list.isEmpty()) {
            DynamicObjectCollection distribplanColl = QueryServiceHelper.query((String)"pom_distribplan", (String)"id", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)this.logid)});
            if (distribplanColl != null) {
                ((DynamicObject)list.get(0)).set("entryprocessdata", (Object)distribplanColl.size());
            }
            ((DynamicObject)list.get(0)).set("entrydetailmsg", (Object)this.entrydetailmsg);
            ((DynamicObject)list.get(0)).set("entrydetailmsg_tag", (Object)this.entrydetailmsg_tag);
            SaveServiceHelper.update((DynamicObject)runlog);
        }
    }

    private void doPush(Object[] ids) {
        if (ids.length > 0) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"createdistribplan", (String)"pom_distplansuggest", (Object[])ids, (OperateOption)this.getOperateOption());
            this.entrydetailmsg_tag = DistrUtil.getErrorString(operationResult);
            if (!operationResult.isSuccess()) {
                throw new KDBizException(this.entrydetailmsg_tag);
            }
        }
    }

    private OperateOption getOperateOption() {
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(true));
        saveOption.setVariableValue("ignoreValidation", String.valueOf(true));
        saveOption.setVariableValue("ishasright", String.valueOf(true));
        saveOption.setVariableValue("WF", "false");
        return saveOption;
    }
}

