/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.distr;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mmc.pom.business.distr.task.DistrPlanPushBatchTaskEvent;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.step.ICalcStep;

public class CreateDistribPlanByBatchTask
implements ICalcStep {
    protected static final Log log = LogFactory.getLog(CreateDistribPlanByBatchTask.class);
    private int calcCount = 0;
    private long logid = 0L;
    private DynamicObject runlog;
    String logEntityNumber = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doWork(ExecutionEnv env, int stepIdx) {
        int count;
        this.logEntityNumber = env.getLogEntityNumber();
        this.logid = env.getCtxId();
        this.runlog = BusinessDataServiceHelper.loadSingle((Object)env.getCtxId(), (String)this.logEntityNumber);
        DataSet calcDataSet = QueryServiceHelper.queryDataSet((String)"kd.mmc.pom.business.distr.CreateDistribPlanByTask:doWork", (String)"pom_distplansuggest", (String)"id,gourpid", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)this.logid)}, null);
        calcDataSet = calcDataSet.groupBy(new String[]{"gourpid"}).groupConcat("id").finish();
        CacheHint hint = new CacheHint();
        hint.setTimeout(2L, TimeUnit.HOURS);
        CachedDataSet cachedDataSet = calcDataSet.cache(hint);
        this.calcCount = count = cachedDataSet.getRowCount();
        if (count == 0) {
            return "";
        }
        Object sliceSizeObj = SystemParamServiceHelper.getBillParameter((String)"pom_distribplan", (String)"slicesize");
        Object queueNameObj = SystemParamServiceHelper.getBillParameter((String)"pom_distribplan", (String)"queuename");
        int sliceSize = 1000;
        String queueName = "kd.mmc.pom.business.batcktask.POMBatchTaskConsumer_queue";
        if (sliceSizeObj instanceof Integer) {
            sliceSize = (Integer)sliceSizeObj;
        }
        if (queueNameObj instanceof String) {
            queueName = (String)queueNameObj;
        }
        String cacheId = cachedDataSet.getCacheId();
        BatchTask task = BatchTask.create((String)"CreateDistribPlanByTask");
        String taskId = task.getCalcId();
        task.setQueueName(queueName);
        task.registBizClass(DistrPlanPushBatchTaskEvent.class);
        int rowCount = cachedDataSet.getRowCount();
        int total = rowCount / sliceSize;
        if (rowCount % sliceSize > 0) {
            ++total;
        }
        for (int i = 0; i < total; ++i) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("cacheId", cacheId);
            params.put("index", i);
            params.put("total", total);
            params.put("logEntityNumber", this.logEntityNumber);
            params.put("logid", this.logid);
            task.addEvent(params);
        }
        boolean successful = true;
        try {
            log.info("BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb...");
            task.startTask();
            log.info("BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...");
        }
        catch (Exception e) {
            log.error("BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            if (e instanceof KDBizException) {
                throw (KDBizException)e;
            }
            successful = false;
        }
        finally {
            task.terminate();
        }
        if (!successful) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7", (String)"CreateDistribPlanByTask_0", (String)"mmc-pom-business", (Object[])new Object[0]));
        }
        if (calcDataSet != null) {
            calcDataSet.close();
        }
        if (cachedDataSet != null) {
            cachedDataSet.close();
        }
        this.logCount(stepIdx, this.logEntityNumber, env);
        return "";
    }

    private void logCount(int stepIdx, String logEntityNumber, ExecutionEnv env) {
        DynamicObject runlog = BusinessDataServiceHelper.loadSingle((Object)this.logid, (String)logEntityNumber);
        DynamicObjectCollection entryentity = runlog.getDynamicObjectCollection("entryentity");
        List list = entryentity.stream().filter(o -> String.valueOf(stepIdx).equals(o.getString("entrystepseq"))).collect(Collectors.toList());
        if (list.size() > 0) {
            ((DynamicObject)list.get(0)).set("entryprocessdata", (Object)this.calcCount);
            SaveServiceHelper.update((DynamicObject)runlog);
        }
    }
}

