/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.distr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CoGroupDataSetX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mmc.pom.business.distr.algox.AddDefaultDistrTypeMapFunction;
import kd.mmc.pom.business.distr.algox.DemandSupplyMatchCoGroupFunc;
import kd.mmc.pom.business.distr.algox.DistrPlanMergeCycleCoGroupFunc;
import kd.mmc.pom.business.distr.algox.DistrPlanMergeDimensionCoGroupFunc;
import kd.mmc.pom.business.distr.helper.ReserveHelper;
import kd.mpscmm.msplan.mservice.service.datafetch.DataFetcher;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.step.ICalcStep;

public class DistrPlanCalcV2
implements ICalcStep {
    protected static final Log log = LogFactory.getLog(DistrPlanCalcV2.class);
    private DynamicObject plan;
    private ExecutionEnv env;
    private DynamicObject runlog;
    private int calcCount = 0;
    private Map<Long, Long> orgParams = new HashMap<Long, Long>();
    private Map<String, Object> entrydetailmsg = new HashMap<String, Object>();
    private String qFilterStr = null;
    private String srcBillEntity = null;
    private int _stepIdx = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doWork(ExecutionEnv env, int stepIdx) {
        try (AlgoContext algoContext = Algo.newContext();){
            this._stepIdx = stepIdx;
            String string = this.doExecute(env, stepIdx);
            return string;
        }
    }

    private String doExecute(ExecutionEnv executionEnv, int stepIdx) {
        DynamicObject billType;
        this.env = executionEnv;
        String logEntityNumber = this.env.getLogEntityNumber();
        this.runlog = BusinessDataServiceHelper.loadSingle((Object)this.env.getCtxId(), (String)logEntityNumber);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(logEntityNumber);
        String algoCacheId = (String)cache.get(String.valueOf(this.env.getCtxId()), "algoCacheId");
        this.qFilterStr = (String)cache.get(String.valueOf(this.env.getCtxId()), "qFilterStr");
        this.srcBillEntity = (String)cache.get(String.valueOf(this.env.getCtxId()), "srcBillEntity");
        this.entrydetailmsg.put("qFilterStr", this.qFilterStr);
        this.entrydetailmsg.put("srcBillEntity", this.srcBillEntity);
        DataSet filterDataSet = null;
        if (StringUtils.isNotEmpty((CharSequence)algoCacheId)) {
            CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)algoCacheId);
            filterDataSet = cachedDataSet.toDataSet(Algo.create((String)"DistrPlanCalc:algoCache"), true);
        }
        String planEntityNumber = this.runlog.getString("plangramentity");
        Object planId = this.runlog.get("plangram");
        this.plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)planEntityNumber);
        this.loadOrgParams();
        DynamicObjectCollection supCollection = this.plan.getDynamicObjectCollection("scentryentity");
        int planoutlook = this.plan.getInt("planoutlook");
        String outofdate = this.plan.getString("outofdate");
        Date plandate = this.runlog.getDate("plandate");
        Calendar instance = Calendar.getInstance();
        instance.setTime(plandate);
        instance.add(5, 1);
        instance.add(5, planoutlook);
        Date endDate = instance.getTime();
        DataSet dataSet = this.getReqData(outofdate, plandate, endDate, filterDataSet);
        if (dataSet == null) {
            return "";
        }
        Set<Long> materialIdSet = this.buildSupQfilter(dataSet);
        this.entrydetailmsg.put("materialIdSet", materialIdSet);
        dataSet = this.reqDataExt(dataSet);
        JobSession session = AlgoX.createSession((String)DistrPlanCalcV2.class.getName(), (String)DistrPlanCalcV2.class.getName());
        DataSetInput dataSetInput = new DataSetInput(dataSet);
        DataSetX reqDataSetX = session.fromInput((Input)dataSetInput);
        reqDataSetX = this.checkCalcField(reqDataSetX);
        DataSet distrTypeDataSet = QueryServiceHelper.queryDataSet((String)"kd.mmc.pom.business.distr.DistrPlanCalc:mpdm_distrtype", (String)"mpdm_distrtype", (String)"id,mergecycle,mergedimension,isfoodconveyer", (QFilter[])new QFilter[]{new QFilter("id", ">", (Object)0L)}, null);
        distrTypeDataSet = distrTypeDataSet.select(new String[]{"id", "mergecycle", "mergedimension", "case when isfoodconveyer then  '1' else '0' end as isfoodconveyer"});
        DataSetInput distrTypeDataSetInput = new DataSetInput(distrTypeDataSet);
        DataSetX distrTypeDataSetX = session.fromInput((Input)distrTypeDataSetInput);
        reqDataSetX = this.calcDistrType(session, reqDataSetX, distrTypeDataSetX);
        reqDataSetX = reqDataSetX.join(distrTypeDataSetX).on("distrtype", "id").select(reqDataSetX.getRowMeta().getFieldNames(), new String[]{"mergecycle", "mergedimension"});
        reqDataSetX = reqDataSetX.coGroup(distrTypeDataSetX, (CoGroupFunction)new DistrPlanMergeCycleCoGroupFunc(reqDataSetX.getRowMeta(), distrTypeDataSetX.getRowMeta())).on("distrtype", "id");
        reqDataSetX = reqDataSetX.addFields(new Field[]{new Field("gourpid", (DataType)DataType.StringType)}, new Object[]{""});
        reqDataSetX = reqDataSetX.coGroup(distrTypeDataSetX, (CoGroupFunction)new DistrPlanMergeDimensionCoGroupFunc(reqDataSetX.getRowMeta(), distrTypeDataSetX.getRowMeta())).on("distrtype", "id");
        reqDataSetX = reqDataSetX.orderBy(new String[]{"gourpid"});
        reqDataSetX = reqDataSetX.filter("demandqty >0 ");
        reqDataSetX = reqDataSetX.orderBy(new String[]{"billdate"});
        reqDataSetX = this.supplyCalc(supCollection, session, reqDataSetX, materialIdSet);
        String distrRType = this.plan.getString("distrrtype");
        long billTypeId = 0L;
        if ("0".equals(distrRType)) {
            billType = BusinessDataServiceHelper.loadSingle((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"pom_distribplan_instruct_BT_S")});
            if (billType != null) {
                billTypeId = billType.getLong("id");
            }
        } else {
            billType = BusinessDataServiceHelper.loadSingle((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"pom_distribplan_BT_S")});
            if (billType != null) {
                billTypeId = billType.getLong("id");
            }
        }
        DataSetOutput output = new DataSetOutput(reqDataSetX.getRowMeta());
        String outputId = output.getId();
        reqDataSetX.output((Output)output);
        session.commit(2, TimeUnit.HOURS);
        DataSet requirementData = session.readDataSet(outputId);
        requirementData = this.addToDBField(requirementData, this.env.getCtxId());
        requirementData = requirementData.addField(String.valueOf(billTypeId), "targetbilltype");
        this.buildDistplanSuggest(requirementData);
        this.logCount(stepIdx, logEntityNumber);
        return "";
    }

    private DataSet reloadByLock(DataSet filterDataSet, int day, String outofdate, Date plandate, Date endDate, DataSet dataSet, Set<Long> materialIdSet) {
        DynamicObjectCollection reqCollection;
        List modelIds;
        DynamicObject srcIsDistribplan;
        boolean oneSuccess = this.lock(materialIdSet);
        if (!oneSuccess && (srcIsDistribplan = QueryServiceHelper.queryOne((String)"mrp_resource_dataconfig", (String)"billfieldtransfer.srcbill.number", (QFilter[])new QFilter[]{new QFilter("id", "in", modelIds = (reqCollection = this.plan.getDynamicObjectCollection("entryentity")).stream().filter(o -> o.getBoolean("entryismrpoperat")).map(o -> o.getLong("resourceregister.id")).collect(Collectors.toList())), new QFilter("billfieldtransfer.srcbill.number", "=", (Object)"pom_distribplan")})) != null && (dataSet = this.getReqData(outofdate, plandate, endDate, filterDataSet)) == null) {
            return null;
        }
        return dataSet;
    }

    private DataSet getReqData(String outofdate, Date plandate, Date endDate, DataSet filterDataSet) {
        DataSet dataSet = this.getReqDataSet(filterDataSet);
        if (dataSet == null) {
            return null;
        }
        dataSet = DistrPlanCalcV2.formatEntryEntity(dataSet);
        HashMap<String, Date> params = new HashMap<String, Date>(16);
        params.put("endDate", endDate);
        dataSet = dataSet.filter("billdate < endDate", params);
        if (filterDataSet != null) {
            DataSet filter = filterDataSet;
            filter = DistrPlanCalcV2.formatEntryEntity(filter);
            RowMeta rowMeta = filter.getRowMeta();
            String[] fieldNames = rowMeta.getFieldNames();
            JoinDataSet join = filter.join(dataSet);
            for (String field : fieldNames) {
                join = join.on(field, field);
            }
            dataSet = join.select(new String[0], dataSet.getRowMeta().getFieldNames()).finish();
        }
        if ("2".equals(outofdate)) {
            int day = this.plan.getInt("day");
            Calendar instance = Calendar.getInstance();
            instance.setTime(plandate);
            instance.add(5, -day);
            Date startDate = instance.getTime();
            params.put("startDate", startDate);
            dataSet = dataSet.filter("billdate >= startDate", params);
        }
        dataSet = this.bomExpand(dataSet);
        if (this.orgParams.size() > 0) {
            dataSet = dataSet.filter(new FilterFunction(){

                public boolean test(Row row) {
                    return DistrPlanCalcV2.this.orgParams.containsKey(row.getLong("productionorgunit"));
                }
            });
        }
        return dataSet;
    }

    private boolean lock(Set<Long> materialIdSet) {
        int hx_retrycountmax = 1000;
        Object hx_retrycountObj = SystemParamServiceHelper.getBillParameter((String)"pom_distribplan", (String)"hx_retrycountmax");
        if (hx_retrycountObj instanceof Integer) {
            hx_retrycountmax = (Integer)hx_retrycountObj;
        }
        if (hx_retrycountmax == 0) {
            return true;
        }
        Map<String, String> lockInfo = this.checkLock(materialIdSet);
        boolean oneSuccess = true;
        for (int reTryCount = 0; !"true".equals(lockInfo.get("success")) && reTryCount < hx_retrycountmax; ++reTryCount) {
            oneSuccess = false;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            lockInfo = this.checkLock(materialIdSet);
            lockInfo.put("reTryCount", String.valueOf(reTryCount));
            this.entrydetailmsg.put("lockInfo", lockInfo);
            this.logCount(this._stepIdx, this.env.getLogEntityNumber());
        }
        ThreadPools.executeOnce((String)"DistrPlanCalcExt_release", () -> this.doRelease(this.env.getCtxId(), this.env.getLogEntityNumber()));
        return oneSuccess;
    }

    private String getCalcStatus(Long id, String logEntityNumber) {
        String status = "";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)logEntityNumber, (String)"calculatestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (dynamicObject != null) {
            status = dynamicObject.getString("calculatestatus");
        }
        return status;
    }

    private void doRelease(Long id, String logEntityNumber) {
        String status = this.getCalcStatus(id, logEntityNumber);
        int i = 0;
        while ("D".equals(status)) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            status = this.getCalcStatus(id, logEntityNumber);
            if (++i <= 10000) continue;
        }
        String sql = "update tk_hx_pom_distrcalcqueue set fk_hx_lockstatus='C' where fk_hx_logid=?";
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql, (Object[])new Object[]{id});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> checkLock(Set<Long> materialIdSet) {
        HashMap<String, String> lockInfo = new HashMap<String, String>(16);
        if (materialIdSet == null || materialIdSet.isEmpty()) {
            lockInfo.put("msg", "materialIdSet isEmpty ");
            lockInfo.put("success", String.valueOf(true));
            return lockInfo;
        }
        boolean flag = false;
        DLock lock = DLock.create((String)"distr_checkLock", (String)"distr_checkLock");
        lock.lock();
        try {
            QFilter filter = new QFilter("hx_materiel", "in", materialIdSet);
            filter.and("hx_lockstatus", "=", (Object)"A");
            filter.and("createtime", ">", (Object)new Date(System.currentTimeMillis() - 3600000L));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"hx_pom_distrcalcqueue", (String)"hx_logid,hx_lockstatus,hx_materiel", (QFilter[])new QFilter[]{filter});
            if (dynamicObjects == null || dynamicObjects.isEmpty()) {
                this.addCalcQueue(materialIdSet);
                flag = true;
            }
        }
        finally {
            lock.unlock();
        }
        lockInfo.put("success", String.valueOf(flag));
        return lockInfo;
    }

    private void addCalcQueue(Set<Long> materialIdSet) {
        String sql = "insert into tk_hx_pom_distrcalcqueue(fid, fbillno, fbillstatus, fcreatorid, fcreatetime, fk_hx_lockstatus, fk_hx_logid,fk_hx_materiel)values (?,?,'C',?,now(),'A',?,?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        long[] genLongIds = ID.genLongIds((int)materialIdSet.size());
        int i = 0;
        long curUserId = RequestContext.get().getCurrUserId();
        for (Long materialiId : materialIdSet) {
            long id = genLongIds[i];
            params.add(new Object[]{id, String.valueOf(id), curUserId, this.env.getCtxId(), materialiId});
            ++i;
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, params);
        }
    }

    private DataSet getReqDataSet(DataSet filterDataSet) {
        DynamicObjectCollection reqCollection = this.plan.getDynamicObjectCollection("entryentity");
        List<Long> modelIds = reqCollection.stream().filter(o -> o.getBoolean("entryismrpoperat")).map(o -> o.getLong("resourceregister.id")).collect(Collectors.toList());
        DataSet resultDataSet = null;
        if (filterDataSet != null) {
            try {
                filterDataSet = filterDataSet.copy();
                RowMeta rowMeta = filterDataSet.getRowMeta();
                ArrayList<Map> filterDataList = new ArrayList<Map>(16);
                String[] targetFieldNames = rowMeta.getFieldNames();
                HashMap<String, Set<Object>> filterMap = new HashMap<String, Set<Object>>(16);
                for (Row row : filterDataSet) {
                    filterDataList.add(rowMeta.toMap(row));
                }
                this.entrydetailmsg.put("filterData", filterDataList);
                for (String targetFieldName : targetFieldNames) {
                    filterMap.put(targetFieldName, filterDataList.stream().map(o -> o.get(targetFieldName)).collect(Collectors.toSet()));
                }
                resultDataSet = this.fetchDataBySetId(modelIds, filterMap);
            }
            catch (Exception e) {
                log.error("DistrPlanCalcExt getReqDataSet error", (Throwable)e);
                resultDataSet = this.fetchDataBySetId(modelIds);
            }
        }
        if (resultDataSet == null) {
            resultDataSet = this.fetchDataBySetId(modelIds);
        }
        return resultDataSet;
    }

    protected DataSet reqDataExt(DataSet dataSet) {
        return dataSet;
    }

    protected DataSet supDataExt(DataSet dataSet) {
        return dataSet;
    }

    protected DataSetX supplyCalc(DynamicObjectCollection supCollection, JobSession session, DataSetX reqDataSetX, Set<Long> materialIdSet) {
        supCollection.sort((o1, o2) -> Integer.compare(o2.getInt("supplypriority"), o1.getInt("supplypriority")));
        reqDataSetX = reqDataSetX.orderBy(new String[]{"billdate"});
        for (DynamicObject supEntry : supCollection) {
            boolean hasBillDate;
            QFilter filter = null;
            if (!supEntry.getBoolean("entryisscmrpoperat")) continue;
            Long modelId = supEntry.getLong("resourceregisters.id");
            String supplybill = supEntry.getString("entrysupplyres.id");
            if (StringUtils.isNotBlank((CharSequence)this.qFilterStr) && StringUtils.isNotBlank((CharSequence)this.srcBillEntity)) {
                DynamicObject mrpDs = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"mrp_resource_dataconfig");
                DynamicObject transferDyn = mrpDs.getDynamicObject("billfieldtransfer");
                DynamicObject srcbill = (transferDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)transferDyn.getLong("id"), (String)"mrp_billfieldtransfer")).getDynamicObject("srcbill");
                String srcEntityId = srcbill.getString("id");
                if (StringUtils.equals((CharSequence)srcEntityId, (CharSequence)this.srcBillEntity)) {
                    filter = QFilter.fromSerializedString((String)this.qFilterStr);
                }
            }
            DataSet supDataSet = DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, materialIdSet, filter);
            String scoutofdate = this.plan.getString("scoutofdate");
            Long supplyprioritymodel = this.plan.getLong("supplyprioritymodel.id");
            if (supDataSet == null) continue;
            if ((supDataSet = DistrPlanCalcV2.formatEntryEntity(supDataSet)).getRowMeta().getFieldIndex("billdate", false) < 0) {
                supDataSet = supDataSet.addField("billdate", "");
            }
            boolean bl = hasBillDate = supDataSet.getRowMeta().getFieldIndex("billdate", false) > -1;
            if (hasBillDate && "2".equals(scoutofdate)) {
                int scday = this.plan.getInt("scday");
                Calendar instance = Calendar.getInstance();
                Date plandate = this.runlog.getDate("plandate");
                instance.setTime(plandate);
                instance.add(5, -scday);
                Date startDate = instance.getTime();
                HashMap<String, Date> params = new HashMap<String, Date>(16);
                params.put("startDate", startDate);
                supDataSet = supDataSet.filter("billdate >= startDate", params);
            }
            supDataSet = this.supDataExt(supDataSet);
            DataSetInput supDataSetInput = new DataSetInput(supDataSet);
            DataSetX supDataSetX = session.fromInput((Input)supDataSetInput);
            supDataSetX = ReserveHelper.writeOff(session, supplybill, supDataSetX);
            this.plan.getString("appmode");
            this.plan.getString("computemode");
            supDataSetX = supDataSetX.addFields(new Field[]{new Field("supplybill", (DataType)DataType.StringType)}, new Object[]{supplybill});
            DynamicObject relativetransfer = this.plan.getDynamicObject("relativetransfer");
            if (relativetransfer == null) continue;
            relativetransfer = BusinessDataServiceHelper.loadSingle((Object)relativetransfer.getPkValue(), (String)"mrp_billfieldtransfer");
            CoGroupDataSetX coGroup = reqDataSetX.coGroup(supDataSetX, (CoGroupFunction)new DemandSupplyMatchCoGroupFunc(reqDataSetX.getRowMeta(), supDataSetX.getRowMeta(), this.orgParams, supplyprioritymodel));
            DynamicObjectCollection entryentity = relativetransfer.getDynamicObjectCollection("entryentity");
            for (DynamicObject o : entryentity) {
                String sourcefieldflag = o.getString("sourcefieldflag").replace("entryentity.", "");
                String destfieldflag = o.getString("destfieldflag").replace("entryentity.", "");
                String converttype = o.getString("converttype");
                if (!"0".equals(converttype)) continue;
                coGroup = coGroup.on(sourcefieldflag, destfieldflag);
            }
            reqDataSetX = coGroup;
        }
        return reqDataSetX;
    }

    private Set<Long> buildSupQfilter(DataSet reqDataSet) {
        DataSet dataSet = reqDataSet.copy();
        HashSet<Long> materialSet = new HashSet<Long>(16);
        for (Row row : dataSet) {
            materialSet.add(row.getLong("material"));
        }
        if (!materialSet.isEmpty() && materialSet.size() < 500000) {
            return materialSet;
        }
        return null;
    }

    private void loadOrgParams() {
        DynamicObjectCollection orgentryentity = this.plan.getDynamicObjectCollection("orgentryentity");
        for (DynamicObject orgentry : orgentryentity) {
            this.orgParams.put(orgentry.getLong("entrydemandorg.id"), orgentry.getLong("entryinvstrategy.id"));
        }
    }

    private DataSetX calcDistrType(JobSession session, DataSetX reqDataSetX, DataSetX distrTypeDataSetX) {
        String distrmatchtype = this.plan.getString("distrmatchtype");
        long errDefaultId = DistrPlanCalcV2.getDefualtDistrTypeId();
        long defaultId = this.plan.getLong("distrtype.id");
        if (defaultId == 0L) {
            defaultId = errDefaultId;
        }
        DataSetX finishNoWorkstation = reqDataSetX.filter("workstation =0  ");
        finishNoWorkstation = finishNoWorkstation.addFields(new Field[]{new Field("foodconveyer", (DataType)DataType.LongType), new Field("zhny_deliverygroup", (DataType)DataType.LongType), new Field("distrtype", (DataType)DataType.LongType)}, new Object[]{0L, 0L, errDefaultId});
        RowMeta globalRowMeta = finishNoWorkstation.getRowMeta();
        reqDataSetX = reqDataSetX.filter("workstation >0");
        reqDataSetX = "B".equals(distrmatchtype) ? DistrPlanCalcV2.calcMaterialDistr(session, reqDataSetX, defaultId) : reqDataSetX.addFields(new Field[]{new Field("distrtype", (DataType)DataType.LongType)}, new Object[]{defaultId});
        DataSetX finishIsErrDefault = reqDataSetX.filter("distrtype =  " + errDefaultId);
        finishIsErrDefault = finishIsErrDefault.addFields(new Field[]{new Field("foodconveyer", (DataType)DataType.LongType), new Field("zhny_deliverygroup", (DataType)DataType.LongType)}, new Object[]{0L, 0L});
        reqDataSetX = reqDataSetX.filter("distrtype <>  " + errDefaultId);
        JoinDataSetX leftjoin = reqDataSetX.leftJoin(distrTypeDataSetX);
        leftjoin = leftjoin.on("distrtype", "id");
        reqDataSetX = leftjoin.select(reqDataSetX.getRowMeta().getFieldNames(), new String[]{"isfoodconveyer"});
        DataSetX noFoodconveyer = reqDataSetX.filter("isfoodconveyer ='0' or isfoodconveyer is null");
        noFoodconveyer = noFoodconveyer.removeFields(new String[]{"isfoodconveyer"});
        noFoodconveyer = this.calcDeliveryGroup(session, noFoodconveyer, errDefaultId);
        noFoodconveyer = noFoodconveyer.addFields(new Field[]{new Field("foodconveyer", (DataType)DataType.LongType)}, new Object[]{0L});
        DataSetX needFoodconveyer = reqDataSetX.filter("isfoodconveyer ='1'");
        needFoodconveyer = needFoodconveyer.removeFields(new String[]{"isfoodconveyer"});
        needFoodconveyer = this.calcFoodConveyer(session, needFoodconveyer, errDefaultId);
        needFoodconveyer = needFoodconveyer.addFields(new Field[]{new Field("zhny_deliverygroup", (DataType)DataType.LongType)}, new Object[]{0L});
        finishIsErrDefault = finishIsErrDefault.select(globalRowMeta.getFieldNames());
        noFoodconveyer = noFoodconveyer.select(globalRowMeta.getFieldNames());
        needFoodconveyer = needFoodconveyer.select(globalRowMeta.getFieldNames());
        reqDataSetX = finishNoWorkstation.union(finishIsErrDefault);
        reqDataSetX = reqDataSetX.union(noFoodconveyer);
        reqDataSetX = reqDataSetX.union(needFoodconveyer);
        return reqDataSetX;
    }

    private DataSetX calcDeliveryGroup(JobSession session, DataSetX noFoodConveyer, long errDefaultId) {
        MainEntityType dataEntityType = null;
        try {
            dataEntityType = EntityMetadataCache.getDataEntityType((String)"zhny_delgrp2station");
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        if (dataEntityType != null) {
            String[] leftFiledNames = noFoodConveyer.getRowMeta().getFieldNames();
            OrmInput delgrp2stationOrmInput = new OrmInput("kd.mmc.pom.business.distr.DistrPlanCalc:zhny_delgrp2station", "zhny_delgrp2station", "zhny_inventoryorg,zhny_productionorg,zhny_workstationnum,zhny_deliverygroupnum", new QFilter[]{new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1")});
            DataSetX delgrp2stationDataSetX = session.fromInput((Input)delgrp2stationOrmInput);
            delgrp2stationDataSetX = delgrp2stationDataSetX.groupBy(new String[]{"zhny_inventoryorg", "zhny_productionorg", "zhny_workstationnum"}).max("zhny_deliverygroupnum", "zhny_deliverygroup");
            JoinDataSetX leftjoin = noFoodConveyer.leftJoin(delgrp2stationDataSetX);
            leftjoin = leftjoin.on("supplyorgunit", "zhny_inventoryorg").on("productionorgunit", "zhny_productionorg").on("workstation", "zhny_workstationnum");
            noFoodConveyer = leftjoin.select(leftFiledNames, new String[]{"zhny_deliverygroup"});
            DataSetX finishHasDeliveryGroup = noFoodConveyer.filter("zhny_deliverygroup >0");
            DataSetX finishErrDeliveryGroup = noFoodConveyer.filter("zhny_deliverygroup is null or  zhny_deliverygroup=0");
            finishErrDeliveryGroup = finishErrDeliveryGroup.removeFields(new String[]{"distrtype"});
            finishErrDeliveryGroup = finishErrDeliveryGroup.addFields(new Field[]{new Field("distrtype", (DataType)DataType.LongType)}, new Object[]{errDefaultId});
            finishErrDeliveryGroup = finishErrDeliveryGroup.select(finishHasDeliveryGroup.getRowMeta().getFieldNames());
            return finishHasDeliveryGroup.union(finishErrDeliveryGroup);
        }
        return noFoodConveyer.addFields(new Field[]{new Field("zhny_deliverygroup", (DataType)DataType.LongType)}, new Object[]{0L});
    }

    private DataSetX calcFoodConveyer(JobSession session, DataSetX needFoodconveyer, long errDefaultId) {
        String[] leftFiledNames = needFoodconveyer.getRowMeta().getFieldNames();
        OrmInput foodconveyerOrmInput = new OrmInput("kd.mmc.pom.business.distr.DistrPlanCalc:mpdm_corstafoodconveyer", "mpdm_corstafoodconveyer", "createorg,workcenter,workstation,foodconveyer", new QFilter[]{new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1")});
        DataSetX foodconveyerDataSetX = session.fromInput((Input)foodconveyerOrmInput);
        foodconveyerDataSetX = foodconveyerDataSetX.groupBy(new String[]{"createorg", "workcenter", "workstation"}).max("foodconveyer");
        JoinDataSetX leftjoin = needFoodconveyer.leftJoin(foodconveyerDataSetX);
        leftjoin = leftjoin.on("productionorgunit", "createorg").on("workcenter", "workcenter").on("workstation", "workstation");
        needFoodconveyer = leftjoin.select(leftFiledNames, new String[]{"foodconveyer"});
        DataSetX finishHasFoodconveyer = needFoodconveyer.filter("foodconveyer >0");
        DataSetX finishErrFoodconveyer = needFoodconveyer.filter("foodconveyer is null or  foodconveyer=0");
        finishErrFoodconveyer = finishErrFoodconveyer.removeFields(new String[]{"distrtype"});
        finishErrFoodconveyer = finishErrFoodconveyer.addFields(new Field[]{new Field("distrtype", (DataType)DataType.LongType)}, new Object[]{errDefaultId});
        finishErrFoodconveyer = finishErrFoodconveyer.select(finishHasFoodconveyer.getRowMeta().getFieldNames());
        return finishHasFoodconveyer.union(finishErrFoodconveyer);
    }

    private static DataSetX calcMaterialDistr(JobSession session, DataSetX reqDataSetX, long defaultId) {
        String[] filedNames = reqDataSetX.getRowMeta().getFieldNames();
        OrmInput materialdistrOrmInput = new OrmInput("kd.mmc.pom.business.distr.DistrPlanCalc:mpdm_materialdistr", "mpdm_materialdistr", "createorg,mftorg,workcentre,workstation,material,distrtype", new QFilter[]{new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1")});
        DataSetX materialdistrDataSetX = session.fromInput((Input)materialdistrOrmInput);
        DataSetX materialDistrDataSetXCondition3 = materialdistrDataSetX.filter("workcentre > 0 and workstation > 0");
        materialDistrDataSetXCondition3 = materialDistrDataSetXCondition3.groupBy(new String[]{"createorg", "mftorg", "workcentre", "workstation", "material"}).max("distrtype");
        JoinDataSetX leftjoin = reqDataSetX.leftJoin(materialDistrDataSetXCondition3);
        leftjoin = leftjoin.on("supplyorgunit", "createorg").on("workcenter", "workcentre").on("workstation", "workstation").on("productionorgunit", "mftorg").on("material", "material");
        reqDataSetX = leftjoin.select(filedNames, new String[]{"distrtype"});
        DataSetX finishDataSetX3 = reqDataSetX.filter("distrtype>0");
        reqDataSetX = reqDataSetX.filter("distrtype is null or distrtype=0");
        DataSetX materialDistrDataSetXCondition2 = materialdistrDataSetX.filter("workcentre > 0 and workstation = 0");
        materialDistrDataSetXCondition2 = materialDistrDataSetXCondition2.groupBy(new String[]{"createorg", "mftorg", "workcentre", "workstation", "material"}).max("distrtype");
        leftjoin = reqDataSetX.leftJoin(materialDistrDataSetXCondition2);
        leftjoin = leftjoin.on("supplyorgunit", "createorg").on("workcenter", "workcentre").on("productionorgunit", "mftorg").on("material", "material");
        reqDataSetX = leftjoin.select(filedNames, new String[]{"distrtype"});
        DataSetX finishDataSetX2 = reqDataSetX.filter("distrtype>0");
        reqDataSetX = reqDataSetX.filter("distrtype is null or distrtype=0");
        DataSetX materialDistrDataSetXCondition1 = materialdistrDataSetX.filter("workcentre = 0 and workstation = 0");
        materialDistrDataSetXCondition1 = materialDistrDataSetXCondition1.groupBy(new String[]{"createorg", "mftorg", "workcentre", "workstation", "material"}).max("distrtype");
        leftjoin = reqDataSetX.leftJoin(materialDistrDataSetXCondition1);
        leftjoin = leftjoin.on("supplyorgunit", "createorg").on("productionorgunit", "mftorg").on("material", "material");
        reqDataSetX = leftjoin.select(filedNames, new String[]{"distrtype"});
        DataSetX finishDataSetX1 = reqDataSetX.filter("distrtype>0");
        reqDataSetX = reqDataSetX.filter("distrtype is null or distrtype=0");
        reqDataSetX = reqDataSetX.removeFields(new String[]{"distrtype"});
        reqDataSetX = reqDataSetX.addFields(new Field[]{new Field("distrtype", (DataType)DataType.LongType)}, new Object[]{defaultId});
        reqDataSetX = reqDataSetX.union(finishDataSetX1);
        reqDataSetX = reqDataSetX.union(finishDataSetX2);
        reqDataSetX = reqDataSetX.union(finishDataSetX3);
        return reqDataSetX;
    }

    private static DataSetX calcDiistrTypeByCondition(DataSetX reqDataSetX, DataSetX materialDistrDataSetXCondition) {
        return reqDataSetX;
    }

    private void logCount(int stepIdx, String logEntityNumber) {
        this.runlog = BusinessDataServiceHelper.loadSingle((Object)this.env.getCtxId(), (String)logEntityNumber);
        DynamicObjectCollection entryentity = this.runlog.getDynamicObjectCollection("entryentity");
        List list = entryentity.stream().filter(o -> String.valueOf(stepIdx).equals(o.getString("entrystepseq"))).collect(Collectors.toList());
        if (!list.isEmpty()) {
            ((DynamicObject)list.get(0)).set("entryprocessdata", (Object)this.calcCount);
            try {
                ((DynamicObject)list.get(0)).set("entrydetailmsg_tag", (Object)JSON.toJSONString(this.entrydetailmsg));
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            SaveServiceHelper.update((DynamicObject)this.runlog);
        }
    }

    public boolean existField(RowMeta meta, String nameOrAlias) {
        Field field = meta.getField(nameOrAlias, false);
        return field != null;
    }

    public DataSet addToDBField(DataSet dataSet, Object logId) {
        if (this.existField(dataSet.getRowMeta(), "creator")) {
            dataSet = dataSet.removeFields(new String[]{"creator"});
        }
        if (this.existField(dataSet.getRowMeta(), "modifier")) {
            dataSet = dataSet.removeFields(new String[]{"modifier"});
        }
        if (this.existField(dataSet.getRowMeta(), "createtime")) {
            dataSet = dataSet.removeFields(new String[]{"createtime"});
        }
        if (this.existField(dataSet.getRowMeta(), "modifytime")) {
            dataSet = dataSet.removeFields(new String[]{"modifytime"});
        }
        if (this.existField(dataSet.getRowMeta(), "logid")) {
            dataSet = dataSet.removeFields(new String[]{"logid"});
        }
        if (this.existField(dataSet.getRowMeta(), "billstatus")) {
            dataSet = dataSet.removeFields(new String[]{"billstatus"});
        }
        Long userId = RequestContext.get().getCurrUserId();
        long createorg = this.runlog.getLong("createorg.id");
        return dataSet.addFields(new String[]{String.valueOf(createorg), String.valueOf(userId), String.valueOf(userId), "now()", "now()", String.valueOf(logId), "'C'"}, new String[]{"org", "creator", "modifier", "createtime", "modifytime", "logid", "billstatus"});
    }

    protected void buildDistplanSuggest(DataSet requirementData) {
        DynamicObject outputmapping;
        DynamicObject demandmodel = this.plan.getDynamicObject("demandmodel");
        if ((demandmodel = BusinessDataServiceHelper.loadSingle((Object)demandmodel.getPkValue(), (String)"mrp_resourceregister_cf")) != null && (outputmapping = demandmodel.getDynamicObject("outputmapping")) != null) {
            ArrayList<String> reqDataFields = new ArrayList<String>(Arrays.asList(requirementData.getRowMeta().getFieldNames()));
            outputmapping = BusinessDataServiceHelper.loadSingle((Object)outputmapping.getPkValue(), (String)"mrp_billfieldtransfer");
            DynamicObjectCollection entryentity = outputmapping.getDynamicObjectCollection("entryentity");
            List<String[]> sourceRelDest = entryentity.stream().map(o -> {
                String sourcefieldflag = o.getString("sourcefieldflag").replace("entryentity.", "");
                String destfieldflag = o.getString("destfieldflag");
                String converttype = o.getString("converttype");
                String calculateexc = o.getString("calculateexc");
                if (!"0".equals(converttype)) {
                    sourcefieldflag = calculateexc;
                }
                String[] result = new String[]{sourcefieldflag, destfieldflag};
                return result;
            }).collect(Collectors.toList());
            List<String[]> defaultSelectFields = this.getDefaultSelectFields();
            List<String[]> mergeFields = this.mergeSelectFields(sourceRelDest, defaultSelectFields);
            List<String> selectFields = mergeFields.stream().filter(o -> reqDataFields.contains(o[0])).map(o -> o[0] + " as " + o[1]).collect(Collectors.toList());
            requirementData = requirementData.select(selectFields.toArray(new String[0]));
            String billNumber = outputmapping.getString("destbill.number");
            this.calcCount = this.saveByDynamicObject(requirementData, billNumber);
        }
    }

    private List<String[]> mergeSelectFields(List<String[]> sourceRelDest, List<String[]> defaultSelectFields) {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < defaultSelectFields.size(); ++i) {
            indexMap.put(defaultSelectFields.get(i)[1], i);
        }
        ArrayList<String[]> result = new ArrayList<String[]>(defaultSelectFields);
        for (String[] strings : sourceRelDest) {
            Integer index = (Integer)indexMap.get(strings[1]);
            if (index != null) {
                result.set(index, strings);
                continue;
            }
            result.add(strings);
        }
        return result;
    }

    private List<String[]> getDefaultSelectFields() {
        ArrayList<String[]> defaultSelectFields = new ArrayList<String[]>(16);
        defaultSelectFields.add(new String[]{"gourpid", "gourpid"});
        defaultSelectFields.add(new String[]{"logid", "logid"});
        defaultSelectFields.add(new String[]{"org", "org"});
        defaultSelectFields.add(new String[]{"creator", "creator"});
        defaultSelectFields.add(new String[]{"modifier", "modifier"});
        defaultSelectFields.add(new String[]{"createtime", "createtime"});
        defaultSelectFields.add(new String[]{"modifytime", "modifytime"});
        defaultSelectFields.add(new String[]{"billstatus", "billstatus"});
        defaultSelectFields.add(new String[]{"targetbilltype", "targetbilltype"});
        return defaultSelectFields;
    }

    private int saveByDynamicObject(DataSet dataSet, String billNumber) {
        int count = 0;
        Field[] fields = dataSet.getRowMeta().getFields();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        HashSet<Field> allField = new HashSet<Field>(Arrays.asList(fields));
        Set insertField = allField.stream().map(Field::getName).collect(Collectors.toSet());
        try (TXHandle h = TX.required();){
            try {
                LinkedList<DynamicObject> values = new LinkedList<DynamicObject>();
                for (Row row : dataSet) {
                    ++count;
                    DynamicObject temp = BusinessDataServiceHelper.newDynamicObject((String)billNumber);
                    String newNum = ID.genStringId();
                    temp.set("billno", (Object)newNum);
                    for (String field : insertField) {
                        IDataEntityProperty findProperty = dataEntityType.findProperty(field);
                        if (findProperty instanceof MulBasedataProp) {
                            this.setMulBasedataVal(field, row, temp);
                            continue;
                        }
                        if (findProperty == null) continue;
                        temp.set(field, row.get(field));
                    }
                    values.add(temp);
                    if (values.size() < 10000) continue;
                    this.executeBatch(values);
                    values.clear();
                }
                if (values.size() > 0) {
                    this.executeBatch(values);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return count;
    }

    private void setMulBasedataVal(String field, Row row, DynamicObject obj) {
        String mulVal = row.getString(field);
        DynamicObjectCollection mulBasedata = obj.getDynamicObjectCollection(field);
        if (StringUtils.isNotEmpty((CharSequence)mulVal)) {
            String[] valArr;
            for (String val : valArr = mulVal.split(",")) {
                DynamicObject addNew = mulBasedata.addNew();
                addNew.set("fbasedataid", (Object)val);
            }
        }
    }

    private void executeBatch(List<DynamicObject> values) {
        SaveServiceHelper.save((DynamicObject[])values.toArray(new DynamicObject[0]));
    }

    private DataSet bomExpand(DataSet reqDataSet) {
        DynamicObject relativeresource;
        DynamicObject demandmodel = this.plan.getDynamicObject("demandmodel");
        if ((demandmodel = BusinessDataServiceHelper.loadSingle((Object)demandmodel.getPkValue(), (String)"mrp_resourceregister_cf")) != null && (relativeresource = demandmodel.getDynamicObject("relativeresource")) != null) {
            relativeresource = BusinessDataServiceHelper.loadSingle((Object)relativeresource.getPkValue(), (String)"mrp_resourceregister_cf");
            DynamicObjectCollection entryentityds = QueryServiceHelper.query((String)"msplan_resource_dataconf", (String)"id", (QFilter[])new QFilter[]{new QFilter("cgnumber.id", "=", relativeresource.getPkValue())});
            List<Long> modelIds = entryentityds.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            DynamicObject relativetransfer = demandmodel.getDynamicObject("relativetransfer");
            relativetransfer = BusinessDataServiceHelper.loadSingle((Object)relativetransfer.getPkValue(), (String)"mrp_billfieldtransfer");
            DynamicObjectCollection entryentity = relativetransfer.getDynamicObjectCollection("entryentity");
            DataSet bomDataSet = null;
            if (this.bomByFilter()) {
                try {
                    QFilter filter = this.buildBomQfilter(reqDataSet, entryentity);
                    bomDataSet = this.fetchDataBySetIdAndFilter(modelIds, filter);
                }
                catch (Exception ex) {
                    log.error((Throwable)ex);
                    bomDataSet = this.fetchDataBySetId(modelIds);
                }
            } else {
                bomDataSet = this.fetchDataBySetId(modelIds);
            }
            bomDataSet = DistrPlanCalcV2.formatEntryEntity(bomDataSet);
            JoinDataSet join = reqDataSet.leftJoin(bomDataSet);
            for (DynamicObject entry : entryentity) {
                join = join.on(entry.getString("sourcefieldflag").replace("entryentity.", ""), entry.getString("destfieldflag").replace("entryentity.", ""));
            }
            String[] leftFieldNames = reqDataSet.getRowMeta().getFieldNames();
            String[] rightFieldNames = bomDataSet.getRowMeta().getFieldNames();
            ArrayList<String> leftFieldNamesList = new ArrayList<String>(Arrays.asList(leftFieldNames));
            ArrayList<String> rightFieldNamesList = new ArrayList<String>(Arrays.asList(rightFieldNames));
            List<String> leftField = leftFieldNamesList.stream().filter(o -> !rightFieldNamesList.contains(o)).collect(Collectors.toList());
            leftField.add("material as prodmtno");
            leftField.add("baseunit as produnit");
            leftField.add("demandqty as prodqty");
            DataSet dataSet = join.select(leftField.toArray(new String[0]), rightFieldNames).finish();
            reqDataSet = dataSet.updateField("demandqty", "demandqty*qty");
        }
        return reqDataSet;
    }

    private static DataSetX setDefaultDistrType(DataSetX reqDataSetX) {
        long defaultId = DistrPlanCalcV2.getDefualtDistrTypeId();
        if (defaultId >= 0L) {
            reqDataSetX = reqDataSetX.map((MapFunction)new AddDefaultDistrTypeMapFunction(reqDataSetX.getRowMeta(), defaultId));
        }
        return reqDataSetX;
    }

    private static long getDefualtDistrTypeId() {
        long defaultId = 0L;
        DynamicObject defaultDistrType = BusinessDataServiceHelper.loadSingle((String)"mpdm_distrtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("isdefault", "=", (Object)true), new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1")});
        if (defaultDistrType != null) {
            defaultId = defaultDistrType.getLong("id");
        }
        return defaultId;
    }

    private static DataSet formatEntryEntity(DataSet dataSet) {
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            String field = fieldNames[i];
            if (!field.contains("entryentity.")) continue;
            fieldNames[i] = field + " as " + field.replace("entryentity.", "");
        }
        return dataSet.select(fieldNames);
    }

    private DataSetX checkCalcField(DataSetX dataSetX) {
        dataSetX.getRowMeta();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"mrp_mftstock_demandbill");
        return dataSetX;
    }

    private DataSet fetchDataBySetId(List<Long> modelIds, Map<String, Set<Object>> filterMap) {
        if (filterMap == null || filterMap.isEmpty()) {
            return this.fetchDataBySetId(modelIds);
        }
        DataSet dataSet = null;
        for (Long modelId : modelIds) {
            QFilter qFilter = this.buildQFilter(modelId, filterMap);
            DataSet dsItem = DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, null, (QFilter)qFilter);
            if (dataSet == null) {
                dataSet = dsItem;
                continue;
            }
            RowMeta leftRowMeta = dataSet.getRowMeta();
            RowMeta rightRowMeta = dsItem.getRowMeta();
            Field[] leftFields = leftRowMeta.getFields();
            Field[] rightFields = rightRowMeta.getFields();
            HashSet<String> allFieldName = new HashSet<String>(16);
            HashSet<String> leftName = new HashSet<String>(16);
            HashSet<String> rightName = new HashSet<String>(16);
            for (Field leftField : leftFields) {
                allFieldName.add(leftField.getName());
                leftName.add(leftField.getName());
            }
            for (Field rightField : rightFields) {
                allFieldName.add(rightField.getName());
                rightName.add(rightField.getName());
            }
            for (String fieldName : allFieldName) {
                if (!leftName.contains(fieldName)) {
                    dataSet = dataSet.addNullField(fieldName);
                }
                if (rightName.contains(fieldName)) continue;
                dsItem = dsItem.addNullField(fieldName);
            }
            dataSet = dataSet.select(allFieldName.toArray(new String[0]));
            dsItem = dsItem.select(allFieldName.toArray(new String[0]));
            dataSet = dataSet.union(dsItem);
        }
        return dataSet;
    }

    private QFilter buildQFilter(Long modelId, Map<String, Set<Object>> filterMap) {
        QFilter resultQFilter = null;
        DynamicObject mrpDs = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"mrp_resource_dataconfig");
        DynamicObject transferDyn = mrpDs.getDynamicObject("billfieldtransfer");
        transferDyn = BusinessDataServiceHelper.loadSingle((Object)transferDyn.getLong("id"), (String)"mrp_billfieldtransfer");
        DynamicObjectCollection fieldMappingAll = transferDyn.getDynamicObjectCollection("entryentity");
        Map<String, String> destRelSourceFieldMap = fieldMappingAll.stream().filter(o -> "0".equals(o.getString("converttype"))).collect(Collectors.toMap(o -> o.getString("destfieldflag"), o -> o.getString("sourcefieldflag")));
        Map<String, String> destRelSourceFieldFormulaMap = fieldMappingAll.stream().filter(o -> "1".equals(o.getString("converttype")) || "4".equals(o.getString("converttype"))).collect(Collectors.toMap(o -> o.getString("destfieldflag"), o -> o.getString("calculateexc_tag")));
        for (Map.Entry<String, Set<Object>> entry : filterMap.entrySet()) {
            String destField = entry.getKey();
            Set<Object> value = entry.getValue();
            String sourceField = destRelSourceFieldMap.get(destField);
            if (StringUtils.isBlank((CharSequence)sourceField)) {
                String col = destRelSourceFieldFormulaMap.get(destField);
                boolean isUnSet = StringUtils.isEmpty((CharSequence)col);
                JSONObject jo = isUnSet ? null : JSON.parseObject((String)col);
                String string = sourceField = jo == null ? null : jo.getString("expression");
            }
            if (!StringUtils.isNotBlank((CharSequence)sourceField)) continue;
            if (resultQFilter == null) {
                resultQFilter = new QFilter(sourceField, "in", value);
                continue;
            }
            resultQFilter.and(sourceField, "in", value);
        }
        return resultQFilter;
    }

    private DataSet fetchDataBySetId(List<Long> modelIds) {
        DataSet dataSet = null;
        DataFetcher dataFetcher = new DataFetcher();
        for (Long modelId : modelIds) {
            DataSet dsItem = dataFetcher.getDataSet(modelId);
            if (dataSet == null) {
                dataSet = dsItem;
                continue;
            }
            RowMeta leftRowMeta = dataSet.getRowMeta();
            RowMeta rightRowMeta = dsItem.getRowMeta();
            Field[] leftFields = leftRowMeta.getFields();
            Field[] rightFields = rightRowMeta.getFields();
            HashSet<String> allFieldName = new HashSet<String>(16);
            HashSet<String> leftName = new HashSet<String>(16);
            HashSet<String> rightName = new HashSet<String>(16);
            for (Field leftField : leftFields) {
                allFieldName.add(leftField.getName());
                leftName.add(leftField.getName());
            }
            for (Field rightField : rightFields) {
                allFieldName.add(rightField.getName());
                rightName.add(rightField.getName());
            }
            for (String fieldName : allFieldName) {
                if (!leftName.contains(fieldName)) {
                    dataSet = dataSet.addNullField(fieldName);
                }
                if (rightName.contains(fieldName)) continue;
                dsItem = dsItem.addNullField(fieldName);
            }
            dataSet = dataSet.select(allFieldName.toArray(new String[0]));
            dsItem = dsItem.select(allFieldName.toArray(new String[0]));
            dataSet = dataSet.union(dsItem);
        }
        return dataSet;
    }

    private boolean queryByFilter() {
        DynamicObject pdmParamset = QueryServiceHelper.queryOne((String)"pdm_paramset", (String)"value", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"displan_QueryByFilter")});
        if (pdmParamset != null) {
            String value = pdmParamset.getString("value");
            return "true".equalsIgnoreCase(value);
        }
        return false;
    }

    private boolean bomByFilter() {
        DynamicObject pdmParamset = QueryServiceHelper.queryOne((String)"pdm_paramset", (String)"value", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"displan_BomByFilter")});
        if (pdmParamset != null) {
            String value = pdmParamset.getString("value");
            return "true".equalsIgnoreCase(value);
        }
        return false;
    }

    private QFilter buildQfilter(String algoCacheId) {
        if (StringUtils.isNotEmpty((CharSequence)algoCacheId)) {
            CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)algoCacheId);
            DataSet filterDataSet = cachedDataSet.toDataSet(Algo.create((String)"DistrPlanCalc:algoCache"), false);
            RowMeta rowMeta = filterDataSet.getRowMeta();
            int billidIndex = rowMeta.getFieldIndex("entryentity.billid", false);
            int billentryidIndex = rowMeta.getFieldIndex("entryentity.billentryid", false);
            int fieldCount = rowMeta.getFieldCount();
            HashSet<String> billidSet = new HashSet<String>(16);
            if (fieldCount == 2 && billidIndex >= 0 && billentryidIndex >= 0) {
                for (Row row : filterDataSet) {
                    billidSet.add(row.getString("entryentity.billid"));
                }
                if (billidSet.size() > 0) {
                    return new QFilter("orderid", "in", billidSet);
                }
            }
        }
        return null;
    }

    private QFilter buildBomQfilter(DataSet reqDataSet, DynamicObjectCollection entryentity) {
        HashMap<String, String> relMap = new HashMap<String, String>(16);
        for (DynamicObject entry : entryentity) {
            relMap.put(entry.getString("sourcefieldflag"), entry.getString("destfieldflag"));
        }
        if (relMap.size() == 2) {
            String field1 = (String)relMap.get("entryentity.billentryid");
            String field2 = (String)relMap.get("entryentity.workcenter");
            if ("entryentity.bomid".equalsIgnoreCase(field1) && "entryentity.workcenter".equalsIgnoreCase(field2)) {
                DataSet dataSet = reqDataSet.copy();
                HashSet<Long> orderentryidSet = new HashSet<Long>(16);
                for (Row row : dataSet) {
                    orderentryidSet.add(row.getLong("billentryid"));
                }
                if (orderentryidSet.size() > 0 && orderentryidSet.size() < 500000) {
                    return new QFilter("orderentryid", "in", orderentryidSet);
                }
            }
        }
        return null;
    }

    private DataSet fetchDataBySetIdAndFilter(List<Long> modelIds, QFilter filter) {
        DataSet dataSet = null;
        for (Long modelId : modelIds) {
            DataSet dsItem = null;
            dsItem = DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, null, (QFilter)filter);
            if (dataSet == null) {
                dataSet = dsItem;
                continue;
            }
            RowMeta leftRowMeta = dataSet.getRowMeta();
            RowMeta rightRowMeta = dsItem.getRowMeta();
            Field[] leftFields = leftRowMeta.getFields();
            Field[] rightFields = rightRowMeta.getFields();
            HashSet<String> allFieldName = new HashSet<String>(16);
            HashSet<String> leftName = new HashSet<String>(16);
            HashSet<String> rightName = new HashSet<String>(16);
            for (Field leftField : leftFields) {
                allFieldName.add(leftField.getName());
                leftName.add(leftField.getName());
            }
            for (Field rightField : rightFields) {
                allFieldName.add(rightField.getName());
                rightName.add(rightField.getName());
            }
            for (String fieldName : allFieldName) {
                if (!leftName.contains(fieldName)) {
                    dataSet = dataSet.addNullField(fieldName);
                }
                if (rightName.contains(fieldName)) continue;
                dsItem = dsItem.addNullField(fieldName);
            }
            dataSet = dataSet.select(allFieldName.toArray(new String[0]));
            dsItem = dsItem.select(allFieldName.toArray(new String[0]));
            dataSet = dataSet.union(dsItem);
        }
        return dataSet;
    }
}

