/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.distr.algox;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;

public class DemandSupplyMatchCoGroupFunc
extends CoGroupFunction {
    private static Log logger = LogFactory.getLog(DemandSupplyMatchCoGroupFunc.class);
    private RowMeta demandRowMeta;
    private RowMeta supplyRowMeta;
    private RowMeta resultRowMeta;
    private Map<Long, Long> orgParams;
    private Map<Object, DynamicObject> invStrategyMap;
    private Long supplyPriorityModelId;

    public DemandSupplyMatchCoGroupFunc(RowMeta demandRowMeta, RowMeta supplyRowMeta, Map<Long, Long> orgParams, Long supplyPriorityModelId) {
        this.demandRowMeta = demandRowMeta;
        this.supplyRowMeta = supplyRowMeta;
        this.resultRowMeta = this.buildResultRowMeta();
        this.setOrgParams(orgParams);
        this.supplyPriorityModelId = supplyPriorityModelId;
    }

    public final RowMeta buildResultRowMeta() {
        Field[] fields = this.demandRowMeta.getFields();
        ArrayList<Field> resultFields = new ArrayList<Field>(Arrays.asList(fields));
        if (this.demandRowMeta.getFieldIndex("supplyqty", false) < 0) {
            resultFields.add(new Field("supplyqty", (DataType)DataType.BigDecimalType));
        }
        if (this.demandRowMeta.getFieldIndex("supplybill", false) < 0) {
            resultFields.add(new Field("supplybill", (DataType)DataType.StringType));
        }
        if (this.demandRowMeta.getFieldIndex("supplybillno", false) < 0) {
            resultFields.add(new Field("supplybillno", (DataType)DataType.StringType));
        }
        if (this.demandRowMeta.getFieldIndex("supplybillid", false) < 0) {
            resultFields.add(new Field("supplybillid", (DataType)DataType.StringType));
        }
        if (this.demandRowMeta.getFieldIndex("supplybillentryid", false) < 0) {
            resultFields.add(new Field("supplybillentryid", (DataType)DataType.StringType));
        }
        if (this.demandRowMeta.getFieldIndex("supplydate", false) < 0) {
            resultFields.add(new Field("supplydate", (DataType)DataType.DateType));
        }
        if (this.demandRowMeta.getFieldIndex("supplybillentryseq", false) < 0) {
            resultFields.add(new Field("supplybillentryseq", (DataType)DataType.IntegerType));
        }
        if (this.demandRowMeta.getFieldIndex("supplyorgunit", false) < 0) {
            resultFields.add(new Field("supplyorgunit", (DataType)DataType.LongType));
        }
        return new RowMeta(resultFields.toArray(new Field[0]));
    }

    public void coGroup(Iterable<RowX> iterable, Iterable<RowX> iterable1, Collector collector) {
        try {
            this.doCoGroup(iterable, iterable1, collector);
        }
        catch (Exception ex) {
            String errorMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            logger.error(errorMessage);
            throw ex;
        }
    }

    public void doCoGroup(Iterable<RowX> iterable, Iterable<RowX> iterable1, Collector collector) {
        List<Map<String, Object>> supplyDataList = null;
        for (RowX rowX : iterable) {
            RowX resultRow;
            BigDecimal supplyqty;
            if (supplyDataList == null) {
                supplyDataList = this.initSupplyData(iterable1);
            }
            if ((supplyqty = (resultRow = this.createRow(rowX)).getBigDecimal(this.resultRowMeta.getFieldIndex("supplyqty"))) != null && supplyqty.compareTo(BigDecimal.ZERO) > 0) {
                collector.collect(resultRow);
                continue;
            }
            BigDecimal demandQty = resultRow.getBigDecimal(this.resultRowMeta.getFieldIndex("demandqty"));
            if (demandQty == null) continue;
            Iterator<Map<String, Object>> iterator = supplyDataList.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> supplyData = iterator.next();
                if (!this.support(resultRow, supplyData)) continue;
                BigDecimal supplyCalcUsedQty = this.getBigDecimal(supplyData.get("supplyCalcUsedQty"));
                BigDecimal allowUseQty = this.getAllowUseQty(resultRow, supplyData);
                if (demandQty.compareTo(allowUseQty) > 0) {
                    demandQty = demandQty.subtract(allowUseQty);
                    RowX newResultRow = this.createRow(resultRow);
                    newResultRow.set(this.resultRowMeta.getFieldIndex("demandqty"), (Object)allowUseQty);
                    newResultRow.set(this.resultRowMeta.getFieldIndex("supplyqty"), (Object)allowUseQty);
                    this.writeToResult(supplyData, newResultRow);
                    collector.collect(newResultRow);
                    resultRow.set(this.resultRowMeta.getFieldIndex("demandqty"), (Object)demandQty);
                    supplyData.put("supplyCalcUsedQty", supplyCalcUsedQty.add(allowUseQty));
                } else {
                    resultRow.set(this.resultRowMeta.getFieldIndex("supplyqty"), (Object)demandQty);
                    this.writeToResult(supplyData, resultRow);
                    supplyData.put("supplyCalcUsedQty", supplyCalcUsedQty.add(demandQty));
                    demandQty = BigDecimal.ZERO;
                }
                if (this.clearSupply(supplyData)) {
                    iterator.remove();
                }
                if (!BigDecimal.ZERO.equals(demandQty)) continue;
                break;
            }
            collector.collect(resultRow);
        }
    }

    protected List<Map<String, Object>> initSupplyData(Iterable<RowX> iterable1) {
        List<Map<String, Object>> supplyDataList = this.getSupplyData(iterable1);
        supplyDataList = this.sortSupply(supplyDataList);
        return supplyDataList;
    }

    protected BigDecimal getAllowUseQty(RowX resultRow, Map<String, Object> supplyData) {
        BigDecimal supplyQty = this.getBigDecimal(supplyData.get("qty"));
        BigDecimal supplyCalcUsedQty = this.getBigDecimal(supplyData.get("supplyCalcUsedQty"));
        return supplyQty.subtract(supplyCalcUsedQty);
    }

    protected boolean support(RowX resultRow, Map<String, Object> supplyData) {
        Object supply_project;
        if (!this.invStrategySupport(resultRow, supplyData)) {
            return false;
        }
        int index = this.resultRowMeta.getFieldIndex("projectnumber", false);
        Long project = 0L;
        if (index > -1) {
            project = resultRow.getLong(index);
        }
        return !((supply_project = supplyData.get("projectnumber")) instanceof Long) || (Long)supply_project <= 0L || project.equals(supply_project);
    }

    protected boolean invStrategySupport(RowX resultRow, Map<String, Object> supplyData) {
        Object org;
        Map<Long, Long> orgParams;
        Long strategyId;
        Map<Object, DynamicObject> invStrategyMap;
        DynamicObject invStrategy;
        if (this.getBoolean(supplyData.get("istock")).booleanValue() && (invStrategy = (invStrategyMap = this.getInvStrategyMap()).get(strategyId = (orgParams = this.getOrgParams()).get(org = resultRow.get(this.demandRowMeta.getFieldIndex("productionorgunit"))))) != null) {
            Object stockindex;
            Object stock;
            DynamicObjectCollection stockstypeentity = invStrategy.getDynamicObjectCollection("stockstypeentity");
            Object stockType = supplyData.get("stocktype");
            if (stockType == null) {
                return false;
            }
            boolean stockTypeSupport = stockstypeentity.stream().anyMatch(o -> o.getBoolean("ismrp") && stockType.equals(o.getLong("stocktype.id")));
            if (!stockTypeSupport) {
                return false;
            }
            DynamicObjectCollection entryentity2 = invStrategy.getDynamicObjectCollection("entryentity2");
            Object stockStatus = supplyData.get("stockstatus");
            if (stockStatus == null) {
                return false;
            }
            boolean stockStatusSupport = entryentity2.stream().anyMatch(o -> o.getBoolean("ismrp1") && stockStatus.equals(o.getLong("stocktype1.id")));
            if (!stockStatusSupport) {
                return false;
            }
            String stockSetup = invStrategy.getString("stocksetup");
            if ("1".equals(stockSetup)) {
                return true;
            }
            Object stockorg = supplyData.get("stockorg");
            if (stockorg == null) {
                stockorg = 0L;
            }
            if ((stock = supplyData.get("stock")) == null) {
                stock = 0L;
            }
            if ((stockindex = supplyData.get("stockindex")) == null) {
                stockindex = 0L;
            }
            Object finalStockorg = stockorg;
            Object finalStock = stock;
            Object finalStockindex = stockindex;
            DynamicObjectCollection stocksetupentry = invStrategy.getDynamicObjectCollection("stocksetupentry");
            if ("2".equals(stockSetup)) {
                return stocksetupentry.stream().anyMatch(o -> finalStockorg.equals(o.getLong("stockorg.id")) && finalStock.equals(o.getLong("stocknumber.id")) && finalStockindex.equals(o.getLong("stockindex.id")) || finalStockorg.equals(o.getLong("stockorg.id")) && finalStock.equals(o.getLong("stocknumber.id")) && Long.valueOf(0L).equals(o.getLong("stockindex.id")));
            }
            if ("3".equals(stockSetup)) {
                return stocksetupentry.stream().noneMatch(o -> finalStockorg.equals(o.getLong("stockorg.id")) && finalStock.equals(o.getLong("stocknumber.id")) && finalStockindex.equals(o.getLong("stockindex.id")) || finalStockorg.equals(o.getLong("stockorg.id")) && finalStock.equals(o.getLong("stocknumber.id")) && Long.valueOf(0L).equals(o.getLong("stockindex.id")));
            }
        }
        return true;
    }

    protected void writeToResult(Map<String, Object> supplyData, RowX newResultRow) {
        newResultRow.set(this.resultRowMeta.getFieldIndex("supplybill"), supplyData.get("supplybill"));
        newResultRow.set(this.resultRowMeta.getFieldIndex("supplybillno"), (Object)this.getString(supplyData.get("billnumber")));
        newResultRow.set(this.resultRowMeta.getFieldIndex("supplybillid"), (Object)this.getString(supplyData.get("billid")));
        newResultRow.set(this.resultRowMeta.getFieldIndex("supplybillentryid"), (Object)this.getString(supplyData.get("billentryid")));
        newResultRow.set(this.resultRowMeta.getFieldIndex("supplydate"), supplyData.get("billdate"));
        newResultRow.set(this.resultRowMeta.getFieldIndex("supplybillentryseq"), (Object)this.getInteger(supplyData.get("billentryseq")));
        newResultRow.set(this.resultRowMeta.getFieldIndex("supplyorgunit"), (Object)this.getLong(supplyData.get("supplyorgunit")));
    }

    protected BigDecimal getBigDecimal(Object value) {
        if ((value = DataType.convertValue((DataType)DataType.BigDecimalType, (Object)value)) instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return BigDecimal.ZERO;
    }

    protected Boolean getBoolean(Object value) {
        if ((value = DataType.convertValue((DataType)DataType.BooleanType, (Object)value)) instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    protected String getString(Object value) {
        if ((value = DataType.convertValue((DataType)DataType.StringType, (Object)value)) instanceof String) {
            return (String)value;
        }
        return "";
    }

    protected Long getLong(Object value) {
        if ((value = DataType.convertValue((DataType)DataType.LongType, (Object)value)) instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    protected Integer getInteger(Object value) {
        if ((value = DataType.convertValue((DataType)DataType.IntegerType, (Object)value)) instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    private boolean clearSupply(Map<String, Object> supplyData) {
        BigDecimal supplyQty = this.getBigDecimal(supplyData.get("qty"));
        BigDecimal supplyCalcUsedQty = this.getBigDecimal(supplyData.get("supplyCalcUsedQty"));
        return supplyQty.equals(supplyCalcUsedQty);
    }

    public RowX createRow(RowX rowX) {
        Object[] values = rowX.values();
        Object[] newValues = new Object[this.resultRowMeta.getFieldCount()];
        System.arraycopy(values, 0, newValues, 0, values.length);
        return new RowX(newValues);
    }

    public List<Map<String, Object>> sortSupply(List<Map<String, Object>> supplyDataList) {
        if (this.supplyPriorityModelId != null && this.supplyPriorityModelId > 0L) {
            supplyDataList = (List)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IPriorityCalculationService", (String)"calPlanPriorityModel", (Object[])new Object[]{this.supplyPriorityModelId, supplyDataList});
        }
        return supplyDataList;
    }

    public List<Map<String, Object>> getSupplyData(Iterable<RowX> iterable) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (RowX row : iterable) {
            result.add(this.toMap(row, this.supplyRowMeta));
        }
        return result;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }

    public Map<String, Object> toMap(RowX row, RowMeta rowMeta) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.toMap(row, map, rowMeta);
        return map;
    }

    public void toMap(RowX row, Map<String, Object> map, RowMeta rowMeta) {
        Field[] fields = rowMeta.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Object value = row.get(i);
            value = DataType.convertValue((DataType)fields[i].getDataType(), (Object)value);
            map.put(fields[i].getAlias(), value);
        }
    }

    public RowMeta getDemandRowMeta() {
        return this.demandRowMeta;
    }

    public void setDemandRowMeta(RowMeta demandRowMeta) {
        this.demandRowMeta = demandRowMeta;
    }

    public RowMeta getSupplyRowMeta() {
        return this.supplyRowMeta;
    }

    public void setSupplyRowMeta(RowMeta supplyRowMeta) {
        this.supplyRowMeta = supplyRowMeta;
    }

    public void setResultRowMeta(RowMeta resultRowMeta) {
        this.resultRowMeta = resultRowMeta;
    }

    public Map<Long, Long> getOrgParams() {
        return this.orgParams;
    }

    public final void setOrgParams(Map<Long, Long> orgParams) {
        this.orgParams = orgParams;
        this.initOrgInvStrategy(orgParams);
    }

    public final void initOrgInvStrategy(Map<Long, Long> orgParams) {
        Collection<Long> orgInvStrategyIds = orgParams.values();
        Object[] ids = orgInvStrategyIds.stream().filter(o -> o != null && o > 0L).distinct().toArray();
        this.setInvStrategyMap(BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"mrp_stocksupply_policy"));
    }

    public Long getSupplyPriorityModelId() {
        return this.supplyPriorityModelId;
    }

    public void setSupplyPriorityModelId(Long supplyPriorityModelId) {
        this.supplyPriorityModelId = supplyPriorityModelId;
    }

    public Map<Object, DynamicObject> getInvStrategyMap() {
        return this.invStrategyMap;
    }

    public final void setInvStrategyMap(Map<Object, DynamicObject> invStrategyMap) {
        this.invStrategyMap = invStrategyMap;
    }
}

