/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.distr.helper;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;

public class DistrUtil {
    private static final Log logger = LogFactory.getLog(DistrUtil.class);

    public static String getErrorString(OperationResult optResult) {
        List allErrorOrValidateInfo = optResult.getAllErrorOrValidateInfo();
        StringBuilder sb = new StringBuilder();
        String message = optResult.getMessage();
        if (message != null && !"".equals(message) && !"null".equals(message)) {
            sb.append(message).append("\r\n");
        }
        for (IOperateInfo errInfo : allErrorOrValidateInfo) {
            message = errInfo.getMessage();
            if (message == null || "".equals(message) || "null".equals(message)) continue;
            sb.append(message).append("\r\n");
        }
        try {
            if (optResult.getInteractionContext() != null) {
                message = optResult.getInteractionContext().getSimpleMessage();
                sb.append(message);
            }
        }
        catch (Exception ex) {
            logger.info("saveOperate" + JSON.toJSON((Object)optResult));
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)ex), (Throwable)ex);
            Map<Object, String> map = DistrUtil.getMesMap(optResult);
            sb.append(String.join((CharSequence)",", map.values()));
        }
        if (sb.length() < 1) {
            List validateErrors = optResult.getValidateResult().getValidateErrors();
            for (ValidateResult validateResult : validateErrors) {
                List allErrorInfo = validateResult.getAllErrorInfo();
                String validatorKey = validateResult.getValidatorKey();
                allErrorInfo.forEach(operateErrorInfo -> {
                    String messages = operateErrorInfo.getMessage();
                    sb.append(validatorKey).append(messages);
                });
            }
        }
        return sb.toString();
    }

    public static Map<Object, String> getMesMap(OperationResult optResult) {
        HashMap<Object, String> mesMap = new HashMap<Object, String>(16);
        try {
            List allErrorOrValidateInfo = optResult.getAllErrorOrValidateInfo();
            String message = optResult.getMessage();
            for (IOperateInfo errInfo : allErrorOrValidateInfo) {
                mesMap.put(errInfo.getPkValue(), message + errInfo.getMessage());
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        return mesMap;
    }
}

