/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.distr.helper;

import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DistrWriteBackSrcHelper {
    protected static final Log log = LogFactory.getLog(DistrWriteBackSrcHelper.class);
    private long logid = 0L;

    public DistrWriteBackSrcHelper(long logid) {
        this.logid = logid;
    }

    public void clearSrc() {
        if (this.logid == 0L) {
            return;
        }
        LinkedList<Long> schedulesortIdList = new LinkedList<Long>();
        LinkedList<Long> sourcebillIdList = new LinkedList<Long>();
        this.loadIdList(schedulesortIdList, sourcebillIdList);
        this.calcLog2mftClear(sourcebillIdList);
        if (schedulesortIdList.size() == 0) {
            this.distrFlagClear(sourcebillIdList, "t_pom_mftorderentry_e");
        } else {
            this.distrFlagClear(schedulesortIdList, "t_mps_schedulesortdetail");
        }
    }

    public void writeBackSrc() {
        if (this.logid == 0L) {
            return;
        }
        LinkedList<Long> schedulesortIdList = new LinkedList<Long>();
        LinkedList<Long> sourcebillIdList = new LinkedList<Long>();
        this.loadIdList(schedulesortIdList, sourcebillIdList);
        this.calcLog2mft(sourcebillIdList);
        if (schedulesortIdList.size() == 0) {
            this.distrFlag(sourcebillIdList, "t_pom_mftorderentry_e");
        } else {
            this.distrFlag(schedulesortIdList, "t_mps_schedulesortdetail");
        }
    }

    private void loadIdList(List<Long> schedulesortIdList, List<Long> sourcebillIdList) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CreateDistribPlan:pom_distplansuggest", (String)"pom_distplansuggest", (String)"schedulesortid,sourcebillid,sourcebillenrtyid", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)this.logid)}, null);
        dataSet = dataSet.groupBy(new String[]{"schedulesortid", "sourcebillid", "sourcebillenrtyid"}).finish();
        dataSet = dataSet.updateField("schedulesortid", "case when schedulesortid ='' then '0' else schedulesortid end");
        dataSet = dataSet.select(new String[]{" cast(schedulesortid as Long) as  schedulesortid", " cast(sourcebillid as Long)  as sourcebillid", " cast(sourcebillenrtyid as Long)  as sourcebillenrtyid"});
        DataSet mftDataSet = dataSet.copy().filter("sourcebillenrtyid>0").groupBy(new String[]{"sourcebillenrtyid"}).finish();
        DataSet sortidDataSet = dataSet.filter("schedulesortid > 0").groupBy(new String[]{"schedulesortid"}).finish();
        for (Row row : sortidDataSet) {
            schedulesortIdList.add(row.getLong("schedulesortid"));
        }
        for (Row row : mftDataSet) {
            long sourcebillenrtyid = row.getLong("sourcebillenrtyid");
            sourcebillIdList.add(sourcebillenrtyid);
        }
        dataSet.close();
    }

    private void calcLog2mft(List<Long> sourcebillIdList) {
        MainEntityType dataEntityType = null;
        try {
            DynamicProperty zhny_mulcaculate;
            dataEntityType = EntityMetadataCache.getDataEntityType((String)"pom_mftorder");
            DynamicProperty treeentryentity = dataEntityType.getProperty("treeentryentity");
            if (treeentryentity instanceof EntryProp && (zhny_mulcaculate = ((EntryProp)treeentryentity).getDynamicCollectionItemPropertyType().getProperty("zhny_mulcaculate")) != null) {
                this.distrCalcNo(sourcebillIdList);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    private void calcLog2mftClear(List<Long> sourcebillIdList) {
        MainEntityType dataEntityType = null;
        try {
            DynamicProperty zhny_mulcaculate;
            dataEntityType = EntityMetadataCache.getDataEntityType((String)"pom_mftorder");
            DynamicProperty treeentryentity = dataEntityType.getProperty("treeentryentity");
            if (treeentryentity instanceof EntryProp && (zhny_mulcaculate = ((EntryProp)treeentryentity).getDynamicCollectionItemPropertyType().getProperty("zhny_mulcaculate")) != null) {
                this.distrCalcNoClear(sourcebillIdList);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    private void distrCalcNo(List<Long> ids) {
        String sql = "insert into tk_zhny_mulcaculate(fpkid,fentryid,fbasedataid) values(?,?,?)";
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        for (Long id : ids) {
            params.add(new Object[]{ID.genLongId(), id, this.logid});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, params);
    }

    private void distrCalcNoClear(List<Long> ids) {
        String sql = "delete from tk_zhny_mulcaculate where fentryid=? and fbasedataid=?";
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        for (Long id : ids) {
            params.add(new Object[]{id, this.logid});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, params);
    }

    private void distrFlag(List<Long> ids, String tableName) {
        String sql = "update t_mps_schedulesortdetail set fhascalculte='1' where fid= ? ";
        if ("t_pom_mftorderentry_e".equals(tableName)) {
            sql = "update t_pom_mftorderentry_e set fisshipinstruction='1' where fentryid= ? ";
        }
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        for (Long id : ids) {
            params.add(new Object[]{id});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, params);
    }

    private void distrFlagClear(List<Long> ids, String tableName) {
        String sql = "update t_mps_schedulesortdetail set fhascalculte='0' where fid= ? ";
        if ("t_pom_mftorderentry_e".equals(tableName)) {
            sql = "update t_pom_mftorderentry_e set fisshipinstruction='0' where fentryid= ? ";
        }
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        for (Long id : ids) {
            params.add(new Object[]{id});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, params);
    }
}

