/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.distr.receive;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mmc.pom.business.distr.botp.PushOrderResult;

public class DistrPlanReceiveReplace {
    protected static final Log log = LogFactory.getLog(DistrPlanReceiveReplace.class);

    public String doReceive(String resultidStr, Long distrplanid, Boolean isvmi, String batchno, Long supplierid, Long outinvstatus, String deliverybillno, BigDecimal qty, Boolean isreplace, String materialreplace, String deliveryno) {
        ConvertRuleElement rule;
        String[] resultIdArr;
        ArrayList<Map<String, Object>> orders = new ArrayList<Map<String, Object>>(16);
        for (String resultId : resultIdArr = resultidStr.split(",")) {
            HashMap<String, Long> order = new HashMap<String, Long>(16);
            order.put("resultid", Long.parseLong(resultId));
            orders.add(order);
        }
        String ruleId = "";
        Object ruleIdObj = SystemParamServiceHelper.getBillParameter((String)"pom_distribplan", (String)"mftfeedorder_botp");
        if (ruleIdObj instanceof DynamicObject) {
            ruleId = String.valueOf(((DynamicObject)ruleIdObj).getPkValue());
        }
        if ((rule = ConvertRuleCache.loadRule((String)ruleId)) == null) {
            return ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5339\u914d\u7684\u8f6c\u6362\u89c4\u5219,\u6216\u8005\u539f\u59cb\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528\u3002", (String)"DistrPlanReceiveReplace_0", (String)"mmc-pom-business", (Object[])new Object[0]);
        }
        PushOrderResult pushOrderResult = this.push(orders, rule);
        Map<Long, String> errorMap = pushOrderResult.getErrorMap();
        if (errorMap != null) {
            String error = errorMap.entrySet().stream().map(o -> o.getKey() + ":" + (String)o.getValue()).collect(Collectors.joining(";"));
            log.error(error);
            return error;
        }
        List<DynamicObject> targetOrders = pushOrderResult.getTargetOrders();
        String opResult = this.saveDataOperation(targetOrders, rule.getTargetEntityNumber(), "submit");
        if (StringUtils.isNotEmpty((CharSequence)opResult)) {
            return opResult;
        }
        opResult = this.saveDataOperation(targetOrders, rule.getTargetEntityNumber(), "audit");
        if (StringUtils.isNotEmpty((CharSequence)opResult)) {
            this.saveDataOperation(targetOrders, rule.getTargetEntityNumber(), "unsubmit");
            this.saveDataOperation(targetOrders, rule.getTargetEntityNumber(), "delete");
            return opResult;
        }
        return "";
    }

    private String saveDataOperation(List<DynamicObject> targetOrders, String entityNumber, String opKey) {
        OperationResult saveOperate = OperationServiceHelper.executeOperate((String)opKey, (String)entityNumber, (DynamicObject[])targetOrders.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!saveOperate.isSuccess()) {
            StringBuilder errormsg = new StringBuilder();
            errormsg.append(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a", (String)"DistrPlanReceive_7", (String)"mmc-pom-business", (Object[])new Object[0]));
            ValidateResultCollection validateResultCollection = saveOperate.getValidateResult();
            List validateErrors = validateResultCollection.getValidateErrors();
            String message = saveOperate.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                errormsg.append(message);
            } else {
                message = saveOperate.getInteractionContext().getSimpleMessage();
                errormsg.append(message);
            }
            for (ValidateResult validateResult : validateErrors) {
                List allErrorInfo = validateResult.getAllErrorInfo();
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    errormsg.append(operateErrorInfo.getMessage());
                }
            }
            log.error(errormsg.toString());
            return errormsg.toString();
        }
        return null;
    }

    private PushOrderResult push(List<Map<String, Object>> orders, ConvertRuleElement rule) {
        PushOrderResult pushOrderResult = new PushOrderResult();
        HashMap<Long, String> errorMap = new HashMap<Long, String>(orders.size());
        try {
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(orders.size());
            for (Map<String, Object> order : orders) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(order.get("resultid"));
                selectedRows.add(row);
            }
            PushArgs args = new PushArgs();
            args.setSourceEntityNumber(rule.getSourceEntityNumber());
            args.setTargetEntityNumber(rule.getTargetEntityNumber());
            args.setRuleId(rule.getId());
            args.setSelectedRows(selectedRows);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
            if (result.getBillReports().size() > 0) {
                for (SourceBillReport billReport : result.getBillReports()) {
                    if (billReport.isFullSuccess()) continue;
                    StringBuilder error = new StringBuilder();
                    String kdString = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a", (String)"DistrPlanReceiveReplace_1", (String)"mmc-pom-business", (Object[])new Object[0]);
                    error.append(kdString);
                    error.append(result.getMessage()).append("\r\n");
                    error.append(billReport.getRowInfo());
                    error.append(':');
                    error.append(billReport.buildSummary()).append("\r\n");
                    Object billId = billReport.getBillId();
                    Long orderId = Long.valueOf(billId.toString());
                    errorMap.put(orderId, error.toString());
                }
            } else if (result.getBillReports().size() == 0) {
                String message = result.getMessage();
                String[] messages = message.split("&&");
                if (messages.length == 2) {
                    messages[0] = messages[0].replace("[", "");
                    messages[0] = messages[0].replace("]", "");
                    String[] ids = messages[0].split(",");
                    String errormessage = messages[1];
                    if (ids != null && ids.length > 0) {
                        StringBuilder error = new StringBuilder();
                        String kdString = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a", (String)"DistrPlanReceiveReplace_1", (String)"mmc-pom-business", (Object[])new Object[0]);
                        error.append(kdString);
                        error.append(':');
                        error.append(errormessage);
                        for (String id : ids) {
                            errorMap.put(Long.valueOf(id.trim()), error.toString());
                        }
                        log.error(error.toString(), (Object)error);
                    }
                } else {
                    if (message.length() > 450) {
                        message = message.substring(0, 450);
                    }
                    for (Map<String, Object> planorder : orders) {
                        Long orderId = (Long)planorder.get("resultid");
                        errorMap.put(orderId, message);
                    }
                    pushOrderResult.setErrorMap(errorMap);
                }
            }
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
                }
            };
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)rule.getTargetEntityNumber());
            List targetDataObjects = result.loadTargetDataObjects(refDataProvider, mainType);
            pushOrderResult.setTargetOrders(targetDataObjects);
            if (errorMap.size() > 0) {
                pushOrderResult.setErrorMap(errorMap);
            }
            return pushOrderResult;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            StringBuilder error = new StringBuilder();
            String kdString = ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a\u5355\u636eID\u3010%s\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a", (String)"DistrPlanReceiveReplace_2", (String)"mmc-pom-business", (Object[])new Object[0]);
            error.append(kdString);
            error.append(e.getMessage());
            this.failInfoUpdate(error.toString(), orders, pushOrderResult, errorMap);
            return pushOrderResult;
        }
    }

    private void failInfoUpdate(String error, List<Map<String, Object>> orders, PushOrderResult pushOrderResult, Map<Long, String> errorMap) {
        for (Map<String, Object> planorder : orders) {
            String errorStr = error;
            if (error == null) continue;
            if (error.split("%s").length == 2) {
                errorStr = String.format(error, planorder.get("resultid"));
            }
            Long orderId = (Long)planorder.get("resultid");
            if (errorStr.length() > 450) {
                errorStr = errorStr.substring(0, 450);
            }
            errorMap.put(orderId, errorStr);
        }
        pushOrderResult.setErrorMap(errorMap);
        pushOrderResult.setTargetOrders(new ArrayList<DynamicObject>());
    }
}

