/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.mrolockcontrol;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class MroLockControlBusiness {
    public String unInstallLockControl(Map<String, Object> paramMap) {
        if (paramMap == null) {
            return "";
        }
        String projectnumber = paramMap.get("projectnumber") == null ? "" : paramMap.get("projectnumber").toString();
        Long materialID = 0L;
        if (paramMap.get("materialID") != null) {
            materialID = Long.parseLong(paramMap.get("materialID").toString());
        }
        Object sn = paramMap.get("sn");
        if (StringUtils.isEmpty((String)projectnumber) && materialID.equals(0L)) {
            return "";
        }
        Set<Long> lockControlIDSet = this.getLockControlIDSet(projectnumber, materialID, sn);
        if (lockControlIDSet.isEmpty()) {
            return "";
        }
        String sourceRemark = paramMap.get("sourceremark") == null ? "" : paramMap.get("sourceremark").toString();
        QFilter qFilter = new QFilter("id", "in", lockControlIDSet);
        String selectProperties = "id,number,bizstatus,billstatus,tagcountdesc,tagcount,remark,entryentity,entryentity.tag,entryentity.isremove,entryentity.removeperson,entryentity.entryremovedate";
        DynamicObject[] dyColl = BusinessDataServiceHelper.load((String)"pom_mrolockcontrol", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        Date thisDate = new Date();
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id,number,name");
        for (DynamicObject dy : dyColl) {
            String remark = "";
            if (dy.getString("remark") != null) {
                remark = dy.getString("remark");
            }
            remark = remark + " " + sourceRemark;
            dy.set("remark", (Object)remark);
            dy.set("bizstatus", (Object)"B");
            int entrySize = dy.getDynamicObjectCollection("entryentity").size();
            dy.set("tagcountdesc", (Object)("0/" + String.valueOf(entrySize)));
            for (int i = 0; i < entrySize; ++i) {
                DynamicObject entry = (DynamicObject)dy.getDynamicObjectCollection("entryentity").get(i);
                if (entry.getBoolean("isremove")) continue;
                entry.set("isremove", (Object)Boolean.TRUE);
                entry.set("removeperson", (Object)userObj);
                entry.set("entryremovedate", (Object)thisDate);
            }
        }
        SaveServiceHelper.save((DynamicObject[])dyColl);
        return "ok";
    }

    private Set<Long> getLockInfoIDSet(Long materialID, Object sn) {
        QFilter qFilter = new QFilter("material.id", "=", (Object)materialID);
        qFilter.and(new QFilter("sn", "in", sn));
        HashSet<Long> lockIDSet = new HashSet<Long>(16);
        String selectProperties = "id";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-findlockcontrol-getLockInfoIDSet", (String)"mpdm_lockinfo", (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                lockIDSet.add(row.getLong("id"));
            }
        }
        return lockIDSet;
    }

    private Set<Long> getLockControlIDSet(String projectnumber, Long materialID, Object sn) {
        QFilter qFilter = new QFilter("bizstatus", "=", (Object)"A");
        qFilter.and(new QFilter("billstatus", "=", (Object)"B"));
        if (StringUtils.isEmpty((String)projectnumber)) {
            Set<Long> lockIdSet = this.getLockInfoIDSet(materialID, sn);
            if (lockIdSet.isEmpty()) {
                return Collections.emptySet();
            }
            qFilter.and(new QFilter("lockinfo.id", "in", lockIdSet));
        } else {
            qFilter.and(new QFilter("project.number", "=", (Object)projectnumber));
        }
        String selectFields = "id";
        HashSet<Long> lockControlIDSet = new HashSet<Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-mrolockcontrol-getLockControlIDSet", (String)"pom_mrolockcontrol", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                lockControlIDSet.add(row.getLong("id"));
            }
        }
        return lockControlIDSet;
    }

    public static Set<String> getProjectBusinessStatus() {
        HashSet<String> statusSet = new HashSet<String>(16);
        statusSet.add("REOPEN_S");
        statusSet.add("START_S");
        statusSet.add("PREPARE_S");
        statusSet.add("ONGOING_S");
        statusSet.add("PASS_S");
        return statusSet;
    }
}

